/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcsImporter {
    Properties tcsProperties;
    VariableTableModel model;
    private static final Logger log = LoggerFactory.getLogger(TcsImporter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcsImporter(File file, CvTableModel cvModel, VariableTableModel model) throws IOException {
        this.model = model;
        this.tcsProperties = new Properties();
        try (FileInputStream fileStream = new FileInputStream(file);){
            this.tcsProperties.load(fileStream);
        }
    }

    public TcsImporter(InputStream stream) throws IOException {
        this.tcsProperties = new Properties();
        this.tcsProperties.load(stream);
    }

    public void setRosterEntry(RosterEntry rosterEntry) {
        log.debug("found name {}", this.tcsProperties.get("Train.Name"));
        log.debug("found address {}", this.tcsProperties.get("Train.Address"));
        log.debug("found step {}", this.tcsProperties.get("Train.Speed"));
        String userDescription = this.tcsProperties.get("Train.User").toString();
        userDescription = userDescription.substring("Description=".length());
        rosterEntry.setComment(userDescription);
        for (int i = 0; i < 27; ++i) {
            Object momentaryObj = this.tcsProperties.get("Train.Functions(" + i + ").Momentary");
            log.trace("Found Momentary {} as {}", (Object)i, momentaryObj);
            if (momentaryObj == null) continue;
            String momentary = momentaryObj.toString();
            Object displayObj = this.tcsProperties.get("Train.Functions(" + i + ").Display");
            log.trace("Found Display {} as {}", (Object)i, displayObj);
            if (displayObj == null) continue;
            String display = displayObj.toString();
            Object descriptionObj = this.tcsProperties.get("Train.Functions(" + i + ").Description");
            log.trace("Found Description {} as {}", (Object)i, descriptionObj);
            if (descriptionObj == null) continue;
            String description = descriptionObj.toString();
            description = TcsImporter.unpackDescription(description, display);
            rosterEntry.setFunctionLabel(i + 1, description);
            rosterEntry.setFunctionLockable(i + 1, momentary.equals("1"));
            VariableValue variable = this.model.findVar("Consist Address Active For F" + (i + 1));
            if (variable != null) {
                Object consistObj = this.tcsProperties.get("Train.Functions(" + i + ").Consist");
                log.debug("Found {} as '{}'", (Object)("Train.Functions(" + i + ").Consist"), consistObj);
                if (consistObj == null) continue;
                if (consistObj.equals("Behavior=1")) {
                    variable.setIntValue(1);
                } else {
                    variable.setIntValue(0);
                }
                log.trace("result is value {}", (Object)variable.getIntValue());
                continue;
            }
            log.debug("Variable {} not found", (Object)("Consist Address Active For F" + (i + 1)));
        }
    }

    static String unpackDescription(String description, String display) {
        if (!description.isEmpty()) {
            return description;
        }
        switch (display) {
            case "0": {
                return "";
            }
            case "1": {
                return "Headlight";
            }
            case "13": {
                return "Bell";
            }
            case "14": {
                return "Horn";
            }
            case "15": {
                return "Whistle";
            }
            case "11": {
                return "Pantograph";
            }
            case "10": {
                return "Smoke";
            }
            case "4": {
                return "Engine";
            }
            case "74": {
                return "Light";
            }
            case "28": {
                return "Coupler Clank";
            }
            case "122": {
                return "Couple";
            }
            case "9": {
                return "Uncouple";
            }
            case "7": {
                return "Shunting Mode";
            }
            case "8": {
                return "Momentum";
            }
            case "57": {
                return "Brake";
            }
            case "200": {
                return "Brake Release";
            }
            case "41": {
                return "Dynamic Brake";
            }
            case "31": {
                return "Manual Notch Down";
            }
            case "30": {
                return "Manual Notch Up";
            }
            case "69": {
                return "Reverser";
            }
            case "100": {
                return "Mute";
            }
            case "12": {
                return "Far Light";
            }
            case "3": {
                return "Cab Light";
            }
            case "48": {
                return "Ditch Lights";
            }
            case "98": {
                return "Step Lights";
            }
            case "62": {
                return "Tail Lights";
            }
            case "58": {
                return "Switching Lights";
            }
            case "51": {
                return "Dimmer";
            }
            case "2": {
                return "Interior Lights";
            }
            case "42": {
                return "Air Compressor";
            }
            case "45": {
                return "Air Pump";
            }
            case "60": {
                return "Injector";
            }
            case "108": {
                return "Exhaust Fan";
            }
            case "17": {
                return "Radiator Fan";
            }
            case "66": {
                return "Steam Generator";
            }
            case "105": {
                return "Blower";
            }
            case "56": {
                return "Blow Down";
            }
            case "38": {
                return "Safety";
            }
            case "55": {
                return "Sanding";
            }
            case "88": {
                return "Ash Dump";
            }
            case "18": {
                return "Shoveling";
            }
            case "35": {
                return "Water Fill";
            }
            case "103": {
                return "Long Whistle";
            }
            case "64": {
                return "Short Whistle";
            }
            case "63": {
                return "Doppler Horn";
            }
            case "36": {
                return "Curve Squeal";
            }
            case "21": {
                return "Brake Squeal";
            }
            case "6": {
                return "Announce";
            }
            case "27": {
                return "Cab Chatter";
            }
            case "255": {
                return "Unavailable_";
            }
        }
        return "<entry error \"" + display + "\">";
    }
}

