/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.TcsExportAction;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.util.swing.JmriJOptionPane;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.cdi.impl.ConfigRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcsUploadAction
extends AbstractAction
implements PropertyChangeListener {
    PaneProgFrame frame;
    RosterEntry rosterEntry;
    CvTableModel cvTable;
    VariableTableModel vModel;
    ConfigRepresentation configRep;
    private static final Logger log = LoggerFactory.getLogger(TcsUploadAction.class);

    public TcsUploadAction(String actionName, CvTableModel pModel, VariableTableModel vModel, RosterEntry rosterEntry, PaneProgFrame pParent) {
        super(actionName);
        this.cvTable = pModel;
        this.vModel = vModel;
        this.frame = pParent;
        this.rosterEntry = rosterEntry;
    }

    public static boolean willBeEnabled() {
        CanSystemConnectionMemo cscm = TcsUploadAction.getSystemConnectionMemo();
        if (cscm == null) {
            return false;
        }
        return cscm.get(NodeID.class) != null;
    }

    static CanSystemConnectionMemo getSystemConnectionMemo() {
        return InstanceManager.getNullableDefault(CanSystemConnectionMemo.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isLong = this.cvTable.holdsLongAddress();
        int addr = this.cvTable.holdsAddress();
        log.debug("computed address is {} long: {}", (Object)addr, (Object)isLong);
        byte upperAddressByte = (byte)(isLong ? 192 + (addr >> 8) : 0);
        byte lowerAddressByte = (byte)(addr & 0xFF);
        NodeID nodeID = new NodeID(new byte[]{6, 1, 0, 0, upperAddressByte, lowerAddressByte});
        log.debug("node ID {}", (Object)nodeID);
        MimicNodeStore nodeStore = TcsUploadAction.getSystemConnectionMemo().get(MimicNodeStore.class);
        MimicNodeStore.NodeMemo nodeMemo = nodeStore.findNode(nodeID);
        if (nodeMemo == null) {
            JmriJOptionPane.showMessageDialog(this.frame, "Entry " + addr + " not found in CS-105, canceling");
            return;
        }
        this.configRep = new ConfigRepresentation(TcsUploadAction.getSystemConnectionMemo().get(OlcbInterface.class), nodeID);
        this.configRep.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        switch (event.getPropertyName()) {
            case "UPDATE_STATE": 
            case "UPDATE_REP": {
                return;
            }
            case "UPDATE_CACHE_COMPLETE": {
                log.debug("CDI read done");
                this.processValuesFromGUI();
                return;
            }
        }
        log.error("Unexpected PropertyChangeEvent {}", (Object)event);
    }

    void processValuesFromGUI() {
        log.trace("processValuesFromGUI");
        this.configRep.visit(new ConfigRepresentation.Visitor(){

            public void visitString(ConfigRepresentation.StringEntry e) {
                log.trace("String entry {} is {}", (Object)e.key, (Object)e.getValue());
                if (e.key.startsWith("Train.User Description")) {
                    e.setValue(TcsUploadAction.this.frame.getRosterPane().getComment());
                } else if (e.key.startsWith("Train.Functions")) {
                    int index = TcsUploadAction.getNumberField(e.key);
                    if (index == -1) {
                        log.warn("Unexpected format \"{}\"", (Object)e.key);
                        return;
                    }
                    if (e.key.endsWith("Description")) {
                        String value = TcsUploadAction.this.frame.getFnLabelPane().getLabel(index + 1).getText();
                        if (value == null) {
                            value = "";
                        }
                        log.debug(".Description found function {} roster description \"{}\"", (Object)index, (Object)value);
                        log.trace("   mapping gives {}", (Object)TcsExportAction.intFromFunctionString(TcsUploadAction.this.rosterEntry.getFunctionLabel(index + 1)));
                        if (TcsExportAction.intFromFunctionString(TcsUploadAction.this.frame.getFnLabelPane().getLabel(index + 1).getText()) == 0) {
                            e.setValue(value);
                        }
                    } else {
                        log.warn("Unexpected content \"{}\"", (Object)e.key);
                    }
                }
            }

            public void visitInt(ConfigRepresentation.IntegerEntry e) {
                log.trace("Integer entry {} is {}", (Object)e.key, (Object)e.getValue());
                if (e.key.startsWith("Train.Delete From Roster")) {
                    JmriJOptionPane.showMessageDialog(TcsUploadAction.this.frame, "Upload complete.");
                } else if (e.key.startsWith("Train.Functions")) {
                    int index = TcsUploadAction.getNumberField(e.key);
                    if (index == -1) {
                        log.warn("Unexpected format \"{}\"", (Object)e.key);
                        return;
                    }
                    if (e.key.endsWith(".Momentary")) {
                        long value = 1L;
                        if (TcsUploadAction.this.frame.getFnLabelPane().getLockable(index + 1).isSelected()) {
                            value = 0L;
                        }
                        e.setValue(value);
                    } else if (e.key.endsWith(".Consist Behavior")) {
                        VariableValue variable = TcsUploadAction.this.vModel.findVar("Consist Address Active For F" + (index + 1));
                        if (variable != null) {
                            int value = variable.getIntValue();
                            e.setValue((long)value);
                        } else {
                            log.debug("Variable {} not found", (Object)("Consist Address Active For F" + (index + 1)));
                        }
                    } else if (e.key.endsWith(".Display")) {
                        int value = TcsExportAction.intFromFunctionString(TcsUploadAction.this.frame.getFnLabelPane().getLabel(index + 1).getText());
                        e.setValue((long)value);
                        log.debug(".display found function {} roster description \"{}\"", (Object)index, (Object)value);
                    } else {
                        log.warn("Unexpected content \"{}\"", (Object)e.key);
                    }
                }
            }

            public void visitEvent(ConfigRepresentation.EventEntry e) {
                log.trace("Event entry {} is {}", (Object)e.key, (Object)e.getValue());
            }
        });
    }

    static int getNumberField(String value) {
        int first = value.indexOf("(");
        int last = value.indexOf(")");
        if (first > 0 && last > 0 && last > first + 1) {
            String digits = value.substring(first + 1, last);
            return Integer.parseInt(digits);
        }
        return -1;
    }
}

