/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.AddressedProgrammer;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.CompositeVariableValue;
import jmri.jmrit.symbolicprog.ConstantValue;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.DecVariableValue;
import jmri.jmrit.symbolicprog.EnumVariableValue;
import jmri.jmrit.symbolicprog.HexVariableValue;
import jmri.jmrit.symbolicprog.LongAddrVariableValue;
import jmri.jmrit.symbolicprog.Qualifier;
import jmri.jmrit.symbolicprog.QualifierAdder;
import jmri.jmrit.symbolicprog.ShortAddrVariableValue;
import jmri.jmrit.symbolicprog.SpeedTableVarValue;
import jmri.jmrit.symbolicprog.SplitDateTimeVariableValue;
import jmri.jmrit.symbolicprog.SplitEnumVariableValue;
import jmri.jmrit.symbolicprog.SplitHexVariableValue;
import jmri.jmrit.symbolicprog.SplitHundredsVariableValue;
import jmri.jmrit.symbolicprog.SplitTextVariableValue;
import jmri.jmrit.symbolicprog.SplitVariableValue;
import jmri.jmrit.symbolicprog.ValueQualifier;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.util.CvUtil;
import jmri.util.jdom.LocaleSelector;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.jdom2.util.IteratorIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableTableModel
extends AbstractTableModel
implements ActionListener,
PropertyChangeListener {
    private String[] headers;
    private Vector<VariableValue> rowVector = new Vector();
    private CvTableModel _cvModel;
    private Vector<JButton> _writeButtons = new Vector();
    private Vector<JButton> _readButtons = new Vector();
    private JLabel _status;
    protected volatile transient DecoderFile _df = null;
    private boolean _fileDirty;
    private static final Logger log = LoggerFactory.getLogger(VariableTableModel.class);

    public VariableTableModel(JLabel status, String[] h, CvTableModel cvModel) {
        this._status = status;
        this._cvModel = cvModel;
        this.headers = Arrays.copyOf(h, h.length);
    }

    @Override
    public int getRowCount() {
        return this.rowVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public String getColumnName(int col) {
        log.debug("getColumnName {}", (Object)col);
        return Bundle.getMessage(this.headers[col]);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (this.headers[col]) {
            case "Value": {
                return JTextField.class;
            }
            case "Read": 
            case "Write": {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        log.debug("isCellEditable {}", (Object)col);
        if (this.headers[col].equals("Value")) {
            return true;
        }
        if (this.headers[col].equals("Read")) {
            return true;
        }
        return this.headers[col].equals("Write") && !this.rowVector.elementAt(row).getReadOnly();
    }

    public VariableValue getVariable(int row) {
        return this.rowVector.elementAt(row);
    }

    public String getLabel(int row) {
        return this.rowVector.elementAt(row).label();
    }

    public String getItem(int row) {
        return this.rowVector.elementAt(row).item();
    }

    public String getCvName(int row) {
        return this.rowVector.elementAt(row).cvName();
    }

    public String getValString(int row) {
        return this.rowVector.elementAt(row).getValueString();
    }

    public void setIntValue(int row, int val) {
        this.rowVector.elementAt(row).setIntValue(val);
    }

    public void setState(int row, AbstractValue.ValueState val) {
        log.debug("setState row: {} val: {}", (Object)row, (Object)val);
        this.rowVector.elementAt(row).setState(val);
    }

    public AbstractValue.ValueState getState(int row) {
        return this.rowVector.elementAt(row).getState();
    }

    public Object getRep(int row, String format) {
        VariableValue v = this.rowVector.elementAt(row);
        return v.getNewRep(format);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.rowVector.size()) {
            log.debug("row index greater than row vector size");
            return "Error";
        }
        VariableValue v = this.rowVector.elementAt(row);
        if (v == null) {
            log.debug("v is null!");
            return "Error value";
        }
        switch (this.headers[col]) {
            case "Value": {
                return v.getCommonRep();
            }
            case "Read": {
                return this._readButtons.elementAt(row);
            }
            case "Write": {
                return this._writeButtons.elementAt(row);
            }
            case "CV": {
                return v.getCvNum();
            }
            case "Name": {
                return v.label();
            }
            case "Comment": {
                return v.getComment();
            }
            case "Mask": {
                return v.getMask();
            }
            case "State": {
                AbstractValue.ValueState state = v.getState();
                switch (state) {
                    case UNKNOWN: {
                        return "Unknown";
                    }
                    case READ: {
                        return "Read";
                    }
                    case EDITED: {
                        return "Edited";
                    }
                    case STORED: {
                        return "Stored";
                    }
                    case FROMFILE: {
                        return "From file";
                    }
                }
                return "inconsistent";
            }
            case "Range": {
                return v.rangeVal();
            }
        }
        return "Later, dude";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        log.debug("setvalueAt {} {} {}", new Object[]{row, col, value});
        this.setFileDirty(true);
    }

    public void setRow(int row, Element e) {
        this.setRow(row, e, null);
    }

    public void setRow(int row, Element e, DecoderFile df) {
        VariableValue v;
        Element child;
        boolean opsOnly;
        String item;
        this._df = df;
        String name = LocaleSelector.getAttribute(e, "label");
        log.debug("Starting to setRow \"{}\"", (Object)name);
        String string = item = e.getAttribute("item") != null ? e.getAttribute("item").getValue() : null;
        if (item == null) {
            item = name;
            log.debug("no item attribute, used label \"{}\"", (Object)name);
        }
        if (name == null) {
            name = item;
            log.debug("no label attribute, used item attribute \"{}\"", (Object)item);
        }
        String comment = LocaleSelector.getAttribute(e, "comment");
        String CV = "";
        if (e.getAttribute("CV") != null) {
            CV = e.getAttribute("CV").getValue();
        }
        String mask = e.getAttribute("mask") != null ? e.getAttribute("mask").getValue() : "VVVVVVVV";
        boolean readOnly = e.getAttribute("readOnly") != null && e.getAttribute("readOnly").getValue().equals("yes");
        boolean infoOnly = e.getAttribute("infoOnly") != null && e.getAttribute("infoOnly").getValue().equals("yes");
        boolean writeOnly = e.getAttribute("writeOnly") != null && e.getAttribute("writeOnly").getValue().equals("yes");
        boolean bl = opsOnly = e.getAttribute("opsOnly") != null && e.getAttribute("opsOnly").getValue().equals("yes");
        if (this._cvModel.getProgrammer() != null && opsOnly && !AddressedProgrammer.class.isAssignableFrom(this._cvModel.getProgrammer().getClass())) {
            readOnly = false;
            writeOnly = false;
            infoOnly = true;
        }
        JButton bw = new JButton(Bundle.getMessage("ButtonWrite"));
        this._writeButtons.addElement(bw);
        JButton br = new JButton(Bundle.getMessage("ButtonRead"));
        this._readButtons.addElement(br);
        this.setButtonsReadWrite(readOnly, infoOnly, writeOnly, bw, br, row);
        if (this._cvModel == null) {
            log.error("CvModel reference is null; cannot add variables");
            return;
        }
        if (!CV.equals("")) {
            List<String> cvList = CvUtil.expandCvList(CV);
            if (cvList.isEmpty()) {
                this._cvModel.addCV(CV, readOnly, infoOnly, writeOnly);
            } else {
                for (String s : cvList) {
                    this._cvModel.addCV(s, readOnly, infoOnly, writeOnly);
                }
            }
        }
        if ((child = e.getChild("decVal")) != null) {
            v = this.processDecVal(child, name, comment, readOnly, infoOnly, writeOnly, opsOnly, CV, mask, item);
        } else {
            child = e.getChild("hexVal");
            if (child != null) {
                v = this.processHexVal(child, name, comment, readOnly, infoOnly, writeOnly, opsOnly, CV, mask, item);
            } else {
                child = e.getChild("enumVal");
                if (child != null) {
                    v = this.processEnumVal(child, name, comment, readOnly, infoOnly, writeOnly, opsOnly, CV, mask, item);
                } else {
                    child = e.getChild("compositeVal");
                    if (child != null) {
                        v = this.processCompositeVal(child, name, comment, readOnly, infoOnly, writeOnly, opsOnly, CV, mask, item);
                    } else {
                        child = e.getChild("speedTableVal");
                        if (child != null) {
                            v = this.processSpeedTableVal(child, CV, readOnly, infoOnly, writeOnly, name, comment, opsOnly, mask, item);
                        } else {
                            child = e.getChild("longAddressVal");
                            if (child != null) {
                                v = this.processLongAddressVal(CV, readOnly, infoOnly, writeOnly, name, comment, opsOnly, mask, item);
                            } else {
                                child = e.getChild("shortAddressVal");
                                if (child != null) {
                                    v = this.processShortAddressVal(name, comment, readOnly, infoOnly, writeOnly, opsOnly, CV, mask, item, child);
                                } else {
                                    child = e.getChild("splitVal");
                                    if (child != null) {
                                        v = this.processSplitVal(child, CV, readOnly, infoOnly, writeOnly, name, comment, opsOnly, mask, item);
                                    } else {
                                        child = e.getChild("splitHexVal");
                                        if (child != null) {
                                            v = this.processSplitHexVal(child, CV, readOnly, infoOnly, writeOnly, name, comment, opsOnly, mask, item);
                                        } else {
                                            child = e.getChild("splitHundredsVal");
                                            if (child != null) {
                                                v = this.processSplitHundredsVal(child, CV, readOnly, infoOnly, writeOnly, name, comment, opsOnly, mask, item);
                                            } else {
                                                child = e.getChild("splitTextVal");
                                                if (child != null) {
                                                    v = this.processSplitTextVal(child, CV, readOnly, infoOnly, writeOnly, name, comment, opsOnly, mask, item);
                                                } else {
                                                    child = e.getChild("splitDateTimeVal");
                                                    if (child != null) {
                                                        v = this.processSplitDateTimeVal(child, CV, readOnly, infoOnly, writeOnly, name, comment, opsOnly, mask, item);
                                                    } else {
                                                        child = e.getChild("splitEnumVal");
                                                        if (child != null) {
                                                            v = this.processSplitEnumVal(child, CV, readOnly, infoOnly, writeOnly, name, comment, opsOnly, mask, item);
                                                        } else {
                                                            this.reportBogus(e);
                                                            return;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.processModifierElements(e, v);
        this.setToolTip(e, v);
        this.rowVector.addElement(v);
        v.setState(AbstractValue.ValueState.FROMFILE);
        v.addPropertyChangeListener(this);
        if (this.setDefaultValue(e, v)) {
            List<String> cvList = CvUtil.expandCvList(CV);
            if (cvList.isEmpty()) {
                cvList.add(CV);
            }
            for (String theCV : cvList) {
                log.debug("Setting CV={} of '{}'to {}", new Object[]{theCV, CV, AbstractValue.ValueState.FROMFILE.getName()});
                this._cvModel.getCvByNumber(theCV).setState(AbstractValue.ValueState.FROMFILE);
            }
        }
    }

    protected void processModifierElements(Element e, final VariableValue variable) {
        QualifierAdder qa = new QualifierAdder(){

            @Override
            protected Qualifier createQualifier(VariableValue variable2, String relation, String value) {
                return new ValueQualifier(variable, variable2, Integer.parseInt(value), relation);
            }

            @Override
            protected void addListener(PropertyChangeListener qc) {
                variable.addPropertyChangeListener(qc);
            }
        };
        qa.processModifierElements(e, this);
    }

    boolean setDefaultValue(Element e, VariableValue variable) {
        boolean set = false;
        Attribute a = e.getAttribute("default");
        if (a != null) {
            String val = a.getValue();
            variable.setValue(val);
            set = true;
        }
        List elements = e.getChildren("defaultItem");
        for (Element defaultItem : elements) {
            if (this._df == null || !DecoderFile.isIncluded(defaultItem, this._df.getProductID(), this._df.getModel(), this._df.getFamily(), "", "")) continue;
            log.debug("element included by productID={} model={} family={}", new Object[]{this._df.getProductID(), this._df.getModel(), this._df.getFamily()});
            variable.setValue(defaultItem.getAttribute("default").getValue());
            return true;
        }
        return set;
    }

    protected VariableValue processCompositeVal(Element child, String name, String comment, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String CV, String mask, String item) {
        CompositeVariableValue v1;
        int count = 0;
        IteratorIterable iterator = child.getDescendants();
        while (iterator.hasNext()) {
            Object ex = iterator.next();
            if (!(ex instanceof Element) || !((Element)ex).getName().equals("compositeChoice")) continue;
            ++count;
        }
        CompositeVariableValue v = v1 = new CompositeVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, 0, count, this._cvModel.allCvMap(), this._status, item);
        v1.nItems(count);
        this.handleCompositeValChildren(child, v1);
        v1.lastItem();
        return v;
    }

    protected void handleCompositeValChildren(Element e, CompositeVariableValue var) {
        List local = e.getChildren();
        for (Element el : local) {
            log.debug("processing element='{}' name='{}' choice='{}' value='{}'", new Object[]{el.getName(), LocaleSelector.getAttribute(el, "name"), LocaleSelector.getAttribute(el, "choice"), el.getAttribute("value")});
            if (this._df != null && !DecoderFile.isIncluded(el, this._df.getProductID(), this._df.getModel(), this._df.getFamily(), "", "")) {
                log.debug("element excluded by productID={} model={} family={}", new Object[]{this._df.getProductID(), this._df.getModel(), this._df.getFamily()});
                continue;
            }
            if (el.getName().equals("compositeChoice")) {
                String choice = LocaleSelector.getAttribute(el, "choice");
                var.addChoice(choice);
                List lSetting = el.getChildren("compositeSetting");
                for (Element settingElement : lSetting) {
                    String varName = LocaleSelector.getAttribute(settingElement, "label");
                    String value = settingElement.getAttribute("value").getValue();
                    var.addSetting(choice, varName, this.findVar(varName), value);
                }
            } else if (el.getName().equals("compositeChoiceGroup")) {
                this.handleCompositeValChildren(el, var);
            }
            log.debug("element processed");
        }
    }

    protected VariableValue processDecVal(Element child, String name, String comment, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String CV, String mask, String item) throws NumberFormatException {
        int minVal = 0;
        int maxVal = 255;
        Attribute a = child.getAttribute("min");
        if (a != null) {
            minVal = Integer.parseInt(a.getValue());
        }
        if ((a = child.getAttribute("max")) != null) {
            maxVal = Integer.parseInt(a.getValue());
        }
        int factor = 1;
        a = child.getAttribute("factor");
        if (a != null) {
            factor = Integer.parseInt(a.getValue());
        }
        int offset = 0;
        a = child.getAttribute("offset");
        if (a != null) {
            offset = Integer.parseInt(a.getValue());
        }
        if (maxVal > 255 && Objects.equals(mask, "VVVVVVVV")) {
            mask = VariableValue.getMaxMask(maxVal);
            log.debug("Created mask {} for DecVar CV {}", (Object)mask, (Object)name);
        }
        DecVariableValue v = new DecVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item, offset, factor);
        this._cvModel.registerCvToVariableMapping(CV, name);
        return v;
    }

    protected VariableValue processEnumVal(Element child, String name, String comment, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String CV, String mask, String item) throws NumberFormatException {
        EnumVariableValue v1;
        int count = 0;
        IteratorIterable iterator = child.getDescendants();
        while (iterator.hasNext()) {
            Object ex = iterator.next();
            if (!(ex instanceof Element) || !((Element)ex).getName().equals("enumChoice")) continue;
            ++count;
        }
        int maxVal = 255;
        Attribute a = child.getAttribute("max");
        maxVal = a != null ? Integer.parseInt(a.getValue()) : count;
        EnumVariableValue v = v1 = new EnumVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, 0, maxVal, this._cvModel.allCvMap(), this._status, item);
        this._cvModel.registerCvToVariableMapping(CV, name);
        v1.nItems(count);
        this.handleEnumValChildren(child, v1);
        v1.lastItem();
        return v;
    }

    protected VariableValue processSplitEnumVal(Element child, String CV, boolean readOnly, boolean infoOnly, boolean writeOnly, String name, String comment, boolean opsOnly, String mask, String item) throws NumberFormatException {
        SplitEnumVariableValue v1;
        int minVal = 0;
        int maxVal = 255;
        String highCV = null;
        int count = 0;
        IteratorIterable iterator = child.getDescendants();
        while (iterator.hasNext()) {
            Object ex = iterator.next();
            if (!(ex instanceof Element) || !((Element)ex).getName().equals("enumChoice")) continue;
            ++count;
        }
        Attribute a = child.getAttribute("highCV");
        if (a != null) {
            highCV = a.getValue();
            this._cvModel.addCV(highCV, readOnly, infoOnly, writeOnly);
            this._cvModel.registerCvToVariableMapping(highCV, name);
        }
        int factor = 1;
        a = child.getAttribute("factor");
        if (a != null) {
            factor = Integer.parseInt(a.getValue());
        }
        int offset = 0;
        a = child.getAttribute("offset");
        if (a != null) {
            offset = Integer.parseInt(a.getValue());
        }
        String uppermask = "VVVVVVVV";
        a = child.getAttribute("upperMask");
        if (a != null) {
            uppermask = a.getValue();
        }
        String extra3 = "0";
        a = child.getAttribute("min");
        if (a != null) {
            extra3 = a.getValue();
        }
        String extra4 = Long.toUnsignedString(-1L);
        a = child.getAttribute("max");
        if (a != null) {
            extra4 = a.getValue();
        }
        SplitEnumVariableValue v = v1 = new SplitEnumVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item, highCV, factor, offset, uppermask, null, null, extra3, extra4);
        this._cvModel.registerCvToVariableMapping(CV, name);
        v1.nItems(count);
        this.handleSplitEnumValChildren(child, v1);
        v1.lastItem();
        return v;
    }

    protected void handleSplitEnumValChildren(Element e, SplitEnumVariableValue var) {
        List local = e.getChildren();
        for (Element el : local) {
            log.debug("processing element='{}' name='{}' choice='{}' value='{}'", new Object[]{el.getName(), LocaleSelector.getAttribute(el, "name"), LocaleSelector.getAttribute(el, "choice"), el.getAttribute("value")});
            if (this._df != null && !DecoderFile.isIncluded(el, this._df.getProductID(), this._df.getModel(), this._df.getFamily(), "", "")) {
                log.debug("element excluded by productID={} model={} family={}", new Object[]{this._df.getProductID(), this._df.getModel(), this._df.getFamily()});
                continue;
            }
            if (el.getName().equals("enumChoice")) {
                Attribute valAttr = el.getAttribute("value");
                if (valAttr == null) {
                    var.addItem(LocaleSelector.getAttribute(el, "choice"));
                } else {
                    var.addItem(LocaleSelector.getAttribute(el, "choice"), Integer.parseInt(valAttr.getValue()));
                }
            } else if (el.getName().equals("enumChoiceGroup")) {
                var.startGroup(LocaleSelector.getAttribute(el, "name"));
                this.handleSplitEnumValChildren(el, var);
                var.endGroup();
            }
            log.debug("element processed");
        }
    }

    protected void handleEnumValChildren(Element e, EnumVariableValue var) {
        List local = e.getChildren();
        for (Element el : local) {
            log.debug("processing element='{}' name='{}' choice='{}' value='{}'", new Object[]{el.getName(), LocaleSelector.getAttribute(el, "name"), LocaleSelector.getAttribute(el, "choice"), el.getAttribute("value")});
            if (this._df != null && !DecoderFile.isIncluded(el, this._df.getProductID(), this._df.getModel(), this._df.getFamily(), "", "")) {
                log.debug("element excluded by productID={} model={} family={}", new Object[]{this._df.getProductID(), this._df.getModel(), this._df.getFamily()});
                continue;
            }
            if (el.getName().equals("enumChoice")) {
                Attribute valAttr = el.getAttribute("value");
                if (valAttr == null) {
                    var.addItem(LocaleSelector.getAttribute(el, "choice"));
                } else {
                    var.addItem(LocaleSelector.getAttribute(el, "choice"), Integer.parseInt(valAttr.getValue()));
                }
            } else if (el.getName().equals("enumChoiceGroup")) {
                var.startGroup(LocaleSelector.getAttribute(el, "name"));
                this.handleEnumValChildren(el, var);
                var.endGroup();
            }
            log.debug("element processed");
        }
    }

    protected VariableValue processHexVal(Element child, String name, String comment, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String CV, String mask, String item) throws NumberFormatException {
        int minVal = 0;
        int maxVal = 255;
        Attribute a = child.getAttribute("min");
        if (a != null) {
            minVal = Integer.valueOf(a.getValue(), 16);
        }
        if ((a = child.getAttribute("max")) != null) {
            maxVal = Integer.valueOf(a.getValue(), 16);
        }
        if (maxVal > 255 && Objects.equals(mask, "VVVVVVVV")) {
            mask = VariableValue.getMaxMask(maxVal);
            log.debug("Created mask {} for Hex CV {}", (Object)mask, (Object)name);
        }
        HexVariableValue v = new HexVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item);
        this._cvModel.registerCvToVariableMapping(CV, name);
        return v;
    }

    protected VariableValue processLongAddressVal(String CV, boolean readOnly, boolean infoOnly, boolean writeOnly, String name, String comment, boolean opsOnly, String mask, String item) {
        int minVal = 0;
        int maxVal = 255;
        this._cvModel.addCV("18", readOnly, infoOnly, writeOnly);
        LongAddrVariableValue v = new LongAddrVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item, this._cvModel.allCvMap().get("18"));
        this._cvModel.registerCvToVariableMapping(CV, name);
        this._cvModel.registerCvToVariableMapping("18", name);
        return v;
    }

    protected VariableValue processShortAddressVal(String name, String comment, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String CV, String mask, String item, Element child) {
        ShortAddrVariableValue v1;
        ShortAddrVariableValue v = v1 = new ShortAddrVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, this._cvModel.allCvMap(), this._status, item);
        List l = child.getChildren("shortAddressChanges");
        for (Element element : l) {
            v1.setModifiedCV(element.getAttribute("cv").getValue());
        }
        this._cvModel.registerCvToVariableMapping(CV, name);
        return v;
    }

    protected VariableValue processSpeedTableVal(Element child, String CV, boolean readOnly, boolean infoOnly, boolean writeOnly, String name, String comment, boolean opsOnly, String mask, String item) throws NumberFormatException {
        int minVal = 0;
        int maxVal = 255;
        Attribute a = child.getAttribute("min");
        if (a != null) {
            minVal = Integer.parseInt(a.getValue());
        }
        if ((a = child.getAttribute("max")) != null) {
            maxVal = Integer.parseInt(a.getValue());
        }
        Attribute entriesAttr = child.getAttribute("entries");
        int entries = 28;
        try {
            if (entriesAttr != null) {
                entries = entriesAttr.getIntValue();
            }
        }
        catch (DataConversionException dataConversionException) {
            // empty catch block
        }
        Attribute ESUAttr = child.getAttribute("mfx");
        boolean mfxFlag = false;
        try {
            if (ESUAttr != null) {
                mfxFlag = ESUAttr.getBooleanValue();
            }
        }
        catch (DataConversionException dataConversionException) {
            // empty catch block
        }
        for (int i = 0; i < entries; ++i) {
            this._cvModel.addCV(Integer.toString(Integer.parseInt(CV) + i), readOnly, infoOnly, writeOnly);
            this._cvModel.registerCvToVariableMapping(Integer.toString(Integer.parseInt(CV) + i), name);
        }
        if (mfxFlag) {
            this._cvModel.addCV("2", readOnly, infoOnly, writeOnly);
            this._cvModel.registerCvToVariableMapping("2", name);
            this._cvModel.addCV("5", readOnly, infoOnly, writeOnly);
            this._cvModel.registerCvToVariableMapping("5", name);
        }
        SpeedTableVarValue v = new SpeedTableVarValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item, entries, mfxFlag);
        return v;
    }

    protected VariableValue processSplitVal(Element child, String CV, boolean readOnly, boolean infoOnly, boolean writeOnly, String name, String comment, boolean opsOnly, String mask, String item) throws NumberFormatException {
        int minVal = 0;
        int maxVal = 255;
        String highCV = null;
        Attribute a = child.getAttribute("highCV");
        if (a != null) {
            highCV = a.getValue();
            this._cvModel.addCV(highCV, readOnly, infoOnly, writeOnly);
            this._cvModel.registerCvToVariableMapping(highCV, name);
        }
        int factor = 1;
        a = child.getAttribute("factor");
        if (a != null) {
            factor = Integer.parseInt(a.getValue());
        }
        int offset = 0;
        a = child.getAttribute("offset");
        if (a != null) {
            offset = Integer.parseInt(a.getValue());
        }
        String uppermask = "VVVVVVVV";
        a = child.getAttribute("upperMask");
        if (a != null) {
            uppermask = a.getValue();
        }
        String extra3 = "0";
        a = child.getAttribute("min");
        if (a != null) {
            extra3 = a.getValue();
        }
        String extra4 = Long.toUnsignedString(-1L);
        a = child.getAttribute("max");
        if (a != null) {
            extra4 = a.getValue();
        }
        SplitVariableValue v = new SplitVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item, highCV, factor, offset, uppermask, null, null, extra3, extra4);
        this._cvModel.registerCvToVariableMapping(CV, name);
        return v;
    }

    protected VariableValue processSplitHexVal(Element child, String CV, boolean readOnly, boolean infoOnly, boolean writeOnly, String name, String comment, boolean opsOnly, String mask, String item) throws NumberFormatException {
        int minVal = 0;
        int maxVal = 255;
        String highCV = null;
        Attribute a = child.getAttribute("highCV");
        if (a != null) {
            highCV = a.getValue();
            this._cvModel.addCV(highCV, readOnly, infoOnly, writeOnly);
            this._cvModel.registerCvToVariableMapping(highCV, name);
        }
        int factor = 1;
        a = child.getAttribute("factor");
        if (a != null) {
            factor = Integer.parseInt(a.getValue());
        }
        int offset = 0;
        a = child.getAttribute("offset");
        if (a != null) {
            offset = Integer.parseInt(a.getValue());
        }
        String uppermask = "VVVVVVVV";
        a = child.getAttribute("upperMask");
        if (a != null) {
            uppermask = a.getValue();
        }
        String extra1 = "default";
        a = child.getAttribute("case");
        if (a != null) {
            extra1 = a.getValue();
        }
        String extra3 = "0";
        a = child.getAttribute("min");
        if (a != null) {
            extra3 = a.getValue();
        }
        String extra4 = Long.toUnsignedString(-1L, 16);
        a = child.getAttribute("max");
        if (a != null) {
            extra4 = a.getValue();
        }
        SplitHexVariableValue v = new SplitHexVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item, highCV, factor, offset, uppermask, extra1, null, extra3, extra4);
        this._cvModel.registerCvToVariableMapping(CV, name);
        return v;
    }

    protected VariableValue processSplitHundredsVal(Element child, String CV, boolean readOnly, boolean infoOnly, boolean writeOnly, String name, String comment, boolean opsOnly, String mask, String item) throws NumberFormatException {
        int minVal = 0;
        int maxVal = 255;
        String highCV = null;
        Attribute a = child.getAttribute("highCV");
        if (a != null) {
            highCV = a.getValue();
            this._cvModel.addCV(highCV, readOnly, infoOnly, writeOnly);
            this._cvModel.registerCvToVariableMapping(highCV, name);
        }
        int factor = 1;
        a = child.getAttribute("factor");
        if (a != null) {
            factor = Integer.parseInt(a.getValue());
        }
        int offset = 0;
        a = child.getAttribute("offset");
        if (a != null) {
            offset = Integer.parseInt(a.getValue());
        }
        String uppermask = "VVVVVVVV";
        a = child.getAttribute("upperMask");
        if (a != null) {
            uppermask = a.getValue();
        }
        String extra3 = "0";
        a = child.getAttribute("min");
        if (a != null) {
            extra3 = a.getValue();
        }
        String extra4 = Long.toUnsignedString(-1L);
        a = child.getAttribute("max");
        if (a != null) {
            extra4 = a.getValue();
        }
        SplitHundredsVariableValue v = new SplitHundredsVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item, highCV, factor, offset, uppermask, null, null, extra3, extra4);
        this._cvModel.registerCvToVariableMapping(CV, name);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Error Message")
    protected VariableValue processSplitTextVal(Element child, String CV, boolean readOnly, boolean infoOnly, boolean writeOnly, String name, String comment, boolean opsOnly, String mask, String item) throws NumberFormatException {
        boolean ok;
        int minVal = 0;
        int maxVal = 255;
        String highCV = null;
        Attribute a = child.getAttribute("min");
        if (a != null) {
            minVal = Integer.parseInt(a.getValue());
        }
        if ((a = child.getAttribute("max")) != null) {
            maxVal = Integer.parseInt(a.getValue());
        }
        if ((a = child.getAttribute("highCV")) != null) {
            highCV = a.getValue();
            this._cvModel.addCV(highCV, readOnly, infoOnly, writeOnly);
            this._cvModel.registerCvToVariableMapping(highCV, name);
        }
        int factor = 1;
        a = child.getAttribute("factor");
        if (a != null) {
            factor = Integer.parseInt(a.getValue());
        }
        int offset = 0;
        a = child.getAttribute("offset");
        if (a != null) {
            offset = Integer.parseInt(a.getValue());
        }
        String uppermask = "VVVVVVVV";
        a = child.getAttribute("upperMask");
        if (a != null) {
            uppermask = a.getValue();
        }
        String match = null;
        a = child.getAttribute("match");
        if (a != null) {
            match = a.getValue();
        }
        String termByte = "0";
        a = child.getAttribute("termByte");
        if (a != null) {
            termByte = a.getValue();
        }
        String padByte = "0";
        a = child.getAttribute("padByte");
        if (a != null) {
            padByte = a.getValue();
        }
        String charSet = Charset.defaultCharset().name();
        a = child.getAttribute("charSet");
        if (a != null) {
            charSet = a.getValue();
        }
        try {
            ok = Charset.isSupported(charSet);
        }
        catch (IllegalArgumentException ex) {
            ok = false;
        }
        if (!ok) {
            VariableTableModel variableTableModel = this;
            synchronized (variableTableModel) {
                JmriJOptionPane.showMessageDialog(new JFrame(), Bundle.getMessage("UnsupportedCharset", charSet, name), Bundle.getMessage("DecoderDefError"), 0);
            }
            log.error(Bundle.getMessage("UnsupportedCharset", charSet, name));
        }
        SplitTextVariableValue v = new SplitTextVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item, highCV, factor, offset, uppermask, match, termByte, padByte, charSet);
        this._cvModel.registerCvToVariableMapping(CV, name);
        return v;
    }

    protected VariableValue processSplitDateTimeVal(Element child, String CV, boolean readOnly, boolean infoOnly, boolean writeOnly, String name, String comment, boolean opsOnly, String mask, String item) throws NumberFormatException {
        int minVal = 0;
        int maxVal = 255;
        boolean varRreadOnly = true;
        String highCV = null;
        Attribute a = child.getAttribute("min");
        if (a != null) {
            minVal = Integer.parseInt(a.getValue());
        }
        if ((a = child.getAttribute("max")) != null) {
            maxVal = Integer.parseInt(a.getValue());
        }
        if ((a = child.getAttribute("highCV")) != null) {
            highCV = a.getValue();
            this._cvModel.addCV(highCV, readOnly, infoOnly, writeOnly);
            this._cvModel.registerCvToVariableMapping(highCV, name);
        }
        int factor = 1;
        int offset = 0;
        String uppermask = "VVVVVVVV";
        a = child.getAttribute("upperMask");
        if (a != null) {
            uppermask = a.getValue();
        }
        String extra1 = "2000-01-01T00:00:00";
        a = child.getAttribute("base");
        if (a != null) {
            extra1 = a.getValue();
        }
        String extra2 = "1";
        a = child.getAttribute("factor");
        if (a != null) {
            extra2 = a.getValue();
        }
        String extra3 = "Seconds";
        a = child.getAttribute("unit");
        if (a != null) {
            extra3 = a.getValue();
        }
        String extra4 = "default";
        a = child.getAttribute("display");
        if (a != null) {
            extra4 = a.getValue();
        }
        SplitDateTimeVariableValue v = new SplitDateTimeVariableValue(name, comment, "", varRreadOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, item, highCV, factor, offset, uppermask, extra1, extra2, extra3, extra4);
        this._cvModel.registerCvToVariableMapping(CV, name);
        return v;
    }

    protected void setButtonsReadWrite(boolean readOnly, boolean infoOnly, boolean writeOnly, JButton bw, JButton br, int row) {
        if (readOnly || infoOnly) {
            if (writeOnly) {
                bw.setEnabled(true);
                bw.setActionCommand("W" + row);
                bw.addActionListener(this);
            } else {
                bw.setEnabled(false);
            }
            if (infoOnly) {
                br.setEnabled(false);
            } else {
                br.setActionCommand("R" + row);
                br.addActionListener(this);
            }
        } else {
            bw.setActionCommand("W" + row);
            bw.addActionListener(this);
            if (writeOnly) {
                br.setEnabled(false);
            } else {
                br.setActionCommand("R" + row);
                br.addActionListener(this);
            }
        }
    }

    public void setButtonModeFromProgrammer() {
        if (this._cvModel.getProgrammer() == null || !this._cvModel.getProgrammer().getCanRead()) {
            for (JButton b : this._readButtons) {
                b.setEnabled(false);
            }
        }
    }

    protected void setToolTip(Element e, VariableValue v) {
        String t = LocaleSelector.getAttribute(e, "tooltip");
        if (t != null) {
            v.setToolTipText(t);
        }
    }

    void reportBogus(Element elem) {
        log.error("Did not find a valid type in {}", (Object)elem.getChildren());
        for (Attribute a : elem.getAttributes()) {
            log.error("   attribute: {}", (Object)a);
        }
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="null mask parameter to ConstantValue constructor expected.")
    public void setConstant(Element e) {
        String stdname = e.getAttribute("item").getValue();
        log.debug("Starting to setConstant \"{}\"", (Object)stdname);
        String name = LocaleSelector.getAttribute(e, "label");
        if (name == null || name.equals("")) {
            name = stdname;
        }
        String comment = LocaleSelector.getAttribute(e, "comment");
        String mask = null;
        JButton bw = new JButton();
        this._writeButtons.addElement(bw);
        JButton br = new JButton("Read");
        this._readButtons.addElement(br);
        int defaultVal = 0;
        Attribute a = e.getAttribute("default");
        if (a != null) {
            String val = a.getValue();
            log.debug("Found default value: {} for {}", (Object)val, (Object)stdname);
            defaultVal = Integer.parseInt(val);
        }
        ConstantValue v = new ConstantValue(name, comment, "", true, true, false, false, "", mask, defaultVal, defaultVal, this._cvModel.allCvMap(), this._status, stdname);
        this.rowVector.addElement(v);
        v.setState(AbstractValue.ValueState.FROMFILE);
        v.addPropertyChangeListener(this);
        a = e.getAttribute("default");
        if (a != null) {
            String val = a.getValue();
            log.debug("Found default value: {} for {}", (Object)val, (Object)name);
            v.setIntValue(defaultVal);
        }
    }

    public void newDecVariableValue(String name, String CV, String comment, String mask, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly) {
        this.setFileDirty(true);
        int minVal = 0;
        int maxVal = 255;
        this._cvModel.addCV(CV, readOnly, infoOnly, writeOnly);
        int row = this.getRowCount();
        JButton bw = new JButton(Bundle.getMessage("ButtonWrite"));
        bw.setActionCommand("W" + row);
        bw.addActionListener(this);
        this._writeButtons.addElement(bw);
        JButton br = new JButton(Bundle.getMessage("ButtonRead"));
        br.setActionCommand("R" + row);
        br.addActionListener(this);
        this._readButtons.addElement(br);
        DecVariableValue v = new DecVariableValue(name, comment, "", readOnly, infoOnly, writeOnly, opsOnly, CV, mask, minVal, maxVal, this._cvModel.allCvMap(), this._status, null);
        this.rowVector.addElement(v);
        v.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("action performed,  command: {}", (Object)e.getActionCommand());
        }
        this.setFileDirty(true);
        char b = e.getActionCommand().charAt(0);
        int row = Integer.parseInt(e.getActionCommand().substring(1));
        log.debug("event on {} row {}", (Object)Character.valueOf(b), (Object)row);
        if (b == 'R') {
            this.read(row);
        } else {
            this.write(row);
        }
    }

    public void read(int i) {
        VariableValue v = this.rowVector.elementAt(i);
        v.readAll();
    }

    public void write(int i) {
        VariableValue v = this.rowVector.elementAt(i);
        v.writeAll();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("prop changed {} new value: {}{} Source {}", new Object[]{e.getPropertyName(), e.getNewValue(), e.getPropertyName().equals("State") ? " (" + ((AbstractValue.ValueState)((Object)e.getNewValue())).getName() + ") " : " ", e.getSource()});
        }
        if (e.getNewValue() == null) {
            log.error("new value of {} should not be null!", (Object)e.getPropertyName(), (Object)new Exception());
        }
        if (e.getPropertyName().equals("State") && (AbstractValue.ValueState)((Object)e.getNewValue()) == AbstractValue.ValueState.READ || e.getPropertyName().equals("State") && (AbstractValue.ValueState)((Object)e.getNewValue()) == AbstractValue.ValueState.EDITED) {
            this.setFileDirty(true);
        }
        this.fireTableDataChanged();
    }

    public void configDone() {
        this.fireTableDataChanged();
    }

    public boolean fileDirty() {
        return this._fileDirty;
    }

    public void setFileDirty(boolean b) {
        this._fileDirty = b;
    }

    public boolean decoderDirty() {
        int len = this.rowVector.size();
        for (int i = 0; i < len; ++i) {
            if (this.rowVector.elementAt(i).getState() != AbstractValue.ValueState.EDITED) continue;
            return true;
        }
        return false;
    }

    public VariableValue findVar(String name) {
        int i;
        for (i = 0; i < this.getRowCount(); ++i) {
            if (!name.equals(this.getItem(i))) continue;
            log.trace("findVar matched '{}' by Item", (Object)name);
            return this.getVariable(i);
        }
        for (i = 0; i < this.getRowCount(); ++i) {
            if (!name.equals(this.getLabel(i))) continue;
            log.trace("findVar matched '{}' by Label rather than Item", (Object)name);
            return this.getVariable(i);
        }
        log.debug("findVar did not match {}, returns null", (Object)name);
        return null;
    }

    public int findVarIndex(String name) {
        return this.findVarIndex(name, false);
    }

    public int findVarIndex(String name, boolean searchFromEnd) {
        if (searchFromEnd) {
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                if (name.equals(this.getItem(i))) {
                    return i;
                }
                if (name.equals(this.getLabel(i))) {
                    return i;
                }
                if (!name.equals("CV" + this.getCvName(i))) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (name.equals(this.getItem(i))) {
                    return i;
                }
                if (name.equals(this.getLabel(i))) {
                    return i;
                }
                if (!name.equals("CV" + this.getCvName(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public void dispose() {
        int i;
        log.debug("dispose");
        for (i = 0; i < this._writeButtons.size(); ++i) {
            this._writeButtons.elementAt(i).removeActionListener(this);
        }
        for (i = 0; i < this._readButtons.size(); ++i) {
            this._readButtons.elementAt(i).removeActionListener(this);
        }
        for (i = 0; i < this.rowVector.size(); ++i) {
            VariableValue v = this.rowVector.elementAt(i);
            v.removePropertyChangeListener(this);
            v.dispose();
        }
        this.headers = null;
        this.rowVector.removeAllElements();
        this.rowVector = null;
        this._cvModel = null;
        this._writeButtons.removeAllElements();
        this._writeButtons = null;
        this._readButtons.removeAllElements();
        this._readButtons = null;
        this._status = null;
    }
}

