/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog.tabbedframe;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.InstanceManager;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterMenu;
import jmri.jmrit.symbolicprog.KnownLocoSelPane;
import jmri.jmrit.symbolicprog.SymbolicProgBundle;
import jmri.jmrit.symbolicprog.tabbedframe.PaneOpsProgFrame;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaneOpsProgAction
extends AbstractAction {
    Object o1;
    Object o2;
    Object o3;
    Object o4;
    JLabel statusLabel = new JLabel(SymbolicProgBundle.getMessage("StateIdle"));
    private static final Logger log = LoggerFactory.getLogger(PaneOpsProgAction.class);

    public PaneOpsProgAction() {
        this("DecoderPro ops-mode programmer");
    }

    public PaneOpsProgAction(String s) {
        super(s);
        if (InstanceManager.getNullableDefault(AddressedProgrammerManager.class) == null || !InstanceManager.getDefault(AddressedProgrammerManager.class).isAddressedModePossible()) {
            this.setEnabled(false);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("Pane programmer requested");
        }
        JmriJFrame f = new JmriJFrame(SymbolicProgBundle.getMessage("FrameOpsProgrammerSetup"));
        f.getContentPane().setLayout(new BoxLayout(f.getContentPane(), 1));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new RosterMenu(SymbolicProgBundle.getMessage("MenuRoster"), 1, f));
        f.setJMenuBar(menuBar);
        KnownLocoSelPane pane1 = new KnownLocoSelPane(false){

            @Override
            protected void startProgrammer(DecoderFile decoderFile, RosterEntry re, String filename) {
                String title = MessageFormat.format(SymbolicProgBundle.getMessage("FrameOpsProgrammerTitle"), re.getId());
                int address = Integer.parseInt(re.getDccAddress());
                boolean longAddr = re.isLongAddress();
                AddressedProgrammer programmer = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(longAddr, address);
                PaneOpsProgFrame p = new PaneOpsProgFrame(decoderFile, re, title, "programmers" + File.separator + filename + ".xml", programmer);
                ((Window)p).pack();
                p.setVisible(true);
            }
        };
        pane1.setAlignmentX(0.5f);
        f.getContentPane().add(pane1);
        f.pack();
        if (log.isDebugEnabled()) {
            log.debug("Tab-Programmer setup created");
        }
        f.setVisible(true);
    }
}

