/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog.tabbedframe;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.PrintDecoderListAction;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.progsupport.ProgServiceModeComboBox;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterMenu;
import jmri.jmrit.symbolicprog.CombinedLocoSelTreePane;
import jmri.jmrit.symbolicprog.SymbolicProgBundle;
import jmri.jmrit.symbolicprog.tabbedframe.PaneServiceProgFrame;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaneProgAction
extends AbstractAction {
    Object o1;
    Object o2;
    Object o3;
    Object o4;
    JLabel statusLabel;
    ProgModeSelector modePane = new ProgServiceModeComboBox();
    private static final Logger log = LoggerFactory.getLogger(PaneProgAction.class);

    public PaneProgAction() {
        this("DecoderPro service programmer");
    }

    public PaneProgAction(String s) {
        super(s);
        this.statusLabel = new JLabel(SymbolicProgBundle.getMessage("StateIdle"));
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) == null || !InstanceManager.getDefault(GlobalProgrammerManager.class).isGlobalProgrammerAvailable()) {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Pane programmer requested");
        final JmriJFrame f = new JmriJFrame(SymbolicProgBundle.getMessage("FrameServiceProgrammerSetup"));
        f.getContentPane().setLayout(new BoxLayout(f.getContentPane(), 1));
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                PaneProgAction.this.statusLabel.setText(SymbolicProgBundle.getMessage("StateIdle"));
                f.windowClosing(we);
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu j = new JMenu(SymbolicProgBundle.getMessage("MenuFile"));
        j.add(new PrintDecoderListAction(SymbolicProgBundle.getMessage("MenuPrintDecoderDefinitions"), f, false));
        j.add(new PrintDecoderListAction(SymbolicProgBundle.getMessage("MenuPrintPreviewDecoderDefinitions"), f, true));
        menuBar.add(j);
        menuBar.add(new RosterMenu(SymbolicProgBundle.getMessage("MenuRoster"), 1, f));
        f.setJMenuBar(menuBar);
        CombinedLocoSelTreePane pane1 = new CombinedLocoSelTreePane(this.statusLabel, this.modePane){

            @Override
            protected void startProgrammer(DecoderFile decoderFile, @Nonnull RosterEntry re, @Nonnull String filename) {
                String title = MessageFormat.format(SymbolicProgBundle.getMessage("FrameServiceProgrammerTitle"), re.getId());
                PaneServiceProgFrame p = new PaneServiceProgFrame(decoderFile, re, title, "programmers" + File.separator + filename + ".xml", PaneProgAction.this.modePane.getProgrammer());
                ((Window)p).pack();
                p.setVisible(true);
            }
        };
        JPanel tempPane = new JPanel();
        tempPane.add(this.modePane);
        f.getContentPane().add(tempPane);
        f.getContentPane().add(new JSeparator(0));
        pane1.setAlignmentX(0.5f);
        f.getContentPane().add(pane1);
        f.getContentPane().add(new JSeparator(0));
        this.statusLabel.setAlignmentX(0.5f);
        f.getContentPane().add(this.statusLabel);
        f.pack();
        log.debug("Tab-Programmer setup created");
        f.setVisible(true);
    }
}

