/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog.tabbedframe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableRowSorter;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.CVNameComparator;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.CvValueRenderer;
import jmri.jmrit.symbolicprog.DccAddressPanel;
import jmri.jmrit.symbolicprog.FnMapPanel;
import jmri.jmrit.symbolicprog.FnMapPanelESU;
import jmri.jmrit.symbolicprog.PrintCvAction;
import jmri.jmrit.symbolicprog.Qualifier;
import jmri.jmrit.symbolicprog.QualifierAdder;
import jmri.jmrit.symbolicprog.SymbolicProgBundle;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.jmrit.symbolicprog.tabbedframe.Bundle;
import jmri.jmrit.symbolicprog.tabbedframe.JComponentQualifier;
import jmri.jmrit.symbolicprog.tabbedframe.PaneContainer;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.jmrit.symbolicprog.tabbedframe.WatchingLabel;
import jmri.util.CvUtil;
import jmri.util.StringUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import jmri.util.jdom.LocaleSelector;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaneProgPane
extends JPanel
implements PropertyChangeListener {
    static final String LAST_GRIDX = "last_gridx";
    static final String LAST_GRIDY = "last_gridy";
    protected CvTableModel _cvModel;
    protected VariableTableModel _varModel;
    protected PaneContainer container;
    protected RosterEntry rosterEntry;
    boolean _cvTable;
    protected JPanel bottom;
    transient ItemListener l1;
    protected transient ItemListener l2;
    transient ItemListener l3;
    protected transient ItemListener l4;
    transient ItemListener l5;
    transient ItemListener l6;
    boolean isCvTablePane = false;
    String mName = "";
    List<Integer> varList = new ArrayList<Integer>();
    int varListIndex;
    protected TreeSet<Integer> cvList = new TreeSet();
    protected Iterator<Integer> cvListIterator;
    protected JToggleButton readChangesButton = new JToggleButton(SymbolicProgBundle.getMessage("ButtonReadChangesSheet"));
    protected JToggleButton readAllButton = new JToggleButton(SymbolicProgBundle.getMessage("ButtonReadFullSheet"));
    protected JToggleButton writeChangesButton = new JToggleButton(SymbolicProgBundle.getMessage("ButtonWriteChangesSheet"));
    protected JToggleButton writeAllButton = new JToggleButton(SymbolicProgBundle.getMessage("ButtonWriteFullSheet"));
    JToggleButton confirmChangesButton = new JToggleButton(SymbolicProgBundle.getMessage("ButtonConfirmChangesSheet"));
    JToggleButton confirmAllButton = new JToggleButton(SymbolicProgBundle.getMessage("ButtonConfirmFullSheet"));
    boolean justChanges;
    long cvReadSoFar;
    long cvReadStartTime;
    VariableValue _programmingVar = null;
    CvValue _programmingCV = null;
    boolean _read = true;
    private boolean _busy = false;
    private int retry = 0;
    ArrayList<FnMapPanel> fnMapList = new ArrayList();
    ArrayList<FnMapPanelESU> fnMapListESU = new ArrayList();
    ArrayList<JPanel> panelList = new ArrayList();
    boolean print = false;
    private static final Logger log = LoggerFactory.getLogger(PaneProgPane.class);

    public PaneProgPane() {
    }

    public PaneProgPane(PaneContainer parent, String name, Element pane, CvTableModel cvModel, VariableTableModel varModel, Element modelElem, RosterEntry pRosterEntry) {
        this(parent, name, pane, cvModel, varModel, modelElem, pRosterEntry, false);
    }

    public PaneProgPane(PaneContainer parent, String name, Element pane, CvTableModel cvModel, VariableTableModel varModel, Element modelElem, RosterEntry pRosterEntry, boolean isProgPane) {
        this.container = parent;
        this.mName = name;
        this._cvModel = cvModel;
        this._varModel = varModel;
        this.rosterEntry = pRosterEntry;
        this._cvTable = false;
        this.setLayout(new BoxLayout(this, 1));
        this.setToolTipText(LocaleSelector.getAttribute(pane, "tooltip"));
        boolean showItem = false;
        Attribute nameFmt = pane.getAttribute("nameFmt");
        if (nameFmt != null && nameFmt.getValue().equals("item")) {
            log.debug("Pane {} will show items, not labels, from decoder file", (Object)name);
            showItem = true;
        }
        JPanel p = new JPanel();
        this.panelList.add(p);
        p.setLayout(new BoxLayout(p, 0));
        List colList = pane.getChildren("column");
        for (Object element : colList) {
            p.add(this.newColumn((Element)element, showItem, modelElem));
        }
        List rowList = pane.getChildren("row");
        for (Object element : rowList) {
            p.add(this.newRow((Element)element, showItem, modelElem));
        }
        List gridList = pane.getChildren("grid");
        for (Object element : gridList) {
            p.add(this.newGrid((Element)element, showItem, modelElem));
        }
        List groupList = pane.getChildren("group");
        for (Element element : groupList) {
            p.add(this.newGroup(element, showItem, modelElem));
        }
        if (this.cvList.isEmpty() && this.varList.isEmpty() && isProgPane) {
            JPanel pe = new JPanel();
            pe.setLayout(new BoxLayout(pe, 1));
            int line = 1;
            while (line >= 0) {
                try {
                    String msg = SymbolicProgBundle.getMessage("TextTabEmptyExplain" + line);
                    if (msg.isEmpty()) {
                        msg = " ";
                    }
                    JLabel l = new JLabel(msg);
                    l.setAlignmentX(0.5f);
                    pe.add(l);
                    ++line;
                }
                catch (MissingResourceException e2) {
                    line = -1;
                }
            }
            this.add(pe);
            this.panelList.add(pe);
            return;
        }
        this.add(Box.createHorizontalGlue());
        this.add(new JScrollPane(p));
        this.bottom = new JPanel();
        this.panelList.add(p);
        this.bottom.setLayout(new BoxLayout(this.bottom, 0));
        this.enableReadButtons();
        this.l1 = e -> {
            if (e.getStateChange() == 1) {
                this.readChangesButton.setText(SymbolicProgBundle.getMessage("ButtonStopReadChangesSheet"));
                if (!this.container.isBusy()) {
                    this.prepReadPane(true);
                    this.prepGlassPane(this.readChangesButton);
                    this.container.getBusyGlassPane().setVisible(true);
                    this.readPaneChanges();
                }
            } else {
                this.stopProgramming();
                this.readChangesButton.setText(SymbolicProgBundle.getMessage("ButtonReadChangesSheet"));
                if (this.container.isBusy()) {
                    this.readChangesButton.setEnabled(false);
                }
            }
        };
        this.readChangesButton.addItemListener(this.l1);
        this.l2 = e -> {
            if (e.getStateChange() == 1) {
                this.readAllButton.setText(SymbolicProgBundle.getMessage("ButtonStopReadSheet"));
                if (!this.container.isBusy()) {
                    this.prepReadPane(false);
                    this.prepGlassPane(this.readAllButton);
                    this.container.getBusyGlassPane().setVisible(true);
                    this.readPaneAll();
                }
            } else {
                this.stopProgramming();
                this.readAllButton.setText(SymbolicProgBundle.getMessage("ButtonReadFullSheet"));
                if (this.container.isBusy()) {
                    this.readAllButton.setEnabled(false);
                }
            }
        };
        this.readAllButton.addItemListener(this.l2);
        this.writeChangesButton.setToolTipText(SymbolicProgBundle.getMessage("TipWriteHighlightedSheet"));
        this.l3 = e -> {
            if (e.getStateChange() == 1) {
                this.writeChangesButton.setText(SymbolicProgBundle.getMessage("ButtonStopWriteChangesSheet"));
                if (!this.container.isBusy()) {
                    this.prepWritePane(true);
                    this.prepGlassPane(this.writeChangesButton);
                    this.container.getBusyGlassPane().setVisible(true);
                    this.writePaneChanges();
                }
            } else {
                this.stopProgramming();
                this.writeChangesButton.setText(SymbolicProgBundle.getMessage("ButtonWriteChangesSheet"));
                if (this.container.isBusy()) {
                    this.writeChangesButton.setEnabled(false);
                }
            }
        };
        this.writeChangesButton.addItemListener(this.l3);
        this.writeAllButton.setToolTipText(SymbolicProgBundle.getMessage("TipWriteAllSheet"));
        this.l4 = e -> {
            if (e.getStateChange() == 1) {
                this.writeAllButton.setText(SymbolicProgBundle.getMessage("ButtonStopWriteSheet"));
                if (!this.container.isBusy()) {
                    this.prepWritePane(false);
                    this.prepGlassPane(this.writeAllButton);
                    this.container.getBusyGlassPane().setVisible(true);
                    this.writePaneAll();
                }
            } else {
                this.stopProgramming();
                this.writeAllButton.setText(SymbolicProgBundle.getMessage("ButtonWriteFullSheet"));
                if (this.container.isBusy()) {
                    this.writeAllButton.setEnabled(false);
                }
            }
        };
        this.writeAllButton.addItemListener(this.l4);
        this.enableConfirmButtons();
        this.l5 = e -> {
            if (e.getStateChange() == 1) {
                this.confirmChangesButton.setText(SymbolicProgBundle.getMessage("ButtonStopConfirmChangesSheet"));
                if (!this.container.isBusy()) {
                    this.prepConfirmPane(true);
                    this.prepGlassPane(this.confirmChangesButton);
                    this.container.getBusyGlassPane().setVisible(true);
                    this.confirmPaneChanges();
                }
            } else {
                this.stopProgramming();
                this.confirmChangesButton.setText(SymbolicProgBundle.getMessage("ButtonConfirmChangesSheet"));
                if (this.container.isBusy()) {
                    this.confirmChangesButton.setEnabled(false);
                }
            }
        };
        this.confirmChangesButton.addItemListener(this.l5);
        this.l6 = e -> {
            if (e.getStateChange() == 1) {
                this.confirmAllButton.setText(SymbolicProgBundle.getMessage("ButtonStopConfirmSheet"));
                if (!this.container.isBusy()) {
                    this.prepConfirmPane(false);
                    this.prepGlassPane(this.confirmAllButton);
                    this.container.getBusyGlassPane().setVisible(true);
                    this.confirmPaneAll();
                }
            } else {
                this.stopProgramming();
                this.confirmAllButton.setText(SymbolicProgBundle.getMessage("ButtonConfirmFullSheet"));
                if (this.container.isBusy()) {
                    this.confirmAllButton.setEnabled(false);
                }
            }
        };
        this.confirmAllButton.addItemListener(this.l6);
        this.bottom.add(this.readChangesButton);
        this.bottom.add(this.writeChangesButton);
        if (this._cvTable) {
            this.bottom.add(this.confirmChangesButton);
        }
        this.bottom.add(this.readAllButton);
        this.bottom.add(this.writeAllButton);
        if (this._cvTable) {
            this.bottom.add(this.confirmAllButton);
        }
        if (this._cvModel.getProgrammer() != null) {
            this.add(this.bottom);
        }
    }

    public void setNoDecoder() {
        this.readChangesButton.setEnabled(false);
        this.readAllButton.setEnabled(false);
        this.writeChangesButton.setEnabled(false);
        this.writeAllButton.setEnabled(false);
        this.confirmChangesButton.setEnabled(false);
        this.confirmAllButton.setEnabled(false);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    void enableReadButtons() {
        this.readChangesButton.setToolTipText(SymbolicProgBundle.getMessage("TipReadChangesSheet"));
        this.readAllButton.setToolTipText(SymbolicProgBundle.getMessage("TipReadAllSheet"));
        if (this._cvModel.getProgrammer() != null && !this._cvModel.getProgrammer().getCanRead()) {
            this.readChangesButton.setEnabled(false);
            this.readAllButton.setEnabled(false);
            this.readChangesButton.setToolTipText(SymbolicProgBundle.getMessage("TipNoRead"));
            this.readAllButton.setToolTipText(SymbolicProgBundle.getMessage("TipNoRead"));
        } else {
            this.readChangesButton.setEnabled(true);
            this.readAllButton.setEnabled(true);
        }
    }

    void enableConfirmButtons() {
        this.confirmChangesButton.setToolTipText(SymbolicProgBundle.getMessage("TipConfirmChangesSheet"));
        this.confirmAllButton.setToolTipText(SymbolicProgBundle.getMessage("TipConfirmAllSheet"));
        if (this._cvModel.getProgrammer() != null && !this._cvModel.getProgrammer().getCanRead()) {
            this.confirmChangesButton.setEnabled(false);
            this.confirmAllButton.setEnabled(false);
            this.confirmChangesButton.setToolTipText(SymbolicProgBundle.getMessage("TipNoRead"));
            this.confirmAllButton.setToolTipText(SymbolicProgBundle.getMessage("TipNoRead"));
        } else {
            this.confirmChangesButton.setEnabled(true);
            this.confirmAllButton.setEnabled(true);
        }
    }

    public int countOpsNeeded(boolean read, boolean changes) {
        HashSet<Integer> set = new HashSet<Integer>(this.cvList.size() + this.varList.size() + 50);
        return this.makeOpsNeededSet(read, changes, set).size();
    }

    public Set<Integer> makeOpsNeededSet(boolean read, boolean changes, Set<Integer> set) {
        for (int varNum : this.varList) {
            CvValue[] cvs;
            VariableValue var = this._varModel.getVariable(varNum);
            if (changes && !var.isChanged()) continue;
            for (CvValue cv : cvs = var.usesCVs()) {
                if (changes && !VariableValue.considerChanged(cv)) continue;
                set.add(Integer.valueOf(cv.number()));
            }
        }
        return set;
    }

    private void prepGlassPane(AbstractButton activeButton) {
        this.container.prepGlassPane(activeButton);
    }

    void enableButtons(boolean stat) {
        if (stat) {
            this.enableReadButtons();
            this.enableConfirmButtons();
        } else {
            this.readChangesButton.setEnabled(stat);
            this.readAllButton.setEnabled(stat);
            this.confirmChangesButton.setEnabled(stat);
            this.confirmAllButton.setEnabled(stat);
        }
        this.writeChangesButton.setEnabled(stat);
        this.writeAllButton.setEnabled(stat);
    }

    public boolean readPaneChanges() {
        if (log.isDebugEnabled()) {
            log.debug("readPane starts with {} vars, {} cvs ", (Object)this.varList.size(), (Object)this.cvList.size());
        }
        this.prepReadPane(true);
        return this.nextRead();
    }

    public void prepReadPane(boolean onlyChanges) {
        log.debug("start prepReadPane with onlyChanges={}", (Object)onlyChanges);
        this.justChanges = onlyChanges;
        if (this.isCvTablePane) {
            this.setCvListFromTable();
        }
        this.enableButtons(false);
        if (this.justChanges) {
            this.readChangesButton.setEnabled(true);
            this.readChangesButton.setSelected(true);
        } else {
            this.readAllButton.setSelected(true);
            this.readAllButton.setEnabled(true);
        }
        if (!this.container.isBusy()) {
            this.container.enableButtons(false);
        }
        this.setToRead(this.justChanges, true);
        this.varListIndex = 0;
        this.cvListIterator = this.cvList.iterator();
        this.cvReadSoFar = 0L;
        this.cvReadStartTime = System.currentTimeMillis();
    }

    public boolean readPaneAll() {
        if (log.isDebugEnabled()) {
            log.debug("readAllPane starts with {} vars, {} cvs ", (Object)this.varList.size(), (Object)this.cvList.size());
        }
        this.prepReadPane(false);
        return this.nextRead();
    }

    void setToRead(boolean justChanges, boolean startProcess) {
        if (!this.container.isBusy() || !startProcess) {
            for (int varNum : this.varList) {
                VariableValue var = this._varModel.getVariable(varNum);
                if (justChanges) {
                    if (var.isChanged()) {
                        var.setToRead(startProcess);
                        continue;
                    }
                    var.setToRead(false);
                    continue;
                }
                var.setToRead(startProcess);
            }
            if (this.isCvTablePane) {
                this.setCvListFromTable();
            }
            for (int cvNum : this.cvList) {
                CvValue cv = this._cvModel.getCvByRow(cvNum);
                if (justChanges) {
                    if (VariableValue.considerChanged(cv)) {
                        cv.setToRead(startProcess);
                        continue;
                    }
                    cv.setToRead(false);
                    continue;
                }
                cv.setToRead(startProcess);
            }
        }
    }

    void setToWrite(boolean justChanges, boolean startProcess) {
        log.debug("start setToWrite method with {},{}", (Object)justChanges, (Object)startProcess);
        if (!this.container.isBusy() || !startProcess) {
            log.debug("about to start setToWrite of varList");
            for (int varNum : this.varList) {
                VariableValue var = this._varModel.getVariable(varNum);
                if (justChanges) {
                    if (var.isChanged()) {
                        var.setToWrite(startProcess);
                        continue;
                    }
                    var.setToWrite(false);
                    continue;
                }
                var.setToWrite(startProcess);
            }
            log.debug("about to start setToWrite of cvList");
            if (this.isCvTablePane) {
                this.setCvListFromTable();
            }
            for (int cvNum : this.cvList) {
                CvValue cv = this._cvModel.getCvByRow(cvNum);
                if (justChanges) {
                    if (VariableValue.considerChanged(cv)) {
                        cv.setToWrite(startProcess);
                        continue;
                    }
                    cv.setToWrite(false);
                    continue;
                }
                cv.setToWrite(startProcess);
            }
        }
        log.debug("end setToWrite method");
    }

    void executeRead(VariableValue var) {
        this.setBusy(true);
        if (this._programmingVar != null) {
            log.error("listener already set at read start");
        }
        this._programmingVar = var;
        this._read = true;
        this._programmingVar.addPropertyChangeListener(this);
        if (this.justChanges) {
            this._programmingVar.readChanges();
        } else {
            this._programmingVar.readAll();
        }
    }

    void executeWrite(VariableValue var) {
        this.setBusy(true);
        if (this._programmingVar != null) {
            log.error("listener already set at write start");
        }
        this._programmingVar = var;
        this._read = false;
        this._programmingVar.addPropertyChangeListener(this);
        if (this.justChanges) {
            this._programmingVar.writeChanges();
        } else {
            this._programmingVar.writeAll();
        }
    }

    boolean nextRead() {
        if (log.isDebugEnabled()) {
            log.debug("nextRead scans {} variables", (Object)this.varList.size());
        }
        while (this.varList.size() > 0 && this.varListIndex < this.varList.size()) {
            int varNum = this.varList.get(this.varListIndex);
            AbstractValue.ValueState vState = this._varModel.getState(varNum);
            VariableValue var = this._varModel.getVariable(varNum);
            if (log.isDebugEnabled()) {
                log.debug("nextRead var index {} state {} isToRead: {} label: {}", new Object[]{varNum, vState.getName(), var.isToRead(), var.label()});
            }
            ++this.varListIndex;
            if (!var.isToRead()) continue;
            if (log.isDebugEnabled()) {
                log.debug("start read of variable {}", (Object)this._varModel.getLabel(varNum));
            }
            this.executeRead(var);
            log.debug("return from starting var read");
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("nextRead scans {} CVs", (Object)this.cvList.size());
        }
        while (this.cvListIterator != null && this.cvListIterator.hasNext()) {
            int cvNum = this.cvListIterator.next();
            ++this.cvReadSoFar;
            CvValue cv = this._cvModel.getCvByRow(cvNum);
            if (log.isDebugEnabled()) {
                log.debug("nextRead cv index {} state {}", (Object)cvNum, (Object)cv.getState());
            }
            if (!cv.isToRead()) continue;
            log.debug("start read of cv {}", (Object)cvNum);
            this.setBusy(true);
            if (this._programmingCV != null) {
                log.error("listener already set at read start");
            }
            this._programmingCV = this._cvModel.getCvByRow(cvNum);
            this._read = true;
            this._programmingCV.addPropertyChangeListener(this);
            this._programmingCV.read(this._cvModel.getStatusLabel(), this.cvReadSoFar, this.cvList.size(), this.cvReadStartTime);
            log.debug("return from starting CV read");
            return true;
        }
        log.debug("nextRead found nothing to do");
        this.readChangesButton.setSelected(false);
        this.readAllButton.setSelected(false);
        this.setBusy(false);
        this.container.paneFinished();
        return false;
    }

    boolean nextConfirm() {
        while (this.cvListIterator != null && this.cvListIterator.hasNext()) {
            int cvNum = this.cvListIterator.next();
            CvValue cv = this._cvModel.getCvByRow(cvNum);
            if (log.isDebugEnabled()) {
                log.debug("nextConfirm cv index {} state {}", (Object)cvNum, (Object)cv.getState());
            }
            if (!cv.isToRead()) continue;
            log.debug("start confirm of cv {}", (Object)cvNum);
            this.setBusy(true);
            if (this._programmingCV != null) {
                log.error("listener already set at confirm start");
            }
            this._programmingCV = this._cvModel.getCvByRow(cvNum);
            this._read = true;
            this._programmingCV.addPropertyChangeListener(this);
            this._programmingCV.confirm(this._cvModel.getStatusLabel());
            log.debug("return from starting CV confirm");
            return true;
        }
        log.debug("nextConfirm found nothing to do");
        this.confirmChangesButton.setSelected(false);
        this.confirmAllButton.setSelected(false);
        this.setBusy(false);
        this.container.paneFinished();
        return false;
    }

    public boolean writePaneChanges() {
        log.debug("writePaneChanges starts");
        this.prepWritePane(true);
        boolean val = this.nextWrite();
        log.debug("writePaneChanges returns {}", (Object)val);
        return val;
    }

    public boolean writePaneAll() {
        this.prepWritePane(false);
        return this.nextWrite();
    }

    public void prepWritePane(boolean onlyChanges) {
        log.debug("start prepWritePane with {}", (Object)onlyChanges);
        this.justChanges = onlyChanges;
        this.enableButtons(false);
        if (this.isCvTablePane) {
            this.setCvListFromTable();
        }
        if (this.justChanges) {
            this.writeChangesButton.setEnabled(true);
            this.writeChangesButton.setSelected(true);
        } else {
            this.writeAllButton.setSelected(true);
            this.writeAllButton.setEnabled(true);
        }
        if (!this.container.isBusy()) {
            this.container.enableButtons(false);
        }
        this.setToWrite(this.justChanges, true);
        this.varListIndex = 0;
        this.cvListIterator = this.cvList.iterator();
        log.debug("end prepWritePane");
    }

    boolean nextWrite() {
        log.debug("start nextWrite");
        while (this.varList.size() > 0 && this.varListIndex < this.varList.size()) {
            int varNum = this.varList.get(this.varListIndex);
            AbstractValue.ValueState vState = this._varModel.getState(varNum);
            VariableValue var = this._varModel.getVariable(varNum);
            if (log.isDebugEnabled()) {
                log.debug("nextWrite var index {} state {} isToWrite: {} label:{}", new Object[]{varNum, vState.getName(), var.isToWrite(), var.label()});
            }
            ++this.varListIndex;
            if (!var.isToWrite()) continue;
            log.debug("start write of variable {}", (Object)this._varModel.getLabel(varNum));
            this.executeWrite(var);
            log.debug("return from starting var write");
            return true;
        }
        while (this.cvListIterator != null && this.cvListIterator.hasNext()) {
            int cvNum = this.cvListIterator.next();
            CvValue cv = this._cvModel.getCvByRow(cvNum);
            if (log.isDebugEnabled()) {
                log.debug("nextWrite cv index {} state {}", (Object)cvNum, (Object)cv.getState());
            }
            if (!cv.isToWrite()) continue;
            log.debug("start write of cv index {}", (Object)cvNum);
            this.setBusy(true);
            if (this._programmingCV != null) {
                log.error("listener already set at write start");
            }
            this._programmingCV = this._cvModel.getCvByRow(cvNum);
            this._read = false;
            this._programmingCV.addPropertyChangeListener(this);
            this._programmingCV.write(this._cvModel.getStatusLabel());
            log.debug("return from starting cv write");
            return true;
        }
        log.debug("nextWrite found nothing to do");
        this.writeChangesButton.setSelected(false);
        this.writeAllButton.setSelected(false);
        this.setBusy(false);
        this.container.paneFinished();
        log.debug("return from nextWrite with nothing to do");
        return false;
    }

    public void prepConfirmPane(boolean onlyChanges) {
        log.debug("start prepReadPane with onlyChanges={}", (Object)onlyChanges);
        this.justChanges = onlyChanges;
        this.enableButtons(false);
        if (this.isCvTablePane) {
            this.setCvListFromTable();
        }
        if (this.justChanges) {
            this.confirmChangesButton.setEnabled(true);
            this.confirmChangesButton.setSelected(true);
        } else {
            this.confirmAllButton.setSelected(true);
            this.confirmAllButton.setEnabled(true);
        }
        if (!this.container.isBusy()) {
            this.container.enableButtons(false);
        }
        this.setToRead(this.justChanges, true);
        this.varListIndex = 0;
        this.cvListIterator = this.cvList.iterator();
    }

    public boolean confirmPaneChanges() {
        if (log.isDebugEnabled()) {
            log.debug("confirmPane starts with {} vars, {} cvs ", (Object)this.varList.size(), (Object)this.cvList.size());
        }
        this.prepConfirmPane(true);
        return this.nextConfirm();
    }

    public boolean confirmPaneAll() {
        if (log.isDebugEnabled()) {
            log.debug("confirmAllPane starts with {} vars, {} cvs ", (Object)this.varList.size(), (Object)this.cvList.size());
        }
        this.prepConfirmPane(false);
        return this.nextConfirm();
    }

    public boolean isBusy() {
        return this._busy;
    }

    protected void setBusy(boolean busy) {
        boolean oldBusy = this._busy;
        this._busy = busy;
        if (!busy && !this.container.isBusy()) {
            this.enableButtons(true);
        }
        if (oldBusy != busy) {
            this.firePropertyChange("Busy", (Object)oldBusy, (Object)busy);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this._programmingVar == null && this._programmingCV == null) {
            log.warn("unexpected propertChange: {}", (Object)e);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("property changed: {} new value: {}", (Object)e.getPropertyName(), e.getNewValue());
        }
        if (e.getSource() == this._programmingVar && e.getPropertyName().equals("Busy") && e.getNewValue().equals(Boolean.FALSE)) {
            if (this._programmingVar.getState() == AbstractValue.ValueState.UNKNOWN) {
                if (this.retry == 0) {
                    --this.varListIndex;
                    ++this.retry;
                    if (this._read) {
                        this._programmingVar.setToRead(true);
                    } else {
                        this._programmingVar.setToWrite(true);
                    }
                } else {
                    this.retry = 0;
                }
            }
            this.replyWhileProgrammingVar();
        } else if (e.getSource() == this._programmingCV && e.getPropertyName().equals("Busy") && e.getNewValue().equals(Boolean.FALSE)) {
            this.replyWhileProgrammingCV();
        } else if (log.isDebugEnabled() && e.getPropertyName().equals("Busy")) {
            log.debug("ignoring change of Busy {} {}", e.getNewValue(), (Object)e.getNewValue().equals(Boolean.FALSE));
        }
    }

    public void replyWhileProgrammingVar() {
        log.debug("correct event for programming variable, restart operation");
        this._programmingVar.removePropertyChangeListener(this);
        this._programmingVar = null;
        this.restartProgramming();
    }

    public void replyWhileProgrammingCV() {
        log.debug("correct event for programming CV, restart operation");
        this._programmingCV.removePropertyChangeListener(this);
        this._programmingCV = null;
        this.restartProgramming();
    }

    void restartProgramming() {
        log.debug("start restartProgramming");
        if (this._read && this.readChangesButton.isSelected()) {
            this.nextRead();
        } else if (this._read && this.readAllButton.isSelected()) {
            this.nextRead();
        } else if (this._read && this.confirmChangesButton.isSelected()) {
            this.nextConfirm();
        } else if (this._read && this.confirmAllButton.isSelected()) {
            this.nextConfirm();
        } else if (this.writeChangesButton.isSelected()) {
            this.nextWrite();
        } else if (this.writeAllButton.isSelected()) {
            this.nextWrite();
        } else {
            log.debug("No operation to restart");
            if (this.isBusy()) {
                this.container.paneFinished();
                this.setBusy(false);
            }
        }
        log.debug("end restartProgramming");
    }

    protected void stopProgramming() {
        log.debug("start stopProgramming");
        this.setToRead(false, false);
        this.setToWrite(false, false);
        this.varListIndex = this.varList.size();
        this.cvListIterator = null;
        log.debug("end stopProgramming");
    }

    protected JPanel newGroup(Element element, boolean showStdName, Element modelElem) {
        final JPanel c = new JPanel();
        this.panelList.add(c);
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints cs = new GridBagConstraints();
        c.setLayout(g);
        if (!PaneProgFrame.isIncludedFE(element, modelElem, this.rosterEntry, "", "")) {
            return c;
        }
        List elemList = element.getChildren();
        log.trace("newColumn starting with {} elements", (Object)elemList.size());
        for (Element e : elemList) {
            JPanel l;
            String name = e.getName();
            log.trace("newGroup processing {} element", (Object)name);
            if (name.equals("display")) {
                this.newVariable(e, c, g, cs, showStdName);
                continue;
            }
            if (name.equals("separator")) {
                JSeparator j = new JSeparator(0);
                cs.fill = 1;
                cs.gridwidth = 0;
                g.setConstraints(j, cs);
                c.add(j);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("label")) {
                cs.gridwidth = 0;
                this.makeLabel(e, c, g, cs);
                continue;
            }
            if (name.equals("soundlabel")) {
                cs.gridwidth = 0;
                this.makeSoundLabel(e, c, g, cs);
                continue;
            }
            if (name.equals("cvtable")) {
                this.makeCvTable(cs, g, c);
                continue;
            }
            if (name.equals("fnmapping")) {
                this.pickFnMapPanel(c, g, cs, modelElem);
                continue;
            }
            if (name.equals("dccaddress")) {
                l = this.addDccAddressPanel(e);
                if (l.getComponentCount() <= 0) continue;
                cs.gridwidth = 0;
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("column")) {
                cs.gridheight = 0;
                l = this.newColumn(e, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridheight = 1;
                continue;
            }
            if (name.equals("row")) {
                cs.gridwidth = 0;
                l = this.newRow(e, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("grid")) {
                cs.gridwidth = 0;
                l = this.newGrid(e, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("group")) {
                l = this.newGroup(e, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                continue;
            }
            if (name.equals("qualifier")) continue;
            log.error("No code to handle element of type {} in newColumn", (Object)e.getName());
        }
        if (c.getComponentCount() > 0) {
            c.add(Box.createVerticalGlue());
        }
        QualifierAdder qa = new QualifierAdder(){

            @Override
            protected Qualifier createQualifier(VariableValue var, String relation, String value) {
                return new JComponentQualifier(c, var, Integer.parseInt(value), relation);
            }

            @Override
            protected void addListener(PropertyChangeListener qc) {
                c.addPropertyChangeListener(qc);
            }
        };
        qa.processModifierElements(element, this._varModel);
        return c;
    }

    protected void newGridGroup(Element element, JPanel c, GridBagLayout g, GridGlobals globs, boolean showStdName, Element modelElem) {
        if (!PaneProgFrame.isIncludedFE(element, modelElem, this.rosterEntry, "", "")) {
            return;
        }
        List elemList = element.getChildren();
        log.trace("newColumn starting with {} elements", (Object)elemList.size());
        for (Element e : elemList) {
            String name = e.getName();
            log.trace("newGroup processing {} element", (Object)name);
            if (name.equals("griditem")) {
                final JPanel l = this.newGridItem(e, showStdName, modelElem, globs);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, globs.gridConstraints);
                c.add(l);
                QualifierAdder qa = new QualifierAdder(){

                    @Override
                    protected Qualifier createQualifier(VariableValue var, String relation, String value) {
                        return new JComponentQualifier(l, var, Integer.parseInt(value), relation);
                    }

                    @Override
                    protected void addListener(PropertyChangeListener qc) {
                        l.addPropertyChangeListener(qc);
                    }
                };
                qa.processModifierElements(e, this._varModel);
                continue;
            }
            if (name.equals("group")) {
                this.newGridGroup(e, c, g, globs, showStdName, modelElem);
                continue;
            }
            if (name.equals("qualifier")) continue;
            log.error("No code to handle element of type {} in newColumn", (Object)e.getName());
        }
    }

    public JPanel newColumn(Element element, boolean showStdName, Element modelElem) {
        final JPanel c = new JPanel();
        this.panelList.add(c);
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints cs = new GridBagConstraints();
        c.setLayout(g);
        List elemList = element.getChildren();
        log.trace("newColumn starting with {} elements", (Object)elemList.size());
        for (Element value : elemList) {
            JPanel l;
            ++cs.gridy;
            cs.gridx = 0;
            String name = value.getName();
            log.trace("newColumn processing {} element", (Object)name);
            if (name.equals("display")) {
                this.newVariable(value, c, g, cs, showStdName);
                continue;
            }
            if (name.equals("separator")) {
                JSeparator j = new JSeparator(0);
                cs.fill = 1;
                cs.gridwidth = 0;
                g.setConstraints(j, cs);
                c.add(j);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("label")) {
                cs.gridwidth = 0;
                this.makeLabel(value, c, g, cs);
                continue;
            }
            if (name.equals("soundlabel")) {
                cs.gridwidth = 0;
                this.makeSoundLabel(value, c, g, cs);
                continue;
            }
            if (name.equals("cvtable")) {
                this.makeCvTable(cs, g, c);
                continue;
            }
            if (name.equals("fnmapping")) {
                this.pickFnMapPanel(c, g, cs, modelElem);
                continue;
            }
            if (name.equals("dccaddress")) {
                l = this.addDccAddressPanel(value);
                if (l.getComponentCount() <= 0) continue;
                cs.gridwidth = 0;
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("column")) {
                cs.gridheight = 0;
                l = this.newColumn(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridheight = 1;
                continue;
            }
            if (name.equals("row")) {
                cs.gridwidth = 0;
                l = this.newRow(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("grid")) {
                cs.gridwidth = 0;
                l = this.newGrid(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("group")) {
                l = this.newGroup(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                continue;
            }
            if (name.equals("qualifier")) continue;
            log.error("No code to handle element of type {} in newColumn", (Object)value.getName());
        }
        if (c.getComponentCount() > 0) {
            c.add(Box.createVerticalGlue());
        }
        QualifierAdder qa = new QualifierAdder(){

            @Override
            protected Qualifier createQualifier(VariableValue var, String relation, String value) {
                return new JComponentQualifier(c, var, Integer.parseInt(value), relation);
            }

            @Override
            protected void addListener(PropertyChangeListener qc) {
                c.addPropertyChangeListener(qc);
            }
        };
        qa.processModifierElements(element, this._varModel);
        return c;
    }

    public JPanel newRow(Element element, boolean showStdName, Element modelElem) {
        final JPanel c = new JPanel();
        this.panelList.add(c);
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints cs = new GridBagConstraints();
        c.setLayout(g);
        List elemList = element.getChildren();
        log.trace("newRow starting with {} elements", (Object)elemList.size());
        for (Element value : elemList) {
            JPanel l;
            cs.gridy = 0;
            ++cs.gridx;
            String name = value.getName();
            log.trace("newRow processing {} element", (Object)name);
            if (name.equals("display")) {
                this.newVariable(value, c, g, cs, showStdName);
                continue;
            }
            if (name.equals("separator")) {
                JSeparator j = new JSeparator(1);
                cs.fill = 1;
                cs.gridheight = 0;
                g.setConstraints(j, cs);
                c.add(j);
                cs.fill = 0;
                cs.gridheight = 1;
                continue;
            }
            if (name.equals("label")) {
                cs.gridheight = 0;
                this.makeLabel(value, c, g, cs);
                continue;
            }
            if (name.equals("soundlabel")) {
                cs.gridheight = 0;
                this.makeSoundLabel(value, c, g, cs);
                continue;
            }
            if (name.equals("cvtable")) {
                this.makeCvTable(cs, g, c);
                continue;
            }
            if (name.equals("fnmapping")) {
                this.pickFnMapPanel(c, g, cs, modelElem);
                continue;
            }
            if (name.equals("dccaddress")) {
                l = this.addDccAddressPanel(value);
                if (l.getComponentCount() <= 0) continue;
                cs.gridheight = 0;
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridheight = 1;
                continue;
            }
            if (name.equals("column")) {
                cs.gridheight = 0;
                l = this.newColumn(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridheight = 1;
                continue;
            }
            if (name.equals("row")) {
                cs.gridwidth = 0;
                l = this.newRow(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("grid")) {
                cs.gridwidth = 0;
                l = this.newGrid(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("group")) {
                l = this.newGroup(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                continue;
            }
            if (name.equals("qualifier")) continue;
            log.error("No code to handle element of type {} in newRow", (Object)value.getName());
        }
        if (c.getComponentCount() > 0) {
            c.add(Box.createVerticalGlue());
        }
        QualifierAdder qa = new QualifierAdder(){

            @Override
            protected Qualifier createQualifier(VariableValue var, String relation, String value) {
                return new JComponentQualifier(c, var, Integer.parseInt(value), relation);
            }

            @Override
            protected void addListener(PropertyChangeListener qc) {
                c.addPropertyChangeListener(qc);
            }
        };
        qa.processModifierElements(element, this._varModel);
        return c;
    }

    public JPanel newGrid(Element element, boolean showStdName, Element modelElem) {
        final JPanel c = new JPanel();
        this.panelList.add(c);
        GridBagLayout g = new GridBagLayout();
        c.setLayout(g);
        GridGlobals globs = new GridGlobals();
        List elemList = element.getChildren();
        globs.gridAttList = element.getAttributes();
        log.trace("newGrid starting with {} elements", (Object)elemList.size());
        for (Element value : elemList) {
            globs.gridConstraints = new GridBagConstraints();
            String name = value.getName();
            log.trace("newGrid processing {} element", (Object)name);
            if (name.equals("griditem")) {
                JPanel l = this.newGridItem(value, showStdName, modelElem, globs);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, globs.gridConstraints);
                c.add(l);
                continue;
            }
            if (name.equals("group")) {
                this.newGridGroup(value, c, g, globs, showStdName, modelElem);
                continue;
            }
            if (name.equals("qualifier")) continue;
            log.error("No code to handle element of type {} in newGrid", (Object)value.getName());
        }
        if (c.getComponentCount() > 0) {
            c.add(Box.createVerticalGlue());
        }
        QualifierAdder qa = new QualifierAdder(){

            @Override
            protected Qualifier createQualifier(VariableValue var, String relation, String value) {
                return new JComponentQualifier(c, var, Integer.parseInt(value), relation);
            }

            @Override
            protected void addListener(PropertyChangeListener qc) {
                c.addPropertyChangeListener(qc);
            }
        };
        qa.processModifierElements(element, this._varModel);
        return c;
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"})
    public JPanel newGridItem(Element element, boolean showStdName, Element modelElem, GridGlobals globs) {
        List itemAttList = element.getAttributes();
        ArrayList<Attribute> attList = new ArrayList<Attribute>(globs.gridAttList);
        attList.addAll(itemAttList);
        attList.add(new Attribute(LAST_GRIDX, ""));
        attList.add(new Attribute(LAST_GRIDY, ""));
        block24: for (int j = 0; j < attList.size(); ++j) {
            String constraintType;
            Field constraint;
            Attribute a;
            Attribute attrib = (Attribute)attList.get(j);
            String attribName = attrib.getName();
            String attribRawValue = attrib.getValue();
            if (attribName.equals("gridx")) {
                a = new Attribute(LAST_GRIDX, attribRawValue);
                attList.set(attList.size() - 2, a);
                continue;
            }
            if (attribName.equals("gridy")) {
                a = new Attribute(LAST_GRIDY, attribRawValue);
                attList.set(attList.size() - 1, a);
                continue;
            }
            if (attribName.equals(LAST_GRIDX)) {
                attribName = "gridx";
                if (attribRawValue.equals("")) continue;
            }
            if (attribName.equals(LAST_GRIDY)) {
                attribName = "gridy";
                if (attribRawValue.equals("")) continue;
            }
            if ((attribName.equals("gridx") || attribName.equals("gridy")) && attribRawValue.equals("RELATIVE")) {
                attribRawValue = "NEXT";
            }
            if (attribName.equals("gridx") && attribRawValue.equals("CURRENT")) {
                attribRawValue = String.valueOf(Math.max(0, globs.gridxCurrent));
            }
            if (attribName.equals("gridy") && attribRawValue.equals("CURRENT")) {
                attribRawValue = String.valueOf(Math.max(0, globs.gridyCurrent));
            }
            if (attribName.equals("gridx") && attribRawValue.equals("NEXT")) {
                attribRawValue = String.valueOf(++globs.gridxCurrent);
            }
            if (attribName.equals("gridy") && attribRawValue.equals("NEXT")) {
                attribRawValue = String.valueOf(++globs.gridyCurrent);
            }
            try {
                constraint = globs.gridConstraints.getClass().getDeclaredField(attribName);
                constraintType = constraint.getType().toString();
                constraint.setAccessible(true);
            }
            catch (NoSuchFieldException ex) {
                log.error("Unrecognised attribute \"{}\", skipping", (Object)attribName);
                continue;
            }
            switch (constraintType) {
                case "int": {
                    try {
                        int attribValue = Integer.parseInt(attribRawValue);
                        constraint.set(globs.gridConstraints, attribValue);
                    }
                    catch (IllegalAccessException ey) {
                        log.error("Unable to set constraint \"{}. IllegalAccessException error thrown.", (Object)attribName);
                    }
                    catch (NumberFormatException ex) {
                        try {
                            Field constant = globs.gridConstraints.getClass().getDeclaredField(attribRawValue);
                            constant.setAccessible(true);
                            int attribValue = (Integer)GridBagConstraints.class.getField(attribRawValue).get(constant);
                            constraint.set(globs.gridConstraints, attribValue);
                        }
                        catch (NoSuchFieldException ey) {
                            log.error("Invalid value \"{}\" for attribute \"{}\"", (Object)attribRawValue, (Object)attribName);
                        }
                        catch (IllegalAccessException ey) {
                            log.error("Unable to set constraint \"{}. IllegalAccessException error thrown.", (Object)attribName);
                        }
                    }
                    continue block24;
                }
                case "double": {
                    try {
                        double attribValue = Double.parseDouble(attribRawValue);
                        constraint.set(globs.gridConstraints, attribValue);
                    }
                    catch (IllegalAccessException ey) {
                        log.error("Unable to set constraint \"{}. IllegalAccessException error thrown.", (Object)attribName);
                    }
                    catch (NumberFormatException ex) {
                        log.error("Invalid value \"{}\" for attribute \"{}\"", (Object)attribRawValue, (Object)attribName);
                    }
                    continue block24;
                }
                case "class java.awt.Insets": {
                    try {
                        String[] insetStrings = attribRawValue.split(",");
                        if (insetStrings.length == 4) {
                            Insets attribValue = new Insets(Integer.parseInt(insetStrings[0]), Integer.parseInt(insetStrings[1]), Integer.parseInt(insetStrings[2]), Integer.parseInt(insetStrings[3]));
                            constraint.set(globs.gridConstraints, attribValue);
                            continue block24;
                        }
                        log.error("Invalid value \"{}\" for attribute \"{}\"", (Object)attribRawValue, (Object)attribName);
                        log.error("Value should be four integers of the form \"top,left,bottom,right\"");
                    }
                    catch (IllegalAccessException ey) {
                        log.error("Unable to set constraint \"{}. IllegalAccessException error thrown.", (Object)attribName);
                    }
                    catch (NumberFormatException ex) {
                        log.error("Invalid value \"{}\" for attribute \"{}\"", (Object)attribRawValue, (Object)attribName);
                        log.error("Value should be four integers of the form \"top,left,bottom,right\"");
                    }
                    continue block24;
                }
                default: {
                    log.error("Required \"{}\" handler for attribute \"{}\" not defined in JMRI code", (Object)constraintType, (Object)attribName);
                    log.error("Please file a JMRI bug report at https://sourceforge.net/p/jmri/bugs/new/");
                }
            }
        }
        final JPanel c = new JPanel();
        this.panelList.add(c);
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints cs = new GridBagConstraints();
        c.setLayout(g);
        List elemList = element.getChildren();
        log.trace("newGridItem starting with {} elements", (Object)elemList.size());
        for (Element value : elemList) {
            JPanel l;
            cs.gridy = 0;
            ++cs.gridx;
            String name = value.getName();
            log.trace("newGridItem processing {} element", (Object)name);
            if (name.equals("display")) {
                this.newVariable(value, c, g, cs, showStdName);
                continue;
            }
            if (name.equals("separator")) {
                JSeparator j = new JSeparator(1);
                cs.fill = 1;
                cs.gridheight = 0;
                g.setConstraints(j, cs);
                c.add(j);
                cs.fill = 0;
                cs.gridheight = 1;
                continue;
            }
            if (name.equals("label")) {
                cs.gridheight = 0;
                this.makeLabel(value, c, g, cs);
                continue;
            }
            if (name.equals("soundlabel")) {
                cs.gridheight = 0;
                this.makeSoundLabel(value, c, g, cs);
                continue;
            }
            if (name.equals("cvtable")) {
                this.makeCvTable(cs, g, c);
                continue;
            }
            if (name.equals("fnmapping")) {
                this.pickFnMapPanel(c, g, cs, modelElem);
                continue;
            }
            if (name.equals("dccaddress")) {
                l = this.addDccAddressPanel(value);
                if (l.getComponentCount() <= 0) continue;
                cs.gridheight = 0;
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridheight = 1;
                continue;
            }
            if (name.equals("column")) {
                cs.gridheight = 0;
                l = this.newColumn(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridheight = 1;
                continue;
            }
            if (name.equals("row")) {
                cs.gridwidth = 0;
                l = this.newRow(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("grid")) {
                cs.gridwidth = 0;
                l = this.newGrid(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                cs.gridwidth = 1;
                continue;
            }
            if (name.equals("group")) {
                l = this.newGroup(value, showStdName, modelElem);
                if (l.getComponentCount() <= 0) continue;
                this.panelList.add(l);
                g.setConstraints(l, cs);
                c.add(l);
                continue;
            }
            if (name.equals("qualifier")) continue;
            log.error("No code to handle element of type {} in newGridItem", (Object)value.getName());
        }
        globs.gridxCurrent = globs.gridConstraints.gridx;
        globs.gridyCurrent = globs.gridConstraints.gridy;
        if (c.getComponentCount() > 0) {
            c.add(Box.createVerticalGlue());
        }
        QualifierAdder qa = new QualifierAdder(){

            @Override
            protected Qualifier createQualifier(VariableValue var, String relation, String value) {
                return new JComponentQualifier(c, var, Integer.parseInt(value), relation);
            }

            @Override
            protected void addListener(PropertyChangeListener qc) {
                c.addPropertyChangeListener(qc);
            }
        };
        qa.processModifierElements(element, this._varModel);
        return c;
    }

    protected void makeLabel(Element e, JPanel c, GridBagLayout g, GridBagConstraints cs) {
        String text = LocaleSelector.getAttribute(e, "text");
        if (text == null || text.equals("")) {
            text = LocaleSelector.getAttribute(e, "label");
        }
        final JLabel l = new JLabel(text);
        l.setAlignmentX(1.0f);
        cs.fill = 1;
        log.trace("Add label: {} cs: {} fill: {} x: {} y: {}", new Object[]{l.getText(), cs.gridwidth, cs.fill, cs.gridx, cs.gridy});
        g.setConstraints(l, cs);
        c.add(l);
        cs.fill = 0;
        cs.gridwidth = 1;
        cs.gridheight = 1;
        QualifierAdder qa = new QualifierAdder(){

            @Override
            protected Qualifier createQualifier(VariableValue var, String relation, String value) {
                return new JComponentQualifier(l, var, Integer.parseInt(value), relation);
            }

            @Override
            protected void addListener(PropertyChangeListener qc) {
                l.addPropertyChangeListener(qc);
            }
        };
        qa.processModifierElements(e, this._varModel);
    }

    protected void makeSoundLabel(Element e, JPanel c, GridBagLayout g, GridBagConstraints cs) {
        String labelText = this.rosterEntry.getSoundLabel(Integer.parseInt(Objects.requireNonNull(LocaleSelector.getAttribute(e, "num"))));
        final JLabel l = new JLabel(labelText);
        l.setAlignmentX(1.0f);
        cs.fill = 1;
        if (log.isDebugEnabled()) {
            log.debug("Add soundlabel: {} cs: {} {} {} {}", new Object[]{l.getText(), cs.gridwidth, cs.fill, cs.gridx, cs.gridy});
        }
        g.setConstraints(l, cs);
        c.add(l);
        cs.fill = 0;
        cs.gridwidth = 1;
        cs.gridheight = 1;
        QualifierAdder qa = new QualifierAdder(){

            @Override
            protected Qualifier createQualifier(VariableValue var, String relation, String value) {
                return new JComponentQualifier(l, var, Integer.parseInt(value), relation);
            }

            @Override
            protected void addListener(PropertyChangeListener qc) {
                l.addPropertyChangeListener(qc);
            }
        };
        qa.processModifierElements(e, this._varModel);
    }

    void makeCvTable(GridBagConstraints cs, GridBagLayout g, JPanel c) {
        log.debug("starting to build CvTable pane");
        TableRowSorter<CvTableModel> sorter = new TableRowSorter<CvTableModel>(this._cvModel);
        JTable cvTable = new JTable(this._cvModel);
        sorter.setComparator(0, new CVNameComparator());
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        cvTable.setRowSorter(sorter);
        cvTable.setDefaultRenderer(JTextField.class, new CvValueRenderer());
        cvTable.setDefaultRenderer(JButton.class, new CvValueRenderer());
        cvTable.setDefaultRenderer(String.class, new CvValueRenderer());
        cvTable.setDefaultRenderer(Integer.class, new CvValueRenderer());
        cvTable.setDefaultEditor(JTextField.class, new ValueEditor());
        cvTable.setDefaultEditor(JButton.class, new ValueEditor());
        cvTable.setRowHeight(new JButton((String)"X").getPreferredSize().height);
        JScrollPane cvScroll = new JScrollPane(cvTable);
        cvScroll.setColumnHeaderView(cvTable.getTableHeader());
        cs.fill = 1;
        cs.weighty = 2.0;
        cs.weightx = 0.75;
        g.setConstraints(cvScroll, cs);
        c.add(cvScroll);
        this.isCvTablePane = true;
        this.setCvListFromTable();
        this._cvTable = true;
        log.debug("end of building CvTable pane");
    }

    void setCvListFromTable() {
        for (int j = 0; j < this._cvModel.getRowCount(); ++j) {
            this.cvList.add(j);
        }
        this._varModel.setButtonModeFromProgrammer();
    }

    void pickFnMapPanel(JPanel c, GridBagLayout g, GridBagConstraints cs, Element modelElem) {
        boolean extFnsESU = false;
        Attribute a = modelElem.getAttribute("extFnsESU");
        try {
            if (a != null) {
                extFnsESU = !a.getValue().equalsIgnoreCase("no");
            }
        }
        catch (Exception ex) {
            log.error("error handling decoder's extFnsESU value");
        }
        if (extFnsESU) {
            FnMapPanelESU l = new FnMapPanelESU(this._varModel, this.varList, modelElem, this.rosterEntry, this._cvModel);
            this.fnMapListESU.add(l);
            cs.gridwidth = 0;
            g.setConstraints(l, cs);
            c.add(l);
        } else {
            FnMapPanel l = new FnMapPanel(this._varModel, this.varList, modelElem);
            this.fnMapList.add(l);
            cs.gridwidth = 0;
            g.setConstraints(l, cs);
            c.add(l);
        }
        cs.gridwidth = 1;
    }

    public void newVariable(Element var, JComponent col, GridBagLayout g, GridBagConstraints cs, boolean showStdName) {
        String temp;
        String name = var.getAttribute("item").getValue();
        int i = this._varModel.findVarIndex(name);
        if (i < 0) {
            log.trace("Variable \"{}\" not found, omitted", (Object)name);
            return;
        }
        String layout = "left";
        Attribute attr = var.getAttribute("layout");
        if (attr != null && attr.getValue() != null) {
            layout = attr.getValue();
        }
        String label = name;
        if (!showStdName) {
            label = this._varModel.getLabel(i);
        }
        if ((temp = LocaleSelector.getAttribute(var, "label")) != null) {
            label = temp;
        }
        JComponent rep = this.getRepresentation(name, var);
        this.varList.add(i);
        WatchingLabel l = new WatchingLabel(label, rep);
        int spaceWidth = this.getFontMetrics(l.getFont()).stringWidth(" ");
        switch (layout) {
            case "left": {
                cs.anchor = 13;
                cs.ipadx = spaceWidth;
                g.setConstraints(l, cs);
                col.add(l);
                cs.ipadx = 0;
                ++cs.gridx;
                cs.anchor = 17;
                g.setConstraints(rep, cs);
                col.add(rep);
                break;
            }
            case "right": {
                cs.anchor = 13;
                g.setConstraints(rep, cs);
                col.add(rep);
                ++cs.gridx;
                cs.anchor = 17;
                cs.ipadx = spaceWidth;
                g.setConstraints(l, cs);
                col.add(l);
                cs.ipadx = 0;
                break;
            }
            case "below": {
                cs.anchor = 10;
                g.setConstraints(rep, cs);
                col.add(rep);
                ++cs.gridy;
                cs.anchor = 17;
                cs.ipadx = spaceWidth;
                g.setConstraints(l, cs);
                col.add(l);
                cs.ipadx = 0;
                break;
            }
            case "above": {
                cs.anchor = 17;
                cs.ipadx = spaceWidth;
                g.setConstraints(l, cs);
                col.add(l);
                cs.ipadx = 0;
                ++cs.gridy;
                cs.anchor = 10;
                g.setConstraints(rep, cs);
                col.add(rep);
                break;
            }
            default: {
                log.error("layout internally inconsistent: {}", (Object)layout);
            }
        }
    }

    public JComponent getRepresentation(String name, Element var) {
        boolean viewOnly;
        int i = this._varModel.findVarIndex(name);
        VariableValue variable = this._varModel.getVariable(i);
        JComponent rep = null;
        String format = "default";
        Attribute attr = var.getAttribute("format");
        if (attr != null && attr.getValue() != null) {
            format = attr.getValue();
        }
        boolean bl = viewOnly = var.getAttribute("viewOnly") != null && var.getAttribute("viewOnly").getValue().equals("yes");
        if (i >= 0) {
            rep = this.getRep(i, format);
            rep.setMaximumSize(rep.getPreferredSize());
            String tip = LocaleSelector.getAttribute(var, "tooltip");
            if (rep.getToolTipText() != null) {
                tip = rep.getToolTipText();
            }
            rep.setToolTipText(this.modifyToolTipText(tip, variable));
            if (viewOnly) {
                rep.setEnabled(false);
            }
        }
        return rep;
    }

    String modifyToolTipText(String start, VariableValue variable) {
        log.trace("modifyToolTipText: {}", (Object)variable.label());
        start = CvUtil.addCvDescription(start, variable.getCvDescription(), variable.getMask());
        if (this._cvModel.getProgrammer() != null && !this._cvModel.getProgrammer().getCanRead()) {
            start = StringUtil.concatTextHtmlAware(start, SymbolicProgBundle.getMessage("TipHardwareCannotRead"));
        }
        if (this._cvModel.getProgrammer() != null && !this._cvModel.getProgrammer().getCanWrite()) {
            start = StringUtil.concatTextHtmlAware(start, SymbolicProgBundle.getMessage("TipHardwareCannotWrite"));
        }
        if (variable.getReadOnly()) {
            start = StringUtil.concatTextHtmlAware(start, SymbolicProgBundle.getMessage("TipDefinedToBeReadOnly"));
        }
        if (variable.getWriteOnly()) {
            start = StringUtil.concatTextHtmlAware(start, SymbolicProgBundle.getMessage("TipDefinedToBeWriteOnly"));
        }
        return start;
    }

    JComponent getRep(int i, String format) {
        return (JComponent)this._varModel.getRep(i, format);
    }

    public void dispose() {
        log.debug("dispose");
        this.removeAll();
        this.readChangesButton.removeItemListener(this.l1);
        this.readAllButton.removeItemListener(this.l2);
        this.writeChangesButton.removeItemListener(this.l3);
        this.writeAllButton.removeItemListener(this.l4);
        this.confirmChangesButton.removeItemListener(this.l5);
        this.confirmAllButton.removeItemListener(this.l6);
        this.l6 = null;
        this.l5 = null;
        this.l4 = null;
        this.l3 = null;
        this.l2 = null;
        this.l1 = null;
        if (this._programmingVar != null) {
            this._programmingVar.removePropertyChangeListener(this);
        }
        if (this._programmingCV != null) {
            this._programmingCV.removePropertyChangeListener(this);
        }
        this._programmingVar = null;
        this._programmingCV = null;
        this.varList.clear();
        this.varList = null;
        this.cvList.clear();
        this.cvList = null;
        for (JPanel jPanel : this.panelList) {
            jPanel.removeAll();
        }
        this.panelList.clear();
        this.panelList = null;
        for (FnMapPanel fnMapPanel : this.fnMapList) {
            fnMapPanel.dispose();
        }
        this.fnMapList.clear();
        this.fnMapList = null;
        for (FnMapPanelESU fnMapPanelESU : this.fnMapListESU) {
            fnMapPanelESU.dispose();
        }
        this.fnMapListESU.clear();
        this.fnMapListESU = null;
        this.readChangesButton = null;
        this.writeChangesButton = null;
        this._cvModel = null;
        this._varModel = null;
    }

    public boolean isEmpty() {
        return this.varList.isEmpty() && this.cvList.isEmpty();
    }

    public boolean includeInPrint() {
        return this.print;
    }

    public void includeInPrint(boolean inc) {
        this.print = inc;
    }

    public void printPane(HardcopyWriter w) {
        if (this.isEmpty()) {
            return;
        }
        int col1Width = w.getCharactersPerLine() / 2 - 3 - 5;
        int col2Width = w.getCharactersPerLine() / 2 - 3 + 5;
        try {
            Object value;
            StringBuilder spaces = new StringBuilder();
            spaces.append(" ".repeat(Math.max(0, col1Width)));
            String heading1 = SymbolicProgBundle.getMessage("PrintHeadingField");
            String heading2 = SymbolicProgBundle.getMessage("PrintHeadingSetting");
            int interval = spaces.length() - heading1.length();
            w.setFontStyle(1);
            Object s = this.mName;
            w.write((String)s, 0, ((String)s).length());
            w.writeBorders();
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine() + 1);
            s = "\n";
            w.write((String)s, 0, ((String)s).length());
            if (this.cvList.isEmpty()) {
                w.setFontStyle(3);
                s = "   " + heading1 + spaces.substring(0, interval) + "   " + heading2;
                w.write((String)s, 0, ((String)s).length());
                w.writeBorders();
                s = "\n";
                w.write((String)s, 0, ((String)s).length());
            }
            w.setFontStyle(0);
            ArrayList<String> printedVariables = new ArrayList<String>(10);
            for (int varNum : this.varList) {
                int here;
                VariableValue var = this._varModel.getVariable(varNum);
                Object name = var.label();
                if (name == null) {
                    name = var.item();
                }
                boolean alreadyPrinted = false;
                for (String printedVariable : printedVariables) {
                    if (!((String)name).equals(printedVariable)) continue;
                    alreadyPrinted = true;
                    break;
                }
                if (alreadyPrinted) continue;
                printedVariables.add((String)name);
                value = var.getTextValue();
                String originalName = name;
                String originalValue = value;
                name = (String)name + " (CV" + var.getCvNum() + ")";
                int nameLeftIndex = 0;
                int nameRightIndex = ((String)name).length();
                int valueLeftIndex = 0;
                int valueRightIndex = ((String)value).length();
                while (valueLeftIndex < ((String)value).length() || nameLeftIndex < ((String)name).length()) {
                    String trimmedValue;
                    int space;
                    String trimmedName;
                    String delimiter;
                    int j;
                    if (((String)name).substring(nameLeftIndex).length() > col1Width) {
                        for (j = 0; j < col1Width; ++j) {
                            delimiter = ((String)name).substring(nameLeftIndex + col1Width - j - 1, nameLeftIndex + col1Width - j);
                            if (!delimiter.equals(" ") && !delimiter.equals(";") && !delimiter.equals(",")) continue;
                            nameRightIndex = nameLeftIndex + col1Width - j;
                            break;
                        }
                        trimmedName = ((String)name).substring(nameLeftIndex, nameRightIndex);
                        nameLeftIndex = nameRightIndex;
                        space = spaces.length() - trimmedName.length();
                        s = "   " + trimmedName + spaces.substring(0, space);
                    } else {
                        trimmedName = ((String)name).substring(nameLeftIndex);
                        space = spaces.length() - trimmedName.length();
                        s = "   " + trimmedName + spaces.substring(0, space);
                        name = "";
                        nameLeftIndex = 0;
                    }
                    if (((String)value).substring(valueLeftIndex).length() > col2Width) {
                        for (j = 0; j < col2Width; ++j) {
                            delimiter = ((String)value).substring(valueLeftIndex + col2Width - j - 1, valueLeftIndex + col2Width - j);
                            if (!delimiter.equals(" ") && !delimiter.equals(";") && !delimiter.equals(",")) continue;
                            valueRightIndex = valueLeftIndex + col2Width - j;
                            break;
                        }
                        trimmedValue = ((String)value).substring(valueLeftIndex, valueRightIndex);
                        valueLeftIndex = valueRightIndex;
                        s = (String)s + "   " + trimmedValue;
                    } else {
                        trimmedValue = ((String)value).substring(valueLeftIndex);
                        s = (String)s + "   " + trimmedValue;
                        valueLeftIndex = 0;
                        value = "";
                    }
                    w.write((String)s, 0, ((String)s).length());
                    w.writeBorders();
                    s = "\n";
                    w.write((String)s, 0, ((String)s).length());
                }
                float v = Float.parseFloat(System.getProperty("java.version").substring(0, 3));
                if (!originalName.equals("Speed Table") || !((double)v < 1.5)) continue;
                int speedFrameLineHeight = 11;
                s = "\n";
                int pageSize = w.getLinesPerPage();
                if (pageSize - (here = w.getCurrentLineNumber()) < speedFrameLineHeight) {
                    for (int j = 0; j < pageSize - here; ++j) {
                        w.writeBorders();
                        w.write((String)s, 0, ((String)s).length());
                    }
                }
                JWindow speedWindow = new JWindow();
                speedWindow.setSize(512, 165);
                speedWindow.getContentPane().setBackground(Color.white);
                speedWindow.getContentPane().setLayout(null);
                StringTokenizer valueTokens = new StringTokenizer(originalValue, ",", false);
                int[] speedVals = new int[28];
                int k = 0;
                while (valueTokens.hasMoreTokens()) {
                    speedVals[k] = Integer.parseInt(valueTokens.nextToken());
                    ++k;
                }
                for (int j = 0; j < 28; ++j) {
                    JProgressBar printerBar = new JProgressBar(1, 0, 127);
                    printerBar.setBounds(52 + j * 15, 19, 10, 127);
                    printerBar.setValue(speedVals[j] / 2);
                    printerBar.setBackground(Color.white);
                    printerBar.setForeground(Color.darkGray);
                    printerBar.setBorder(BorderFactory.createLineBorder(Color.black));
                    speedWindow.getContentPane().add(printerBar);
                    JLabel barValLabel = new JLabel(Integer.toString(speedVals[j]), 0);
                    barValLabel.setBounds(50 + j * 15, 4, 15, 15);
                    barValLabel.setFont(new Font("Monospaced", 0, 7));
                    speedWindow.getContentPane().add(barValLabel);
                    JLabel barCvLabel = new JLabel(Integer.toString(67 + j), 0);
                    barCvLabel.setBounds(50 + j * 15, 150, 15, 15);
                    barCvLabel.setFont(new Font("Monospaced", 0, 7));
                    speedWindow.getContentPane().add(barCvLabel);
                }
                JLabel cvLabel = new JLabel(Bundle.getMessage("Value"));
                cvLabel.setFont(new Font("Monospaced", 0, 7));
                cvLabel.setBounds(25, 4, 26, 15);
                speedWindow.getContentPane().add(cvLabel);
                JLabel valueLabel = new JLabel("CV");
                valueLabel.setFont(new Font("Monospaced", 0, 7));
                valueLabel.setBounds(37, 150, 13, 15);
                speedWindow.getContentPane().add(valueLabel);
                w.write(speedWindow);
                for (int j = 0; j < speedFrameLineHeight; ++j) {
                    w.writeBorders();
                    w.write((String)s, 0, ((String)s).length());
                }
            }
            int TABLE_COLS = 3;
            if (!this.cvList.isEmpty()) {
                boolean swap;
                int cvCount = this.cvList.size();
                w.setFontStyle(1);
                s = String.format("%1$21s", Bundle.getMessage("Value")) + String.format("%1$28s", Bundle.getMessage("Value")) + String.format("%1$28s", Bundle.getMessage("Value"));
                w.write((String)s, 0, ((String)s).length());
                w.writeBorders();
                s = "\n";
                w.write((String)s, 0, ((String)s).length());
                s = "            CV  Dec Hex                 CV  Dec Hex                 CV  Dec Hex";
                w.write((String)s, 0, ((String)s).length());
                w.writeBorders();
                s = "\n";
                w.write((String)s, 0, ((String)s).length());
                w.setFontStyle(0);
                int tableHeight = cvCount / 3;
                if (cvCount % 3 > 0) {
                    ++tableHeight;
                }
                Object[] cvStrings = new String[3 * tableHeight];
                Arrays.fill(cvStrings, "");
                int i = 0;
                value = this.cvList.iterator();
                while (value.hasNext()) {
                    int cvNum = (Integer)value.next();
                    CvValue cv = this._cvModel.getCvByRow(cvNum);
                    int value2 = cv.getValue();
                    String numString = String.format("%12s", cv.number());
                    StringBuilder valueString = new StringBuilder(Integer.toString(value2));
                    Object valueStringHex = Integer.toHexString(value2).toUpperCase(Locale.ENGLISH);
                    if (value2 < 16) {
                        valueStringHex = "0" + (String)valueStringHex;
                    }
                    for (int j = 1; j < 3; ++j) {
                        if (valueString.length() >= 3) continue;
                        valueString.insert(0, " ");
                    }
                    cvStrings[i] = s = "  " + numString + "  " + valueString + "  " + (String)valueStringHex + " ";
                    ++i;
                }
                do {
                    swap = false;
                    for (i = 0; i < this._cvModel.getRowCount() - 1; ++i) {
                        if (PrintCvAction.cvSortOrderVal(((String)cvStrings[i + 1]).substring(0, 15).trim()) >= PrintCvAction.cvSortOrderVal(((String)cvStrings[i]).substring(0, 15).trim())) continue;
                        Object temp = cvStrings[i + 1];
                        cvStrings[i + 1] = cvStrings[i];
                        cvStrings[i] = temp;
                        swap = true;
                    }
                } while (swap);
                for (i = 0; i < tableHeight; ++i) {
                    s = (String)cvStrings[i] + "    " + (String)cvStrings[i + tableHeight] + "    " + (String)cvStrings[i + tableHeight * 2];
                    w.write((String)s, 0, ((String)s).length());
                    w.writeBorders();
                    s = "\n";
                    w.write((String)s, 0, ((String)s).length());
                }
            }
            s = "\n";
            w.writeBorders();
            w.write((String)s, 0, ((String)s).length());
            w.writeBorders();
            w.write((String)s, 0, ((String)s).length());
        }
        catch (IOException e) {
            log.warn("error during printing", (Throwable)e);
        }
    }

    private JPanel addDccAddressPanel(Element e) {
        DccAddressPanel l = new DccAddressPanel(this._varModel);
        this.panelList.add(l);
        int iVar = this._varModel.findVarIndex("Short Address");
        if (iVar >= 0) {
            this.varList.add(iVar);
        } else {
            log.debug("addDccAddressPanel did not find Short Address");
        }
        iVar = this._varModel.findVarIndex("Address Format");
        if (iVar >= 0) {
            this.varList.add(iVar);
        } else {
            log.debug("addDccAddressPanel did not find Address Format");
        }
        iVar = this._varModel.findVarIndex("Long Address");
        if (iVar >= 0) {
            this.varList.add(iVar);
        } else {
            log.debug("addDccAddressPanel did not find Long Address");
        }
        iVar = this._varModel.findVarIndex("Consist Address");
        if (iVar >= 0) {
            this.varList.add(iVar);
        } else {
            log.debug("addDccAddressPanel did not find CV19 Consist Address");
        }
        return l;
    }

    protected static class GridGlobals {
        public int gridxCurrent = -1;
        public int gridyCurrent = -1;
        public List<Attribute> gridAttList;
        public GridBagConstraints gridConstraints;

        protected GridGlobals() {
        }
    }
}

