/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog.tabbedframe;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.symbolicprog.NameFile;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgCheckAction
extends AbstractAction {
    JFileChooser fci;
    JPanel _who;
    static final String numericRegex = "^F(\\d++) controls output (\\d++)$";
    static volatile Pattern numericPattern;
    static final String ffRegex = "^FL\\(f\\) controls output (\\d++)$";
    static volatile Pattern ffPattern;
    static final String frRegex = "^FL\\(r\\) controls output (\\d++)$";
    static volatile Pattern frPattern;
    private static final Logger log;

    public ProgCheckAction(String s, JPanel who) {
        super(s);
        this._who = who;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.fci == null) {
            this.fci = XmlFile.userFileChooser("XML files", "xml");
        }
        this.fci.rescanCurrentDirectory();
        int retVal = this.fci.showOpenDialog(this._who);
        if (retVal == 0) {
            File file = this.fci.getSelectedFile();
            if (log.isDebugEnabled()) {
                log.debug("located file {} for XML processing", (Object)file);
            }
            this.warnMissingNames(file);
            if (file.getName().toLowerCase().endsWith("comprehensive.xml")) {
                this.warnIncompleteComprehensive(file);
            }
        } else {
            log.info("XmlFileCheckAction cancelled in open dialog");
        }
    }

    protected static void expandElement(Element el, List<Element> list) {
        list.addAll(el.getChildren("display"));
        List children = el.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ProgCheckAction.expandElement((Element)children.get(i), list);
        }
    }

    void warnMissingNames(File file) {
        String result = ProgCheckAction.checkMissingNames(file);
        if (result.equals("")) {
            JmriJOptionPane.showMessageDialog(this._who, "OK, all variables in file are known");
        } else {
            JmriJOptionPane.showMessageDialog(this._who, result);
        }
    }

    static String checkMissingNames(File file) {
        try {
            Element root = ProgCheckAction.readFile(file);
            log.debug("parsing complete");
            if (root.getChild("programmer") == null) {
                log.warn("Does not appear to be a programmer file");
                return "Does not appear to be a programmer file";
            }
            ArrayList<Element> varList = new ArrayList<Element>();
            ProgCheckAction.expandElement(root.getChild("programmer"), varList);
            log.debug("found {} display elements", (Object)varList.size());
            NameFile nfile = InstanceManager.getDefault(NameFile.class);
            StringBuilder warnings = new StringBuilder("");
            for (int i = 0; i < varList.size(); ++i) {
                Element varElement = (Element)varList.get(i);
                Attribute nameAttr = varElement.getAttribute("item");
                String name = null;
                if (nameAttr != null) {
                    name = nameAttr.getValue();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Variable called \"{}\"", (Object)(name != null ? name : "<none>"));
                }
                if (name != null && nfile.checkName(name)) continue;
                log.warn("Variable not found in name list: name=\"{}\"", (Object)name);
                warnings.append("Variable not found in name list: name=\"").append(name).append("\"\n");
            }
            String result = warnings.toString();
            return !result.isEmpty() ? "Names missing from Comprehensive.xml\n" + result : "";
        }
        catch (IOException | JDOMException ex) {
            return "Error parsing programmer file: " + (Exception)ex;
        }
    }

    void warnIncompleteComprehensive(File file) {
        String result = ProgCheckAction.checkIncompleteComprehensive(file);
        if (result.equals("")) {
            JmriJOptionPane.showMessageDialog(this._who, "OK, Comprehensive.xml is complete");
        } else {
            JmriJOptionPane.showMessageDialog(this._who, result);
        }
    }

    static String checkIncompleteComprehensive(File file) {
        try {
            Element root = ProgCheckAction.readFile(file);
            if (log.isDebugEnabled()) {
                log.debug("parsing complete");
            }
            if (root.getChild("programmer") == null) {
                log.warn("Does not appear to be a programmer file");
                return "Does not appear to be a programmer file";
            }
            ArrayList<Element> varList = new ArrayList<Element>();
            ProgCheckAction.expandElement(root.getChild("programmer"), varList);
            if (log.isDebugEnabled()) {
                log.debug("found {} display elements", (Object)varList.size());
            }
            NameFile nfile = InstanceManager.getDefault(NameFile.class);
            StringBuilder warnings = new StringBuilder("");
            nfile.names().stream().filter(s -> !ProgCheckAction.functionMapName(s)).forEachOrdered(s -> {
                boolean found = false;
                for (int i = 0; i < varList.size(); ++i) {
                    Element varElement = (Element)varList.get(i);
                    Attribute nameAttr = varElement.getAttribute("item");
                    String name = null;
                    if (nameAttr != null) {
                        name = nameAttr.getValue();
                    }
                    if (name == null || !name.equals(s)) continue;
                    found = true;
                }
                if (!found) {
                    log.warn("Variable not in Comprehensive: name=\"{}\"", s);
                    warnings.append("Variable not in Comprehensive: name=\"").append((String)s).append("\"\n");
                }
            });
            return warnings.toString();
        }
        catch (IOException | JDOMException ex) {
            return "Error parsing programmer file: " + (Exception)ex;
        }
    }

    static boolean functionMapName(String name) {
        Matcher matcher;
        if (numericPattern == null) {
            numericPattern = Pattern.compile(numericRegex);
        }
        if (ffPattern == null) {
            ffPattern = Pattern.compile(ffRegex);
        }
        if (frPattern == null) {
            frPattern = Pattern.compile(frRegex);
        }
        if ((matcher = numericPattern.matcher(name)).matches()) {
            return true;
        }
        matcher = ffPattern.matcher(name);
        if (matcher.matches()) {
            return true;
        }
        matcher = frPattern.matcher(name);
        return matcher.matches();
    }

    static Element readFile(File file) throws JDOMException, IOException {
        XmlFile xf = new XmlFile(){};
        return xf.rootFromFile(file);
    }

    static {
        log = LoggerFactory.getLogger(ProgCheckAction.class);
    }
}

