/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.Consist;
import jmri.ConsistManager;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.configurexml.LocoAddressXml;
import jmri.jmrit.DccLocoAddressSelector;
import jmri.jmrit.consisttool.ConsistComboBox;
import jmri.jmrit.consisttool.ConsistToolAction;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntrySelectorPanel;
import jmri.jmrit.symbolicprog.ProgDefault;
import jmri.jmrit.symbolicprog.tabbedframe.PaneOpsProgFrame;
import jmri.jmrit.throttle.AddressListener;
import jmri.jmrit.throttle.BackgroundPanel;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.FunctionPanel;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrit.throttle.WindowPreferences;
import jmri.jmrix.nce.consist.NceConsistRoster;
import jmri.jmrix.nce.consist.NceConsistRosterEntry;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.WrapLayout;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressPanel
extends JInternalFrame
implements ThrottleListener,
PropertyChangeListener {
    private final ThrottleManager throttleManager;
    private final ConsistManager consistManager;
    private DccThrottle throttle;
    private DccThrottle consistThrottle;
    private final DccLocoAddressSelector addrSelector = new DccLocoAddressSelector();
    private DccLocoAddress currentAddress;
    private DccLocoAddress consistAddress;
    private DccLocoAddress requestedAddress;
    private ArrayList<AddressListener> listeners;
    private JPanel mainPanel;
    private JButton releaseButton;
    private JButton dispatchButton;
    private JButton progButton;
    private JButton setButton;
    private RosterEntrySelectorPanel rosterBox;
    private JComboBox conRosterBox;
    private boolean isUpdatingUI = false;
    private RosterEntry rosterEntry;
    private BackgroundPanel backgroundPanel;
    private static final Logger log = LoggerFactory.getLogger(AddressPanel.class);

    public AddressPanel(ThrottleManager throttleManager) {
        this.throttleManager = throttleManager;
        this.consistManager = InstanceManager.getNullableDefault(ConsistManager.class);
        this.initGUI();
        this.applyPreferences();
    }

    public void destroy() {
        if (this.conRosterBox != null && this.conRosterBox instanceof ConsistComboBox) {
            ((ConsistComboBox)this.conRosterBox).dispose();
        }
        if (this.requestedAddress != null) {
            this.throttleManager.cancelThrottleRequest(this.requestedAddress, (ThrottleListener)this);
            this.requestedAddress = null;
        }
        if (this.throttle != null) {
            this.throttle.removePropertyChangeListener(this);
            this.throttleManager.releaseThrottle(this.throttle, this);
            this.notifyListenersOfThrottleRelease();
            this.throttle = null;
        }
        if (this.consistThrottle != null) {
            this.consistThrottle.removePropertyChangeListener(this);
            this.throttleManager.releaseThrottle(this.consistThrottle, this);
            this.notifyListenersOfThrottleRelease();
            this.consistThrottle = null;
        }
    }

    public void addAddressListener(AddressListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeAddressListener(AddressListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public int getRosterSelectedIndex() {
        return this.getRosterEntrySelector().getRosterEntryComboBox().getSelectedIndex();
    }

    public void setRosterSelectedIndex(int index) {
        if (this.getRosterEntrySelector().isEnabled() && index >= 0 && index < this.getRosterEntrySelector().getRosterEntryComboBox().getItemCount()) {
            this.getRosterEntrySelector().getRosterEntryComboBox().setSelectedIndex(index);
        }
        if (this.backgroundPanel != null && this.rosterBox.getSelectedRosterEntries().length == 0) {
            this.backgroundPanel.setImagePath(null);
            String rosterEntryTitle = this.getRosterEntrySelector().getSelectedRosterEntries()[0].titleString();
            RosterEntry re = Roster.getDefault().entryFromTitle(rosterEntryTitle);
            if (re != null) {
                this.backgroundPanel.setImagePath(re.getImagePath());
            }
        }
    }

    public void setBackgroundPanel(BackgroundPanel bp) {
        this.backgroundPanel = bp;
    }

    public void selectRosterEntry() {
        if (this.isUpdatingUI) {
            return;
        }
        if (this.getRosterEntrySelector().getSelectedRosterEntries().length != 0) {
            this.setRosterEntry(this.getRosterEntrySelector().getSelectedRosterEntries()[0]);
            this.consistAddress = null;
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        List<RosterEntry> l2;
        log.debug("Throttle found :  {} ", (Object)t.getLocoAddress());
        if (this.consistAddress == null && this.consistManager != null && this.consistManager.isEnabled() && this.consistManager.getConsistList().contains(t.getLocoAddress())) {
            this.consistAddress = (DccLocoAddress)t.getLocoAddress();
        }
        if (this.consistAddress != null && t.getLocoAddress().equals(this.consistAddress)) {
            log.debug("notifying that this is a consist");
            this.notifyConsistThrottleFound(t);
            return;
        }
        if (t.getLocoAddress().getNumber() != this.currentAddress.getNumber()) {
            log.warn("Not correct address, asked for {} got {}, requesting again...", (Object)this.currentAddress.getNumber(), (Object)t.getLocoAddress());
            boolean requestOK = this.throttleManager.requestThrottle(this.currentAddress, (ThrottleListener)this, true);
            if (!requestOK) {
                JmriJOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("AddressInUse"));
                this.requestedAddress = null;
            }
            return;
        }
        this.requestedAddress = null;
        this.currentAddress = (DccLocoAddress)t.getLocoAddress();
        if (this.rosterEntry == null && InstanceManager.getDefault(ThrottlesPreferences.class).isUsingExThrottle() && InstanceManager.getDefault(ThrottlesPreferences.class).isEnablingRosterSearch() && this.currentAddress != null && !(l2 = Roster.getDefault().matchingList(null, null, "" + this.currentAddress.getNumber(), null, null, null, null)).isEmpty()) {
            this.rosterEntry = l2.get(0);
        }
        if (this.consistAddress != null) {
            log.debug("Advanced consist throttle, got the throttle for the head locomotive functions control");
            new ArrayList<AddressListener>(this.listeners).forEach(l -> {
                if (l instanceof FunctionPanel) {
                    l.notifyAddressThrottleFound(t);
                }
            });
            return;
        }
        if (this.throttle != null) {
            log.debug("notifyThrottleFound() throttle non null, called for loc {}", (Object)t.getLocoAddress());
            return;
        }
        this.throttle = t;
        this.throttle.addPropertyChangeListener(this);
        this.updateGUIOnThrottleFound(true);
        new ArrayList<AddressListener>(this.listeners).forEach(l -> l.notifyAddressThrottleFound(t));
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        JmriJOptionPane.showMessageDialog(null, reason, Bundle.getMessage("FailedSetupRequestTitle"), 2);
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
        if (null != question) {
            switch (question) {
                case STEAL: {
                    if (InstanceManager.getDefault(ThrottlesPreferences.class).isSilentSteal()) {
                        this.throttleManager.responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                        return;
                    }
                    ThreadingUtil.runOnGUI(() -> {
                        if (0 == JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("StealQuestionText", address.toString()), Bundle.getMessage("StealRequestTitle"), 0)) {
                            this.throttleManager.responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                        } else {
                            this.throttleManager.cancelThrottleRequest(address, (ThrottleListener)this);
                            this.requestedAddress = null;
                        }
                    });
                    break;
                }
                case SHARE: {
                    if (InstanceManager.getDefault(ThrottlesPreferences.class).isSilentShare()) {
                        this.throttleManager.responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.SHARE);
                        return;
                    }
                    ThreadingUtil.runOnGUI(() -> {
                        if (0 == JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("ShareQuestionText", address.toString()), Bundle.getMessage("ShareRequestTitle"), 0)) {
                            this.throttleManager.responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.SHARE);
                        } else {
                            this.throttleManager.cancelThrottleRequest(address, (ThrottleListener)this);
                            this.requestedAddress = null;
                        }
                    });
                    break;
                }
                case STEAL_OR_SHARE: {
                    if (InstanceManager.getDefault(ThrottlesPreferences.class).isSilentSteal()) {
                        this.throttleManager.responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                        return;
                    }
                    if (InstanceManager.getDefault(ThrottlesPreferences.class).isSilentShare()) {
                        this.throttleManager.responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.SHARE);
                        return;
                    }
                    String[] options = new String[]{Bundle.getMessage("StealButton"), Bundle.getMessage("ShareButton"), Bundle.getMessage("ButtonCancel")};
                    ThreadingUtil.runOnGUI(() -> {
                        int response = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("StealShareQuestionText", address.toString()), Bundle.getMessage("StealShareRequestTitle"), -1, 3, null, options, options[1]);
                        switch (response) {
                            case 0: {
                                log.debug("steal clicked");
                                this.throttleManager.responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                                break;
                            }
                            case 1: {
                                log.debug("share clicked");
                                this.throttleManager.responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.SHARE);
                                break;
                            }
                            default: {
                                log.debug("cancel clicked");
                                this.throttleManager.cancelThrottleRequest(address, (ThrottleListener)this);
                                this.requestedAddress = null;
                            }
                        }
                    });
                    break;
                }
            }
        }
    }

    public void notifyConsistThrottleFound(DccThrottle t) {
        DccLocoAddress headLocoAddress;
        List<RosterEntry> l2;
        if (this.consistThrottle != null) {
            log.debug("notifyConsistThrottleFound() consistThrottle non null, called for loc {}", (Object)t.getLocoAddress());
            return;
        }
        this.requestedAddress = null;
        this.consistThrottle = t;
        this.currentAddress = (DccLocoAddress)t.getLocoAddress();
        this.consistThrottle.addPropertyChangeListener(this);
        Consist consist = this.getConsistEntry();
        if (consist != null && consist.getConsistType() == 1 && this.rosterEntry == null && InstanceManager.getDefault(ThrottlesPreferences.class).isUsingExThrottle() && InstanceManager.getDefault(ThrottlesPreferences.class).isEnablingRosterSearch() && this.currentAddress != null && !(l2 = Roster.getDefault().matchingList(null, null, "" + this.currentAddress.getNumber(), null, null, null, null)).isEmpty()) {
            this.rosterEntry = l2.get(0);
        }
        this.updateGUIOnThrottleFound(true);
        new ArrayList<AddressListener>(this.listeners).forEach(l -> l.notifyConsistAddressThrottleFound(t));
        if (consist != null && consist.getConsistType() == 0 && !(headLocoAddress = consist.getConsistList().get(0)).equals(this.currentAddress)) {
            log.debug("Advanced consist throttle, requesting secondary throttle for head locomotive function control.");
            this.changeOfAddress(headLocoAddress);
        }
    }

    private void updateGUIOnThrottleFound(boolean throttleActive) {
        this.isUpdatingUI = true;
        this.setButton.setEnabled(!throttleActive);
        this.addrSelector.setEnabled(!throttleActive);
        this.releaseButton.setEnabled(throttleActive);
        if (throttleActive && this.rosterEntry != null) {
            this.getRosterEntrySelector().setSelectedRosterEntry(this.rosterEntry);
        } else {
            this.getRosterEntrySelector().getRosterEntryComboBox().setSelectedItem(Bundle.getMessage("NoLocoSelected"));
        }
        this.getRosterEntrySelector().setEnabled(!throttleActive);
        if (this.conRosterBox != null) {
            if (throttleActive && this.consistThrottle != null) {
                this.conRosterBox.setSelectedItem(this.consistThrottle.getLocoAddress());
            } else {
                this.conRosterBox.setSelectedItem(Bundle.getMessage("NoConsistSelected"));
            }
            this.conRosterBox.setEnabled(!throttleActive);
        }
        if (this.throttleManager.hasDispatchFunction()) {
            this.dispatchButton.setEnabled(throttleActive);
        }
        if (this.rosterEntry != null && ProgDefault.getDefaultProgFile() != null && InstanceManager.getNullableDefault(AddressedProgrammerManager.class) != null && InstanceManager.getDefault(AddressedProgrammerManager.class).isAddressedModePossible()) {
            this.progButton.setEnabled(true);
        } else {
            this.progButton.setEnabled(false);
        }
        this.isUpdatingUI = false;
    }

    public void notifyThrottleDisposed() {
        log.debug("notifyThrottleDisposed");
        this.notifyListenersOfThrottleRelease();
        this.updateGUIOnThrottleFound(false);
        this.rosterEntry = null;
        if (this.consistThrottle != null) {
            this.consistThrottle.removePropertyChangeListener(this);
        }
        if (this.throttle != null) {
            this.throttle.removePropertyChangeListener(this);
        }
    }

    public RosterEntry getRosterEntry() {
        return this.rosterEntry;
    }

    public Consist getConsistEntry() {
        if (this.consistManager == null || this.consistAddress == null || !this.consistManager.isEnabled()) {
            return null;
        }
        if (this.consistManager.getConsistList().contains(this.consistAddress)) {
            return this.consistManager.getConsist(this.consistAddress);
        }
        return null;
    }

    public void setRosterEntry(RosterEntry entry) {
        this.isUpdatingUI = true;
        this.getRosterEntrySelector().setSelectedRosterEntry(entry);
        this.addrSelector.setAddress(entry.getDccLocoAddress());
        this.isUpdatingUI = false;
        this.rosterEntry = entry;
        this.changeOfAddress(this.addrSelector.getAddress());
    }

    private void initGUI() {
        this.setDefaultCloseOperation(0);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.setContentPane(this.mainPanel);
        this.addrSelector.setVariableSize(true);
        this.mainPanel.add((Component)this.addrSelector.getCombinedJPanel(), "Center");
        this.addrSelector.getTextField().addActionListener(e -> {
            if (this.isUpdatingUI) {
                return;
            }
            this.consistAddress = null;
            this.changeOfAddress(this.addrSelector.getAddress());
        });
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new WrapLayout(1, 2, 2));
        this.rosterBox = new RosterEntrySelectorPanel();
        this.getRosterEntrySelector().setNonSelectedItem(Bundle.getMessage("NoLocoSelected"));
        this.getRosterEntrySelector().setToolTipText(Bundle.getMessage("SelectLocoFromRosterTT"));
        this.getRosterEntrySelector().addPropertyChangeListener("selectedRosterEntries", pce -> this.selectRosterEntry());
        this.getRosterEntrySelector().setLayout(new WrapLayout(1, 2, 2));
        topPanel.add(this.getRosterEntrySelector());
        if (InstanceManager.getDefault(NceConsistRoster.class).numEntries() > 0) {
            this.conRosterBox = InstanceManager.getDefault(NceConsistRoster.class).fullRosterComboBox();
            this.conRosterBox.insertItemAt(Bundle.getMessage("NoConsistSelected"), 0);
            this.conRosterBox.setSelectedIndex(0);
            this.conRosterBox.setToolTipText(Bundle.getMessage("SelectConsistFromRosterTT"));
            this.conRosterBox.addActionListener(e -> this.nceConsistRosterSelected());
            topPanel.add(this.conRosterBox);
        } else if (this.consistManager != null && this.consistManager.isEnabled()) {
            JPanel consistPanel = new JPanel();
            JButton consistToolButton = new JButton(new ConsistToolAction());
            consistPanel.add(consistToolButton);
            this.conRosterBox = new ConsistComboBox();
            this.conRosterBox.addActionListener(e -> this.jmriConsistRosterSelected());
            consistPanel.add(this.conRosterBox);
            topPanel.add(consistPanel);
        }
        this.mainPanel.add((Component)topPanel, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new WrapLayout(1, 2, 2));
        this.progButton = new JButton(Bundle.getMessage("ButtonProgram"));
        buttonPanel.add(this.progButton);
        this.progButton.setEnabled(false);
        this.progButton.addActionListener(e -> this.openProgrammer());
        this.dispatchButton = new JButton(Bundle.getMessage("ButtonDispatch"));
        buttonPanel.add(this.dispatchButton);
        this.dispatchButton.setEnabled(false);
        this.dispatchButton.addActionListener(e -> this.dispatchAddress());
        this.releaseButton = new JButton(Bundle.getMessage("ButtonRelease"));
        buttonPanel.add(this.releaseButton);
        this.releaseButton.setEnabled(false);
        this.releaseButton.addActionListener(e -> this.releaseAddress());
        this.setButton = new JButton(Bundle.getMessage("ButtonSet"));
        this.setButton.addActionListener(e -> {
            this.consistAddress = null;
            this.changeOfAddress(this.addrSelector.getAddress());
        });
        buttonPanel.add(this.setButton);
        this.mainPanel.add((Component)buttonPanel, "South");
        this.pack();
    }

    private void jmriConsistRosterSelected() {
        if (this.isUpdatingUI) {
            return;
        }
        if (this.conRosterBox.getSelectedIndex() != 0 && this.conRosterBox.getSelectedItem() instanceof DccLocoAddress) {
            this.consistAddress = (DccLocoAddress)this.conRosterBox.getSelectedItem();
            this.changeOfConsistAddress();
        }
    }

    private void nceConsistRosterSelected() {
        if (this.isUpdatingUI) {
            return;
        }
        if (!Objects.equals(this.conRosterBox.getSelectedItem(), Bundle.getMessage("NoConsistSelected"))) {
            String rosterEntryTitle = Objects.requireNonNull(this.conRosterBox.getSelectedItem()).toString();
            NceConsistRosterEntry nceConsistRosterEntry = InstanceManager.getDefault(NceConsistRoster.class).entryFromTitle(rosterEntryTitle);
            DccLocoAddress a = new DccLocoAddress(Integer.parseInt(nceConsistRosterEntry.getLoco1DccAddress()), nceConsistRosterEntry.isLoco1LongAddress());
            this.addrSelector.setAddress(a);
            this.consistAddress = null;
            int cA = 0;
            try {
                cA = Integer.parseInt(nceConsistRosterEntry.getConsistNumber());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (0 >= cA || cA >= 128) {
                log.warn("consist number missing {}", (Object)nceConsistRosterEntry.getLoco1DccAddress());
                JmriJOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("ConsistNumberHasNotBeenAssigned"), Bundle.getMessage("NeedsConsistNumber"), 0);
                return;
            }
            this.consistAddress = new DccLocoAddress(cA, false);
            if (JmriJOptionPane.showConfirmDialog(this.mainPanel, Bundle.getMessage("SendFunctionToLead"), Bundle.getMessage("NCEconsistThrottle"), 0) != 0) {
                this.addrSelector.setAddress(this.consistAddress);
                this.consistAddress = null;
            }
            this.changeOfAddress(this.addrSelector.getAddress());
        }
    }

    private void changeOfAddress(DccLocoAddress a) {
        boolean requestOK;
        this.currentAddress = a;
        if (this.currentAddress == null) {
            return;
        }
        this.listeners.forEach(l -> l.notifyAddressChosen(this.currentAddress));
        log.debug("Requesting new slot for address {} rosterEntry {}", (Object)this.currentAddress, (Object)this.rosterEntry);
        if (this.rosterEntry == null) {
            this.requestedAddress = this.currentAddress;
            requestOK = this.throttleManager.requestThrottle(this.currentAddress, (ThrottleListener)this, true);
        } else {
            this.requestedAddress = this.rosterEntry.getDccLocoAddress();
            requestOK = this.throttleManager.requestThrottle(this.rosterEntry, (ThrottleListener)this, true);
        }
        if (!requestOK) {
            this.requestedAddress = null;
            JmriJOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("AddressInUse"));
        }
    }

    private void changeOfConsistAddress() {
        if (this.consistAddress == null) {
            return;
        }
        this.addrSelector.setAddress(this.consistAddress);
        this.listeners.forEach(l -> l.notifyAddressChosen(this.currentAddress));
        log.debug("Requesting new slot for consist address {}", (Object)this.consistAddress);
        this.requestedAddress = this.consistAddress;
        boolean requestOK = this.throttleManager.requestThrottle(this.consistAddress, (ThrottleListener)this, true);
        if (!requestOK) {
            this.requestedAddress = null;
            JmriJOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("AddressInUse"));
        }
    }

    protected void openProgrammer() {
        if (this.rosterEntry == null) {
            return;
        }
        ResourceBundle rbt = ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle");
        String ptitle = MessageFormat.format(rbt.getString("FrameOpsProgrammerTitle"), this.rosterEntry.getId());
        int address = Integer.parseInt(this.rosterEntry.getDccAddress());
        boolean longAddr = true;
        if (address < 100) {
            longAddr = false;
        }
        AddressedProgrammer programmer = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(longAddr, address);
        PaneOpsProgFrame p = new PaneOpsProgFrame(null, this.rosterEntry, ptitle, "programmers" + File.separator + ProgDefault.getDefaultProgFile() + ".xml", programmer);
        ((Window)p).pack();
        p.setVisible(true);
    }

    public void dispatchAddress() {
        if (this.throttle != null) {
            int usageCount = this.throttleManager.getThrottleUsageCount(this.throttle.getLocoAddress()) - 1;
            if (usageCount != 0) {
                JmriJOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("CannotDispatch", usageCount));
                return;
            }
            this.notifyThrottleDisposed();
            this.throttleManager.dispatchThrottle(this.throttle, this);
            this.throttle = null;
        }
    }

    public void releaseAddress() {
        this.notifyThrottleDisposed();
        if (this.throttle != null) {
            this.throttleManager.releaseThrottle(this.throttle, this);
            this.throttle = null;
        }
        if (this.consistThrottle != null) {
            this.throttleManager.releaseThrottle(this.consistThrottle, this);
            this.consistThrottle = null;
        }
    }

    private void notifyListenersOfThrottleRelease() {
        if (this.listeners != null) {
            this.listeners.forEach(l -> {
                if (this.consistAddress != null) {
                    l.notifyConsistAddressReleased(this.consistAddress);
                }
                l.notifyAddressReleased(this.currentAddress);
            });
        }
    }

    public Element getXml() {
        Element me = new Element("AddressPanel");
        ArrayList<Element> children = new ArrayList<Element>(1);
        children.add(WindowPreferences.getPreferences(this));
        children.add(new LocoAddressXml().store(this.addrSelector.getAddress()));
        children.add(new LocoAddressXml().store(this.consistAddress));
        me.setContent(children);
        return me;
    }

    public void setXml(Element e) {
        List elementList;
        Element window = e.getChild("window");
        WindowPreferences.setPreferences(this, window);
        Element addressElement = e.getChild("address");
        if (addressElement != null && this.getRosterEntry() == null) {
            String address = addressElement.getAttribute("value").getValue();
            this.addrSelector.setAddress(new DccLocoAddress(Integer.parseInt(address), false));
            this.consistAddress = null;
            this.changeOfAddress(this.addrSelector.getAddress());
        }
        if (!(elementList = e.getChildren("locoaddress")).isEmpty() && this.getThrottle() == null) {
            DccLocoAddress tmpAdd;
            log.debug("found {} locoaddress(es)", (Object)elementList.size());
            this.currentAddress = (DccLocoAddress)new LocoAddressXml().getAddress((Element)elementList.get(0));
            log.debug("Loaded address {} from xml", (Object)this.currentAddress);
            this.addrSelector.setAddress(this.currentAddress);
            this.consistAddress = null;
            if (elementList.size() > 1 && (tmpAdd = (DccLocoAddress)new LocoAddressXml().getAddress((Element)elementList.get(1))) != null && !this.currentAddress.equals(tmpAdd)) {
                log.debug("and consist with {}", (Object)tmpAdd);
                this.consistAddress = tmpAdd;
            }
            this.changeOfAddress(this.addrSelector.getAddress());
        }
    }

    public RosterEntrySelectorPanel getRosterEntrySelector() {
        return this.rosterBox;
    }

    public DccThrottle getThrottle() {
        if (this.consistThrottle != null) {
            return this.consistThrottle;
        }
        return this.throttle;
    }

    public DccThrottle getFunctionThrottle() {
        if (this.throttle != null) {
            return this.throttle;
        }
        return this.consistThrottle;
    }

    public DccLocoAddress getCurrentAddress() {
        return this.currentAddress;
    }

    public void setCurrentAddress(DccLocoAddress currentAddress) {
        if (log.isDebugEnabled()) {
            log.debug("Setting CurrentAddress to {}", (Object)currentAddress);
        }
        this.addrSelector.setAddress(currentAddress);
        this.changeOfAddress(this.addrSelector.getAddress());
    }

    public void setAddress(int number, boolean isLong) {
        this.setCurrentAddress(new DccLocoAddress(number, isLong));
    }

    @CheckForNull
    public DccLocoAddress getConsistAddress() {
        return this.consistAddress;
    }

    public void setConsistAddress(DccLocoAddress consistAddress) {
        log.debug("Setting Consist Address to {}", (Object)consistAddress);
        this.consistAddress = consistAddress;
        this.changeOfConsistAddress();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        if ("ThrottleConnected".compareTo(evt.getPropertyName()) == 0 && ((Boolean)evt.getOldValue()).booleanValue() && !((Boolean)evt.getNewValue()).booleanValue()) {
            log.debug("propertyChange: ThrottleConnected to false");
            this.notifyThrottleDisposed();
            this.throttle = null;
            this.consistThrottle = null;
        }
        if ("DispatchEnabled".compareTo(evt.getPropertyName()) == 0) {
            log.debug("propertyChange: Dispatch Button Enabled {}", evt.getNewValue());
            this.dispatchButton.setEnabled((Boolean)evt.getNewValue());
        }
        if ("ReleaseEnabled".compareTo(evt.getPropertyName()) == 0) {
            log.debug("propertyChange: release Button Enabled {}", evt.getNewValue());
            this.releaseButton.setEnabled((Boolean)evt.getNewValue());
        }
    }

    void applyPreferences() {
    }
}

