/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.Color;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.throttle.AddressListener;
import jmri.jmrit.throttle.AddressPanel;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.util.FileUtil;
import jmri.util.swing.ResizableImagePanel;

public class BackgroundPanel
extends ResizableImagePanel
implements AddressListener {
    AddressPanel addressPanel = null;

    public BackgroundPanel() {
        this.initGUI();
        this.applyPreferences();
    }

    private void initGUI() {
        this.setBackground(Color.GRAY);
        this.setRespectAspectRatio(true);
    }

    public void applyPreferences() {
        this.setResizingContainer(InstanceManager.getDefault(ThrottlesPreferences.class).isResizingWindow());
    }

    public void setAddressPanel(AddressPanel addressPanel) {
        this.addressPanel = addressPanel;
    }

    @Override
    public void notifyAddressThrottleFound(DccThrottle t) {
        RosterEntry rosterEntry = null;
        if (this.addressPanel != null) {
            rosterEntry = this.addressPanel.getRosterEntry();
        }
        if (rosterEntry != null) {
            this.setImagePath(rosterEntry.getImagePath());
        } else {
            if (t.getLocoAddress().toString().compareTo("3(S)") == 0) {
                this.setImagePath(FileUtil.getExternalFilename("resources/icons/throttles/DCCImage.png"));
            }
            if (t.getLocoAddress().toString().compareTo("0(S)") == 0) {
                this.setImagePath(FileUtil.getExternalFilename("resources/icons/throttles/DCImage.png"));
            }
        }
    }

    @Override
    public void notifyAddressReleased(LocoAddress la) {
        this.setImagePath(null);
        this.setVisible(false);
    }

    @Override
    public void notifyAddressChosen(LocoAddress l) {
    }

    @Override
    public void notifyConsistAddressChosen(LocoAddress l) {
        this.notifyAddressChosen(l);
    }

    @Override
    public void notifyConsistAddressReleased(LocoAddress l) {
        this.notifyAddressReleased(l);
    }

    @Override
    public void notifyConsistAddressThrottleFound(DccThrottle t) {
        this.notifyAddressThrottleFound(t);
    }

    public void destroy() {
        if (this.addressPanel != null) {
            this.addressPanel.removeAddressListener(this);
            this.addressPanel = null;
        }
    }
}

