/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.basic.BasicSliderUI;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleManager;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.throttle.AddressListener;
import jmri.jmrit.throttle.AddressPanel;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ControlPanelCustomSliderUI;
import jmri.jmrit.throttle.ControlPanelPropertyEditor;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrit.throttle.WindowPreferences;
import jmri.util.FileUtil;
import jmri.util.LoggingUtil;
import jmri.util.MouseInputAdapterInstaller;
import jmri.util.swing.JmriMouseAdapter;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ControlPanel
extends JInternalFrame
implements PropertyChangeListener,
AddressListener {
    private final ThrottleManager throttleManager;
    private DccThrottle throttle;
    private boolean isConsist = false;
    private JSlider speedSlider;
    private JSlider speedSliderContinuous;
    private JSpinner speedSpinner;
    private SpinnerNumberModel speedSpinnerModel;
    private JComboBox<SpeedStepMode> speedStepBox;
    private JRadioButton forwardButton;
    private JRadioButton reverseButton;
    private JButton stopButton;
    private JButton idleButton;
    private JPanel buttonPanel;
    private JPanel topButtonPanel;
    private Document forwardButtonSvgIcon;
    private Document forwardSelectedButtonSvgIcon;
    private Document forwardRollButtonSvgIcon;
    private ImageIcon forwardButtonImageIcon;
    private ImageIcon forwardSelectedButtonImageIcon;
    private ImageIcon forwardRollButtonImageIcon;
    private Document reverseButtonSvgIcon;
    private Document reverseSelectedButtonSvgIcon;
    private Document reverseRollButtonSvgIcon;
    private ImageIcon reverseButtonImageIcon;
    private ImageIcon reverseSelectedButtonImageIcon;
    private ImageIcon reverseRollButtonImageIcon;
    private Document idleButtonSvgIcon;
    private Document idleSelectedButtonSvgIcon;
    private Document idleRollButtonSvgIcon;
    private ImageIcon idleButtonImageIcon;
    private ImageIcon idleSelectedButtonImageIcon;
    private ImageIcon idleRollButtonImageIcon;
    private Document stopButtonSvgIcon;
    private Document stopSelectedButtonSvgIcon;
    private Document stopRollButtonSvgIcon;
    private ImageIcon stopButtonImageIcon;
    private ImageIcon stopSelectedButtonImageIcon;
    private ImageIcon stopRollButtonImageIcon;
    private ImageIcon speedLabelVerticalImageIcon;
    private ImageIcon speedLabelHorizontalImageIcon;
    private Map<Integer, JLabel> defaultLabelTable;
    private Map<Integer, JLabel> verticalLabelMap;
    private Map<Integer, JLabel> horizontalLabelMap;
    private boolean internalAdjust = false;
    private JPopupMenu popupMenu;
    private ControlPanelPropertyEditor propertyEditor;
    private JPanel speedControlPanel;
    private JPanel spinnerPanel;
    private JPanel sliderPanel;
    private JPanel speedSliderContinuousPanel;
    private AddressPanel addressPanel;
    public static final int SLIDERDISPLAY = 0;
    public static final int STEPDISPLAY = 1;
    public static final int SLIDERDISPLAYCONTINUOUS = 2;
    public static final int DEFAULT_BUTTON_SIZE = 24;
    private static final String LONGEST_SS_STRING = "999";
    private static final int FONT_SIZE_MIN = 12;
    private static final int FONT_INCREMENT = 2;
    private int _displaySlider = 0;
    private JPanel mainPanel;
    private boolean trackSlider = false;
    private boolean hideSpeedStep = false;
    private final boolean trackSliderDefault = false;
    private long trackSliderMinInterval = 200L;
    private final long trackSliderMinIntervalDefault = 200L;
    private final long trackSliderMinIntervalMin = 50L;
    private final long trackSliderMinIntervalMax = 1000L;
    private long lastTrackedSliderMovementTime = 0L;
    private int intSpeedSteps = 126;
    private int maxSpeed = 126;
    private boolean speedControllerEnable = false;
    private String switchSliderFunction = "Fxx";
    private String prevShuntingFn = null;
    MyTranscoder transcoder = new MyTranscoder();
    private static final Logger log = LoggerFactory.getLogger(ControlPanel.class);

    public ControlPanel() {
        this(InstanceManager.getDefault(ThrottleManager.class));
    }

    public ControlPanel(ThrottleManager tm) {
        this.throttleManager = tm;
        this.initGUI();
        this.applyPreferences();
    }

    public void setAddressPanel(AddressPanel addressPanel) {
        this.addressPanel = addressPanel;
    }

    public void destroy() {
        if (this.addressPanel != null) {
            this.addressPanel.removeAddressListener(this);
            this.addressPanel = null;
        }
        if (this.throttle != null) {
            this.throttle.removePropertyChangeListener(this);
            this.throttle = null;
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.forwardButton.setEnabled(isEnabled);
        this.reverseButton.setEnabled(isEnabled);
        this.speedStepBox.setEnabled(isEnabled);
        this.stopButton.setEnabled(isEnabled);
        this.idleButton.setEnabled(isEnabled);
        this.speedControllerEnable = isEnabled;
        switch (this._displaySlider) {
            case 1: {
                this.speedSpinner.setEnabled(isEnabled);
                this.speedSliderContinuous.setEnabled(false);
                this.speedSlider.setEnabled(false);
                break;
            }
            case 2: {
                this.speedSliderContinuous.setEnabled(isEnabled);
                this.speedSpinner.setEnabled(false);
                this.speedSlider.setEnabled(false);
                break;
            }
            default: {
                this.speedSpinner.setEnabled(false);
                this.speedSliderContinuous.setEnabled(false);
                this.speedSlider.setEnabled(isEnabled);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.speedControllerEnable;
    }

    private void setIsForward(boolean isForward) {
        this.forwardButton.setSelected(isForward);
        this.reverseButton.setSelected(!isForward);
        this.internalAdjust = true;
        if (isForward) {
            this.speedSliderContinuous.setValue(Math.abs(this.speedSliderContinuous.getValue()));
        } else {
            this.speedSliderContinuous.setValue(-Math.abs(this.speedSliderContinuous.getValue()));
        }
        this.internalAdjust = false;
    }

    public void setSpeedStepsMode(SpeedStepMode speedStepMode) {
        this.internalAdjust = true;
        int maxSpeedPCT = 100;
        if (this.addressPanel != null && this.addressPanel.getRosterEntry() != null) {
            maxSpeedPCT = this.addressPanel.getRosterEntry().getMaxSpeedPCT();
        }
        float oldSpeed = (float)this.speedSlider.getValue() / ((float)this.maxSpeed * 1.0f);
        if (speedStepMode == SpeedStepMode.UNKNOWN) {
            speedStepMode = (SpeedStepMode)((Object)this.speedStepBox.getSelectedItem());
        } else {
            this.speedStepBox.setSelectedItem((Object)speedStepMode);
        }
        this.intSpeedSteps = speedStepMode.numSteps;
        this.maxSpeed = (int)((float)this.intSpeedSteps * (float)maxSpeedPCT / 100.0f);
        this.speedSlider.setMaximum(this.maxSpeed);
        this.speedSlider.setValue((int)(oldSpeed * (float)this.maxSpeed));
        this.speedSlider.setMajorTickSpacing(this.maxSpeed / 2);
        this.speedSliderContinuous.setMaximum(this.maxSpeed);
        this.speedSliderContinuous.setMinimum(-this.maxSpeed);
        if (this.forwardButton.isSelected()) {
            this.speedSliderContinuous.setValue((int)(oldSpeed * (float)this.maxSpeed));
        } else {
            this.speedSliderContinuous.setValue(-((int)(oldSpeed * (float)this.maxSpeed)));
        }
        this.speedSliderContinuous.setMajorTickSpacing(this.maxSpeed / 2);
        this.computeLabelsTable();
        this.updateSlidersLabelDisplay();
        this.speedSpinnerModel.setMaximum(Integer.valueOf(this.maxSpeed));
        this.speedSpinnerModel.setMinimum(Integer.valueOf(0));
        this.speedSpinnerModel.setValue(this.speedSlider.getValue());
        this.internalAdjust = false;
    }

    public boolean isSpeedControllerAvailable(int displaySlider) {
        switch (displaySlider) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void setSpeedController(int displaySlider) {
        this._displaySlider = displaySlider;
        switch (displaySlider) {
            case 1: {
                this.sliderPanel.setVisible(false);
                this.speedSlider.setEnabled(false);
                this.speedSliderContinuousPanel.setVisible(false);
                this.speedSliderContinuous.setEnabled(false);
                this.spinnerPanel.setVisible(true);
                this.speedSpinner.setEnabled(this.speedControllerEnable);
                return;
            }
            case 2: {
                this.sliderPanel.setVisible(false);
                this.speedSlider.setEnabled(false);
                this.speedSliderContinuousPanel.setVisible(true);
                this.speedSliderContinuous.setEnabled(this.speedControllerEnable);
                this.spinnerPanel.setVisible(false);
                this.speedSpinner.setEnabled(false);
                return;
            }
            case 0: {
                break;
            }
            default: {
                LoggingUtil.warnOnce(log, "Unexpected displaySlider = {}", displaySlider);
            }
        }
        this.sliderPanel.setVisible(true);
        this.speedSlider.setEnabled(this.speedControllerEnable);
        this.spinnerPanel.setVisible(false);
        this.speedSpinner.setEnabled(false);
        this.speedSliderContinuousPanel.setVisible(false);
        this.speedSliderContinuous.setEnabled(false);
    }

    public int getDisplaySlider() {
        return this._displaySlider;
    }

    public JSlider getSpeedSlider() {
        return this.speedSlider;
    }

    public void setTrackSlider(boolean track) {
        this.trackSlider = track;
    }

    public boolean getTrackSlider() {
        return this.trackSlider;
    }

    public void setHideSpeedStep(boolean hide) {
        this.hideSpeedStep = hide;
        this.speedStepBox.setVisible(!this.hideSpeedStep);
    }

    public boolean getHideSpeedStep() {
        return this.hideSpeedStep;
    }

    private void setSpeedValues(float speedIncrement, float speed) {
        this.internalAdjust = true;
        this.speedSlider.setValue(Math.round(speed / speedIncrement));
        log.debug("SpeedSlider value: {}", (Object)this.speedSlider.getValue());
        this.speedSpinnerModel.setValue(this.speedSlider.getValue());
        if (this.forwardButton.isSelected()) {
            this.speedSliderContinuous.setValue(this.speedSlider.getValue());
        } else {
            this.speedSliderContinuous.setValue(-this.speedSlider.getValue());
        }
        this.stopButton.setSelected(speed == -1.0f);
        this.idleButton.setSelected(speed == 0.0f);
        this.internalAdjust = false;
    }

    private GridBagConstraints makeDefaultGridBagConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 10;
        constraints.fill = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        return constraints;
    }

    private void layoutTopButtonPanel() {
        GridBagConstraints constraints = this.makeDefaultGridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.topButtonPanel.add(this.speedStepBox, constraints);
    }

    private void layoutButtonPanel() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        GridBagConstraints constraints = this.makeDefaultGridBagConstraints();
        if (preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon()) {
            this.resizeButtons();
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.gridheight = 2;
            constraints.gridwidth = 2;
            constraints.gridy = 0;
            constraints.gridx = 0;
            this.buttonPanel.add((Component)this.reverseButton, constraints);
            constraints.gridx = 3;
            this.buttonPanel.add((Component)this.forwardButton, constraints);
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.gridx = 2;
            constraints.gridy = 0;
            this.buttonPanel.add((Component)this.idleButton, constraints);
            constraints.gridy = 1;
            this.buttonPanel.add((Component)this.stopButton, constraints);
        } else {
            constraints.fill = 0;
            constraints.gridy = 1;
            this.buttonPanel.add((Component)this.forwardButton, constraints);
            constraints.gridy = 2;
            this.buttonPanel.add((Component)this.reverseButton, constraints);
            constraints.gridy = 3;
            this.buttonPanel.add((Component)this.idleButton, constraints);
            constraints.gridy = 4;
            this.buttonPanel.add((Component)this.stopButton, constraints);
        }
    }

    private void resizeButtons() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        int w = this.buttonPanel.getWidth();
        int h = this.buttonPanel.getHeight();
        if (this.buttonPanel.getWidth() == 0 || this.buttonPanel.getHeight() == 0 || !preferences.isUsingExThrottle() || !preferences.isUsingLargeSpeedSlider()) {
            w = 120;
            h = 48;
        }
        float f = Math.min(Math.floorDiv(w * 2, 5), h);
        if (this.forwardButtonSvgIcon != null) {
            this.forwardButton.setIcon(this.scaleTo(this.forwardButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.forwardButton.setIcon(this.scaleTo(this.forwardButtonImageIcon, (int)f));
        }
        if (this.forwardSelectedButtonSvgIcon != null) {
            this.forwardButton.setSelectedIcon(this.scaleTo(this.forwardSelectedButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.forwardButton.setSelectedIcon(this.scaleTo(this.forwardSelectedButtonImageIcon, (int)f));
        }
        if (this.forwardRollButtonSvgIcon != null) {
            this.forwardButton.setRolloverIcon(this.scaleTo(this.forwardRollButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.forwardButton.setRolloverIcon(this.scaleTo(this.forwardRollButtonImageIcon, (int)f));
        }
        if (this.reverseButtonSvgIcon != null) {
            this.reverseButton.setIcon(this.scaleTo(this.reverseButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.reverseButton.setIcon(this.scaleTo(this.reverseButtonImageIcon, (int)f));
        }
        if (this.reverseSelectedButtonSvgIcon != null) {
            this.reverseButton.setSelectedIcon(this.scaleTo(this.reverseSelectedButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.reverseButton.setSelectedIcon(this.scaleTo(this.reverseSelectedButtonImageIcon, (int)f));
        }
        if (this.reverseRollButtonSvgIcon != null) {
            this.reverseButton.setRolloverIcon(this.scaleTo(this.reverseRollButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.reverseButton.setRolloverIcon(this.scaleTo(this.reverseRollButtonImageIcon, (int)f));
        }
        f = Math.min(Math.floorDiv(w, 5), h / 2);
        if (this.idleButtonSvgIcon != null) {
            this.idleButton.setIcon(this.scaleTo(this.idleButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.idleButton.setIcon(this.scaleTo(this.idleButtonImageIcon, (int)f));
        }
        if (this.idleSelectedButtonSvgIcon != null) {
            this.idleButton.setSelectedIcon(this.scaleTo(this.idleSelectedButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.idleButton.setSelectedIcon(this.scaleTo(this.idleSelectedButtonImageIcon, (int)f));
        }
        if (this.idleRollButtonSvgIcon != null) {
            this.idleButton.setRolloverIcon(this.scaleTo(this.idleRollButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.idleButton.setRolloverIcon(this.scaleTo(this.idleRollButtonImageIcon, (int)f));
        }
        if (this.stopButtonSvgIcon != null) {
            this.stopButton.setIcon(this.scaleTo(this.stopButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.stopButton.setIcon(this.scaleTo(this.stopButtonImageIcon, (int)f));
        }
        if (this.stopSelectedButtonSvgIcon != null) {
            this.stopButton.setSelectedIcon(this.scaleTo(this.stopSelectedButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.stopButton.setSelectedIcon(this.scaleTo(this.stopSelectedButtonImageIcon, (int)f));
        }
        if (this.stopRollButtonSvgIcon != null) {
            this.stopButton.setRolloverIcon(this.scaleTo(this.stopRollButtonSvgIcon, Float.valueOf(f)));
        } else {
            this.stopButton.setRolloverIcon(this.scaleTo(this.stopRollButtonImageIcon, (int)f));
        }
    }

    private ImageIcon scaleTo(ImageIcon imic, int s) {
        return new ImageIcon(imic.getImage().getScaledInstance(s, s, 4));
    }

    private ImageIcon scaleTo(Document svgImage, Float f) {
        TranscodingHints hints = new TranscodingHints();
        hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)f);
        hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)f);
        this.transcoder.setTranscodingHints(hints);
        try {
            this.transcoder.transcode(new TranscoderInput(svgImage), null);
        }
        catch (TranscoderException ex) {
            log.debug("Exception while transposing : {}", (Object)ex.getMessage());
        }
        return new ImageIcon(this.transcoder.getImage());
    }

    private void layoutSliderPanel() {
        this.sliderPanel.setLayout(new GridBagLayout());
        this.sliderPanel.add((Component)this.speedSlider, this.makeDefaultGridBagConstraints());
    }

    private void layoutSpeedSliderContinuous() {
        this.speedSliderContinuousPanel.setLayout(new GridBagLayout());
        this.speedSliderContinuousPanel.add((Component)this.speedSliderContinuous, this.makeDefaultGridBagConstraints());
    }

    private void layoutSpinnerPanel() {
        this.spinnerPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = this.makeDefaultGridBagConstraints();
        constraints.fill = 2;
        this.spinnerPanel.add((Component)this.speedSpinner, constraints);
    }

    private void setupButton(AbstractButton button, ThrottlesPreferences preferences, String message) {
        button.setHorizontalAlignment(0);
        button.setVerticalAlignment(0);
        button.setToolTipText(Bundle.getMessage(message));
        if (preferences != null && preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon()) {
            button.setBorder(null);
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
            button.setText(null);
            button.setRolloverEnabled(true);
        } else {
            button.setBorder(new JButton().getBorder());
            button.setBorderPainted(true);
            button.setContentAreaFilled(true);
            button.setText(Bundle.getMessage(message));
            button.setIcon(null);
            button.setSelectedIcon(null);
            button.setRolloverIcon(null);
            button.setRolloverEnabled(false);
        }
    }

    private void initGUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.setContentPane(this.mainPanel);
        this.setDefaultCloseOperation(0);
        JPanel speedPanel = new JPanel();
        speedPanel.setLayout(new BorderLayout());
        speedPanel.setOpaque(false);
        this.mainPanel.add((Component)speedPanel, "Center");
        this.topButtonPanel = new JPanel();
        this.topButtonPanel.setLayout(new GridBagLayout());
        speedPanel.add((Component)this.topButtonPanel, "North");
        this.speedControlPanel = new JPanel();
        this.speedControlPanel.setLayout(new BoxLayout(this.speedControlPanel, 0));
        this.speedControlPanel.setOpaque(false);
        speedPanel.add((Component)this.speedControlPanel, "Center");
        this.sliderPanel = new JPanel();
        this.sliderPanel.setOpaque(false);
        this.speedSlider = new JSlider(0, this.intSpeedSteps);
        this.speedSlider.setOpaque(false);
        this.speedSlider.setValue(0);
        this.speedSlider.setFocusable(false);
        this.speedSlider.addMouseListener(JmriMouseListener.adapt(new JSliderPreciseMouseAdapter()));
        this.speedSliderContinuous = new JSlider(-this.intSpeedSteps, this.intSpeedSteps);
        this.speedSliderContinuous.setValue(0);
        this.speedSliderContinuous.setOpaque(false);
        this.speedSliderContinuous.setFocusable(false);
        this.speedSliderContinuous.addMouseListener(JmriMouseListener.adapt(new JSliderPreciseMouseAdapter()));
        this.speedSpinner = new JSpinner();
        this.speedSpinnerModel = new SpinnerNumberModel(0, 0, this.intSpeedSteps, 1);
        this.speedSpinner.setModel(this.speedSpinnerModel);
        this.speedSpinner.getActionMap().put("doNothing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.speedSpinner.getActionMap().put("giveUpFocus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceManager.getDefault(ThrottleFrameManager.class).getCurrentThrottleFrame().getRootPane().requestFocusInWindow();
            }
        });
        for (int i : new ArrayList<Integer>(Arrays.asList(48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 37, 39, 38, 40, 127, 8))) {
            this.speedSpinner.getInputMap(1).put(KeyStroke.getKeyStroke(i, 0, true), "doNothing");
            this.speedSpinner.getInputMap(1).put(KeyStroke.getKeyStroke(i, 0, false), "doNothing");
        }
        this.speedSpinner.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "giveUpFocus");
        this.speedSpinner.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "giveUpFocus");
        EnumSet<SpeedStepMode> speedStepModes = this.throttleManager.supportedSpeedModes();
        this.speedStepBox = new JComboBox<SpeedStepMode>((SpeedStepMode[])speedStepModes.toArray(SpeedStepMode[]::new));
        this.forwardButton = new JRadioButton();
        this.reverseButton = new JRadioButton();
        try {
            this.forwardButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/dirFwdOff.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.forwardButtonSvgIcon = null;
            this.forwardButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/dirFwdOff64.png"));
        }
        try {
            this.forwardSelectedButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/dirFwdOn.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.forwardSelectedButtonSvgIcon = null;
            this.forwardSelectedButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/dirFwdOn64.png"));
        }
        try {
            this.forwardRollButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/dirFwdRoll.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.forwardRollButtonSvgIcon = null;
            this.forwardRollButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/dirFwdRoll64.png"));
        }
        try {
            this.reverseButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/dirBckOff.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.reverseButtonSvgIcon = null;
            this.reverseButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/dirBckOff64.png"));
        }
        try {
            this.reverseSelectedButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/dirBckOn.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.reverseSelectedButtonSvgIcon = null;
            this.reverseSelectedButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/dirBckOn64.png"));
        }
        try {
            this.reverseRollButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/dirBckRoll.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.reverseRollButtonSvgIcon = null;
            this.reverseRollButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/dirBckRoll64.png"));
        }
        this.speedLabelVerticalImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/labelArrowVertical.png"));
        this.speedLabelHorizontalImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/labelArrowHorizontal.png"));
        this.layoutSliderPanel();
        this.speedControlPanel.add(this.sliderPanel);
        this.speedSlider.setOrientation(1);
        this.speedSlider.setMajorTickSpacing(this.maxSpeed / 2);
        this.speedSlider.addChangeListener(e -> {
            if (!this.internalAdjust) {
                boolean doIt = false;
                if (!this.speedSlider.getValueIsAdjusting()) {
                    doIt = true;
                    this.lastTrackedSliderMovementTime = System.currentTimeMillis() - this.trackSliderMinInterval;
                } else if (this.trackSlider && System.currentTimeMillis() - this.lastTrackedSliderMovementTime >= this.trackSliderMinInterval) {
                    doIt = true;
                    this.lastTrackedSliderMovementTime = System.currentTimeMillis();
                }
                if (doIt) {
                    float newSpeed = (float)this.speedSlider.getValue() / ((float)this.intSpeedSteps * 1.0f);
                    if (log.isDebugEnabled()) {
                        log.debug("stateChanged: slider pos: {} speed: {}", (Object)this.speedSlider.getValue(), (Object)Float.valueOf(newSpeed));
                    }
                    if (this.sliderPanel.isVisible() && this.throttle != null) {
                        this.throttle.setSpeedSetting(newSpeed);
                    }
                    this.speedSpinnerModel.setValue(this.speedSlider.getValue());
                    if (this.forwardButton.isSelected()) {
                        this.speedSliderContinuous.setValue(this.speedSlider.getValue());
                    } else {
                        this.speedSliderContinuous.setValue(-this.speedSlider.getValue());
                    }
                }
            }
        });
        this.speedSliderContinuousPanel = new JPanel();
        this.layoutSpeedSliderContinuous();
        this.speedControlPanel.add(this.speedSliderContinuousPanel);
        this.speedSliderContinuous.setOrientation(1);
        this.speedSliderContinuous.setMajorTickSpacing(this.maxSpeed / 2);
        this.speedSliderContinuous.addChangeListener(e -> {
            if (!this.internalAdjust) {
                boolean doIt = false;
                if (!this.speedSliderContinuous.getValueIsAdjusting()) {
                    doIt = true;
                    this.lastTrackedSliderMovementTime = System.currentTimeMillis() - this.trackSliderMinInterval;
                } else if (this.trackSlider && System.currentTimeMillis() - this.lastTrackedSliderMovementTime >= this.trackSliderMinInterval) {
                    doIt = true;
                    this.lastTrackedSliderMovementTime = System.currentTimeMillis();
                }
                if (doIt) {
                    boolean newDir;
                    float newSpeed = (float)Math.abs(this.speedSliderContinuous.getValue()) / ((float)this.intSpeedSteps * 1.0f);
                    boolean bl = newDir = this.speedSliderContinuous.getValue() >= 0;
                    if (log.isDebugEnabled()) {
                        log.debug("stateChanged: slider pos: {} speed: {} dir: {}", new Object[]{this.speedSliderContinuous.getValue(), Float.valueOf(newSpeed), newDir});
                    }
                    if (this.speedSliderContinuousPanel.isVisible() && this.throttle != null) {
                        this.throttle.setSpeedSetting(newSpeed);
                        if (newSpeed > 0.0f && newDir != this.forwardButton.isSelected()) {
                            this.throttle.setIsForward(newDir);
                        }
                    }
                    this.speedSpinnerModel.setValue(Math.abs(this.speedSliderContinuous.getValue()));
                    this.speedSlider.setValue(Math.abs(this.speedSliderContinuous.getValue()));
                }
            }
        });
        this.computeLabelsTable();
        this.updateSlidersLabelDisplay();
        this.spinnerPanel = new JPanel();
        this.layoutSpinnerPanel();
        this.speedControlPanel.add(this.spinnerPanel);
        this.speedSpinner.addChangeListener(e -> {
            if (!this.internalAdjust) {
                float newSpeed = ((Integer)this.speedSpinner.getValue()).floatValue() / ((float)this.intSpeedSteps * 1.0f);
                if (log.isDebugEnabled()) {
                    log.debug("stateChanged: spinner pos: {} speed: {}", this.speedSpinner.getValue(), (Object)Float.valueOf(newSpeed));
                }
                if (this.throttle != null) {
                    if (this.spinnerPanel.isVisible()) {
                        this.throttle.setSpeedSetting(newSpeed);
                    }
                    this.speedSlider.setValue((Integer)this.speedSpinner.getValue());
                    if (this.forwardButton.isSelected()) {
                        this.speedSliderContinuous.setValue((Integer)this.speedSpinner.getValue());
                    } else {
                        this.speedSliderContinuous.setValue(-((Integer)this.speedSpinner.getValue()).intValue());
                    }
                } else {
                    log.warn("no throttle object in stateChanged, ignoring change of speed to {}", (Object)Float.valueOf(newSpeed));
                }
            }
        });
        this.speedStepBox.addActionListener(e -> {
            SpeedStepMode s = (SpeedStepMode)((Object)((Object)this.speedStepBox.getSelectedItem()));
            this.setSpeedStepsMode(s);
            if (this.throttle != null) {
                this.throttle.setSpeedStepMode(s);
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.buttonPanel, "South");
        ButtonGroup directionButtons = new ButtonGroup();
        directionButtons.add(this.forwardButton);
        directionButtons.add(this.reverseButton);
        this.forwardButton.addActionListener(e -> {
            if (this.throttle != null) {
                this.throttle.setIsForward(true);
            }
            this.speedSliderContinuous.setValue(Math.abs(this.speedSliderContinuous.getValue()));
        });
        this.reverseButton.addActionListener(e -> {
            if (this.throttle != null) {
                this.throttle.setIsForward(false);
            }
            this.speedSliderContinuous.setValue(-Math.abs(this.speedSliderContinuous.getValue()));
        });
        this.stopButton = new JButton();
        this.idleButton = new JButton();
        try {
            this.stopButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/estop.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.stopButtonSvgIcon = null;
            this.stopButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/estop64.png"));
        }
        try {
            this.stopSelectedButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/estopOn.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.stopSelectedButtonSvgIcon = null;
            this.stopSelectedButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/estopOn64.png"));
        }
        try {
            this.stopRollButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/estopRoll.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.stopRollButtonSvgIcon = null;
            this.stopRollButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/estopRoll64.png"));
        }
        try {
            this.idleButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/stop.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.idleButtonSvgIcon = null;
            this.idleButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/stop64.png"));
        }
        try {
            this.idleSelectedButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/stopOn.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.idleSelectedButtonSvgIcon = null;
            this.idleSelectedButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/stopOn64.png"));
        }
        try {
            this.idleRollButtonSvgIcon = this.createSVGDocument(FileUtil.findURI("resources/icons/throttles/stopRoll.svg").toString());
        }
        catch (Exception ex) {
            log.debug("Issue loading svg icon, reverting to png : {}", (Object)ex.getMessage());
            this.idleRollButtonSvgIcon = null;
            this.idleRollButtonImageIcon = new ImageIcon(FileUtil.findURL("resources/icons/throttles/stopRoll64.png"));
        }
        this.stopButton.addActionListener(e -> this.stop());
        this.idleButton.addActionListener(e -> {
            this.speedSlider.setValue(0);
            this.speedSpinner.setValue(0);
            this.speedSliderContinuous.setValue(0);
            this.throttle.setSpeedSetting(0.0f);
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ControlPanel.this.changeOrientation();
            }
        });
        speedPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ControlPanel.this.changeFontSizes();
            }
        });
        this.layoutButtonPanel();
        this.layoutTopButtonPanel();
        MouseInputAdapterInstaller.installMouseListenerOnAllComponents(new PopupListener(), this);
        this.setSpeedController(this._displaySlider);
    }

    private Document createSVGDocument(String uri) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        return factory.createDocument(uri);
    }

    public void stop() {
        if (this.throttle == null) {
            return;
        }
        this.internalAdjust = true;
        this.throttle.setSpeedSetting(-1.0f);
        this.speedSlider.setValue(0);
        this.speedSpinnerModel.setValue(0);
        this.speedSliderContinuous.setValue(0);
        this.internalAdjust = false;
    }

    private void changeOrientation() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        if (this.mainPanel.getWidth() > this.mainPanel.getHeight()) {
            this.speedSlider.setOrientation(0);
            this.speedSliderContinuous.setOrientation(0);
            if (preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon() && preferences.isUsingLargeSpeedSlider()) {
                int bpw = this.mainPanel.getHeight() * 5 / 2;
                if (bpw > this.mainPanel.getWidth() / 2) {
                    bpw = this.mainPanel.getWidth() / 2;
                }
                this.buttonPanel.setSize(bpw, this.mainPanel.getHeight());
                this.resizeButtons();
            }
            this.mainPanel.remove(this.buttonPanel);
            this.mainPanel.add((Component)this.buttonPanel, "East");
        } else {
            this.speedSlider.setOrientation(1);
            this.speedSliderContinuous.setOrientation(1);
            if (preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon() && preferences.isUsingLargeSpeedSlider()) {
                int bph = this.mainPanel.getWidth() * 2 / 5;
                if (bph > this.mainPanel.getHeight() / 2) {
                    bph = this.mainPanel.getHeight() / 2;
                }
                this.buttonPanel.setSize(this.mainPanel.getWidth(), bph);
                this.resizeButtons();
            }
            this.mainPanel.remove(this.buttonPanel);
            this.mainPanel.add((Component)this.buttonPanel, "South");
        }
        this.updateSlidersLabelDisplay();
    }

    private void changeFontSizes() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        if (preferences.isUsingExThrottle() && preferences.isUsingLargeSpeedSlider()) {
            Font f;
            int fontSize = this.speedSpinner.getFont().getSize();
            int fieldHeight = this.speedControlPanel.getSize().height;
            int stringHeight = this.speedSpinner.getFontMetrics(this.speedSpinner.getFont()).getHeight() + 16;
            if (stringHeight > fieldHeight) {
                while (stringHeight > fieldHeight && fontSize >= 14) {
                    f = new Font("", 0, fontSize -= 2);
                    this.speedSpinner.setFont(f);
                    stringHeight = this.speedSpinner.getFontMetrics(this.speedSpinner.getFont()).getHeight() + 16;
                }
            } else {
                while (fieldHeight - stringHeight > 10) {
                    f = new Font("", 0, fontSize += 2);
                    this.speedSpinner.setFont(f);
                    stringHeight = this.speedSpinner.getFontMetrics(this.speedSpinner.getFont()).getHeight() + 16;
                }
            }
            int fieldWidth = this.speedControlPanel.getSize().width;
            int stringWidth = this.speedSpinner.getFontMetrics(this.speedSpinner.getFont()).stringWidth(LONGEST_SS_STRING) + 24;
            while (stringWidth > fieldWidth && fontSize >= 14) {
                Font f2 = new Font("", 0, fontSize -= 2);
                this.speedSpinner.setFont(f2);
                stringWidth = this.speedSpinner.getFontMetrics(this.speedSpinner.getFont()).stringWidth(LONGEST_SS_STRING) + 24;
            }
            this.speedSpinner.setMinimumSize(new Dimension(stringWidth, stringHeight));
        }
    }

    public void setForwardDirection(boolean fwd) {
        if (fwd) {
            if (this.forwardButton.isEnabled()) {
                this.forwardButton.doClick();
            } else {
                log.error("setForwardDirection(true) with forwardButton disabled, failed");
            }
        } else if (this.reverseButton.isEnabled()) {
            this.reverseButton.doClick();
        } else {
            log.error("setForwardDirection(false) with reverseButton disabled, failed");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("SpeedSetting")) {
            float speed = ((Float)e.getNewValue()).floatValue();
            log.debug("Throttle panel speed updated to {} increment {}", (Object)Float.valueOf(speed), (Object)Float.valueOf(this.throttle.getSpeedIncrement()));
            this.setSpeedValues(this.throttle.getSpeedIncrement(), speed);
        } else if (e.getPropertyName().equals("SpeedSteps")) {
            SpeedStepMode steps = (SpeedStepMode)((Object)e.getNewValue());
            this.setSpeedStepsMode(steps);
        } else if (e.getPropertyName().equals("IsForward")) {
            boolean Forward = (Boolean)e.getNewValue();
            this.setIsForward(Forward);
        } else if (e.getPropertyName().equals(this.switchSliderFunction)) {
            if (((Boolean)e.getNewValue()).booleanValue()) {
                this.updateSlidersLabelDisplay();
                if (this._displaySlider == 0) {
                    this.setSpeedController(2);
                }
            } else {
                this.updateSlidersLabelDisplay();
                if (this._displaySlider == 2) {
                    this.setSpeedController(0);
                }
            }
        }
        log.debug("Property change event received {} / {}", (Object)e.getPropertyName(), e.getNewValue());
    }

    final void applyPreferences() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        if (preferences.isUsingExThrottle() && preferences.isUsingLargeSpeedSlider()) {
            this.speedSlider.setUI(new ControlPanelCustomSliderUI(this.speedSlider));
            this.speedSliderContinuous.setUI(new ControlPanelCustomSliderUI(this.speedSliderContinuous));
            this.changeFontSizes();
        } else {
            this.speedSlider.setUI(new JSlider().getUI());
            this.speedSliderContinuous.setUI(new JSlider().getUI());
            this.speedSpinner.setFont(new JSpinner().getFont());
        }
        this.updateSlidersLabelDisplay();
        this.setupButton(this.stopButton, preferences, "ButtonEStop");
        this.setupButton(this.idleButton, preferences, "ButtonIdle");
        this.setupButton(this.forwardButton, preferences, "ButtonForward");
        this.setupButton(this.reverseButton, preferences, "ButtonReverse");
        this.buttonPanel.removeAll();
        this.layoutButtonPanel();
        if (preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon()) {
            this.changeOrientation();
        }
        this.setHideSpeedStep(preferences.isUsingExThrottle() && preferences.isHidingSpeedStepSelector());
    }

    private void initPopupMenu() {
        if (this.popupMenu == null) {
            JMenuItem propertiesMenuItem = new JMenuItem(Bundle.getMessage("ControlPanelProperties"));
            propertiesMenuItem.addActionListener(e -> {
                if (this.propertyEditor == null) {
                    this.propertyEditor = new ControlPanelPropertyEditor(this);
                }
                this.propertyEditor.setLocation(MouseInfo.getPointerInfo().getLocation());
                this.propertyEditor.resetProperties();
                this.propertyEditor.setVisible(true);
            });
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(propertiesMenuItem);
        }
    }

    public Element getXml() {
        Element me = new Element("ControlPanel");
        me.setAttribute("displaySpeedSlider", String.valueOf(this._displaySlider));
        me.setAttribute("trackSlider", String.valueOf(this.trackSlider));
        me.setAttribute("trackSliderMinInterval", String.valueOf(this.trackSliderMinInterval));
        me.setAttribute("switchSliderOnFunction", this.switchSliderFunction != null ? this.switchSliderFunction : "Fxx");
        me.setAttribute("hideSpeedStep", String.valueOf(this.hideSpeedStep));
        ArrayList<Element> children = new ArrayList<Element>(1);
        children.add(WindowPreferences.getPreferences(this));
        me.setContent(children);
        return me;
    }

    public void setXml(Element e) {
        Attribute tsmiAtt;
        this.internalAdjust = true;
        try {
            this.setSpeedController(e.getAttribute("displaySpeedSlider").getIntValue());
        }
        catch (DataConversionException ex) {
            log.error("DataConverstionException in setXml", (Throwable)ex);
            this.setSpeedController(0);
        }
        Attribute tsAtt = e.getAttribute("trackSlider");
        if (tsAtt != null) {
            try {
                this.trackSlider = tsAtt.getBooleanValue();
            }
            catch (DataConversionException ex) {
                this.trackSlider = false;
            }
        } else {
            this.trackSlider = false;
        }
        if ((tsmiAtt = e.getAttribute("trackSliderMinInterval")) != null) {
            try {
                this.trackSliderMinInterval = tsmiAtt.getLongValue();
            }
            catch (DataConversionException ex) {
                this.trackSliderMinInterval = 200L;
            }
            if (this.trackSliderMinInterval < 50L) {
                this.trackSliderMinInterval = 50L;
            } else if (this.trackSliderMinInterval > 1000L) {
                this.trackSliderMinInterval = 1000L;
            }
        } else {
            this.trackSliderMinInterval = 200L;
        }
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        Attribute hssAtt = e.getAttribute("hideSpeedStep");
        if (hssAtt != null) {
            try {
                this.setHideSpeedStep(hssAtt.getBooleanValue());
            }
            catch (DataConversionException ex) {
                this.setHideSpeedStep(preferences.isUsingExThrottle() && preferences.isHidingSpeedStepSelector());
            }
        } else {
            this.setHideSpeedStep(preferences.isUsingExThrottle() && preferences.isHidingSpeedStepSelector());
        }
        if (this.prevShuntingFn == null && e.getAttribute("switchSliderOnFunction") != null) {
            this.setSwitchSliderFunction(e.getAttribute("switchSliderOnFunction").getValue());
        }
        this.internalAdjust = false;
        Element window = e.getChild("window");
        WindowPreferences.setPreferences(this, window);
    }

    @Override
    public void notifyAddressChosen(LocoAddress l) {
    }

    @Override
    public void notifyAddressReleased(LocoAddress la) {
        if (this.throttle == null) {
            log.debug("notifyAddressReleased() throttle already null, called for loc {}", (Object)la);
            return;
        }
        this.setEnabled(false);
        if (this.throttle != null) {
            this.throttle.removePropertyChangeListener(this);
        }
        this.throttle = null;
        if (this.prevShuntingFn != null) {
            this.setSwitchSliderFunction(this.prevShuntingFn);
            this.prevShuntingFn = null;
        }
    }

    private void addressThrottleFound() {
        this.setEnabled(true);
        this.setIsForward(this.throttle.getIsForward());
        this.setSpeedStepsMode(this.throttle.getSpeedStepMode());
        this.setSpeedValues(this.throttle.getSpeedIncrement(), this.throttle.getSpeedSetting());
        this.throttle.addPropertyChangeListener(this);
    }

    @Override
    public void notifyAddressThrottleFound(DccThrottle t) {
        log.debug("control panel received new throttle {}", (Object)t);
        if (this.throttle != null) {
            log.debug("notifyAddressThrottleFound() throttle non null, called for loc {}", (Object)t.getLocoAddress());
            return;
        }
        if (this.isConsist) {
            return;
        }
        this.throttle = t;
        this.addressThrottleFound();
        if (this.addressPanel != null && this.addressPanel.getRosterEntry() != null && this.addressPanel.getRosterEntry().getShuntingFunction() != null) {
            this.prevShuntingFn = this.getSwitchSliderFunction();
            this.setSwitchSliderFunction(this.addressPanel.getRosterEntry().getShuntingFunction());
        } else {
            this.setSwitchSliderFunction(this.switchSliderFunction);
        }
        if (log.isDebugEnabled()) {
            DccLocoAddress Address2 = (DccLocoAddress)this.throttle.getLocoAddress();
            log.debug("new address is {}", (Object)Address2.toString());
        }
    }

    @Override
    public void notifyConsistAddressChosen(LocoAddress l) {
        this.notifyAddressChosen(l);
    }

    @Override
    public void notifyConsistAddressReleased(LocoAddress la) {
        this.notifyAddressReleased(la);
        this.isConsist = false;
    }

    @Override
    public void notifyConsistAddressThrottleFound(DccThrottle t) {
        log.debug("control panel received consist throttle {}", (Object)t);
        this.isConsist = true;
        this.throttle = t;
        this.addressThrottleFound();
    }

    public void setSwitchSliderFunction(String fn) {
        this.switchSliderFunction = fn;
        if (this.switchSliderFunction == null || this.switchSliderFunction.length() == 0) {
            return;
        }
        if (this.throttle != null && this._displaySlider != 1) {
            try {
                Method getter = this.throttle.getClass().getMethod("get" + this.switchSliderFunction, null);
                Boolean state = (Boolean)getter.invoke((Object)this.throttle, (Object[])null);
                if (state.booleanValue()) {
                    this.setSpeedController(2);
                } else {
                    this.setSpeedController(0);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                log.debug("Exception in setSwitchSliderFunction: {} while looking for function {}", (Object)ex, (Object)this.switchSliderFunction);
            }
        }
    }

    private void computeLabelsTable() {
        this.defaultLabelTable = new HashMap<Integer, JLabel>(5);
        this.defaultLabelTable.put(this.maxSpeed / 2, new JLabel("50%"));
        this.defaultLabelTable.put(this.maxSpeed, new JLabel("100%"));
        this.defaultLabelTable.put(0, new JLabel(Bundle.getMessage("ButtonStop")));
        this.defaultLabelTable.put(-this.maxSpeed / 2, new JLabel("-50%"));
        this.defaultLabelTable.put(-this.maxSpeed, new JLabel("-100%"));
        if (this.addressPanel != null && this.addressPanel.getRosterEntry() != null && this.addressPanel.getRosterEntry().getAttribute("speedLabels") != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                SpeedLabel[] speedLabels = (SpeedLabel[])mapper.readValue(this.addressPanel.getRosterEntry().getAttribute("speedLabels"), SpeedLabel[].class);
                if (speedLabels != null && speedLabels.length > 0) {
                    this.verticalLabelMap = new HashMap<Integer, JLabel>(speedLabels.length * 2);
                    this.horizontalLabelMap = new HashMap<Integer, JLabel>(speedLabels.length * 2);
                    for (SpeedLabel sp : speedLabels) {
                        JLabel label = new JLabel(sp.label, this.speedLabelVerticalImageIcon, 2);
                        label.setVerticalTextPosition(0);
                        this.verticalLabelMap.put(sp.value, label);
                        this.verticalLabelMap.put(-sp.value, label);
                        label = new JLabel(sp.label, this.speedLabelHorizontalImageIcon, 2);
                        label.setHorizontalTextPosition(0);
                        label.setVerticalTextPosition(3);
                        this.horizontalLabelMap.put(sp.value, label);
                        this.horizontalLabelMap.put(-sp.value, label);
                    }
                    this.updateSlidersLabelDisplay();
                }
            }
            catch (JsonProcessingException ex) {
                log.error("Exception trying to parse speedLabels attribute from roster entry: {} ", (Object)ex.getMessage());
            }
        } else {
            this.verticalLabelMap = null;
            this.horizontalLabelMap = null;
        }
    }

    private void updateSlidersLabelDisplay() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        HashMap<Integer, JLabel> labelTable = new HashMap<Integer, JLabel>(10);
        if (preferences.isUsingExThrottle() && preferences.isUsingLargeSpeedSlider()) {
            this.speedSlider.setPaintTicks(false);
            this.speedSliderContinuous.setPaintTicks(false);
        } else {
            this.speedSlider.setPaintTicks(true);
            this.speedSliderContinuous.setPaintTicks(true);
            labelTable.putAll(this.defaultLabelTable);
        }
        if (this.speedSlider.getOrientation() == 0 && this.horizontalLabelMap != null) {
            labelTable.putAll(this.horizontalLabelMap);
        }
        if (this.speedSlider.getOrientation() == 1 && this.verticalLabelMap != null) {
            labelTable.putAll(this.verticalLabelMap);
        }
        if (!labelTable.isEmpty()) {
            this.speedSlider.setLabelTable(new Hashtable(labelTable));
            this.speedSliderContinuous.setLabelTable(new Hashtable(labelTable));
            this.speedSlider.setPaintLabels(true);
            this.speedSliderContinuous.setPaintLabels(true);
        } else {
            this.speedSlider.setPaintLabels(false);
            this.speedSliderContinuous.setPaintLabels(false);
        }
    }

    public String getSwitchSliderFunction() {
        return this.switchSliderFunction;
    }

    public void saveToRoster(RosterEntry re) {
        if (re == null) {
            return;
        }
        if (re.getShuntingFunction() != null && re.getShuntingFunction().compareTo(this.getSwitchSliderFunction()) != 0) {
            re.setShuntingFunction(this.getSwitchSliderFunction());
        } else if (re.getShuntingFunction() == null && this.getSwitchSliderFunction() != null) {
            re.setShuntingFunction(this.getSwitchSliderFunction());
        } else {
            return;
        }
        Roster.getDefault().writeRoster();
    }

    private static class SpeedLabel {
        public int value = -1;
        public String label = "";

        private SpeedLabel() {
        }
    }

    private static class JSliderPreciseMouseAdapter
    extends JmriMouseAdapter {
        private JSliderPreciseMouseAdapter() {
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            if (e.getButton() == 1) {
                JSlider sourceSlider = (JSlider)e.getSource();
                if (!sourceSlider.isEnabled()) {
                    return;
                }
                BasicSliderUI ui = (BasicSliderUI)sourceSlider.getUI();
                int value = sourceSlider.getOrientation() == 1 ? ui.valueForYPosition(e.getY()) : ui.valueForXPosition(e.getX());
                sourceSlider.setValue(value);
            }
        }
    }

    private static class MyTranscoder
    extends ImageTranscoder {
        private BufferedImage image = null;

        private MyTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            this.image = new BufferedImage(w, h, 2);
            return this.image;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void writeImage(BufferedImage bi, TranscoderOutput to) throws TranscoderException {
        }
    }

    private class PopupListener
    extends JmriMouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mouseClicked(JmriMouseEvent e) {
            this.checkTrigger(e);
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            this.checkTrigger(e);
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
            this.checkTrigger(e);
        }

        private void checkTrigger(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                ControlPanel.this.initPopupMenu();
                ControlPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

