/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class ControlPanelCustomSliderUI
extends BasicSliderUI {
    private static final Color TRACK_COLOR_BACK = new Color(136, 138, 133, 136);
    private static final Color TRACK_COLOR_FRONT = new Color(245, 121, 0, 204);
    private static final Color TRACK_COLOR_FRONT_DISABLED = new Color(245, 245, 245, 204);
    private static final Color TRACK_COLOR_TICKS = new Color(0x888A85);
    private static final Color THUMB_INNER_COLOR_STOP = new Color(0xCC0000);
    private static final Color THUMB_INNER_COLOR_RUN = new Color(14144122);
    private static final Color THUMB_INNER_COLOR_DISABLED = new Color(0x101010);
    private static final Color THUMB_CONTOUR_COLOR = new Color(0x555753);

    public ControlPanelCustomSliderUI(JSlider b) {
        super(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paint(g, c);
    }

    @Override
    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(16, this.contentRect.height - this.tickRect.height - this.labelRect.height - this.trackBuffer * 2);
        }
        return new Dimension(this.contentRect.width - this.tickRect.width - this.labelRect.width - this.trackBuffer * 2, 16);
    }

    @Override
    public void paintTrack(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(TRACK_COLOR_BACK);
        g2d.fillRect(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height);
        int[] ticksAt = new int[]{3 * this.slider.getMinimum() / 4, this.slider.getMinimum() / 2, this.slider.getMinimum() / 4, 0, this.slider.getMaximum() / 4, this.slider.getMaximum() / 2, 3 * this.slider.getMaximum() / 4};
        g2d.setPaint(TRACK_COLOR_TICKS);
        if (this.slider.getOrientation() == 1 && this.trackRect.height > ticksAt.length * 8) {
            for (int n : ticksAt) {
                g2d.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / ((this.slider.getMaximum() - this.slider.getMinimum()) / this.slider.getMaximum()) - n * this.trackRect.height / (this.slider.getMaximum() - this.slider.getMinimum()), this.trackRect.x + this.trackRect.width - 1, this.trackRect.y + this.trackRect.height / ((this.slider.getMaximum() - this.slider.getMinimum()) / this.slider.getMaximum()) - n * this.trackRect.height / (this.slider.getMaximum() - this.slider.getMinimum()));
            }
        } else if (this.slider.getOrientation() == 0 && this.trackRect.width > ticksAt.length * 8) {
            for (int n : ticksAt) {
                g2d.drawLine(this.trackRect.x + this.trackRect.width - this.trackRect.width / ((this.slider.getMaximum() - this.slider.getMinimum()) / this.slider.getMaximum()) + n * this.trackRect.width / (this.slider.getMaximum() - this.slider.getMinimum()), this.trackRect.y, this.trackRect.x + this.trackRect.width - this.trackRect.width / ((this.slider.getMaximum() - this.slider.getMinimum()) / this.slider.getMaximum()) + n * this.trackRect.width / (this.slider.getMaximum() - this.slider.getMinimum()), this.trackRect.y + this.trackRect.height);
            }
        }
        if (this.slider.isEnabled()) {
            g2d.setPaint(TRACK_COLOR_FRONT);
        } else {
            g2d.setPaint(TRACK_COLOR_FRONT_DISABLED);
        }
        if (this.slider.getOrientation() == 0) {
            if (this.slider.getMinimum() < 0 && this.slider.getMaximum() > 0) {
                double doublerel0Pos = Math.abs((double)this.slider.getMinimum()) / ((double)this.slider.getMaximum() - (double)this.slider.getMinimum());
                double x0 = (double)this.trackRect.x + (double)this.trackRect.width * doublerel0Pos;
                double widthRect = (double)this.thumbRect.x + (double)this.thumbRect.width / 2.0 - x0;
                if (widthRect > 0.0) {
                    g2d.fillRect((int)Math.round(x0), this.trackRect.y, (int)Math.round(widthRect), this.trackRect.height);
                } else {
                    g2d.fillRect((int)Math.round(x0 + widthRect), this.trackRect.y, (int)Math.round(-widthRect), this.trackRect.height);
                }
            } else {
                g2d.fillRect(this.trackRect.x, this.trackRect.y, this.thumbRect.x - this.thumbRect.width / 2, this.trackRect.height);
            }
        } else if (this.slider.getMinimum() < 0 && this.slider.getMaximum() > 0) {
            double doublerel0Pos = Math.abs((double)this.slider.getMaximum()) / ((double)this.slider.getMaximum() - (double)this.slider.getMinimum());
            double y0 = (double)this.trackRect.y + (double)this.trackRect.height * doublerel0Pos;
            double heightRect = (double)this.thumbRect.y + (double)this.thumbRect.height / 2.0 - y0;
            if (heightRect > 0.0) {
                g2d.fillRect(this.trackRect.x, (int)Math.round(y0), this.trackRect.width, (int)Math.round(heightRect));
            } else {
                g2d.fillRect(this.trackRect.x, (int)Math.round(y0 + heightRect), this.trackRect.width, (int)Math.round(-heightRect));
            }
        } else {
            g2d.fillRect(this.trackRect.x, this.thumbRect.y + this.thumbRect.height / 2, this.trackRect.width, this.trackRect.height - (this.thumbRect.y - this.trackRect.y + this.thumbRect.height / 2));
        }
        g2d.setPaint(oldPaint);
    }

    @Override
    public void paintThumb(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        int x1 = this.thumbRect.x + 3;
        int x2 = this.thumbRect.x + this.thumbRect.width - 5;
        int y1 = this.thumbRect.y + 1;
        int y2 = this.thumbRect.y + this.thumbRect.height - 2;
        if (this.slider.getOrientation() == 0) {
            x1 = this.thumbRect.x + 1;
            x2 = this.thumbRect.x + this.thumbRect.width - 2;
            y1 = this.thumbRect.y + 3;
            y2 = this.thumbRect.y + this.thumbRect.height - 5;
        }
        GeneralPath shape = new GeneralPath(0);
        shape.moveTo(x1, y1);
        shape.lineTo(x2, y1);
        shape.lineTo(x2, y2);
        shape.lineTo(x1, y2);
        shape.closePath();
        if (this.slider.isEnabled()) {
            if (this.slider.getValue() == 0) {
                g2d.setPaint(THUMB_INNER_COLOR_STOP);
            } else {
                g2d.setPaint(new Color(THUMB_INNER_COLOR_RUN.getRed() - Math.abs(this.slider.getValue()) * 100 / this.slider.getMaximum(), THUMB_INNER_COLOR_RUN.getGreen(), THUMB_INNER_COLOR_RUN.getBlue() - Math.abs(this.slider.getValue() * 100 / this.slider.getMaximum())));
            }
        } else {
            g2d.setPaint(THUMB_INNER_COLOR_DISABLED);
        }
        g2d.fill(shape);
        Stroke old = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setPaint(THUMB_CONTOUR_COLOR);
        g2d.draw(shape);
        g2d.setStroke(old);
        g2d.setPaint(oldPaint);
    }
}

