/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ControlPanel;

public class ControlPanelPropertyEditor
extends JDialog {
    private final ControlPanel control;
    private JRadioButton displaySlider;
    private JRadioButton displaySliderContinuous;
    private JRadioButton displaySteps;
    private JCheckBox trackBox;
    private JCheckBox speedStepBoxVisibleBox;
    private JTextField functionSwitchSlider;
    private int _displaySlider;

    public ControlPanelPropertyEditor(ControlPanel panel) {
        this.control = panel;
        this.initGUI();
        this.resetProperties();
    }

    private void initGUI() {
        Insets insets;
        this.setDefaultCloseOperation(1);
        this.setTitle(Bundle.getMessage("TitleEditSpeedControlPanel"));
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setLayout(new BorderLayout());
        JPanel propertyPanel = new JPanel();
        propertyPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.insets = insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        ButtonGroup modeSelectionButtons = new ButtonGroup();
        this.displaySlider = new JRadioButton(Bundle.getMessage("ButtonDisplaySpeedSlider"));
        this.displaySliderContinuous = new JRadioButton(Bundle.getMessage("ButtonDisplaySpeedSliderContinuous"));
        this.displaySteps = new JRadioButton(Bundle.getMessage("ButtonDisplaySpeedSteps"));
        modeSelectionButtons.add(this.displaySlider);
        modeSelectionButtons.add(this.displaySteps);
        modeSelectionButtons.add(this.displaySliderContinuous);
        constraints.anchor = 10;
        constraints.gridy = 1;
        propertyPanel.add((Component)this.displaySlider, constraints);
        constraints.gridy = 2;
        propertyPanel.add((Component)this.displaySteps, constraints);
        constraints.gridy = 3;
        propertyPanel.add((Component)this.displaySliderContinuous, constraints);
        this.trackBox = new JCheckBox(Bundle.getMessage("CheckBoxTrackSliderInRealTime"));
        constraints.gridy = 4;
        propertyPanel.add((Component)this.trackBox, constraints);
        this.speedStepBoxVisibleBox = new JCheckBox(Bundle.getMessage("CheckBoxHideSpeedStepSelector"));
        constraints.gridy = 5;
        propertyPanel.add((Component)this.speedStepBoxVisibleBox, constraints);
        JLabel functionSwitchLabel = new JLabel(Bundle.getMessage("SwitchSliderOnFunction"));
        this.functionSwitchSlider = new JTextField(4);
        constraints.gridy = 6;
        constraints.gridx = 0;
        propertyPanel.add((Component)functionSwitchLabel, constraints);
        constraints.gridx = 1;
        propertyPanel.add((Component)this.functionSwitchSlider, constraints);
        this.displaySlider.addActionListener(e -> {
            this.displaySlider.setSelected(true);
            this.displaySteps.setSelected(false);
            this.displaySliderContinuous.setSelected(false);
            this._displaySlider = 0;
        });
        this.displaySteps.addActionListener(e -> {
            this.displaySlider.setSelected(false);
            this.displaySteps.setSelected(true);
            this.displaySliderContinuous.setSelected(false);
            this._displaySlider = 1;
        });
        this.displaySliderContinuous.addActionListener(e -> {
            this.displaySlider.setSelected(false);
            this.displaySteps.setSelected(false);
            this.displaySliderContinuous.setSelected(true);
            this._displaySlider = 2;
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 4, 4));
        JButton applyButton = new JButton(Bundle.getMessage("ButtonApply"));
        applyButton.addActionListener(e -> this.saveProperties());
        JButton resetButton = new JButton(Bundle.getMessage("ButtonReset"));
        resetButton.addActionListener(e -> this.resetProperties());
        JButton closeButton = new JButton(Bundle.getMessage("ButtonClose"));
        closeButton.addActionListener(e -> this.finishEdit());
        buttonPanel.add(resetButton);
        buttonPanel.add(closeButton);
        buttonPanel.add(applyButton);
        mainPanel.add((Component)propertyPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.pack();
    }

    private void saveProperties() {
        if (this.isDataValid()) {
            this.control.setTrackSlider(this.trackBox.isSelected());
            this.control.setSwitchSliderFunction(this.functionSwitchSlider.getText());
            this.control.setSpeedController(this._displaySlider);
            this.control.setHideSpeedStep(this.speedStepBoxVisibleBox.isSelected());
        }
    }

    private void finishEdit() {
        this.setVisible(false);
    }

    public void resetProperties() {
        this._displaySlider = this.control.getDisplaySlider();
        this.displaySlider.setSelected(this._displaySlider == 0);
        this.displaySteps.setSelected(this._displaySlider == 1);
        this.displaySliderContinuous.setSelected(this._displaySlider == 2);
        this.displaySlider.setEnabled(this.control.isSpeedControllerAvailable(0));
        this.displaySteps.setEnabled(this.control.isSpeedControllerAvailable(1));
        this.displaySliderContinuous.setEnabled(this.control.isSpeedControllerAvailable(2));
        this.trackBox.setSelected(this.control.getTrackSlider());
        this.speedStepBoxVisibleBox.setSelected(this.control.getHideSpeedStep());
        this.functionSwitchSlider.setText(this.control.getSwitchSliderFunction());
    }

    private boolean isDataValid() {
        return true;
    }
}

