/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.Throttle;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.FunctionButton;
import jmri.util.FileUtil;
import jmri.util.swing.EditableResizableImagePanel;
import jmri.util.swing.JmriJOptionPane;

public final class FunctionButtonPropertyEditor
extends JDialog {
    private final FunctionButton button;
    private JTextField textField;
    private JCheckBox lockableCheckBox;
    private JTextField idField;
    private JTextField fontField;
    private JCheckBox visibleCheckBox;
    private EditableResizableImagePanel _imageFilePath;
    private EditableResizableImagePanel _imagePressedFilePath;
    private JTextField imageSize;
    static final int BUT_IMG_SIZE = 45;

    public FunctionButtonPropertyEditor(FunctionButton btn) {
        this.button = btn;
        this.initGUI();
        this.resetProperties();
    }

    private void initGUI() {
        Insets insets;
        this.setDefaultCloseOperation(1);
        this.setTitle(Bundle.getMessage("ButtonEditFunction"));
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setLayout(new BorderLayout());
        JPanel propertyPanel = new JPanel();
        propertyPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.insets = insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.idField = new JTextField();
        this.idField.setColumns(1);
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("LabelFunctionNumber")), constraints);
        constraints.anchor = 10;
        constraints.gridx = 1;
        propertyPanel.add((Component)this.idField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.textField = new JTextField();
        this.textField.setColumns(10);
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("LabelText")), constraints);
        constraints.anchor = 10;
        constraints.gridx = 1;
        propertyPanel.add((Component)this.textField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.fontField = new JTextField();
        this.fontField.setColumns(10);
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("LabelFontSize")), constraints);
        constraints.anchor = 10;
        constraints.gridx = 1;
        propertyPanel.add((Component)this.fontField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.imageSize = new JTextField();
        this.imageSize.setColumns(10);
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("LabelFunctionImageSize")), constraints);
        constraints.anchor = 10;
        constraints.gridx = 1;
        propertyPanel.add((Component)this.imageSize, constraints);
        this.lockableCheckBox = new JCheckBox(Bundle.getMessage("CheckBoxLockable"));
        constraints.anchor = 10;
        constraints.gridx = 0;
        ++constraints.gridy;
        propertyPanel.add((Component)this.lockableCheckBox, constraints);
        this.visibleCheckBox = new JCheckBox(Bundle.getMessage("CheckBoxVisible"));
        constraints.anchor = 10;
        constraints.gridx = 0;
        ++constraints.gridy;
        propertyPanel.add((Component)this.visibleCheckBox, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("OffIcon")), constraints);
        constraints.gridx = 1;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("OnIcon")), constraints);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weighty = 100.0;
        constraints.gridx = 0;
        this._imageFilePath = new EditableResizableImagePanel("", 45, 45);
        this._imageFilePath.setDropFolder(FileUtil.getUserResourcePath());
        this._imageFilePath.setBackground(new Color(0, 0, 0, 0));
        this._imageFilePath.setBorder(BorderFactory.createLineBorder(Color.blue));
        this._imageFilePath.addMenuItemBrowseFolder(Bundle.getMessage("OpenSystemFileBrowserOnJMRIfnButtonsRessources"), FileUtil.getExternalFilename("resources/icons/functionicons"));
        this._imageFilePath.addComponentListener(this._imageFilePath);
        propertyPanel.add((Component)this._imageFilePath, constraints);
        constraints.gridx = 1;
        this._imagePressedFilePath = new EditableResizableImagePanel("", 45, 45);
        this._imagePressedFilePath.setDropFolder(FileUtil.getUserResourcePath());
        this._imagePressedFilePath.setBackground(new Color(0, 0, 0, 0));
        this._imagePressedFilePath.setBorder(BorderFactory.createLineBorder(Color.blue));
        this._imagePressedFilePath.addMenuItemBrowseFolder(Bundle.getMessage("OpenSystemFileBrowserOnJMRIfnButtonsRessources"), FileUtil.getExternalFilename("resources/icons/functionicons"));
        this._imagePressedFilePath.addComponentListener(this._imagePressedFilePath);
        propertyPanel.add((Component)this._imagePressedFilePath, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 4, 4));
        JButton applyButton = new JButton(Bundle.getMessage("ButtonApply"));
        applyButton.addActionListener(e -> this.saveProperties());
        JButton resetButton = new JButton(Bundle.getMessage("ButtonReset"));
        resetButton.addActionListener(e -> this.resetProperties());
        JButton closeButton = new JButton(Bundle.getMessage("ButtonClose"));
        closeButton.addActionListener(e -> this.finishEdit());
        buttonPanel.add(resetButton);
        buttonPanel.add(closeButton);
        buttonPanel.add(applyButton);
        mainPanel.add((Component)propertyPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.pack();
    }

    public void resetProperties() {
        this.textField.setText(this.button.getButtonLabel());
        this.lockableCheckBox.setSelected(this.button.getIsLockable());
        this.idField.setText(String.valueOf(this.button.getIdentity()));
        Throttle mThrottle = this.button.getThrottle();
        if (mThrottle != null) {
            this.idField.setToolTipText(Bundle.getMessage("MaxFunction", mThrottle.getFunctions().length - 1));
        }
        this.fontField.setText(String.valueOf(this.button.getFont().getSize()));
        this.imageSize.setText(String.valueOf(this.button.getButtonImageSize()));
        this.visibleCheckBox.setSelected(this.button.getDisplay());
        this._imageFilePath.setImagePath(this.button.getIconPath());
        this._imagePressedFilePath.setImagePath(this.button.getSelectedIconPath());
        this.textField.requestFocus();
    }

    private void saveProperties() {
        if (this.isDataValid()) {
            this.button.setButtonLabel(this.textField.getText());
            this.button.setIsLockable(this.lockableCheckBox.isSelected());
            this.button.setIdentity(Integer.parseInt(this.idField.getText()));
            String name = this.button.getFont().getName();
            this.button.setFont(new Font(name, this.button.getFont().getStyle(), Integer.parseInt(this.fontField.getText())));
            this.button.setButtonImageSize(Integer.parseInt(this.imageSize.getText()));
            this.button.setDisplay(this.visibleCheckBox.isSelected());
            this.button.setIconPath(this._imageFilePath.getImagePath());
            this.button.setSelectedIconPath(this._imagePressedFilePath.getImagePath());
            this.button.setDirty(true);
            this.button.updateLnF();
        }
    }

    private void finishEdit() {
        this.setVisible(false);
    }

    private boolean isDataValid() {
        StringBuffer errors = new StringBuffer();
        int errorNumber = 0;
        Throttle mThrottle = this.button.getThrottle();
        if (mThrottle == null) {
            return false;
        }
        try {
            int id = Integer.parseInt(this.idField.getText());
            if (id < 0 || id >= mThrottle.getFunctions().length) {
                throw new NumberFormatException("");
            }
        }
        catch (NumberFormatException ex) {
            errors.append(String.valueOf(++errorNumber)).append(". ");
            errors.append(Bundle.getMessage("ErrorFunctionKeyRange", mThrottle.getFunctions().length - 1)).append("\n");
        }
        try {
            int size = Integer.parseInt(this.fontField.getText());
            if (size < 1) {
                throw new NumberFormatException("");
            }
        }
        catch (NumberFormatException ex) {
            errors.append(String.valueOf(++errorNumber)).append(". ");
            errors.append(Bundle.getMessage("ErrorFontSize"));
        }
        try {
            int size = Integer.parseInt(this.imageSize.getText());
            if (size < 1) {
                throw new NumberFormatException("");
            }
        }
        catch (NumberFormatException ex) {
            errors.append(String.valueOf(++errorNumber)).append(". ");
            errors.append(Bundle.getMessage("ErrorImageSize"));
        }
        if (errorNumber > 0) {
            JmriJOptionPane.showMessageDialog(this, errors, Bundle.getMessage("ErrorOnPage"), 0);
            return false;
        }
        return true;
    }

    void setDropFolder(String dropFolder) {
        this._imageFilePath.setDropFolder(dropFolder);
        this._imagePressedFilePath.setDropFolder(dropFolder);
    }

    void destroy() {
        if (this._imageFilePath != null) {
            this._imageFilePath.removeDnd();
        }
        if (this._imagePressedFilePath != null) {
            this._imagePressedFilePath.removeDnd();
        }
    }
}

