/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import jmri.InstanceManager;
import jmri.ThrottleManager;
import jmri.jmrit.throttle.LoadXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadDefaultXmlThrottlesLayoutAction
extends JmriAbstractAction {
    private static final Logger log = LoggerFactory.getLogger(LoadDefaultXmlThrottlesLayoutAction.class);

    public LoadDefaultXmlThrottlesLayoutAction(String s, WindowInterface wi) {
        super(s, wi);
        if (InstanceManager.getNullableDefault(ThrottleManager.class) == null) {
            this.setEnabled(false);
        }
    }

    public LoadDefaultXmlThrottlesLayoutAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
        if (InstanceManager.getNullableDefault(ThrottleManager.class) == null) {
            this.setEnabled(false);
        }
    }

    public LoadDefaultXmlThrottlesLayoutAction(String s) {
        super(s);
        if (InstanceManager.getNullableDefault(ThrottleManager.class) == null) {
            this.setEnabled(false);
        }
    }

    public LoadDefaultXmlThrottlesLayoutAction() {
        this("Load default throttle layout...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LoadXmlThrottlesLayoutAction lxta = new LoadXmlThrottlesLayoutAction();
        try {
            if (lxta.loadThrottlesLayout(new File(ThrottleFrame.getDefaultThrottleFilename()))) {
                return;
            }
        }
        catch (IOException ex) {
            log.error("No default throttle layout, creating an empty throttle window");
        }
        ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
        tf.toFront();
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

