/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.ThrottleManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadXmlThrottlesLayoutAction
extends AbstractAction {
    JFileChooser fileChooser;
    private static final Logger log = LoggerFactory.getLogger(LoadXmlThrottlesLayoutAction.class);

    public LoadXmlThrottlesLayoutAction(String s) {
        super(s);
        if (InstanceManager.getNullableDefault(ThrottleManager.class) == null) {
            this.setEnabled(false);
        }
    }

    public LoadXmlThrottlesLayoutAction() {
        this("Open Throttle");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int retVal;
        if (this.fileChooser == null) {
            this.fileChooser = XmlFile.userFileChooser(Bundle.getMessage("PromptXmlFileTypes"), "xml");
            this.fileChooser.setDialogType(0);
            this.fileChooser.setCurrentDirectory(new File(ThrottleFrame.getDefaultThrottleFolder()));
        }
        if ((retVal = this.fileChooser.showOpenDialog(null)) != 0) {
            return;
        }
        if (InstanceManager.getDefault(ThrottleFrameManager.class).getThrottleWindows().hasNext()) {
            Object[] possibleValues = new Object[]{Bundle.getMessage("LabelMerge"), Bundle.getMessage("LabelReplace"), Bundle.getMessage("ButtonCancel")};
            int selectedValue = JmriJOptionPane.showOptionDialog(null, Bundle.getMessage("DialogMergeOrReplace"), Bundle.getMessage("OptionLoadingThrottles"), -1, 1, null, possibleValues, possibleValues[0]);
            if (selectedValue == 2 || selectedValue == -1) {
                return;
            }
            if (selectedValue == 1) {
                InstanceManager.getDefault(ThrottleFrameManager.class).requestAllThrottleWindowsDestroyed();
            }
        }
        try {
            this.loadThrottlesLayout(this.fileChooser.getSelectedFile());
        }
        catch (IOException e1) {
            log.warn("Exception while reading file", (Throwable)e1);
        }
    }

    public boolean loadThrottlesLayout(File f) throws IOException {
        try {
            ThrottlePrefs prefs = new ThrottlePrefs();
            prefs.setValidate(XmlFile.Validate.CheckDtdThenSchema);
            Element root = prefs.rootFromFile(f);
            List throttles = root.getChildren("ThrottleFrame");
            ThrottleFrameManager tfManager = InstanceManager.getDefault(ThrottleFrameManager.class);
            if (throttles != null && throttles.size() > 0) {
                for (Element e : throttles) {
                    SwingUtilities.invokeLater(() -> {
                        ThrottleFrame tf = tfManager.createThrottleFrame();
                        tf.setXml(e);
                        tf.toFront();
                    });
                }
            } else {
                throttles = root.getChildren("ThrottleWindow");
                for (Element e : throttles) {
                    SwingUtilities.invokeLater(() -> tfManager.createThrottleWindow(e).setVisible(true));
                }
                Element tlp = root.getChild("ThrottlesListPanel");
                if (tlp != null) {
                    InstanceManager.getDefault(ThrottleFrameManager.class).getThrottlesListPanel().setXml(tlp);
                }
            }
        }
        catch (JDOMException ex) {
            log.warn("Loading Throttles exception", (Throwable)ex);
            ConfigXmlManager.creationErrorEncountered(null, "parsing file " + f.getName(), "Parse error", null, null, ex);
            return false;
        }
        return true;
    }

    static class ThrottlePrefs
    extends XmlFile {
        ThrottlePrefs() {
        }
    }
}

