/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.throttle.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PowerManagerButton
extends JButton
implements PropertyChangeListener {
    private final PropertyChangeListener listener;
    private Boolean fullText = true;
    private NamedIcon powerUnknownIcon;
    private NamedIcon powerOffIcon;
    private NamedIcon powerOnIcon;
    private static final Logger log = LoggerFactory.getLogger(PowerManagerButton.class);

    public PowerManagerButton() {
        this(true);
    }

    public PowerManagerButton(Boolean fullText) {
        this.fullText = fullText;
        this.listener = evt -> this.setPowerIcons();
        PowerManager powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
        if (powerMgr == null) {
            log.info("No power manager instance found, panel not active");
        } else {
            powerMgr.addPropertyChangeListener(this.listener);
        }
        super.addActionListener(e -> this.setPower());
        this.initComponentsImpl();
    }

    public void dispose() {
        PowerManager powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
        if (powerMgr != null) {
            powerMgr.removePropertyChangeListener(this.listener);
        }
    }

    private void initComponentsImpl() {
        this.initComponents();
        this.loadIcons();
        this.setPowerIcons();
    }

    protected void initComponents() {
    }

    abstract void loadIcons();

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setPowerIcons();
    }

    protected void setPowerIcons() {
        PowerManager powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
        if (powerMgr == null) {
            return;
        }
        switch (powerMgr.getPower()) {
            case 2: {
                this.setIcon(this.getPowerOnIcon());
                this.setToolTipText(Bundle.getMessage("LayoutPowerOn"));
                if (!this.getFullText().booleanValue()) break;
                this.setText(Bundle.getMessage("PowerStateOn"));
                break;
            }
            case 4: {
                this.setIcon(this.getPowerOffIcon());
                this.setToolTipText(Bundle.getMessage("LayoutPowerOff"));
                if (!this.getFullText().booleanValue()) break;
                this.setText(Bundle.getMessage("PowerStateOff"));
                break;
            }
            case 1: {
                this.setIcon(this.getPowerUnknownIcon());
                this.setToolTipText(Bundle.getMessage("LayoutPowerUnknown"));
                if (!this.getFullText().booleanValue()) break;
                this.setText(Bundle.getMessage("PowerStateUnknown"));
                break;
            }
            default: {
                this.setIcon(this.getPowerUnknownIcon());
                this.setToolTipText(Bundle.getMessage("LayoutPowerUnknown"));
                log.error("Unexpected state value: {}", (Object)powerMgr.getPower());
                if (!this.getFullText().booleanValue()) break;
                this.setText(Bundle.getMessage("PowerStateUnknown"));
            }
        }
    }

    private void setPower() {
        block7: {
            PowerManager powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
            if (powerMgr != null) {
                try {
                    switch (powerMgr.getPower()) {
                        case 2: {
                            powerMgr.setPower(4);
                            break;
                        }
                        case 4: {
                            powerMgr.setPower(2);
                            break;
                        }
                        default: {
                            powerMgr.setPower(4);
                            break;
                        }
                    }
                }
                catch (JmriException ex) {
                    this.setIcon(this.getPowerUnknownIcon());
                    this.setToolTipText(Bundle.getMessage("LayoutPowerUnknown"));
                    if (!this.getFullText().booleanValue()) break block7;
                    this.setText(Bundle.getMessage("PowerStateUnknown"));
                }
            }
        }
    }

    public NamedIcon getPowerUnknownIcon() {
        return this.powerUnknownIcon;
    }

    public void setPowerUnknownIcon(NamedIcon powerUnknownIcon) {
        this.powerUnknownIcon = powerUnknownIcon;
        this.setPowerIcons();
    }

    public NamedIcon getPowerOffIcon() {
        return this.powerOffIcon;
    }

    public void setPowerOffIcon(NamedIcon powerOffIcon) {
        this.powerOffIcon = powerOffIcon;
        this.setPowerIcons();
    }

    public NamedIcon getPowerOnIcon() {
        return this.powerOnIcon;
    }

    public void setPowerOnIcon(NamedIcon powerOnIcon) {
        this.powerOnIcon = powerOnIcon;
        this.setPowerIcons();
    }

    protected Boolean getFullText() {
        return this.fullText;
    }

    protected void setFullText(Boolean fullText) {
        this.fullText = fullText;
        this.setPowerIcons();
    }
}

