/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.throttle.AddressListener;
import jmri.jmrit.throttle.AddressPanel;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.WindowPreferences;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedPanel
extends JInternalFrame
implements PropertyChangeListener,
AddressListener {
    private DccThrottle throttle;
    private JPanel mainPanel;
    private JPanel speedDisplayPanel;
    private JLabel scaleSpeedLabel = new JLabel("", 0);
    private boolean useSpeedProfile = false;
    private boolean currentIsForward = true;
    private float currentThrottleVol = 0.0f;
    private AddressPanel addressPanel;
    private static final Logger log = LoggerFactory.getLogger(SpeedPanel.class);

    public SpeedPanel() {
        this.initGUI();
    }

    public void setAddressPanel(AddressPanel addressPanel) {
        this.addressPanel = addressPanel;
    }

    public void destroy() {
        if (this.addressPanel != null) {
            this.addressPanel.removeAddressListener(this);
            this.addressPanel = null;
        }
        if (this.throttle != null) {
            this.throttle.removePropertyChangeListener(this);
            this.throttle = null;
        }
    }

    private void initGUI() {
        this.mainPanel = new JPanel();
        this.setContentPane(this.mainPanel);
        this.mainPanel.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.speedDisplayPanel = new JPanel();
        this.speedDisplayPanel.setFont(new Font("", 0, 32));
        this.speedDisplayPanel.setLayout(new BoxLayout(this.speedDisplayPanel, 0));
        this.speedDisplayPanel.setOpaque(false);
        this.mainPanel.add((Component)this.speedDisplayPanel, "Center");
        this.speedDisplayPanel.add(this.scaleSpeedLabel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("SpeedSetting")) {
            this.currentThrottleVol = ((Float)e.getNewValue()).floatValue();
            this.scaleSpeedLabel.setText(this.updateSpeedLabel(this.useSpeedProfile, this.currentThrottleVol, this.currentIsForward));
        } else if (e.getPropertyName().equals("IsForward")) {
            this.currentIsForward = (Boolean)e.getNewValue();
            this.scaleSpeedLabel.setText(this.updateSpeedLabel(this.useSpeedProfile, this.currentThrottleVol, this.currentIsForward));
        }
        if (log.isDebugEnabled()) {
            log.debug("Property change event received {} / {}", (Object)e.getPropertyName(), e.getNewValue());
        }
    }

    private String updateSpeedLabel(boolean useSpeedProfile, float throttleVolume, boolean isForward) {
        RosterEntry re = this.addressPanel.getRosterEntry();
        if (re != null && useSpeedProfile) {
            return re.getSpeedProfile().convertThrottleSettingToScaleSpeedWithUnits(throttleVolume, isForward);
        }
        return Bundle.getMessage("ThrottleSpeedPanelError");
    }

    @Override
    public void notifyAddressChosen(LocoAddress l) {
    }

    @Override
    public void notifyAddressReleased(LocoAddress la) {
        if (this.throttle == null) {
            log.debug("notifyAddressReleased() throttle alreaday null, called for loc {}", (Object)la);
            return;
        }
        this.setEnabled(false);
        this.throttle.removePropertyChangeListener(this);
        this.throttle = null;
    }

    @Override
    public void notifyAddressThrottleFound(DccThrottle t) {
        if (this.throttle != null) {
            log.debug("notifyAddressThrottleFound() throttle non null, called for loc {}", (Object)t.getLocoAddress());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("control panel received new throttle {}", (Object)t);
        }
        this.throttle = t;
        this.throttle.addPropertyChangeListener(this);
        if (log.isDebugEnabled()) {
            DccLocoAddress Address2 = (DccLocoAddress)this.throttle.getLocoAddress();
            log.debug("new address is {}", (Object)Address2.toString());
        }
        this.useSpeedProfile = false;
        RosterEntry re = this.addressPanel.getRosterEntry();
        if (re != null && re.getSpeedProfile() != null && re.getSpeedProfile().getProfileSize() > 0) {
            this.useSpeedProfile = true;
        }
    }

    @Override
    public void notifyConsistAddressChosen(LocoAddress l) {
        this.notifyAddressChosen(l);
    }

    @Override
    public void notifyConsistAddressReleased(LocoAddress l) {
        this.notifyAddressReleased(l);
    }

    @Override
    public void notifyConsistAddressThrottleFound(DccThrottle throttle) {
        if (log.isDebugEnabled()) {
            log.debug("control panel received consist throttle");
        }
        this.notifyAddressThrottleFound(throttle);
    }

    public Element getXml() {
        Element me = new Element("SpeedPanel");
        ArrayList<Element> children = new ArrayList<Element>(1);
        children.add(WindowPreferences.getPreferences(this));
        me.setContent(children);
        return me;
    }

    public void setXml(Element e) {
        Element window = e.getChild("window");
        WindowPreferences.setPreferences(this, window);
    }
}

