/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import jmri.InstanceManager;
import jmri.ThrottleManager;
import jmri.configurexml.StoreXmlConfigAction;
import jmri.jmrit.XmlFile;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.throttle.ThrottleWindow;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreXmlThrottlesLayoutAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(StoreXmlThrottlesLayoutAction.class);

    public StoreXmlThrottlesLayoutAction(String s) {
        super(s);
        if (InstanceManager.getNullableDefault(ThrottleManager.class) == null) {
            this.setEnabled(false);
        }
    }

    public StoreXmlThrottlesLayoutAction() {
        this("Save default throttle layout...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = XmlFile.userFileChooser(Bundle.getMessage("PromptXmlFileTypes"), "xml");
        fileChooser.setDialogType(1);
        fileChooser.setCurrentDirectory(new File(ThrottleFrame.getDefaultThrottleFolder()));
        File file = StoreXmlConfigAction.getFileName(fileChooser);
        if (file == null) {
            return;
        }
        this.saveThrottlesLayout(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveThrottlesLayout(File f) {
        try {
            Element root = new Element("throttle-layout-config");
            root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/throttle-layout-config.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
            Document doc = new Document(root);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", "text/xsl");
            m.put("href", "/xml/XSLT/throttle-layout-config.xsl");
            ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
            doc.addContent(0, (Content)p);
            ArrayList<Element> children = new ArrayList<Element>(5);
            children.add(InstanceManager.getDefault(ThrottleFrameManager.class).getThrottlesListPanel().getXml());
            Iterator<ThrottleWindow> i = InstanceManager.getDefault(ThrottleFrameManager.class).getThrottleWindows();
            while (i.hasNext()) {
                ThrottleWindow tw = i.next();
                Element throttleElement = tw.getXml();
                children.add(throttleElement);
            }
            root.setContent(children);
            try (FileOutputStream o = new FileOutputStream(f);){
                XMLOutputter fmt = new XMLOutputter();
                fmt.setFormat(Format.getPrettyFormat().setLineSeparator(System.getProperty("line.separator")).setTextMode(Format.TextMode.TRIM_FULL_WHITE));
                fmt.output(doc, (OutputStream)o);
            }
        }
        catch (FileNotFoundException ex) {
            log.warn("Exception in storing throttle xml", (Throwable)ex);
        }
        catch (IOException ex) {
            log.warn("Exception in storing throttle xml", (Throwable)ex);
        }
    }
}

