/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.event.ActionEvent;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.JMenu;
import jmri.InstanceManager;
import jmri.ThrottleManager;
import jmri.beans.BeanUtil;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;

public class ThrottleCreationAction
extends JmriAbstractAction {
    private final ConnectionConfig connectionConfig;

    public ThrottleCreationAction(String s, WindowInterface wi) {
        super(s, wi);
        this.connectionConfig = null;
        if (InstanceManager.getNullableDefault(ThrottleManager.class) == null) {
            this.setEnabled(false);
        }
    }

    public ThrottleCreationAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
        this.connectionConfig = null;
        if (InstanceManager.getNullableDefault(ThrottleManager.class) == null) {
            this.setEnabled(false);
        }
    }

    public ThrottleCreationAction(String s) {
        super(s);
        this.connectionConfig = null;
        if (InstanceManager.getNullableDefault(ThrottleManager.class) == null) {
            this.setEnabled(false);
        }
    }

    public ThrottleCreationAction(String s, ConnectionConfig connectionConfig) {
        super(s);
        this.connectionConfig = connectionConfig;
        if (connectionConfig == null || !connectionConfig.getAdapter().getSystemConnectionMemo().provides(ThrottleManager.class)) {
            super.setEnabled(false);
        }
    }

    public ThrottleCreationAction() {
        this(Bundle.getMessage("MenuItemNewThrottle"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String group = null;
        if (BeanUtil.hasProperty(this.wi, "selectedRosterGroup")) {
            group = (String)BeanUtil.getProperty(this.wi, "selectedRosterGroup");
        }
        ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame(this.connectionConfig);
        tf.getAddressPanel().getRosterEntrySelector().setSelectedRosterGroup(group);
        tf.toFront();
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }

    public static void addNewThrottleItemsToThrottleMenu(@Nonnull JMenu throttleMenu) {
        throttleMenu.add(new ThrottleCreationAction(Bundle.getMessage("MenuItemNewThrottle")));
        ConnectionConfigManager ccm = InstanceManager.getNullableDefault(ConnectionConfigManager.class);
        if (ccm == null) {
            return;
        }
        int numConnectionsWithThrottleManager = 0;
        for (ConnectionConfig c : ccm) {
            ThrottleManager connectionThrottleManager;
            if (!c.getAdapter().getSystemConnectionMemo().provides(ThrottleManager.class) || (connectionThrottleManager = c.getAdapter().getSystemConnectionMemo().get(ThrottleManager.class)) == null) continue;
            ++numConnectionsWithThrottleManager;
        }
        if (numConnectionsWithThrottleManager > 1) {
            JMenu throttleConnectionMenu = new JMenu(Bundle.getMessage("MenuThrottlesForConnections"));
            ThrottleManager defaultThrottleManager = InstanceManager.getDefault(ThrottleManager.class);
            for (ConnectionConfig c : InstanceManager.getDefault(ConnectionConfigManager.class)) {
                ThrottleManager connectionThrottleManager = c.getAdapter().getSystemConnectionMemo().get(ThrottleManager.class);
                if (connectionThrottleManager == null) continue;
                if (connectionThrottleManager == defaultThrottleManager) {
                    throttleConnectionMenu.add(new ThrottleCreationAction(Bundle.getMessage("MenuItemNewThrottleWithConnectionDefault", c.getConnectionName()), c));
                    continue;
                }
                throttleConnectionMenu.add(new ThrottleCreationAction(Bundle.getMessage("MenuItemNewThrottleWithConnection", c.getConnectionName()), c));
            }
            throttleMenu.add(throttleConnectionMenu);
        }
    }
}

