/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.util.ArrayList;
import java.util.Iterator;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleWindow;
import jmri.jmrit.throttle.ThrottlesListPanel;
import jmri.jmrit.throttle.ThrottlesPreferencesWindow;
import jmri.jmrix.ConnectionConfig;
import jmri.util.JmriJFrame;
import org.jdom2.Element;

public class ThrottleFrameManager
implements InstanceManagerAutoDefault {
    private int activeFrame;
    private ArrayList<ThrottleWindow> throttleWindows = new ArrayList(0);
    private ThrottlesPreferencesWindow throttlePreferencesFrame;
    private JmriJFrame throttlesListFrame;
    private ThrottlesListPanel throttlesListPanel;

    public ThrottleFrameManager() {
        this.buildThrottleListFrame();
    }

    public ThrottleWindow createThrottleWindow() {
        return this.createThrottleWindow((ConnectionConfig)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThrottleWindow createThrottleWindow(ConnectionConfig connectionConfig) {
        ThrottleWindow tw = new ThrottleWindow(connectionConfig);
        tw.pack();
        ThrottleFrameManager throttleFrameManager = this;
        synchronized (throttleFrameManager) {
            this.throttleWindows.add(tw);
            this.activeFrame = this.throttleWindows.indexOf(tw);
        }
        return tw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThrottleWindow createThrottleWindow(Element e) {
        ThrottleWindow tw = ThrottleWindow.createThrottleWindow(e);
        tw.pack();
        ThrottleFrameManager throttleFrameManager = this;
        synchronized (throttleFrameManager) {
            this.throttleWindows.add(tw);
            this.activeFrame = this.throttleWindows.indexOf(tw);
        }
        return tw;
    }

    public ThrottleFrame createThrottleFrame() {
        return this.createThrottleFrame(null);
    }

    public ThrottleFrame createThrottleFrame(ConnectionConfig connectionConfig) {
        return this.createThrottleWindow(connectionConfig).getCurrentThrottleFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestThrottleWindowDestruction(ThrottleWindow frame) {
        if (frame != null) {
            this.destroyThrottleWindow(frame);
            ThrottleFrameManager throttleFrameManager = this;
            synchronized (throttleFrameManager) {
                this.throttleWindows.remove(frame);
                if (!this.throttleWindows.isEmpty()) {
                    this.requestFocusForNextThrottleWindow();
                }
            }
        }
    }

    public synchronized void requestAllThrottleWindowsDestroyed() {
        for (ThrottleWindow frame : this.throttleWindows) {
            this.destroyThrottleWindow(frame);
        }
        this.throttleWindows = new ArrayList(0);
    }

    private void destroyThrottleWindow(ThrottleWindow window) {
        window.dispose();
    }

    public synchronized Iterator<ThrottleWindow> getThrottleWindows() {
        return this.throttleWindows.iterator();
    }

    public synchronized int getNumberThrottleWindows() {
        return this.throttleWindows.size();
    }

    public synchronized void requestFocusForNextThrottleWindow() {
        this.activeFrame = (this.activeFrame + 1) % this.throttleWindows.size();
        ThrottleWindow tw = this.throttleWindows.get(this.activeFrame);
        tw.requestFocus();
        tw.toFront();
    }

    public synchronized void requestFocusForPreviousThrottleWindow() {
        --this.activeFrame;
        if (this.activeFrame < 0) {
            this.activeFrame = this.throttleWindows.size() - 1;
        }
        ThrottleWindow tw = this.throttleWindows.get(this.activeFrame);
        tw.requestFocus();
        tw.toFront();
    }

    public synchronized ThrottleWindow getCurrentThrottleFrame() {
        if (this.throttleWindows == null) {
            return null;
        }
        if (this.throttleWindows.isEmpty()) {
            return null;
        }
        return this.throttleWindows.get(this.activeFrame);
    }

    public ThrottlesListPanel getThrottlesListPanel() {
        return this.throttlesListPanel;
    }

    private void buildThrottleListFrame() {
        this.throttlesListFrame = new JmriJFrame(Bundle.getMessage("ThrottleListFrameTile"));
        this.throttlesListPanel = new ThrottlesListPanel();
        this.throttlesListFrame.setContentPane(this.throttlesListPanel);
        this.throttlesListFrame.pack();
    }

    public void showThrottlesList() {
        if (this.throttlesListFrame == null) {
            this.buildThrottleListFrame();
        }
        this.throttlesListFrame.setVisible(true);
    }

    public void showThrottlesPreferences() {
        if (this.throttlePreferencesFrame == null) {
            this.throttlePreferencesFrame = new ThrottlesPreferencesWindow(Bundle.getMessage("ThrottlePreferencesFrameTitle"));
            this.throttlePreferencesFrame.setDefaultCloseOperation(2);
            this.throttlePreferencesFrame.pack();
        } else {
            this.throttlePreferencesFrame.resetComponents();
            this.throttlePreferencesFrame.revalidate();
        }
        this.throttlePreferencesFrame.setVisible(true);
        this.throttlePreferencesFrame.requestFocus();
    }

    public void applyPreferences() {
        this.throttleWindows.forEach(frame -> frame.applyPreferences());
        this.throttlesListPanel.applyPreferences();
    }
}

