/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ThrottleWindow;
import jmri.util.swing.JmriJOptionPane;

public class ThrottleFramePropertyEditor
extends JDialog {
    private ThrottleWindow frame;
    private JTextField titleField;
    private JList<String> titleType;
    private String[] titleTextTypes = new String[]{"address", "text", "textAddress", "addressText", "rosterID"};
    private String[] titleTextTypeNames = new String[]{Bundle.getMessage("SelectTitleTypeADDRESS"), Bundle.getMessage("SelectTitleTypeTEXT"), Bundle.getMessage("SelectTitleTypeTEXTADDRESS"), Bundle.getMessage("SelectTitleTypeADDRESSTEXT"), Bundle.getMessage("SelectTitleTypeROSTERID")};

    public ThrottleFramePropertyEditor(ThrottleWindow w) {
        this.setThrottleFrame(w);
        this.setLocation(w.getLocationOnScreen());
        this.setLocationRelativeTo(w);
    }

    private void initGUI() {
        Insets insets;
        this.setDefaultCloseOperation(1);
        this.setTitle(Bundle.getMessage("EditThrottleFrameTitle"));
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setLayout(new BorderLayout());
        JPanel propertyPanel = new JPanel();
        propertyPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.insets = insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.titleField = new JTextField();
        this.titleField.setColumns(24);
        this.titleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleFramePropertyEditor.this.titleFieldChanged();
            }
        });
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("FrameTitlePrompt")), constraints);
        constraints.anchor = 10;
        ++constraints.gridx;
        propertyPanel.add((Component)this.titleField, constraints);
        this.titleType = new JList<String>(this.titleTextTypeNames);
        this.titleType.setVisibleRowCount(this.titleTextTypeNames.length);
        this.titleType.setSelectionMode(0);
        for (int i = 0; i < this.titleTextTypes.length; ++i) {
            if (this.titleTextTypes[i].compareTo(this.frame.getTitleTextType()) != 0) continue;
            this.titleType.setSelectedIndex(i);
            break;
        }
        ++constraints.gridy;
        constraints.gridx = 0;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("SelectTitleTypePrompt")), constraints);
        ++constraints.gridx;
        propertyPanel.add(this.titleType, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 4, 4));
        JButton saveButton = new JButton(Bundle.getMessage("ButtonOK"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleFramePropertyEditor.this.saveProperties();
            }
        });
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleFramePropertyEditor.this.finishEdit();
            }
        });
        buttonPanel.add(saveButton);
        buttonPanel.add(cancelButton);
        mainPanel.add((Component)propertyPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
    }

    private void setThrottleFrame(ThrottleWindow f) {
        this.frame = f;
        this.initGUI();
        this.pack();
        this.titleField.setText(this.frame.getTitleText());
        this.titleField.selectAll();
    }

    protected void titleFieldChanged() {
        if (this.titleField.getText().equals("")) {
            return;
        }
        if (this.titleType.getSelectedValue().equals(Bundle.getMessage("SelectTitleTypeADDRESS"))) {
            this.titleType.setSelectedValue(Bundle.getMessage("SelectTitleTypeTEXT"), true);
        }
    }

    private void saveProperties() {
        if (this.isDataValid()) {
            this.frame.setTitleText(this.titleField.getText());
            this.frame.setTitleTextType(this.titleTextTypes[this.titleType.getSelectedIndex()]);
            this.frame.getCurrentThrottleFrame().setFrameTitle();
            this.finishEdit();
        }
    }

    private void finishEdit() {
        this.setVisible(false);
    }

    private boolean isDataValid() {
        StringBuffer errors = new StringBuffer();
        int errorNumber = 0;
        if (errorNumber > 0) {
            JmriJOptionPane.showMessageDialog(this, errors, Bundle.getMessage("ErrorOnPage"), 0);
            return false;
        }
        return true;
    }
}

