/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.jmrit.throttle.ThrottleWindow;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrit.throttle.ThrottlesPreferencesWindowKeyboardControls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThrottleWindowActions
implements PropertyChangeListener {
    protected final ThrottleWindow tw;
    protected ThrottlesPreferencesWindowKeyboardControls tpwkc;
    private static final Logger log = LoggerFactory.getLogger(ThrottleWindowActions.class);

    ThrottleWindowActions(ThrottleWindow tw) {
        this.tw = tw;
        this.resetTpwkc();
    }

    private void resetTpwkc() {
        this.tpwkc = InstanceManager.getDefault(ThrottlesPreferences.class).getThrottlesKeyboardControls();
    }

    protected void toFront(JInternalFrame jif) {
        if (jif == null) {
            return;
        }
        if (!jif.isVisible()) {
            jif.setVisible(true);
        }
        if (jif.isIcon()) {
            try {
                jif.setIcon(false);
            }
            catch (PropertyVetoException ex) {
                log.debug("JInternalFrame uniconify, vetoed");
            }
        }
        jif.requestFocus();
        jif.toFront();
        try {
            jif.setSelected(true);
        }
        catch (PropertyVetoException ex) {
            log.debug("JInternalFrame selection, vetoed");
        }
    }

    protected void incrementSpeed(DccThrottle throttle, float increment) {
        float speed;
        if (throttle == null) {
            return;
        }
        float curSpeed = throttle.getSpeedSetting();
        if (curSpeed < 0.0f) {
            curSpeed = 0.0f;
        }
        if (this.tw.getCurrentThrottleFrame().getControlPanel().getDisplaySlider() == 2) {
            if (throttle.getIsForward()) {
                speed = curSpeed + increment;
                if (speed > -throttle.getSpeedIncrement() / 2.0f && speed < throttle.getSpeedIncrement() / 2.0f) {
                    speed = 0.0f;
                }
                if (speed < 0.0f) {
                    throttle.setIsForward(false);
                    speed = -speed;
                }
            } else {
                speed = -curSpeed + increment;
                if (speed > -throttle.getSpeedIncrement() / 2.0f && speed < throttle.getSpeedIncrement() / 2.0f) {
                    speed = 0.0f;
                }
                if (speed > 0.0f) {
                    throttle.setIsForward(true);
                } else {
                    speed = -speed;
                }
            }
        } else {
            speed = curSpeed + increment;
        }
        if (speed < throttle.getSpeedIncrement() / 2.0f || speed < 0.0f) {
            speed = 0.0f;
        } else if (speed > 1.0f) {
            speed = 1.0f;
        }
        throttle.setSpeedSetting(speed);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null || evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().compareTo("ThrottlePreferences") == 0) {
            this.resetTpwkc();
        }
    }
}

