/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.throttle.ThrottleWindow;
import jmri.jmrit.throttle.ThrottleWindowActions;

public class ThrottleWindowActionsFactory
extends ThrottleWindowActions {
    private final List<String> actionStrings = new ArrayList<String>(Arrays.asList("accelerate", "decelerate", "accelerateMore", "decelerateMore", "idle", "stop", "forward", "reverse", "switchDirection", "nextJInternalFrame", "previousJInternalFrame", "showControlPanel", "showFunctionPanel", "showAddressPanel", "nextThrottleFrame", "previousThrottleFrame", "nextRunningThrottleFrame", "previousRunningThrottleFrame", "nextThrottleWindow", "previousThrottleWindow"));

    public ThrottleWindowActionsFactory(ThrottleWindow tw) {
        super(tw);
        this.completeActionStrings();
    }

    private void completeActionStrings() {
        for (int i = 0; i < this.tpwkc.getNbFunctionsKeys(); ++i) {
            this.actionStrings.add("fn_" + i + "_Pressed");
            this.actionStrings.add("fn_" + i + "_Released");
        }
    }

    public ActionMap buildActionMap() {
        ActionMap ret = new ActionMap();
        ret.put("accelerate", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getThrottle();
                ThrottleWindowActionsFactory.this.incrementSpeed(throttle, throttle.getSpeedIncrement());
            }
        });
        ret.put("decelerate", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getThrottle();
                ThrottleWindowActionsFactory.this.incrementSpeed(throttle, -throttle.getSpeedIncrement());
            }
        });
        ret.put("accelerateMore", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getThrottle();
                ThrottleWindowActionsFactory.this.incrementSpeed(throttle, throttle.getSpeedIncrement() * ThrottleWindowActionsFactory.this.tpwkc.getMoreSpeedMultiplier());
            }
        });
        ret.put("decelerateMore", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getThrottle();
                ThrottleWindowActionsFactory.this.incrementSpeed(throttle, -throttle.getSpeedIncrement() * ThrottleWindowActionsFactory.this.tpwkc.getMoreSpeedMultiplier());
            }
        });
        ret.put("idle", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getThrottle();
                if (throttle != null) {
                    throttle.setSpeedSetting(0.0f);
                }
            }
        });
        ret.put("stop", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getThrottle();
                if (throttle != null) {
                    throttle.setSpeedSetting(-1.0f);
                }
            }
        });
        ret.put("forward", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getThrottle();
                if (throttle != null) {
                    throttle.setIsForward(true);
                }
            }
        });
        ret.put("reverse", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getThrottle();
                if (throttle != null) {
                    throttle.setIsForward(false);
                }
            }
        });
        ret.put("switchDirection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getThrottle();
                if (throttle != null) {
                    throttle.setIsForward(!throttle.getIsForward());
                }
            }
        });
        for (int i = 0; i < this.tpwkc.getNbFunctionsKeys(); ++i) {
            ret.put("fn_" + i + "_Pressed", new FnActionPressed(i));
            ret.put("fn_" + i + "_Released", new FnActionReleased(i));
        }
        ret.put("nextJInternalFrame", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().activateNextJInternalFrame();
            }
        });
        ret.put("previousJInternalFrame", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().activatePreviousJInternalFrame();
            }
        });
        ret.put("showControlPanel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindowActionsFactory.this.toFront(ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getControlPanel());
            }
        });
        ret.put("showFunctionPanel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindowActionsFactory.this.toFront(ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getFunctionPanel());
            }
        });
        ret.put("showAddressPanel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindowActionsFactory.this.toFront(ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel());
            }
        });
        ret.put("nextThrottleFrame", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindowActionsFactory.this.tw.nextThrottleFrame();
            }
        });
        ret.put("previousThrottleFrame", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindowActionsFactory.this.tw.previousThrottleFrame();
            }
        });
        ret.put("nextRunningThrottleFrame", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindowActionsFactory.this.tw.nextRunningThrottleFrame();
            }
        });
        ret.put("previousRunningThrottleFrame", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindowActionsFactory.this.tw.previousRunningThrottleFrame();
            }
        });
        ret.put("nextThrottleWindow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceManager.getDefault(ThrottleFrameManager.class).requestFocusForNextThrottleWindow();
            }
        });
        ret.put("previousThrottleWindow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceManager.getDefault(ThrottleFrameManager.class).requestFocusForPreviousThrottleWindow();
            }
        });
        return ret;
    }

    private class FnActionReleased
    extends AbstractAction {
        private final int fn;

        FnActionReleased(int fn) {
            this.fn = fn;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getFunctionThrottle();
            if (throttle != null) {
                throttle.setFunction(this.fn, !throttle.getFunction(this.fn));
            }
        }
    }

    private class FnActionPressed
    extends AbstractAction {
        private final int fn;

        FnActionPressed(int fn) {
            this.fn = fn;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DccThrottle throttle = ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getAddressPanel().getFunctionThrottle();
            if (throttle != null && (throttle.getFunctionMomentary(this.fn) || !ThrottleWindowActionsFactory.this.tw.getCurrentThrottleFrame().getFunctionPanel().getFunctionButtons()[this.fn].getIsLockable())) {
                throttle.setFunction(this.fn, true);
            }
        }
    }
}

