/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrit.throttle.ThrottlesPreferencesWindowKeyboardControls;
import jmri.swing.JTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlesPreferencesControlsSettingsPane
extends JPanel {
    private ShortCutsField tfNextThrottleWindow;
    private ShortCutsField tfPrevThrottleWindow;
    private ShortCutsField tfNextThrottleFrame;
    private ShortCutsField tfPrevThrottleFrame;
    private ShortCutsField tfNextRunningThrottleFrame;
    private ShortCutsField tfPrevRunningThrottleFrame;
    private ShortCutsField tfNextThrottleInternalWindow;
    private ShortCutsField tfPrevThrottleInternalWindow;
    private ShortCutsField tfGotoControl;
    private ShortCutsField tfGotoFunctions;
    private ShortCutsField tfGotoAddress;
    private ShortCutsField tfForward;
    private ShortCutsField tfReverse;
    private ShortCutsField tfSwitchDir;
    private ShortCutsField tfSpeedIdle;
    private ShortCutsField tfSpeedStop;
    private ShortCutsField tfSpeedUp;
    private ShortCutsField tfSpeedDown;
    private ShortCutsField tfSpeedUpMore;
    private ShortCutsField tfSpeedDownMore;
    private JTextField tfSpeedMultiplier;
    private float origSpeedMultiplier;
    private ShortCutsField[] tfFunctionKeys;
    private ThrottlesPreferencesWindowKeyboardControls _tpwkc;
    private static final Logger log = LoggerFactory.getLogger(ThrottlesPreferencesControlsSettingsPane.class);

    public ThrottlesPreferencesControlsSettingsPane(ThrottlesPreferences tp) {
        try {
            this._tpwkc = tp.getThrottlesKeyboardControls().clone();
        }
        catch (CloneNotSupportedException ex) {
            log.debug("Couldn't clone ThrottlesPreferencesWindowKeyboardControls");
        }
        this.initComponents();
    }

    private void initComponents() {
        JPanel propertyPanel = new JPanel();
        propertyPanel.setLayout(new GridBagLayout());
        this.add(propertyPanel);
        GridBagConstraints constraintsL = new GridBagConstraints();
        constraintsL.fill = 2;
        constraintsL.gridheight = 1;
        constraintsL.gridwidth = 1;
        constraintsL.ipadx = 0;
        constraintsL.ipady = 0;
        constraintsL.insets = new Insets(2, 18, 2, 2);
        constraintsL.weightx = 1.0;
        constraintsL.weighty = 1.0;
        constraintsL.anchor = 17;
        constraintsL.gridx = 0;
        constraintsL.gridy = 0;
        GridBagConstraints constraintsR = (GridBagConstraints)constraintsL.clone();
        constraintsR.anchor = 10;
        constraintsR.gridx = 1;
        GridBagConstraints constraintsS = (GridBagConstraints)constraintsL.clone();
        constraintsS.gridwidth = 2;
        constraintsS.insets = new Insets(18, 2, 2, 2);
        propertyPanel.add((Component)new JTitledSeparator(Bundle.getMessage("ThrottleWindowControls")), constraintsS);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("NextThrottleWindow")), constraintsL);
        this.tfNextThrottleWindow = new ShortCutsField(this._tpwkc.getNextThrottleWindowKeys());
        propertyPanel.add((Component)this.tfNextThrottleWindow, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("PrevThrottleWindow")), constraintsL);
        this.tfPrevThrottleWindow = new ShortCutsField(this._tpwkc.getPrevThrottleWindowKeys());
        propertyPanel.add((Component)this.tfPrevThrottleWindow, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("NextThrottleFrame")), constraintsL);
        this.tfNextThrottleFrame = new ShortCutsField(this._tpwkc.getNextThrottleFrameKeys());
        propertyPanel.add((Component)this.tfNextThrottleFrame, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("PrevThrottleFrame")), constraintsL);
        this.tfPrevThrottleFrame = new ShortCutsField(this._tpwkc.getPrevThrottleFrameKeys());
        propertyPanel.add((Component)this.tfPrevThrottleFrame, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("NextRunningThrottleFrame")), constraintsL);
        this.tfNextRunningThrottleFrame = new ShortCutsField(this._tpwkc.getNextRunThrottleFrameKeys());
        propertyPanel.add((Component)this.tfNextRunningThrottleFrame, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("PrevRunningThrottleFrame")), constraintsL);
        this.tfPrevRunningThrottleFrame = new ShortCutsField(this._tpwkc.getPrevRunThrottleFrameKeys());
        propertyPanel.add((Component)this.tfPrevRunningThrottleFrame, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("NextThrottleInternalWindow")), constraintsL);
        this.tfNextThrottleInternalWindow = new ShortCutsField(this._tpwkc.getNextThrottleInternalWindowKeys());
        propertyPanel.add((Component)this.tfNextThrottleInternalWindow, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("PrevThrottleInternalWindow")), constraintsL);
        this.tfPrevThrottleInternalWindow = new ShortCutsField(this._tpwkc.getPrevThrottleInternalWindowKeys());
        propertyPanel.add((Component)this.tfPrevThrottleInternalWindow, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("GotoControl")), constraintsL);
        this.tfGotoControl = new ShortCutsField(this._tpwkc.getMoveToControlPanelKeys());
        propertyPanel.add((Component)this.tfGotoControl, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("GotoFunctions")), constraintsL);
        this.tfGotoFunctions = new ShortCutsField(this._tpwkc.getMoveToFunctionPanelKeys());
        propertyPanel.add((Component)this.tfGotoFunctions, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("GotoAddress")), constraintsL);
        this.tfGotoAddress = new ShortCutsField(this._tpwkc.getMoveToAddressPanelKeys());
        propertyPanel.add((Component)this.tfGotoAddress, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JTitledSeparator(Bundle.getMessage("ThrottleSpeedControls")), constraintsS);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("Forward")), constraintsL);
        this.tfForward = new ShortCutsField(this._tpwkc.getForwardKeys());
        propertyPanel.add((Component)this.tfForward, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("Backward")), constraintsL);
        this.tfReverse = new ShortCutsField(this._tpwkc.getReverseKeys());
        propertyPanel.add((Component)this.tfReverse, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("SwitchDirection")), constraintsL);
        this.tfSwitchDir = new ShortCutsField(this._tpwkc.getSwitchDirectionKeys());
        propertyPanel.add((Component)this.tfSwitchDir, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("SpeedIdle")), constraintsL);
        this.tfSpeedIdle = new ShortCutsField(this._tpwkc.getIdleKeys());
        propertyPanel.add((Component)this.tfSpeedIdle, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("SpeedStop")), constraintsL);
        this.tfSpeedStop = new ShortCutsField(this._tpwkc.getStopKeys());
        propertyPanel.add((Component)this.tfSpeedStop, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("SpeedUp")), constraintsL);
        this.tfSpeedUp = new ShortCutsField(this._tpwkc.getAccelerateKeys());
        propertyPanel.add((Component)this.tfSpeedUp, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("SpeedDown")), constraintsL);
        this.tfSpeedDown = new ShortCutsField(this._tpwkc.getDecelerateKeys());
        propertyPanel.add((Component)this.tfSpeedDown, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("SpeedUpMore")), constraintsL);
        this.tfSpeedUpMore = new ShortCutsField(this._tpwkc.getAccelerateMoreKeys());
        propertyPanel.add((Component)this.tfSpeedUpMore, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("SpeedDownMore")), constraintsL);
        this.tfSpeedDownMore = new ShortCutsField(this._tpwkc.getDecelerateMoreKeys());
        propertyPanel.add((Component)this.tfSpeedDownMore, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JLabel(Bundle.getMessage("SpeedMultiplier")), constraintsL);
        this.origSpeedMultiplier = this._tpwkc.getMoreSpeedMultiplier();
        this.tfSpeedMultiplier = new JTextField("" + this.origSpeedMultiplier);
        this.tfSpeedMultiplier.setColumns(5);
        propertyPanel.add((Component)this.tfSpeedMultiplier, constraintsR);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        propertyPanel.add((Component)new JTitledSeparator(Bundle.getMessage("ThrottleFunctionsControls")), constraintsS);
        ++constraintsL.gridy;
        ++constraintsR.gridy;
        ++constraintsS.gridy;
        this.tfFunctionKeys = new ShortCutsField[this._tpwkc.getNbFunctionsKeys()];
        for (int i = 0; i < this.tfFunctionKeys.length; ++i) {
            propertyPanel.add((Component)new JLabel(Bundle.getMessage("Function") + " " + i), constraintsL);
            this.tfFunctionKeys[i] = new ShortCutsField(this._tpwkc.getFunctionsKeys(i));
            propertyPanel.add((Component)this.tfFunctionKeys[i], constraintsR);
            ++constraintsL.gridy;
            ++constraintsR.gridy;
            ++constraintsS.gridy;
        }
    }

    public ThrottlesPreferences updateThrottlesPreferences(ThrottlesPreferences tp) {
        ThrottlesPreferencesWindowKeyboardControls tpwkc = tp.getThrottlesKeyboardControls();
        if (this.tfNextThrottleWindow.isDirty()) {
            tpwkc.setNextThrottleWindowKeys(this.tfNextThrottleWindow.getShortCuts());
        }
        if (this.tfPrevThrottleWindow.isDirty()) {
            tpwkc.setPrevThrottleWindowKeys(this.tfPrevThrottleWindow.getShortCuts());
        }
        if (this.tfNextThrottleFrame.isDirty()) {
            tpwkc.setNextTrottleFrameKeys(this.tfNextThrottleFrame.getShortCuts());
        }
        if (this.tfPrevThrottleFrame.isDirty()) {
            tpwkc.setPrevThrottleFrameKeys(this.tfPrevThrottleFrame.getShortCuts());
        }
        if (this.tfNextRunningThrottleFrame.isDirty()) {
            tpwkc.setNextRunThrottleFrameKeys(this.tfNextRunningThrottleFrame.getShortCuts());
        }
        if (this.tfPrevRunningThrottleFrame.isDirty()) {
            tpwkc.setPrevRunThrottleFrameKeys(this.tfPrevRunningThrottleFrame.getShortCuts());
        }
        if (this.tfNextThrottleInternalWindow.isDirty()) {
            tpwkc.setNextThrottleInternalWindowKeys(this.tfNextThrottleInternalWindow.getShortCuts());
        }
        if (this.tfPrevThrottleInternalWindow.isDirty()) {
            tpwkc.setPrevThrottleInternalWindowKeys(this.tfPrevThrottleInternalWindow.getShortCuts());
        }
        if (this.tfGotoControl.isDirty()) {
            tpwkc.setMoveToControlPanelKeys(this.tfGotoControl.getShortCuts());
        }
        if (this.tfGotoFunctions.isDirty()) {
            tpwkc.setMoveToFunctionPanelKeys(this.tfGotoFunctions.getShortCuts());
        }
        if (this.tfGotoAddress.isDirty()) {
            tpwkc.setMoveToAddressPanelKeys(this.tfGotoAddress.getShortCuts());
        }
        if (this.tfForward.isDirty()) {
            tpwkc.setForwardKeys(this.tfForward.getShortCuts());
        }
        if (this.tfReverse.isDirty()) {
            tpwkc.setReverseKeys(this.tfReverse.getShortCuts());
        }
        if (this.tfSwitchDir.isDirty()) {
            tpwkc.setSwitchDirectionKeys(this.tfSwitchDir.getShortCuts());
        }
        if (this.tfSpeedIdle.isDirty()) {
            tpwkc.setIdleKeys(this.tfSpeedIdle.getShortCuts());
        }
        if (this.tfSpeedStop.isDirty()) {
            tpwkc.setStopKeys(this.tfSpeedStop.getShortCuts());
        }
        if (this.tfSpeedUp.isDirty()) {
            tpwkc.setAccelerateKeys(this.tfSpeedUp.getShortCuts());
        }
        if (this.tfSpeedDown.isDirty()) {
            tpwkc.setDecelerateKeys(this.tfSpeedDown.getShortCuts());
        }
        if (this.tfSpeedUpMore.isDirty()) {
            tpwkc.setAccelerateMoreKeys(this.tfSpeedUpMore.getShortCuts());
        }
        if (this.tfSpeedDownMore.isDirty()) {
            tpwkc.setDecelerateMoreKeys(this.tfSpeedDownMore.getShortCuts());
        }
        for (int i = 0; i < this.tfFunctionKeys.length; ++i) {
            if (!this.tfFunctionKeys[i].isDirty) continue;
            tpwkc.setFunctionsKeys(i, this.tfFunctionKeys[i].getShortCuts());
        }
        try {
            float sm = Float.parseFloat(this.tfSpeedMultiplier.getText());
            if ((double)Math.abs(sm - tpwkc.getMoreSpeedMultiplier()) > 1.0E-4) {
                tpwkc.setMoreSpeedMultiplier(sm);
            }
        }
        catch (NumberFormatException e) {
            log.error("Speed multiplier must be a numerical float value.");
        }
        return tp;
    }

    void resetComponents(ThrottlesPreferences tp) {
        try {
            this._tpwkc = tp.getThrottlesKeyboardControls().clone();
        }
        catch (CloneNotSupportedException ex) {
            log.debug("Couldn't clone ThrottlesPreferencesWindowKeyboardControls");
        }
        this.removeAll();
        this.initComponents();
        this.revalidate();
    }

    boolean isDirty() {
        boolean ret = false;
        ret = this.tfNextThrottleWindow.isDirty() || ret;
        ret = this.tfPrevThrottleWindow.isDirty() || ret;
        ret = this.tfNextThrottleFrame.isDirty() || ret;
        ret = this.tfPrevThrottleFrame.isDirty() || ret;
        ret = this.tfNextRunningThrottleFrame.isDirty() || ret;
        ret = this.tfPrevRunningThrottleFrame.isDirty() || ret;
        ret = this.tfNextThrottleInternalWindow.isDirty() || ret;
        ret = this.tfPrevThrottleInternalWindow.isDirty() || ret;
        ret = this.tfGotoControl.isDirty() || ret;
        ret = this.tfGotoFunctions.isDirty() || ret;
        ret = this.tfGotoAddress.isDirty() || ret;
        ret = this.tfForward.isDirty() || ret;
        ret = this.tfReverse.isDirty() || ret;
        ret = this.tfSwitchDir.isDirty() || ret;
        ret = this.tfSpeedIdle.isDirty() || ret;
        ret = this.tfSpeedStop.isDirty() || ret;
        ret = this.tfSpeedDown.isDirty() || ret;
        ret = this.tfSpeedUp.isDirty() || ret;
        ret = this.tfSpeedDownMore.isDirty() || ret;
        ret = this.tfSpeedUpMore.isDirty() || ret;
        for (ShortCutsField tfFunctionKey : this.tfFunctionKeys) {
            if (!tfFunctionKey.isDirty) continue;
            ret = tfFunctionKey.isDirty() || ret;
        }
        try {
            float sm = Float.parseFloat(this.tfSpeedMultiplier.getText());
            ret = (double)Math.abs(sm - this.origSpeedMultiplier) > 1.0E-4 || ret;
        }
        catch (NumberFormatException e) {
            log.error("Speed multiplier must be a numerical float value.");
        }
        return ret;
    }

    private final class ShortCutTextField
    extends JTextField {
        ShortCutsField shortCutsField;

        ShortCutTextField(int[] v) {
            this.setEditable(false);
            Object text = "";
            if (v[0] != 0) {
                text = (String)text + (KeyEvent.getKeyModifiersText(v[0]).isEmpty() ? KeyEvent.getModifiersExText(v[0]) : KeyEvent.getKeyModifiersText(v[0])) + " + ";
            }
            if (v[1] != 0) {
                text = (String)text + KeyEvent.getKeyText(v[1]);
            }
            super.setText((String)text);
        }

        ShortCutTextField(ShortCutsField scf) {
            this.setEditable(false);
            this.shortCutsField = scf;
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    int[] values = new int[]{e.getModifiersEx(), e.getExtendedKeyCode()};
                    ShortCutTextField.this.shortCutsField.addValue(values, e.getComponent());
                    log.debug("Key pressed: {} / modifier: {} / ext. key code: {} / location: {}", new Object[]{e.getKeyCode(), e.getModifiersEx(), e.getExtendedKeyCode(), e.getKeyLocation()});
                }
            });
        }
    }

    private final class ShortCutPanel
    extends JPanel {
        ShortCutsField shortCutsField;
        int[] shortcut;

        ShortCutPanel(ShortCutsField scf, int[] sc) {
            this.shortCutsField = scf;
            this.shortcut = sc;
            this.setLayout(new BorderLayout());
            this.add(new ShortCutTextField(this.shortcut));
            JButton removeBtn = new JButton("X");
            removeBtn.addActionListener(e -> {
                this.shortcut[0] = 0;
                this.shortcut[1] = 0;
                this.shortCutsField.setDirty(true);
                this.shortCutsField.remove(this);
                this.shortCutsField.revalidate();
            });
            this.add((Component)removeBtn, "West");
            this.setBorder(BorderFactory.createEtchedBorder(0));
        }
    }

    private final class ShortCutsField
    extends JPanel {
        int[][] shortcuts;
        boolean isDirty = false;

        ShortCutsField(int[][] values) {
            this.shortcuts = values;
            this.setLayout(new GridLayout());
            for (int[] v : this.shortcuts) {
                if (v[0] == 0 && v[1] == 0) continue;
                this.add(new ShortCutPanel(this, v));
            }
            this.add(new ShortCutTextField(this));
        }

        private void addValue(int[] values, Component cmp) {
            this.shortcuts = (int[][])Arrays.copyOf(this.shortcuts, this.shortcuts.length + 1);
            this.shortcuts[this.shortcuts.length - 1] = values;
            this.add(new ShortCutPanel(this, this.shortcuts[this.shortcuts.length - 1]));
            this.add(new ShortCutTextField(this));
            this.setDirty(true);
            this.remove(cmp);
            this.revalidate();
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void setDirty(boolean b) {
            this.isDirty = b;
        }

        public int[][] getShortCuts() {
            return this.shortcuts;
        }
    }
}

