/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.util.ArrayList;
import javax.swing.KeyStroke;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlesPreferencesWindowKeyboardControls
implements Cloneable {
    private float moreSpeedMultiplier = 5.0f;
    private int[][] nextThrottleWindowKeys = new int[][]{{0, 155}};
    private int[][] prevThrottleWindowKeys = new int[][]{{0, 127}};
    private int[][] nextThrottleFrameKeys = new int[][]{{0, 35}};
    private int[][] prevThrottleFrameKeys = new int[][]{{0, 36}};
    private int[][] nextRunThrottleFrameKeys = new int[][]{{128, 35}};
    private int[][] prevRunThrottleFrameKeys = new int[][]{{128, 36}};
    private int[][] nextThrottleInternalWindowKeys = new int[][]{{0, 75}, {0, 9}};
    private int[][] prevThrottleInternalWindowKeys = new int[][]{{0, 76}, {64, 9}};
    private int[][] moveToControlPanelKeys = new int[][]{{0, 67}};
    private int[][] moveToFunctionPanelKeys = new int[][]{{0, 70}};
    private int[][] moveToAddressPanelKeys = new int[][]{{0, 65}};
    private int[][] reverseKeys = new int[][]{{0, 40}};
    private int[][] forwardKeys = new int[][]{{0, 38}};
    private int[][] switchDirectionKeys = new int[0][];
    private int[][] idleKeys = new int[][]{{0, 106}, {0, 32}};
    private int[][] stopKeys = new int[][]{{0, 111}, {0, 27}};
    private int[][] accelerateKeys = new int[][]{{0, 107}, {0, 37}};
    private int[][] decelerateKeys = new int[][]{{0, 109}, {0, 39}};
    private int[][] accelerateMoreKeys = new int[][]{{0, 33}, {128, 37}};
    private int[][] decelerateMoreKeys = new int[][]{{0, 34}, {128, 39}};
    private int[][][] functionsKeys = new int[][][]{new int[][]{{0, 96}}, new int[][]{{0, 112}, {0, 97}}, new int[][]{{0, 113}, {0, 98}}, new int[][]{{0, 114}, {0, 99}}, new int[][]{{0, 115}, {0, 100}}, new int[][]{{0, 116}, {0, 101}}, new int[][]{{0, 117}, {0, 102}}, new int[][]{{0, 118}, {0, 103}}, new int[][]{{0, 119}, {0, 104}}, new int[][]{{0, 120}, {0, 105}}, new int[][]{{0, 121}, {0, 110}, {64, 96}}, new int[][]{{0, 122}, {64, 112}, {64, 97}}, new int[][]{{0, 123}, {64, 113}, {64, 98}}, new int[][]{{0, 61440}, {64, 114}, {64, 99}}, new int[][]{{0, 61441}, {64, 115}, {64, 100}}, new int[][]{{0, 61442}, {64, 116}, {64, 101}}, new int[][]{{0, 61443}, {64, 117}, {64, 102}}, new int[][]{{0, 61444}, {64, 118}, {64, 103}}, new int[][]{{0, 61445}, {64, 119}, {64, 104}}, new int[][]{{0, 61446}, {64, 120}, {64, 105}}, new int[][]{{0, 61447}, {128, 121}, {128, 96}}, new int[][]{{0, 61448}, {128, 112}, {128, 97}}, new int[][]{{0, 61449}, {128, 113}, {128, 98}}, new int[][]{{0, 61450}, {128, 114}, {128, 99}}, new int[][]{{0, 61451}, {128, 115}, {128, 100}}, new int[][]{{128, 116}, {128, 101}}, new int[][]{{128, 117}, {128, 102}}, new int[][]{{128, 118}, {128, 103}}, new int[][]{{128, 119}, {128, 104}}};
    private static final Logger log = LoggerFactory.getLogger(ThrottlesPreferencesWindowKeyboardControls.class);

    public int[][] getNextThrottleWindowKeys() {
        return this.nextThrottleWindowKeys;
    }

    public int[][] getPrevThrottleWindowKeys() {
        return this.prevThrottleWindowKeys;
    }

    public int[][] getNextThrottleFrameKeys() {
        return this.nextThrottleFrameKeys;
    }

    public int[][] getPrevThrottleFrameKeys() {
        return this.prevThrottleFrameKeys;
    }

    public int[][] getNextRunThrottleFrameKeys() {
        return this.nextRunThrottleFrameKeys;
    }

    public int[][] getPrevRunThrottleFrameKeys() {
        return this.prevRunThrottleFrameKeys;
    }

    public int[][] getNextThrottleInternalWindowKeys() {
        return this.nextThrottleInternalWindowKeys;
    }

    public int[][] getPrevThrottleInternalWindowKeys() {
        return this.prevThrottleInternalWindowKeys;
    }

    public int[][] getMoveToControlPanelKeys() {
        return this.moveToControlPanelKeys;
    }

    public int[][] getMoveToFunctionPanelKeys() {
        return this.moveToFunctionPanelKeys;
    }

    public int[][] getMoveToAddressPanelKeys() {
        return this.moveToAddressPanelKeys;
    }

    public int[][] getReverseKeys() {
        return this.reverseKeys;
    }

    public int[][] getForwardKeys() {
        return this.forwardKeys;
    }

    public int[][] getSwitchDirectionKeys() {
        return this.switchDirectionKeys;
    }

    public int[][] getIdleKeys() {
        return this.idleKeys;
    }

    public int[][] getStopKeys() {
        return this.stopKeys;
    }

    public int[][] getAccelerateKeys() {
        return this.accelerateKeys;
    }

    public int[][] getDecelerateKeys() {
        return this.decelerateKeys;
    }

    public int[][] getAccelerateMoreKeys() {
        return this.accelerateMoreKeys;
    }

    public int[][] getDecelerateMoreKeys() {
        return this.decelerateMoreKeys;
    }

    public int[][] getFunctionsKeys(int fn) {
        return this.functionsKeys[fn];
    }

    public KeyStroke[] getKeyStrokes(String evtString) {
        int[][] keys = null;
        boolean onKeyRelease = true;
        switch (evtString) {
            case "accelerate": {
                keys = this.getAccelerateKeys();
                onKeyRelease = false;
                break;
            }
            case "decelerate": {
                keys = this.getDecelerateKeys();
                onKeyRelease = false;
                break;
            }
            case "accelerateMore": {
                keys = this.getAccelerateMoreKeys();
                onKeyRelease = false;
                break;
            }
            case "decelerateMore": {
                keys = this.getDecelerateMoreKeys();
                onKeyRelease = false;
                break;
            }
            case "idle": {
                keys = this.getIdleKeys();
                break;
            }
            case "stop": {
                keys = this.getStopKeys();
                break;
            }
            case "forward": {
                keys = this.getForwardKeys();
                break;
            }
            case "reverse": {
                keys = this.getReverseKeys();
                break;
            }
            case "switchDirection": {
                keys = this.getSwitchDirectionKeys();
                break;
            }
            case "nextJInternalFrame": {
                keys = this.getNextThrottleInternalWindowKeys();
                break;
            }
            case "previousJInternalFrame": {
                keys = this.getPrevThrottleInternalWindowKeys();
                break;
            }
            case "showControlPanel": {
                keys = this.getMoveToControlPanelKeys();
                break;
            }
            case "showFunctionPanel": {
                keys = this.getMoveToFunctionPanelKeys();
                break;
            }
            case "showAddressPanel": {
                keys = this.getMoveToAddressPanelKeys();
                break;
            }
            case "nextThrottleFrame": {
                keys = this.getNextThrottleFrameKeys();
                break;
            }
            case "previousThrottleFrame": {
                keys = this.getPrevThrottleFrameKeys();
                break;
            }
            case "nextRunningThrottleFrame": {
                keys = this.getNextRunThrottleFrameKeys();
                break;
            }
            case "previousRunningThrottleFrame": {
                keys = this.getPrevRunThrottleFrameKeys();
                break;
            }
            case "nextThrottleWindow": {
                keys = this.getNextThrottleWindowKeys();
                break;
            }
            case "previousThrottleWindow": {
                keys = this.getPrevThrottleWindowKeys();
                break;
            }
        }
        if (evtString.matches("fn_.*_.*")) {
            String[] tokens = evtString.split("_");
            keys = this.functionsKeys[Integer.parseInt(tokens[1])];
            if ("Pressed".equals(tokens[2])) {
                onKeyRelease = false;
            }
        }
        if (keys == null) {
            return new KeyStroke[0];
        }
        KeyStroke[] ks = new KeyStroke[keys.length];
        for (int i = 0; i < ks.length; ++i) {
            ks[i] = KeyStroke.getKeyStroke(keys[i][1], keys[i][0], onKeyRelease);
        }
        return ks;
    }

    public int getNbFunctionsKeys() {
        return this.functionsKeys.length;
    }

    public void setFunctionsKeys(int fn, int[][] aFunctionsKeys) {
        this.functionsKeys[fn] = aFunctionsKeys;
    }

    public float getMoreSpeedMultiplier() {
        return this.moreSpeedMultiplier;
    }

    public void setMoreSpeedMultiplier(float moreSpeedMultiplier) {
        this.moreSpeedMultiplier = moreSpeedMultiplier;
    }

    public void setNextThrottleWindowKeys(int[][] nextThrottleWindowKeys) {
        this.nextThrottleWindowKeys = nextThrottleWindowKeys;
    }

    public void setPrevThrottleWindowKeys(int[][] prevThrottleWindowKeys) {
        this.prevThrottleWindowKeys = prevThrottleWindowKeys;
    }

    public void setNextTrottleFrameKeys(int[][] nextTrottleFrameKeys) {
        this.nextThrottleFrameKeys = nextTrottleFrameKeys;
    }

    public void setPrevThrottleFrameKeys(int[][] prevThrottleFrameKeys) {
        this.prevThrottleFrameKeys = prevThrottleFrameKeys;
    }

    public void setNextRunThrottleFrameKeys(int[][] nextRunThrottleFrameKeys) {
        this.nextRunThrottleFrameKeys = nextRunThrottleFrameKeys;
    }

    public void setPrevRunThrottleFrameKeys(int[][] prevRunThrottleFrameKeys) {
        this.prevRunThrottleFrameKeys = prevRunThrottleFrameKeys;
    }

    public void setNextThrottleInternalWindowKeys(int[][] nextThrottleInternalWindowKeys) {
        this.nextThrottleInternalWindowKeys = nextThrottleInternalWindowKeys;
    }

    public void setPrevThrottleInternalWindowKeys(int[][] prevThrottleInternalWindowKeys) {
        this.prevThrottleInternalWindowKeys = prevThrottleInternalWindowKeys;
    }

    public void setMoveToControlPanelKeys(int[][] moveToControlPanelKeys) {
        this.moveToControlPanelKeys = moveToControlPanelKeys;
    }

    public void setMoveToFunctionPanelKeys(int[][] moveToFunctionPanelKeys) {
        this.moveToFunctionPanelKeys = moveToFunctionPanelKeys;
    }

    public void setMoveToAddressPanelKeys(int[][] moveToAddressPanelKeys) {
        this.moveToAddressPanelKeys = moveToAddressPanelKeys;
    }

    public void setReverseKeys(int[][] reverseKeys) {
        this.reverseKeys = reverseKeys;
    }

    public void setForwardKeys(int[][] forwardKeys) {
        this.forwardKeys = forwardKeys;
    }

    public void setSwitchDirectionKeys(int[][] switchDirectionKeys) {
        this.switchDirectionKeys = switchDirectionKeys;
    }

    public void setIdleKeys(int[][] idleKeys) {
        this.idleKeys = idleKeys;
    }

    public void setStopKeys(int[][] stopKeys) {
        this.stopKeys = stopKeys;
    }

    public void setAccelerateKeys(int[][] accelerateKeys) {
        this.accelerateKeys = accelerateKeys;
    }

    public void setDecelerateKeys(int[][] decelerateKeys) {
        this.decelerateKeys = decelerateKeys;
    }

    public void setAccelerateMoreKeys(int[][] accelerateMoreKeys) {
        this.accelerateMoreKeys = accelerateMoreKeys;
    }

    public void setDecelerateMoreKeys(int[][] decelerateMoreKeys) {
        this.decelerateMoreKeys = decelerateMoreKeys;
    }

    public ThrottlesPreferencesWindowKeyboardControls clone() throws CloneNotSupportedException {
        ThrottlesPreferencesWindowKeyboardControls ret = (ThrottlesPreferencesWindowKeyboardControls)super.clone();
        ret.moreSpeedMultiplier = this.moreSpeedMultiplier;
        ret.nextThrottleWindowKeys = this.clone(this.nextThrottleWindowKeys);
        ret.prevThrottleWindowKeys = this.clone(this.prevThrottleWindowKeys);
        ret.nextThrottleFrameKeys = this.clone(this.nextThrottleFrameKeys);
        ret.prevThrottleFrameKeys = this.clone(this.prevThrottleFrameKeys);
        ret.nextRunThrottleFrameKeys = this.clone(this.nextRunThrottleFrameKeys);
        ret.prevRunThrottleFrameKeys = this.clone(this.prevRunThrottleFrameKeys);
        ret.nextThrottleInternalWindowKeys = this.clone(this.nextThrottleInternalWindowKeys);
        ret.prevThrottleInternalWindowKeys = this.clone(this.prevThrottleInternalWindowKeys);
        ret.moveToControlPanelKeys = this.clone(this.moveToControlPanelKeys);
        ret.moveToFunctionPanelKeys = this.clone(this.moveToFunctionPanelKeys);
        ret.moveToAddressPanelKeys = this.clone(this.moveToAddressPanelKeys);
        ret.reverseKeys = this.clone(this.reverseKeys);
        ret.forwardKeys = this.clone(this.forwardKeys);
        ret.switchDirectionKeys = this.clone(this.switchDirectionKeys);
        ret.idleKeys = this.clone(this.idleKeys);
        ret.stopKeys = this.clone(this.stopKeys);
        ret.accelerateKeys = this.clone(this.accelerateKeys);
        ret.decelerateKeys = this.clone(this.decelerateKeys);
        ret.accelerateMoreKeys = this.clone(this.accelerateMoreKeys);
        ret.decelerateMoreKeys = this.clone(this.decelerateMoreKeys);
        ret.functionsKeys = new int[this.functionsKeys.length][0][0];
        for (int i = 0; i < this.functionsKeys.length; ++i) {
            ret.functionsKeys[i] = this.clone(this.functionsKeys[i]);
        }
        return ret;
    }

    private int[][] clone(int[][] from) {
        int[][] to = new int[from.length][2];
        for (int i = 0; i < from.length; ++i) {
            to[i][0] = from[i][0];
            to[i][1] = from[i][1];
        }
        return to;
    }

    private Element getControlXml(String eltname, int[][] controls) {
        ArrayList<Element> children = new ArrayList<Element>(controls.length);
        for (int i = 0; i < controls.length; ++i) {
            Element e = new Element("ksc-" + i);
            e.setAttribute("m", "" + controls[i][0]);
            e.setAttribute("k", "" + controls[i][1]);
            children.add(e);
        }
        Element e = new Element(eltname);
        e.setContent(children);
        return e;
    }

    Element store() {
        ArrayList<Element> children = new ArrayList<Element>(10);
        children.add(this.getControlXml("nextThrottleWindowKeys", this.nextThrottleWindowKeys));
        children.add(this.getControlXml("prevThrottleWindowKeys", this.prevThrottleWindowKeys));
        children.add(this.getControlXml("nextThrottleFrameKeys", this.nextThrottleFrameKeys));
        children.add(this.getControlXml("prevThrottleFrameKeys", this.prevThrottleFrameKeys));
        children.add(this.getControlXml("nextRunThrottleFrameKeys", this.nextRunThrottleFrameKeys));
        children.add(this.getControlXml("prevRunThrottleFrameKeys", this.prevRunThrottleFrameKeys));
        children.add(this.getControlXml("nextThrottleInternalWindowKeys", this.nextThrottleInternalWindowKeys));
        children.add(this.getControlXml("prevThrottleInternalWindowKeys", this.prevThrottleInternalWindowKeys));
        children.add(this.getControlXml("moveToControlPanelKeys", this.moveToControlPanelKeys));
        children.add(this.getControlXml("moveToFunctionPanelKeys", this.moveToFunctionPanelKeys));
        children.add(this.getControlXml("moveToAddressPanelKeys", this.moveToAddressPanelKeys));
        children.add(this.getControlXml("reverseKeys", this.reverseKeys));
        children.add(this.getControlXml("forwardKeys", this.forwardKeys));
        children.add(this.getControlXml("switchDirectionKeys", this.switchDirectionKeys));
        children.add(this.getControlXml("idleKeys", this.idleKeys));
        children.add(this.getControlXml("stopKeys", this.stopKeys));
        children.add(this.getControlXml("accelerateKeys", this.accelerateKeys));
        children.add(this.getControlXml("decelerateKeys", this.decelerateKeys));
        children.add(this.getControlXml("accelerateMoreKeys", this.accelerateMoreKeys));
        children.add(this.getControlXml("decelerateMoreKeys", this.decelerateMoreKeys));
        for (int i = 0; i < this.functionsKeys.length; ++i) {
            children.add(this.getControlXml("functionsKeys-" + i, this.functionsKeys[i]));
        }
        Element e = new Element("throttlesControls");
        e.setAttribute("moreSpeedMultiplier", "" + this.moreSpeedMultiplier);
        e.setContent(children);
        return e;
    }

    private int[][] createControlFromXml(Element child) {
        int[][] ret = new int[child.getChildren().size()][2];
        int i = 0;
        for (Element e : child.getChildren()) {
            ret[i][0] = Integer.parseInt(e.getAttributeValue("m"));
            ret[i][1] = Integer.parseInt(e.getAttributeValue("k"));
            ++i;
        }
        return ret;
    }

    public void load(Element e) {
        if (e == null || e.getChildren().isEmpty()) {
            return;
        }
        try {
            this.nextThrottleWindowKeys = this.createControlFromXml(e.getChild("nextThrottleWindowKeys"));
            this.prevThrottleWindowKeys = this.createControlFromXml(e.getChild("prevThrottleWindowKeys"));
            this.nextThrottleFrameKeys = this.createControlFromXml(e.getChild("nextThrottleFrameKeys"));
            this.prevThrottleFrameKeys = this.createControlFromXml(e.getChild("prevThrottleFrameKeys"));
            this.nextRunThrottleFrameKeys = this.createControlFromXml(e.getChild("nextRunThrottleFrameKeys"));
            this.prevRunThrottleFrameKeys = this.createControlFromXml(e.getChild("prevRunThrottleFrameKeys"));
            this.nextThrottleInternalWindowKeys = this.createControlFromXml(e.getChild("nextThrottleInternalWindowKeys"));
            this.prevThrottleInternalWindowKeys = this.createControlFromXml(e.getChild("prevThrottleInternalWindowKeys"));
            this.moveToControlPanelKeys = this.createControlFromXml(e.getChild("moveToControlPanelKeys"));
            this.moveToFunctionPanelKeys = this.createControlFromXml(e.getChild("moveToFunctionPanelKeys"));
            this.moveToAddressPanelKeys = this.createControlFromXml(e.getChild("moveToAddressPanelKeys"));
            this.reverseKeys = this.createControlFromXml(e.getChild("reverseKeys"));
            this.forwardKeys = this.createControlFromXml(e.getChild("forwardKeys"));
            this.switchDirectionKeys = this.createControlFromXml(e.getChild("switchDirectionKeys"));
            this.idleKeys = this.createControlFromXml(e.getChild("idleKeys"));
            this.stopKeys = this.createControlFromXml(e.getChild("stopKeys"));
            this.accelerateKeys = this.createControlFromXml(e.getChild("accelerateKeys"));
            this.decelerateKeys = this.createControlFromXml(e.getChild("decelerateKeys"));
            this.accelerateMoreKeys = this.createControlFromXml(e.getChild("accelerateMoreKeys"));
            this.decelerateMoreKeys = this.createControlFromXml(e.getChild("decelerateMoreKeys"));
            for (int i = 0; i < this.functionsKeys.length; ++i) {
                this.functionsKeys[i] = this.createControlFromXml(e.getChild("functionsKeys-" + i));
            }
            this.moreSpeedMultiplier = Float.parseFloat(e.getAttributeValue("moreSpeedMultiplier"));
        }
        catch (NumberFormatException exc) {
            log.error("Error while restoring thottle controls from xml : {}", (Object)exc.getMessage());
        }
    }
}

