/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import jmri.Consist;
import jmri.ConsistManager;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.jmrit.roster.RosterIconFactory;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.util.FileUtil;

public class ThrottlesTableCellRenderer
implements TableCellRenderer {
    private static final ImageIcon FWD_ICN = new ImageIcon(FileUtil.findURL("resources/icons/throttles/dirFwdOn.png"));
    private static final ImageIcon BCK_ICN = new ImageIcon(FileUtil.findURL("resources/icons/throttles/dirBckOn.png"));
    private static final ImageIcon ESTOP_ICN = new ImageIcon(FileUtil.findURL("resources/icons/throttles/estop24.png"));
    private static final RosterIconFactory ICN_FACT = new RosterIconFactory(32);
    static final int LINE_HEIGHT = 42;

    @Override
    public Component getTableCellRendererComponent(JTable jtable, Object value, boolean bln, boolean bln1, int i, int i1) {
        JPanel retPanel = new JPanel();
        retPanel.setLayout(new BorderLayout());
        if (value == null) {
            return retPanel;
        }
        ThrottleFrame tf = (ThrottleFrame)value;
        if (tf.getAddressPanel().getConsistAddress() != null && tf.getAddressPanel().getThrottle() != null) {
            JPanel consistPanel = new JPanel();
            consistPanel.setLayout(new FlowLayout());
            consistPanel.setOpaque(false);
            Consist consist = InstanceManager.getDefault(ConsistManager.class).getConsist(tf.getAddressPanel().getConsistAddress());
            Object consistName = "";
            for (DccLocoAddress loco : consist.getConsistList()) {
                JLabel label;
                String reName = consist.getRosterId(loco);
                if (reName != null) {
                    consistName = " [" + reName + "]" + (String)consistName;
                    label = new JLabel();
                    Boolean dir = consist.getLocoDirection(loco);
                    ImageIcon icon = dir != false ? ICN_FACT.getIcon(reName) : ICN_FACT.getReversedIcon(reName);
                    if (icon != null) {
                        icon.setImageObserver(jtable);
                        label.setIcon(icon);
                    } else {
                        label.setName(reName);
                    }
                } else {
                    label = new JLabel("[" + loco.toString() + "]");
                    consistName = " [" + loco.toString() + "]" + (String)consistName;
                }
                consistPanel.add((Component)label, 0);
            }
            consistPanel.add(new JLabel((String)consistName));
            retPanel.add((Component)consistPanel, "Center");
        } else {
            Object text;
            ImageIcon icon = null;
            if (tf.getRosterEntry() != null) {
                icon = ICN_FACT.getIcon(tf.getAddressPanel().getRosterEntry());
                text = tf.getAddressPanel().getRosterEntry().getId();
            } else if (tf.getAddressPanel().getCurrentAddress() != null && tf.getAddressPanel().getThrottle() != null) {
                switch (tf.getAddressPanel().getCurrentAddress().getNumber()) {
                    case 0: {
                        text = Bundle.getMessage("ThrottleDCControl") + " - " + tf.getAddressPanel().getCurrentAddress();
                        break;
                    }
                    case 3: {
                        text = Bundle.getMessage("ThrottleDCCControl") + " - " + tf.getAddressPanel().getCurrentAddress();
                        break;
                    }
                    default: {
                        text = Bundle.getMessage("ThrottleAddress") + " " + tf.getAddressPanel().getCurrentAddress();
                        break;
                    }
                }
            } else {
                text = Bundle.getMessage("ThrottleNotAssigned");
            }
            if (icon != null) {
                icon.setImageObserver(jtable);
            }
            JLabel locoID = new JLabel();
            locoID.setHorizontalAlignment(0);
            locoID.setVerticalAlignment(0);
            locoID.setIcon(icon);
            locoID.setText((String)text);
            retPanel.add((Component)locoID, "Center");
        }
        if (tf.getAddressPanel().getThrottle() != null) {
            ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
            JPanel ctrlPanel = new JPanel();
            ctrlPanel.setLayout(new BorderLayout());
            DccThrottle thr = tf.getAddressPanel().getThrottle();
            JLabel dir = new JLabel();
            if (preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon()) {
                if (thr.getIsForward()) {
                    dir.setIcon(FWD_ICN);
                } else {
                    dir.setIcon(BCK_ICN);
                }
            } else if (thr.getIsForward()) {
                dir.setText(Bundle.getMessage("ButtonForward"));
            } else {
                dir.setText(Bundle.getMessage("ButtonReverse"));
            }
            dir.setVerticalAlignment(0);
            ctrlPanel.add((Component)dir, "West");
            if (preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon()) {
                if (thr.getSpeedSetting() == -1.0f) {
                    JLabel estop = new JLabel();
                    estop.setPreferredSize(new Dimension(64, 34));
                    estop.setHorizontalAlignment(0);
                    estop.setIcon(ESTOP_ICN);
                    ctrlPanel.add((Component)estop, "Center");
                } else {
                    JProgressBar speedBar = new JProgressBar();
                    speedBar.setPreferredSize(new Dimension(64, 34));
                    speedBar.setMinimum(0);
                    speedBar.setMaximum(100);
                    speedBar.setValue((int)(thr.getSpeedSetting() * 100.0f));
                    ctrlPanel.add((Component)speedBar, "Center");
                }
            } else {
                JLabel speedLabel = new JLabel("");
                if (thr.getSpeedSetting() == -1.0f) {
                    speedLabel.setText(" " + Bundle.getMessage("ButtonEStop") + " ");
                } else {
                    speedLabel.setText(" " + (int)(thr.getSpeedSetting() * 100.0f) + "% ");
                }
                ctrlPanel.add((Component)speedLabel, "Center");
            }
            ctrlPanel.setOpaque(false);
            retPanel.add((Component)ctrlPanel, "East");
        }
        if (tf.isVisible()) {
            Color selForeground;
            Color selBackground = UIManager.getDefaults().getColor("List.selectionBackground");
            if (selBackground == null) {
                selBackground = Color.ORANGE;
            }
            if ((selForeground = UIManager.getDefaults().getColor("List.selectionForeground")) == null) {
                selForeground = Color.BLACK;
            }
            retPanel.setBackground(selBackground);
            this.setForegroundAllComp(retPanel, selForeground);
            retPanel.setBorder(BorderFactory.createBevelBorder(1));
        } else {
            retPanel.setBorder(BorderFactory.createBevelBorder(0));
        }
        return retPanel;
    }

    private void setForegroundAllComp(JComponent cmp, Color color) {
        if (cmp != null) {
            cmp.setForeground(color);
            for (Component c : cmp.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                this.setForegroundAllComp((JComponent)c, color);
            }
        }
    }
}

