/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.swing.table.AbstractTableModel;
import jmri.ConsistListListener;
import jmri.DccLocoAddress;
import jmri.jmrit.throttle.AddressPanel;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleWindow;

public class ThrottlesTableModel
extends AbstractTableModel
implements PropertyChangeListener,
ConsistListListener {
    private final List<ThrottleFrame> throttleFrames = new LinkedList<ThrottleFrame>();

    @Override
    public int getRowCount() {
        return this.throttleFrames.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int i, int i1) {
        return this.throttleFrames.get(i);
    }

    public Iterator<ThrottleFrame> iterator() {
        return this.throttleFrames.iterator();
    }

    public void addThrottleFrame(ThrottleWindow tw, ThrottleFrame ntf) {
        int loc = -1;
        int idx = 0;
        for (ThrottleFrame tf : this.throttleFrames) {
            if (tf.getThrottleWindow() == tw) {
                loc = idx;
            }
            ++idx;
        }
        if (loc != -1) {
            this.throttleFrames.add(loc + 1, ntf);
        } else {
            this.throttleFrames.add(ntf);
        }
        this.fireTableDataChanged();
    }

    public int getNumberOfEntriesFor(@CheckForNull DccLocoAddress la) {
        if (la == null) {
            return 0;
        }
        int ret = 0;
        for (ThrottleFrame tf : this.throttleFrames) {
            AddressPanel ap = tf.getAddressPanel();
            if (ap.getThrottle() == null || !la.equals(ap.getCurrentAddress()) && !la.equals(ap.getConsistAddress())) continue;
            ++ret;
        }
        return ret;
    }

    public void removeThrottleFrame(ThrottleFrame tf, DccLocoAddress la) {
        this.throttleFrames.remove(tf);
        this.fireTableDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("SpeedSetting") || e.getPropertyName().equals("SpeedSteps") || e.getPropertyName().equals("IsForward") || e.getPropertyName().equals("ThrottleFrame")) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public void notifyConsistListChanged() {
        this.fireTableDataChanged();
    }
}

