/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import jmri.InstanceManager;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.jmrit.timetable.Bundle;
import jmri.jmrit.timetable.Schedule;
import jmri.jmrit.timetable.TimeTableDataManager;
import jmri.jmrit.timetable.Train;
import jmri.jmrit.timetable.configurexml.TimeTableXml;
import jmri.jmrit.timetable.swing.TimeTableFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Layout
implements VetoableChangeListener {
    public static final String SCALE_RATIO = "ScaleRatio";
    TimeTableDataManager _dm = TimeTableDataManager.getDataManager();
    private final int _layoutId;
    private String _layoutName = Bundle.getMessage("NewLayoutName");
    private Scale _scale = ScaleManager.getScale("HO");
    private int _fastClock = 4;
    private int _throttles = 0;
    private boolean _metric = false;
    private double _ratio = 87.1;
    private double _scaleMK;
    private static final Logger log = LoggerFactory.getLogger(Layout.class);

    public Layout() {
        this._layoutId = this._dm.getNextId("Layout");
        this._dm.addLayout(this._layoutId, this);
        this._scale.addVetoableChangeListener(SCALE_RATIO, this);
        this.setScaleMK();
    }

    public Layout(int layoutId, String layoutName, Scale scale, int fastClock, int throttles, boolean metric) {
        this._layoutId = layoutId;
        this.setLayoutName(layoutName);
        this.setScale(scale);
        this.setFastClock(fastClock);
        this.setThrottles(throttles);
        this.setMetric(metric);
    }

    public Layout getCopy() {
        Layout copy = new Layout();
        copy.setLayoutName(Bundle.getMessage("DuplicateCopyName", this._layoutName));
        copy.setScale(this._scale);
        copy.setFastClock(this._fastClock);
        copy.setThrottles(this._throttles);
        copy.setMetric(this._metric);
        return copy;
    }

    public void setScaleMK() {
        double distance = this._metric ? 1000.0 : 5280.0;
        this._scaleMK = distance / this._ratio / (double)this._fastClock;
        log.debug("scaleMK = {}, scale = {}", (Object)this._scaleMK, (Object)this._scale);
        this._dm.calculateLayoutTrains(this.getLayoutId(), false);
        this._dm.calculateLayoutTrains(this.getLayoutId(), true);
    }

    public double getScaleMK() {
        return this._scaleMK;
    }

    public int getLayoutId() {
        return this._layoutId;
    }

    public String getLayoutName() {
        return this._layoutName;
    }

    public void setLayoutName(String newName) {
        this._layoutName = newName;
    }

    public double getRatio() {
        return this._ratio;
    }

    public Scale getScale() {
        return this._scale;
    }

    public void setScale(Scale newScale) {
        this._scale.removeVetoableChangeListener(SCALE_RATIO, this);
        if (newScale == null) {
            newScale = ScaleManager.getScale("HO");
            log.warn("No scale found, defaulting to HO");
        }
        Scale oldScale = this._scale;
        double oldRatio = this._ratio;
        this._scale = newScale;
        this._ratio = newScale.getScaleRatio();
        try {
            this.setScaleMK();
        }
        catch (IllegalArgumentException ex) {
            this._scale = oldScale;
            this._ratio = oldRatio;
            this.setScaleMK();
            throw ex;
        }
        this._scale.addVetoableChangeListener(SCALE_RATIO, this);
    }

    public int getFastClock() {
        return this._fastClock;
    }

    public void setFastClock(int newClock) {
        if (newClock < 1) {
            throw new IllegalArgumentException("FastClockLt1");
        }
        int oldClock = this._fastClock;
        this._fastClock = newClock;
        try {
            this.setScaleMK();
        }
        catch (IllegalArgumentException ex) {
            this._fastClock = oldClock;
            this.setScaleMK();
            throw ex;
        }
    }

    public int getThrottles() {
        return this._throttles;
    }

    public void setThrottles(int newThrottles) {
        if (newThrottles < 0) {
            throw new IllegalArgumentException("ThrottlesLt0");
        }
        for (Schedule schedule : this._dm.getSchedules(this._layoutId, true)) {
            for (Train train : this._dm.getTrains(schedule.getScheduleId(), 0, true)) {
                if (train.getThrottle() <= newThrottles) continue;
                throw new IllegalArgumentException("ThrottlesInUse");
            }
        }
        this._throttles = newThrottles;
    }

    public boolean getMetric() {
        return this._metric;
    }

    public void setMetric(boolean newMetric) {
        boolean oldMetric = this._metric;
        this._metric = newMetric;
        try {
            this.setScaleMK();
        }
        catch (IllegalArgumentException ex) {
            this._metric = oldMetric;
            this.setScaleMK();
            throw ex;
        }
    }

    public String toString() {
        return this._layoutName;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        log.debug("scale change event: layout = {}, evt = {}", (Object)this._layoutName, (Object)evt);
        double newRatio = (Double)evt.getNewValue();
        if (newRatio < 1.0) {
            throw new PropertyVetoException("Ratio is less than 1", evt);
        }
        double oldRatio = this._ratio;
        this._ratio = newRatio;
        try {
            this.setScaleMK();
        }
        catch (IllegalArgumentException ex) {
            this._ratio = oldRatio;
            this.setScaleMK();
            throw new PropertyVetoException("New ratio causes calc errors", evt);
        }
        TimeTableFrame frame = InstanceManager.getNullableDefault(TimeTableFrame.class);
        if (frame != null) {
            frame.setShowReminder(true);
        } else {
            TimeTableXml.doStore();
        }
    }
}

