/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import jmri.jmrit.timetable.Bundle;
import jmri.jmrit.timetable.TimeTableDataManager;

public class Schedule {
    TimeTableDataManager _dm = TimeTableDataManager.getDataManager();
    private int _scheduleId = 0;
    private int _layoutId = 0;
    private String _scheduleName = Bundle.getMessage("NewScheduleName");
    private String _effDate = Bundle.getMessage("NewScheduleDate");
    private int _startHour = 0;
    private int _duration = 24;

    public Schedule(int layoutId) {
        if (this._dm.getLayout(layoutId) == null) {
            throw new IllegalArgumentException("ScheduleAddFail");
        }
        this._scheduleId = this._dm.getNextId("Schedule");
        this._layoutId = layoutId;
        this._dm.addSchedule(this._scheduleId, this);
    }

    public Schedule(int scheduleId, int layoutId, String scheduleName, String effDate, int startHour, int duration) {
        this._scheduleId = scheduleId;
        this._layoutId = layoutId;
        this.setScheduleName(scheduleName);
        this.setEffDate(effDate);
        this.setStartHour(startHour);
        this.setDuration(duration);
    }

    public Schedule getCopy(int layoutId) {
        if (layoutId == 0) {
            layoutId = this.getLayoutId();
        }
        Schedule copy = new Schedule(layoutId);
        copy.setScheduleName(Bundle.getMessage("DuplicateCopyName", this._scheduleName));
        copy.setEffDate(this._effDate);
        copy.setStartHour(this._startHour);
        copy.setDuration(this._duration);
        return copy;
    }

    public int getScheduleId() {
        return this._scheduleId;
    }

    public int getLayoutId() {
        return this._layoutId;
    }

    public String getScheduleName() {
        return this._scheduleName;
    }

    public void setScheduleName(String newName) {
        this._scheduleName = newName;
    }

    public String getEffDate() {
        return this._effDate;
    }

    public void setEffDate(String newDate) {
        this._effDate = newDate;
    }

    public int getStartHour() {
        return this._startHour;
    }

    public void setStartHour(int newStartHour) {
        if (newStartHour < 0 || newStartHour > 23) {
            throw new IllegalArgumentException("StartHourRange");
        }
        int oldStartHour = this._startHour;
        this._startHour = newStartHour;
        try {
            this._dm.calculateScheduleTrains(this.getScheduleId(), false);
            this._dm.calculateScheduleTrains(this.getScheduleId(), true);
        }
        catch (IllegalArgumentException ex) {
            this._startHour = oldStartHour;
            throw ex;
        }
    }

    public int getDuration() {
        return this._duration;
    }

    public void setDuration(int newDuration) {
        if (newDuration < 1 || newDuration > 24) {
            throw new IllegalArgumentException("DurationRange");
        }
        int oldDuration = this._duration;
        this._duration = newDuration;
        try {
            this._dm.calculateScheduleTrains(this.getScheduleId(), false);
            this._dm.calculateScheduleTrains(this.getScheduleId(), true);
        }
        catch (IllegalArgumentException ex) {
            this._duration = oldDuration;
            throw ex;
        }
    }

    public String toString() {
        return this._scheduleName;
    }
}

