/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import jmri.jmrit.timetable.Bundle;
import jmri.jmrit.timetable.Stop;
import jmri.jmrit.timetable.TimeTableDataManager;

public class Station {
    TimeTableDataManager _dm = TimeTableDataManager.getDataManager();
    private final int _stationId;
    private final int _segmentId;
    private String _stationName = Bundle.getMessage("NewStationName");
    private double _distance = 1.0;
    private boolean _doubleTrack = false;
    private int _sidings = 0;
    private int _staging = 0;

    public Station(int segmentId) {
        if (this._dm.getSegment(segmentId) == null) {
            throw new IllegalArgumentException("StationAddFail");
        }
        this._stationId = this._dm.getNextId("Station");
        this._segmentId = segmentId;
        this._dm.addStation(this._stationId, this);
    }

    public Station(int stationId, int segmentId, String stationName, double distance, boolean doubleTrack, int sidings, int staging) {
        this._stationId = stationId;
        this._segmentId = segmentId;
        this.setStationName(stationName);
        this.setDistance(distance);
        this.setDoubleTrack(doubleTrack);
        this.setSidings(sidings);
        this.setStaging(staging);
    }

    public Station getCopy(int segmentId) {
        if (segmentId == 0) {
            segmentId = this.getSegmentId();
        }
        Station copy = new Station(segmentId);
        copy.setStationName(Bundle.getMessage("DuplicateCopyName", this._stationName));
        copy.setDistance(this._distance);
        copy.setDoubleTrack(this._doubleTrack);
        copy.setSidings(this._sidings);
        copy.setStaging(this._staging);
        return copy;
    }

    public int getStationId() {
        return this._stationId;
    }

    public int getSegmentId() {
        return this._segmentId;
    }

    public String getStationName() {
        return this._stationName;
    }

    public void setStationName(String newName) {
        this._stationName = newName;
    }

    public double getDistance() {
        return this._distance;
    }

    public void setDistance(double newDistance) {
        if (newDistance < 0.0) {
            throw new IllegalArgumentException("DistanceLt0");
        }
        double oldDistance = this._distance;
        this._distance = newDistance;
        try {
            int layoutId = this._dm.getSegment(this.getSegmentId()).getLayoutId();
            this._dm.calculateLayoutTrains(layoutId, false);
            this._dm.calculateLayoutTrains(layoutId, true);
        }
        catch (IllegalArgumentException ex) {
            this._distance = oldDistance;
            throw ex;
        }
    }

    public boolean getDoubleTrack() {
        return this._doubleTrack;
    }

    public void setDoubleTrack(boolean newDoubleTrack) {
        this._doubleTrack = newDoubleTrack;
    }

    public int getSidings() {
        return this._sidings;
    }

    public void setSidings(int newSidings) {
        if (newSidings < 0) {
            throw new IllegalArgumentException("SidingsLt0");
        }
        this._sidings = newSidings;
    }

    public int getStaging() {
        return this._staging;
    }

    public void setStaging(int newStaging) {
        if (newStaging < 0) {
            throw new IllegalArgumentException("StagingLt0");
        }
        for (Stop stop : this._dm.getStops(0, this.getStationId(), false)) {
            if (stop.getStagingTrack() <= newStaging) continue;
            throw new IllegalArgumentException("StagingInUse");
        }
        this._staging = newStaging;
    }

    public String toString() {
        return this._stationName;
    }
}

