/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jmri.jmrit.timetable.Layout;
import jmri.jmrit.timetable.Schedule;
import jmri.jmrit.timetable.Segment;
import jmri.jmrit.timetable.Station;
import jmri.jmrit.timetable.Stop;
import jmri.jmrit.timetable.TimeTableDataManager;
import jmri.jmrit.timetable.Train;
import jmri.jmrit.timetable.swing.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTableGraphCommon {
    final Font _stdFont = new Font("SansSerif", 0, 10);
    final Font _smallFont = new Font("SansSerif", 0, 8);
    static final BasicStroke gridstroke = new BasicStroke(0.5f);
    static final BasicStroke stroke = new BasicStroke(2.0f);
    TimeTableDataManager _dataMgr;
    int _segmentId;
    int _scheduleId;
    Layout _layout;
    int _throttles;
    Segment _segment;
    Schedule _schedule;
    int _startHour;
    int _duration;
    List<Station> _stations;
    List<Train> _trains;
    List<Stop> _stops;
    HashMap<Integer, Double> _stationGrid = new HashMap();
    HashMap<Integer, Double> _hourMap = new HashMap();
    ArrayList<Double> _hourGrid = new ArrayList();
    int _infoColWidth = 0;
    double _hourOffset = 0.0;
    double _graphHeight = 0.0;
    double _graphWidth = 0.0;
    double _graphTop = 0.0;
    double _graphBottom = 0.0;
    double _graphLeft = 0.0;
    double _graphRight = 0.0;
    Graphics2D _g2;
    boolean _showTrainTimes;
    PageFormat _pf;
    double _dimHeight = 0.0;
    double _dimWidth = 0.0;
    ArrayList<Rectangle2D> _textLocation = new ArrayList();
    String _trainName;
    int _trainThrottle;
    Color _trainColor;
    Path2D _trainLine;
    int _stopCnt;
    int _stopIdx;
    int _arriveTime;
    int _departTime;
    double _maxDistance;
    String _direction;
    boolean _firstStop;
    boolean _lastStop;
    double _firstX;
    double _lastX;
    double _sizeMinute;
    double _throttleX;
    private static final Logger log = LoggerFactory.getLogger(TimeTableGraphCommon.class);

    void init(int segmentId, int scheduleId, boolean showTrainTimes, double height, double width, boolean displayType) {
        this._segmentId = segmentId;
        this._scheduleId = scheduleId;
        this._showTrainTimes = showTrainTimes;
        this._dataMgr = TimeTableDataManager.getDataManager();
        this._segment = this._dataMgr.getSegment(this._segmentId);
        this._layout = this._dataMgr.getLayout(this._segment.getLayoutId());
        this._throttles = this._layout.getThrottles();
        this._schedule = this._dataMgr.getSchedule(this._scheduleId);
        this._startHour = this._schedule.getStartHour();
        this._duration = this._schedule.getDuration();
        this._stations = this._dataMgr.getStations(this._segmentId, true);
        this._trains = this._dataMgr.getTrains(this._scheduleId, 0, true);
        this._dimHeight = height;
        this._dimWidth = width;
    }

    public void doPaint(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            throw new IllegalArgumentException();
        }
        this._g2 = (Graphics2D)g;
        this._g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._stationGrid.clear();
        this._hourGrid.clear();
        this._textLocation.clear();
        this._graphTop = 70.0;
        if (this._layout.getThrottles() > 4) {
            this._graphTop = (double)this._layout.getThrottles() * 15.0;
        }
        this._graphHeight = this._dimHeight - this._graphTop - 30.0;
        this._graphBottom = this._graphTop + this._graphHeight;
        this.drawInfoSection();
        this.drawStationSection();
        this._graphLeft = (double)this._infoColWidth + 50.0;
        this._graphWidth = this._dimWidth - (double)this._infoColWidth - 65.0;
        this._graphRight = this._graphLeft + this._graphWidth;
        this.drawHours();
        this.drawThrottleNumbers();
        this.drawGraphGrid();
        this.drawTrains();
    }

    void drawInfoSection() {
        this._g2.setFont(this._stdFont);
        this._g2.setColor(Color.BLACK);
        String layoutName = String.format("%s %s", Bundle.getMessage("LabelLayoutName"), this._layout.getLayoutName());
        String segmentName = String.format("%s %s", Bundle.getMessage("LabelSegmentName"), this._segment.getSegmentName());
        String scheduleName = String.format("%s %s", Bundle.getMessage("LabelScheduleName"), this._schedule.getScheduleName());
        String effDate = String.format("%s %s", Bundle.getMessage("LabelEffDate"), this._schedule.getEffDate());
        this._infoColWidth = Math.max(this._infoColWidth, this._g2.getFontMetrics().stringWidth(layoutName));
        this._infoColWidth = Math.max(this._infoColWidth, this._g2.getFontMetrics().stringWidth(scheduleName));
        this._infoColWidth = Math.max(this._infoColWidth, this._g2.getFontMetrics().stringWidth(effDate));
        this._g2.drawString(layoutName, 10, 20);
        this._g2.drawString(segmentName, 10, 40);
        this._g2.drawString(scheduleName, 10, 60);
        this._g2.drawString(effDate, 10, 80);
    }

    void drawStationSection() {
        this._maxDistance = this._stations.get(this._stations.size() - 1).getDistance();
        this._g2.setFont(this._stdFont);
        this._g2.setColor(Color.BLACK);
        this._stationGrid.clear();
        for (Station station : this._stations) {
            String stationName = station.getStationName();
            this._infoColWidth = Math.max(this._infoColWidth, this._g2.getFontMetrics().stringWidth(stationName) + 5);
            double distance = station.getDistance();
            double stationY = (this._graphHeight - 50.0) / this._maxDistance * distance + this._graphTop + 30.0;
            this._g2.drawString(stationName, 15.0f, (float)stationY);
            this._stationGrid.put(station.getStationId(), stationY);
        }
    }

    void drawHours() {
        int currentHour = this._startHour;
        double hourWidth = this._graphWidth / (double)(this._duration + 1);
        this._hourOffset = hourWidth / 2.0;
        this._g2.setFont(this._stdFont);
        this._g2.setColor(Color.BLACK);
        this._hourGrid.clear();
        for (int i = 0; i <= this._duration; ++i) {
            String hourString = Integer.toString(currentHour);
            double hourX = hourWidth * (double)i + this._hourOffset + this._graphLeft;
            int hOffset = this._g2.getFontMetrics().stringWidth(hourString) / 2;
            this._g2.drawString(hourString, (float)hourX - (float)hOffset, (float)this._graphBottom + 20.0f);
            if (i < this._duration) {
                this._hourMap.put(currentHour, hourX);
            }
            this._hourGrid.add(hourX);
            if (i == 0) {
                this._firstX = hourX - (double)hOffset;
            }
            if (i == this._duration) {
                this._lastX = hourX - (double)hOffset;
            }
            if (++currentHour <= 23) continue;
            currentHour -= 24;
        }
    }

    void drawThrottleNumbers() {
        this._g2.setFont(this._smallFont);
        this._g2.setColor(Color.BLACK);
        for (int i = 1; i <= this._throttles; ++i) {
            this._g2.drawString(Integer.toString(i), (float)this._graphLeft, (float)i * 14.0f);
        }
    }

    void drawGraphGrid() {
        this._g2.draw(new Rectangle2D.Double(this._graphLeft, this._graphTop, this._graphWidth, this._graphHeight));
        this._g2.setStroke(gridstroke);
        this._g2.setColor(Color.GRAY);
        this._stationGrid.forEach((i, y) -> this._g2.draw(new Line2D.Double(this._graphLeft, (double)y, this._graphRight, (double)y)));
        this._hourGrid.forEach(x -> this._g2.draw(new Line2D.Double((double)x, this._graphTop, (double)x, this._graphBottom)));
    }

    void drawTrains() {
        this._sizeMinute = this._graphWidth / (double)((this._duration + 1) * 60);
        this._throttleX = 0.0;
        block0: for (Train train : this._trains) {
            this._trainName = train.getTrainName();
            this._trainThrottle = train.getThrottle();
            String typeColor = train.getTypeId() == 0 ? "#000000" : this._dataMgr.getTrainType(train.getTypeId()).getTypeColor();
            this._trainColor = Color.decode(typeColor);
            this._trainLine = new Path2D.Double();
            boolean activeSeg = false;
            this._stops = this._dataMgr.getStops(train.getTrainId(), 0, true);
            this._stopCnt = this._stops.size();
            this._firstStop = true;
            this._lastStop = false;
            this._stopIdx = 0;
            while (this._stopIdx < this._stopCnt) {
                Stop stop = this._stops.get(this._stopIdx);
                this._arriveTime = stop.getArriveTime();
                this._departTime = stop.getDepartTime();
                Station stopStation = this._dataMgr.getStation(stop.getStationId());
                int stopSegmentId = stopStation.getSegmentId();
                if (this._stopIdx > 0) {
                    this._firstStop = false;
                }
                if (this._stopIdx == this._stopCnt - 1) {
                    this._lastStop = true;
                }
                if (!activeSeg) {
                    if (stopSegmentId == this._segmentId) {
                        activeSeg = true;
                        this.setBegin(stop);
                        if (this._lastStop) {
                            this.setEnd(stop, false);
                            continue block0;
                        }
                    }
                } else if (stopSegmentId != this._segmentId) {
                    this.setEnd(stop, true);
                    activeSeg = false;
                } else {
                    this.drawLine(stop);
                    if (this._lastStop) {
                        this.setEnd(stop, false);
                        continue block0;
                    }
                }
                ++this._stopIdx;
            }
        }
    }

    void drawTrainName(double x, double y, String justify, boolean invert, boolean throttle) {
        Rectangle2D textRect = this._g2.getFontMetrics().getStringBounds(this._trainName, this._g2);
        if (justify.equals("Center")) {
            x -= textRect.getWidth() / 2.0;
        } else if (justify.equals("Right")) {
            x -= textRect.getWidth();
        }
        y = invert ? (y += (double)(this._direction.equals("down") || throttle ? -7 : 13)) : (y += (double)(this._direction.equals("down") || throttle ? 13 : -7));
        textRect.setRect(x, y, textRect.getWidth(), textRect.getHeight());
        textRect = this.adjustText(textRect);
        x = textRect.getX();
        this._g2.setFont(this._stdFont);
        this._g2.setColor(Color.BLACK);
        this._g2.drawString(this._trainName, (float)x, (float)y);
        this._textLocation.add(textRect);
    }

    void drawTrainTime(int time, String mode, double x, double y) {
        if (!this._showTrainTimes) {
            return;
        }
        String minutes = String.format("%02d", time % 60);
        Rectangle2D textRect = this._g2.getFontMetrics().getStringBounds(minutes, this._g2);
        switch (mode) {
            case "begin": {
                x += (double)(this._direction.equals("down") ? 2 : 2);
                y += (double)(this._direction.equals("down") ? 10 : -1);
                break;
            }
            case "arrive": {
                x += (double)(this._direction.equals("down") ? 2 : 3);
                y += (double)(this._direction.equals("down") ? -2 : 10);
                break;
            }
            case "depart": {
                x += (double)(this._direction.equals("down") ? 2 : 2);
                y += (double)(this._direction.equals("down") ? 10 : -2);
                break;
            }
            case "end": {
                x += (double)(this._direction.equals("down") ? false : false);
                y += (double)(this._direction.equals("down") ? false : false);
                break;
            }
            default: {
                log.error("drawTrainTime mode {} is unknown", (Object)mode);
                return;
            }
        }
        textRect.setRect(x, y, textRect.getWidth(), textRect.getHeight());
        textRect = this.adjustText(textRect);
        x = textRect.getX();
        this._g2.setFont(this._smallFont);
        this._g2.setColor(Color.GRAY);
        this._g2.drawString(minutes, (float)x, (float)y);
        this._textLocation.add(textRect);
    }

    Rectangle2D adjustText(Rectangle2D textRect) {
        double xLoc = textRect.getX();
        double yLoc = textRect.getY();
        double xLen = textRect.getWidth();
        double wrkX = xLoc;
        boolean chgX = false;
        for (Rectangle2D workRect : this._textLocation) {
            if (workRect.getY() != yLoc) continue;
            double xMin = workRect.getX();
            double xMax = xMin + workRect.getWidth();
            if (xLoc > xMin && xLoc < xMax) {
                wrkX = xMax + 2.0;
                chgX = true;
            }
            if (!(xLoc + xLen > xMin) || !(xLoc + xLen < xMax)) continue;
            wrkX = xMin - xLen - 2.0;
            chgX = true;
        }
        if (chgX) {
            textRect.setRect(wrkX, yLoc, textRect.getWidth(), textRect.getHeight());
        }
        return textRect;
    }

    void setDirection() {
        Station nextStation;
        if (this._stopCnt == 1) {
            this._direction = "down";
            return;
        }
        Stop stop = this._stops.get(this._stopIdx);
        Station currStation = this._dataMgr.getStation(stop.getStationId());
        double currDistance = currStation.getDistance();
        if (this._firstStop) {
            Station nextStation2 = this._dataMgr.getStation(this._stops.get(this._stopIdx + 1).getStationId());
            this._direction = nextStation2.getDistance() > currDistance ? "down" : "up";
            return;
        }
        Station prevStation = this._dataMgr.getStation(this._stops.get(this._stopIdx - 1).getStationId());
        if (this._lastStop && prevStation.getSegmentId() == this._segmentId) {
            this._direction = prevStation.getDistance() < currDistance ? "down" : "up";
            return;
        }
        if (prevStation.getSegmentId() != this._segmentId) {
            String prevName = prevStation.getStationName();
            for (Station segStation : this._stations) {
                if (!segStation.getStationName().equals(prevName)) continue;
                this._direction = segStation.getDistance() < currDistance ? "down" : "up";
                return;
            }
        }
        if (!this._lastStop && (nextStation = this._dataMgr.getStation(this._stops.get(this._stopIdx + 1).getStationId())).getSegmentId() == this._segmentId) {
            this._direction = nextStation.getDistance() > currDistance ? "down" : "up";
            return;
        }
    }

    void setBegin(Stop stop) {
        double y;
        double x;
        boolean segmentChange = false;
        if (this._stopIdx > 0) {
            segmentChange = true;
            Stop prevStop = this._stops.get(this._stopIdx - 1);
            Station prevStation = this._dataMgr.getStation(prevStop.getStationId());
            String prevName = prevStation.getStationName();
            for (Station segStation : this._stations) {
                if (!segStation.getStationName().equals(prevName)) continue;
                x = this.calculateX(prevStop.getDepartTime());
                y = this._stationGrid.get(segStation.getStationId());
                this._trainLine.moveTo(x, y);
                this._throttleX = x;
                this.setDirection();
                this.drawTrainName(x, y, "Center", true, false);
                this.drawTrainTime(prevStop.getDepartTime(), "begin", x, y);
                break;
            }
        }
        x = this.calculateX(stop.getArriveTime());
        y = this._stationGrid.get(stop.getStationId());
        if (segmentChange) {
            this._trainLine.lineTo(x, y);
            this.setDirection();
            this.drawTrainTime(stop.getArriveTime(), "arrive", x, y);
        } else {
            this._trainLine.moveTo(x, y);
            this._throttleX = x;
            this.setDirection();
            this.drawTrainName(x, y, "Center", true, false);
            this.drawTrainTime(stop.getArriveTime(), "begin", x, y);
        }
        if (stop.getDuration() > 0) {
            x = this.calculateX(stop.getDepartTime());
            this._trainLine.lineTo(x, y);
            this.drawTrainTime(stop.getDepartTime(), "depart", x, y);
        }
    }

    void drawLine(Stop stop) {
        double x = this.calculateX(this._arriveTime);
        double y = this._stationGrid.get(stop.getStationId());
        this._trainLine.lineTo(x, y);
        this.drawTrainTime(this._arriveTime, "arrive", x, y);
        this.setDirection();
        if (stop.getDuration() > 0) {
            x = this.calculateX(this._departTime);
            if (x < this._trainLine.getCurrentPoint().getX()) {
                this._trainLine.lineTo(this._graphRight - this._hourOffset, y);
                this.drawTrainName(this._graphRight - this._hourOffset, y, "Right", false, false);
                this._trainLine.moveTo(this._graphLeft + this._hourOffset, y);
                this._trainLine.lineTo(x, y);
                this.drawTrainName(this._graphLeft + this._hourOffset, y, "Left", true, false);
                this.drawTrainTime(this._departTime, "depart", x, y);
            } else {
                this._trainLine.lineTo(x, y);
                this.drawTrainTime(this._departTime, "depart", x, y);
            }
        }
    }

    void setEnd(Stop stop, boolean endSegment) {
        double y;
        double x;
        boolean skipLine = false;
        if (this._stops.size() == 1 || endSegment) {
            x = this._trainLine.getCurrentPoint().getX();
            y = this._trainLine.getCurrentPoint().getY();
            skipLine = true;
        } else {
            x = this.calculateX(this._arriveTime);
            y = this._stationGrid.get(stop.getStationId());
        }
        this.drawTrainName(x, y, "Center", false, false);
        this._g2.setColor(this._trainColor);
        this._g2.setStroke(stroke);
        if (!skipLine) {
            this._trainLine.lineTo(x, y);
        }
        this._g2.draw(this._trainLine);
        if (this._trainThrottle > 0) {
            this._g2.setFont(this._smallFont);
            double throttleY = this._trainThrottle * 14;
            if (x < this._throttleX) {
                this._g2.draw(new Line2D.Double(this._throttleX, throttleY, this._graphRight - this._hourOffset, throttleY));
                this._g2.draw(new Line2D.Double(this._graphLeft + this._hourOffset, throttleY, x, throttleY));
                this.drawTrainName(this._throttleX + 10.0, throttleY + 5.0, "Left", true, true);
                this.drawTrainName(this._graphLeft + this._hourOffset + 10.0, throttleY + 5.0, "Left", true, true);
            } else {
                this._g2.draw(new Line2D.Double(this._throttleX, throttleY, x, throttleY));
                this.drawTrainName(this._throttleX + 10.0, throttleY + 5.0, "Left", true, true);
            }
        }
    }

    double calculateX(int time) {
        if (time < 0) {
            time = 0;
        }
        if (time > 1439) {
            time = 1439;
        }
        int hour = time / 60;
        int min = time % 60;
        return this._hourMap.get(hour) + (double)min * this._sizeMinute;
    }
}

