/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.tracker;

import jmri.Block;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTracker {
    private final NamedBeanHandle<Memory> namedMemory;
    private final Block block;
    private static final Logger log = LoggerFactory.getLogger(MemoryTracker.class);

    public MemoryTracker(Block b, String namePrefix) throws IllegalArgumentException {
        this.block = b;
        Memory m = InstanceManager.memoryManagerInstance().provideMemory(namePrefix + this.block.getSystemName());
        this.namedMemory = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(namePrefix + this.block.getSystemName(), m);
        this.block.addPropertyChangeListener(e -> this.handleChange());
        this.handleChange();
    }

    private void handleChange() {
        Object o;
        if (log.isDebugEnabled() && this.block.getValue() != null) {
            log.debug("set value {} in block {}", this.block.getValue(), (Object)this.block.getSystemName());
        }
        if ((o = this.block.getValue()) != null) {
            o = o.toString();
        }
        this.namedMemory.getBean().setValue(o);
    }
}

