/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.tracker;

import java.beans.PropertyChangeEvent;
import jmri.Block;
import jmri.SignalHead;
import jmri.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoppingBlock {
    Block block;
    SignalHead sig1;
    SignalHead sig2;
    int direction;
    private float slow = 0.3f;
    private float fast = 0.6f;
    private static final Logger log = LoggerFactory.getLogger(StoppingBlock.class);

    public StoppingBlock(Block b) {
        this.block = b;
        this.block.addPropertyChangeListener(this::handleBlockChange);
    }

    void handleBlockChange(PropertyChangeEvent e) {
        if ("state".equals(e.getPropertyName()) && e.getNewValue().equals(2)) {
            if (this.sig1 == null) {
                return;
            }
            if (this.direction != this.block.getDirection()) {
                return;
            }
            int val = this.fastestAppearance();
            if (log.isDebugEnabled()) {
                log.debug("Block {} occupied with {}", (Object)this.block.getSystemName(), (Object)val);
            }
            if (val == 1) {
                this.doStop();
            }
            if (val == 4) {
                this.doSlow();
            }
        }
    }

    void handleSignalChange(PropertyChangeEvent e) {
        if (this.block.getValue() != null && this.block.getState() == 2) {
            if (this.sig1 == null) {
                return;
            }
            if (this.direction != this.block.getDirection()) {
                return;
            }
            int val = this.fastestAppearance();
            log.debug("Block {} signal change to {}", (Object)this.block, (Object)val);
            if (val == 4) {
                this.doSlow();
            }
            if (val == 16) {
                this.doRestart();
            }
        }
    }

    public void addSignal(SignalHead s, int dir) {
        this.sig1 = s;
        this.direction = dir;
        this.sig1.addPropertyChangeListener(this::handleSignalChange);
    }

    public void addSignal(SignalHead s1, SignalHead s2, int dir) {
        this.addSignal(s1, dir);
        this.sig2 = s2;
        this.sig2.addPropertyChangeListener(this::handleSignalChange);
    }

    int fastestAppearance() {
        if (this.sig1 == null) {
            log.error("Should not get null in fastestAppearance");
            return 0;
        }
        if (this.sig2 == null) {
            return this.sig1.getAppearance();
        }
        return Math.max(this.sig1.getAppearance(), this.sig2.getAppearance());
    }

    void doStop() {
        log.debug("Block {} speed being set to stop", (Object)this.block.getDisplayName());
        this.setSpeed(0.0f, false, false, false);
    }

    void doSlow() {
        log.debug("Block {} speed being set to slow", (Object)this.block.getDisplayName());
        this.setSpeed(this.slow, false, false, false);
    }

    void doRestart() {
        log.debug("Block {} speed being set to run", (Object)this.block.getDisplayName());
        this.setSpeed(this.fast, false, false, false);
    }

    void setSpeed(float speed, boolean f1, boolean f2, boolean f3) {
        Object o = this.block.getValue();
        if (o == null) {
            log.error("Block {} contained no Throttle object", (Object)this.block.getDisplayName());
            return;
        }
        if (o instanceof Throttle) {
            Throttle t = (Throttle)o;
            t.setSpeedSetting(speed);
            t.setFunction(1, f1);
            t.setFunction(2, f2);
        } else {
            log.error("Block {} did not contain object of Throttle type, was {} , a {}", new Object[]{this.block.getDisplayName(), o, o.getClass()});
        }
    }

    public void setSpeeds(float s, float f) {
        this.slow = s;
        this.fast = f;
    }
}

