/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.turnoutoperations;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import jmri.InstanceManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.TurnoutOperation;
import jmri.TurnoutOperationManager;
import jmri.jmrit.turnoutoperations.Bundle;
import jmri.jmrit.turnoutoperations.TurnoutOperationConfig;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutOperationFrame
extends JDialog {
    TurnoutOperationConfig currentConfig = null;
    TurnoutOperation currentOperation = null;
    String previousSelectionName = "";
    JTabbedPane tabPane;
    private JButton deleteButton;
    private JButton renameOrCopyButton;
    private final PropertyChangeListener pcl = e -> {
        if (e.getPropertyName().equals("Content")) {
            this.populateTabs();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(TurnoutOperationFrame.class);

    public TurnoutOperationFrame(Frame parent) {
        super(parent, Bundle.getMessage("TurnoutOperationEditorTitle"));
        this.init();
    }

    private void init() {
        Container contentPane = this.getContentPane();
        this.setMinimumSize(new Dimension(400, 165));
        Box outerBox = Box.createVerticalBox();
        contentPane.add(outerBox);
        this.tabPane = new JTabbedPane();
        this.tabPane.addChangeListener(this::changeTab);
        outerBox.add(this.tabPane);
        Box bottomBox = Box.createHorizontalBox();
        bottomBox.add(Box.createHorizontalGlue());
        this.renameOrCopyButton = new JButton("RenameOrCopy");
        this.renameOrCopyButton.addActionListener(this::doRenameOrCopy);
        bottomBox.add(this.renameOrCopyButton);
        this.deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
        this.deleteButton.addActionListener(this::doDelete);
        bottomBox.add(this.deleteButton);
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(a -> this.dispose());
        bottomBox.add(cancelButton);
        JButton okButton = new JButton(Bundle.getMessage("ButtonOK"));
        okButton.addActionListener(this::doOK);
        bottomBox.add(okButton);
        outerBox.add(bottomBox);
        this.populateTabs();
        InstanceManager.getDefault(TurnoutOperationManager.class).addPropertyChangeListener(this.pcl);
        this.setVisible(this.tabPane.getTabCount() > 0);
    }

    private void doOK(ActionEvent e) {
        log.debug("OK clicked {}", (Object)e);
        for (Component tab : this.tabPane.getComponents()) {
            ((TurnoutOperationConfig)tab).endConfigure();
        }
        this.dispose();
    }

    private void doDelete(ActionEvent e) {
        log.debug("Delete clicked {}", (Object)e);
        Object query = "";
        if (this.currentOperation != null && !this.currentOperation.isDefinitive()) {
            if (this.currentOperation.isInUse()) {
                query = Bundle.getMessage("DeleteOperationInUse", this.currentOperation.getName()) + Bundle.getMessage("DeleteRevert");
            }
            if (JmriJOptionPane.showConfirmDialog(this, (String)query + Bundle.getMessage("DeleteOperationDialog", this.currentOperation.getName()), Bundle.getMessage("WarningTitle"), 0) == 0) {
                this.currentOperation.dispose();
                this.populateTabs();
            }
        }
    }

    private void doRenameOrCopy(ActionEvent e) {
        log.debug("CopyOr clicked {}", (Object)e);
        String newName = JmriJOptionPane.showInputDialog(this, Bundle.getMessage("EnterNewName"), Bundle.getMessage("EnterNewNameTitle"), 3);
        if (newName != null && !newName.isEmpty()) {
            if (this.currentOperation.isDefinitive()) {
                this.currentOperation.makeCopy(newName);
            } else {
                if (!this.currentOperation.rename(newName)) {
                    JmriJOptionPane.showMessageDialog(this, "TurnoutErrorDuplicate", Bundle.getMessage("WarningTitle"), 0);
                    return;
                }
                for (Turnout t : InstanceManager.getDefault(TurnoutManager.class).getNamedBeanSet()) {
                    if (!this.currentOperation.equivalentTo(t.getTurnoutOperation())) continue;
                    t.setTurnoutOperation(null);
                    t.setTurnoutOperation(this.currentOperation);
                }
            }
            this.populateTabs();
        }
    }

    private void populateTabs() {
        TurnoutOperationConfig pane;
        TurnoutOperation[] operations = InstanceManager.getDefault(TurnoutOperationManager.class).getTurnoutOperations();
        log.debug("found {} turnoutoperations from TurnoutOperationManager", (Object)operations.length);
        TurnoutOperationConfig firstPane = null;
        this.tabPane.removeAll();
        ArrayList<TurnoutOperation> definitiveOperations = new ArrayList<TurnoutOperation>(10);
        ArrayList<TurnoutOperation> namedOperations = new ArrayList<TurnoutOperation>(50);
        for (TurnoutOperation operation : operations) {
            if (operation.isDefinitive()) {
                definitiveOperations.add(operation);
                continue;
            }
            if (operation.isNonce()) continue;
            namedOperations.add(operation);
        }
        definitiveOperations.sort(null);
        namedOperations.sort(null);
        for (int j = 0; j < definitiveOperations.size(); ++j) {
            TurnoutOperation op = (TurnoutOperation)definitiveOperations.get(j);
            pane = TurnoutOperationConfig.getConfigPanel(op);
            if (pane == null) continue;
            if (firstPane == null) {
                firstPane = pane;
            }
            this.tabPane.add(op.getName(), pane);
            if (!op.getName().equals(this.previousSelectionName)) continue;
            this.tabPane.setSelectedComponent(pane);
        }
        for (int k = 0; k < namedOperations.size(); ++k) {
            TurnoutOperation op = (TurnoutOperation)namedOperations.get(k);
            pane = TurnoutOperationConfig.getConfigPanel(op);
            if (pane == null) continue;
            this.tabPane.add(op.getName(), pane);
            if (!op.getName().equals(this.previousSelectionName)) continue;
            this.tabPane.setSelectedComponent(pane);
        }
        if (this.tabPane.getSelectedComponent() == null && firstPane != null) {
            this.tabPane.setSelectedComponent(firstPane);
        }
        this.changeTab(null);
        this.pack();
    }

    private void changeTab(ChangeEvent e) {
        log.debug("tab changed {}", (Object)e);
        this.currentConfig = (TurnoutOperationConfig)this.tabPane.getSelectedComponent();
        if (this.currentConfig == null) {
            this.currentOperation = null;
            this.previousSelectionName = "";
        } else {
            this.currentOperation = this.currentConfig.getOperation();
            this.previousSelectionName = this.currentOperation.getName();
        }
        this.deleteButton.setEnabled(this.currentConfig != null && !this.currentConfig.getOperation().isDefinitive());
        this.renameOrCopyButton.setText(this.currentConfig != null && !this.currentConfig.getOperation().isDefinitive() ? Bundle.getMessage("Rename") : Bundle.getMessage("MenuItemCopy"));
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        InstanceManager.getDefault(TurnoutOperationManager.class).removePropertyChangeListener(this.pcl);
        super.dispose();
    }
}

