/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.text.MessageFormat;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.Sensor;
import jmri.Turnout;
import jmri.jmrit.ussctc.Bundle;
import jmri.jmrit.ussctc.Constants;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePanel
extends JPanel
implements Constants {
    private static final Logger log = LoggerFactory.getLogger(BasePanel.class);

    BasePanel() {
    }

    void complain(String message, String value) {
        JmriJOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage(message), value), Bundle.getMessage("ErrorTitle"), 0);
    }

    boolean validateTurnout(String name) {
        Turnout t = null;
        try {
            t = InstanceManager.turnoutManagerInstance().provideTurnout(name);
        }
        catch (IllegalArgumentException e) {
            log.debug("could not create turnout \"{}\"", (Object)name);
        }
        if (t == null) {
            this.complain("ErrorNoTurnoutMatch", name);
            return false;
        }
        return true;
    }

    boolean validateSensor(String name) {
        Sensor t = null;
        try {
            t = InstanceManager.sensorManagerInstance().provideSensor(name);
        }
        catch (IllegalArgumentException e) {
            log.debug("could not create sensor \"{}\"", (Object)name);
        }
        if (t == null) {
            this.complain("ErrorNoSensorMatch", name);
            return false;
        }
        return true;
    }

    boolean validateMemory(String name) {
        Memory t = null;
        try {
            t = InstanceManager.memoryManagerInstance().provideMemory(name);
        }
        catch (IllegalArgumentException e) {
            log.debug("could not create memory \"{}\"", (Object)name);
        }
        if (t == null) {
            this.complain("ErrorNoMemoryMatch", name);
            return false;
        }
        return true;
    }
}

