/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.beans.PropertyChangeEvent;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.ussctc.Station;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeButton {
    Station<?, ?> station;
    NamedBeanHandle<Sensor> hButtonSensor;
    NamedBeanHandle<Turnout> hPanelIndicator;
    private static final Logger log = LoggerFactory.getLogger(CodeButton.class);

    public CodeButton(String buttonSensor, String panelIndicator) {
        NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
        TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
        SensorManager sm = InstanceManager.getDefault(SensorManager.class);
        this.hButtonSensor = hm.getNamedBeanHandle(buttonSensor, sm.provideSensor(buttonSensor));
        this.hPanelIndicator = hm.getNamedBeanHandle(panelIndicator, tm.provideTurnout(panelIndicator));
        sm.provideSensor(buttonSensor).addPropertyChangeListener(e -> this.layoutSensorChanged(e));
    }

    CodeButton addStation(Station<?, ?> station) {
        this.station = station;
        return this;
    }

    void layoutSensorChanged(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState") && e.getNewValue().equals(2) && !e.getOldValue().equals(2)) {
            this.codeButtonPressed();
        }
    }

    void codeButtonPressed() {
        log.debug("Code button pressed");
        log.debug("Code light on - codeButtonPressed");
        this.hPanelIndicator.getBean().setCommandedState(4);
        this.station.codeSendRequest();
    }

    void codeValueDelivered() {
        log.debug("Code light off - codeValueDelivered");
        this.hPanelIndicator.getBean().setCommandedState(2);
    }

    void indicationStart() {
        log.debug("Code light on - indicationStart");
        this.hPanelIndicator.getBean().setCommandedState(4);
    }

    void indicationComplete() {
        log.debug("Code light off - indicationComplete");
        this.hPanelIndicator.getBean().setCommandedState(2);
    }
}

