/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Route;
import jmri.RouteManager;
import jmri.implementation.DefaultRoute;
import jmri.jmrit.ussctc.Constants;

public class Follower
implements Constants {
    static String routePrefix = InstanceManager.getDefault(RouteManager.class).getSystemNamePrefix();
    static final String namePrefix = routePrefix + ":USS CTC:FOLLOWER:1:";
    String output;
    String sensor;
    String veto;
    boolean invert;

    public Follower(String output, String sensor, boolean invert, String veto) {
        this.veto = veto;
        this.sensor = sensor;
        this.invert = invert;
        this.output = output;
    }

    public void instantiate() {
        Route rc;
        String nameT = namePrefix + "T:" + this.output;
        String nameC = namePrefix + "C:" + this.output;
        RouteManager rm = InstanceManager.getDefault(RouteManager.class);
        Route rt = rm.getBySystemName(nameT);
        if (rt != null) {
            rt.deActivateRoute();
            rm.deleteRoute(rt);
        }
        if ((rc = rm.getBySystemName(nameC)) != null) {
            rc.deActivateRoute();
            rm.deleteRoute(rc);
        }
        rt = new DefaultRoute(nameT);
        rc = new DefaultRoute(nameC);
        rt.addSensorToRoute(this.sensor, this.invert ? 1 : 0);
        rc.addSensorToRoute(this.sensor, !this.invert ? 1 : 0);
        if (!this.veto.isEmpty()) {
            rt.addSensorToRoute(this.veto, 2);
            rc.addSensorToRoute(this.veto, 2);
        }
        rt.addOutputTurnout(this.output, 4);
        rc.addOutputTurnout(this.output, 2);
        rt.activateRoute();
        rc.activateRoute();
        rm.register(rt);
        rm.register(rc);
    }

    public Follower(String outputName) throws JmriException {
        this.output = outputName;
        String nameT = namePrefix + "T:" + this.output;
        RouteManager rm = InstanceManager.getDefault(RouteManager.class);
        Route r = rm.getBySystemName(nameT);
        if (r == null) {
            throw new JmriException("Route does not exist");
        }
        this.sensor = r.getRouteSensorName(0);
        this.invert = r.getRouteSensorMode(0) == 1;
        this.veto = r.getRouteSensorName(1);
        if (this.veto == null) {
            this.veto = "";
        }
    }

    public String getOutputName() {
        return this.output;
    }

    public String getSensorName() {
        return this.sensor;
    }

    public boolean getInvert() {
        return this.invert;
    }

    public String getVetoName() {
        return this.veto;
    }
}

