/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.JmriException;
import jmri.jmrit.ussctc.BasePanel;
import jmri.jmrit.ussctc.Bundle;
import jmri.jmrit.ussctc.Follower;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowerPanel
extends BasePanel {
    JTextField outputName;
    JTextField sensorName;
    JTextField vetoName;
    JCheckBox invert;
    JButton viewButton;
    JButton addButton;
    private static final Logger log = LoggerFactory.getLogger(FollowerPanel.class);

    public FollowerPanel() {
        JPanel p2xs = new JPanel();
        p2xs.setLayout(new BoxLayout(p2xs, 1));
        JPanel p3 = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage("LabelOutputName"));
        label.setToolTipText(Bundle.getMessage("ToolTipFollowerOutput"));
        p3.add(label);
        this.outputName = new JTextField(12);
        this.outputName.setToolTipText(Bundle.getMessage("ToolTipFollowerOutput"));
        p3.add(this.outputName);
        p2xs.add(p3);
        p3 = new JPanel();
        label = new JLabel(Bundle.getMessage("LabelSensorName"));
        label.setToolTipText(Bundle.getMessage("ToolTipFollowerSensor"));
        p3.add(label);
        this.sensorName = new JTextField(12);
        this.sensorName.setToolTipText(Bundle.getMessage("ToolTipFollowerSensor"));
        p3.add(this.sensorName);
        p2xs.add(p3);
        this.invert = new JCheckBox(Bundle.getMessage("ButtonInvert"));
        this.invert.setToolTipText(Bundle.getMessage("ToolTipFollowerInvert"));
        p2xs.add(this.invert);
        p3 = new JPanel();
        label = new JLabel(Bundle.getMessage("LabelVetoName"));
        label.setToolTipText(Bundle.getMessage("ToolTipFollowerVeto"));
        p3.add(label);
        this.vetoName = new JTextField(12);
        this.vetoName.setToolTipText(Bundle.getMessage("ToolTipFollowerVeto"));
        p3.add(this.vetoName);
        p2xs.add(p3);
        this.add(p2xs);
        p2xs = new JPanel();
        p2xs.setLayout(new BoxLayout(p2xs, 1));
        this.viewButton = new JButton(Bundle.getMessage("ButtonView"));
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FollowerPanel.this.viewPressed();
            }
        });
        p2xs.add(this.viewButton);
        this.addButton = new JButton(Bundle.getMessage("ButtonAddUpdate"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FollowerPanel.this.addPressed();
            }
        });
        p2xs.add(this.addButton);
        this.add(p2xs);
    }

    void addPressed() {
        boolean ok = true;
        ok &= this.validateTurnout(this.outputName.getText());
        ok &= this.validateSensor(this.sensorName.getText());
        if (!this.vetoName.getText().isEmpty()) {
            ok &= this.validateSensor(this.vetoName.getText());
        }
        if (!ok) {
            return;
        }
        new Follower(this.outputName.getText(), this.sensorName.getText(), this.invert.isSelected(), this.vetoName.getText()).instantiate();
    }

    void viewPressed() {
        try {
            Follower o = new Follower(this.outputName.getText());
            this.sensorName.setText(o.getSensorName());
            this.invert.setSelected(o.getInvert());
            this.vetoName.setText(o.getVetoName());
        }
        catch (JmriException e) {
            log.error("Exception trying to find existing OS Indicator", (Throwable)e);
        }
    }
}

