/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.ussctc.CodeGroupNoBits;
import jmri.jmrit.ussctc.CodeGroupOneBit;
import jmri.jmrit.ussctc.Section;
import jmri.jmrit.ussctc.Station;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintainerCallSection
implements Section<CodeGroupOneBit, CodeGroupNoBits> {
    NamedBeanHandle<Sensor> hInputSensor;
    NamedBeanHandle<Turnout> hLayoutOutput;
    Station<CodeGroupOneBit, CodeGroupNoBits> station;
    private static final Logger log = LoggerFactory.getLogger(MaintainerCallSection.class);

    MaintainerCallSection() {
    }

    public MaintainerCallSection(String inputSensor, String layoutOutput, Station<CodeGroupOneBit, CodeGroupNoBits> station) {
        this.station = station;
        NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
        TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
        SensorManager sm = InstanceManager.getDefault(SensorManager.class);
        this.hInputSensor = hm.getNamedBeanHandle(inputSensor, sm.provideSensor(inputSensor));
        this.hLayoutOutput = hm.getNamedBeanHandle(layoutOutput, tm.provideTurnout(layoutOutput));
        this.codeValueDelivered(this.codeSendStart());
    }

    @Override
    public Station<CodeGroupOneBit, CodeGroupNoBits> getStation() {
        return this.station;
    }

    @Override
    public String getName() {
        return "MC for " + this.hLayoutOutput.getBean().getDisplayName();
    }

    @Override
    public CodeGroupOneBit codeSendStart() {
        log.debug("codeSendStart with Sensor state == {}", (Object)this.hInputSensor.getBean().getKnownState());
        if (this.hInputSensor.getBean().getKnownState() == 2) {
            return CodeGroupOneBit.Single1;
        }
        return CodeGroupOneBit.Single0;
    }

    @Override
    public void indicationComplete(CodeGroupNoBits value) {
    }

    @Override
    public void codeValueDelivered(CodeGroupOneBit value) {
        log.debug("codeValueDelivered({}) with Turnout state == {}", (Object)value, (Object)this.hLayoutOutput.getBean().getCommandedState());
        if (value == CodeGroupOneBit.Single0 && this.hLayoutOutput.getBean().getCommandedState() != 2) {
            this.hLayoutOutput.getBean().setCommandedState(2);
            log.debug("Layout MC output set CLOSED");
        } else if (value == CodeGroupOneBit.Single1 && this.hLayoutOutput.getBean().getCommandedState() != 4) {
            this.hLayoutOutput.getBean().setCommandedState(4);
            log.debug("Layout MC output set THROWN");
        }
    }

    @Override
    public CodeGroupNoBits indicationStart() {
        return CodeGroupNoBits.None;
    }
}

