/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.ussctc.Lock;
import jmri.jmrit.ussctc.LockLogger;

public class OccupancyLock
implements Lock {
    List<NamedBeanHandle<Sensor>> list;

    public OccupancyLock(List<NamedBeanHandle<Sensor>> list) {
        this.list = list;
    }

    public OccupancyLock(String[] array) {
        NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
        SensorManager sm = InstanceManager.getDefault(SensorManager.class);
        this.list = new ArrayList<NamedBeanHandle<Sensor>>();
        for (String s : array) {
            this.list.add(hm.getNamedBeanHandle(s, sm.provideSensor(s)));
        }
    }

    public OccupancyLock(String sensor) {
        this(new String[]{sensor});
    }

    @Override
    public boolean isLockClear(LockLogger lockLogger) {
        for (NamedBeanHandle<Sensor> handle : this.list) {
            if (handle.getBean().getState() == 4) continue;
            lockLogger.setStatus(this, "Locked due to occupancy: " + handle.getBean().getDisplayName());
            return false;
        }
        lockLogger.setStatus(this, "");
        return true;
    }

    public String toString() {
        Object retval = this.isLockClear(debugLockLogger) ? "clear " : "locked";
        retval = (String)retval + OccupancyLock.debugLockLogger.memory.getValue();
        return retval;
    }
}

