/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.util.List;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Logix;
import jmri.LogixManager;
import jmri.implementation.DefaultConditionalAction;
import jmri.jmrit.ussctc.Constants;

public class OsIndicator
implements Constants {
    static String logixPrefix = InstanceManager.getDefault(LogixManager.class).getSystemNamePrefix();
    static final String namePrefix = logixPrefix + ":USS CTC:OsIndicator:1:";
    String output;
    String osSensor;
    String lock;

    public OsIndicator(String output, String osSensor, String lock) {
        this.lock = lock;
        this.osSensor = osSensor;
        this.output = output;
    }

    public void instantiate() {
        String nameP = namePrefix + this.output;
        Logix l = InstanceManager.getDefault(LogixManager.class).getLogix(nameP);
        if (l == null) {
            l = InstanceManager.getDefault(LogixManager.class).createNewLogix(nameP, "");
        }
        l.deActivateLogix();
        Conditional c = InstanceManager.getDefault(ConditionalManager.class).getConditional(l, nameP + "C1");
        if (c == null) {
            c = InstanceManager.getDefault(ConditionalManager.class).createNewConditional(nameP + "C1", "");
            l.addConditional(nameP + "C1", -1);
        }
        List<ConditionalVariable> variableList = c.getCopyOfStateVariables();
        variableList.add(new ConditionalVariable(false, Conditional.Operator.NONE, Conditional.Type.SENSOR_INACTIVE, this.osSensor, true));
        if (!this.lock.isEmpty()) {
            variableList.add(new ConditionalVariable(false, Conditional.Operator.AND, Conditional.Type.SENSOR_INACTIVE, this.lock, true));
        }
        c.setStateVariables(variableList);
        List<ConditionalAction> actionList = c.getCopyOfActions();
        actionList.add(new DefaultConditionalAction(1, Conditional.Action.SET_TURNOUT, this.output, 2, " "));
        actionList.add(new DefaultConditionalAction(2, Conditional.Action.SET_TURNOUT, this.output, 4, " "));
        c.setAction(actionList);
        l.activateLogix();
    }

    public OsIndicator(String outputName) throws JmriException {
        this.output = outputName;
        String nameP = namePrefix + this.output;
        Logix l = InstanceManager.getDefault(LogixManager.class).getLogix(nameP);
        if (l == null) {
            throw new JmriException("Logix does not exist");
        }
        Conditional c = InstanceManager.getDefault(ConditionalManager.class).getConditional(l, nameP + "C1");
        if (c == null) {
            throw new JmriException("Conditional does not exist");
        }
        List<ConditionalVariable> variableList = c.getCopyOfStateVariables();
        ConditionalVariable variable = variableList.get(0);
        this.osSensor = variable.getName();
        if (variableList.size() > 0) {
            variable = variableList.get(1);
            this.lock = variable.getName();
        }
    }

    public String getOutputName() {
        return this.output;
    }

    public String getOsSensorName() {
        return this.osSensor;
    }

    public String getLockName() {
        return this.lock;
    }
}

