/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.JmriException;
import jmri.jmrit.ussctc.BasePanel;
import jmri.jmrit.ussctc.Bundle;
import jmri.jmrit.ussctc.OsIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsIndicatorPanel
extends BasePanel {
    JTextField outputName;
    JTextField sensorName;
    JTextField lockName;
    JButton viewButton;
    JButton addButton;
    private static final Logger log = LoggerFactory.getLogger(OsIndicatorPanel.class);

    public OsIndicatorPanel() {
        JPanel p2xs = new JPanel();
        p2xs.setLayout(new BoxLayout(p2xs, 1));
        JPanel p3 = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage("LabelOutputName"));
        label.setToolTipText(Bundle.getMessage("ToolTipOsIndicatorOutput"));
        p3.add(label);
        this.outputName = new JTextField(12);
        this.outputName.setToolTipText(Bundle.getMessage("ToolTipOsIndicatorOutput"));
        p3.add(this.outputName);
        p2xs.add(p3);
        p3 = new JPanel();
        label = new JLabel(Bundle.getMessage("LabelSensorName"));
        label.setToolTipText(Bundle.getMessage("ToolTipOsIndicatorSensor"));
        p3.add(label);
        this.sensorName = new JTextField(12);
        this.sensorName.setToolTipText(Bundle.getMessage("ToolTipOsIndicatorSensor"));
        p3.add(this.sensorName);
        p2xs.add(p3);
        p3 = new JPanel();
        label = new JLabel(Bundle.getMessage("LabelLockName"));
        label.setToolTipText(Bundle.getMessage("ToolTipOsIndicatorLock"));
        p3.add(label);
        this.lockName = new JTextField(12);
        this.lockName.setToolTipText(Bundle.getMessage("ToolTipOsIndicatorLock"));
        p3.add(this.lockName);
        p2xs.add(p3);
        this.add(p2xs);
        p2xs = new JPanel();
        p2xs.setLayout(new BoxLayout(p2xs, 1));
        this.viewButton = new JButton(Bundle.getMessage("ButtonView"));
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsIndicatorPanel.this.viewPressed();
            }
        });
        p2xs.add(this.viewButton);
        this.addButton = new JButton(Bundle.getMessage("ButtonAddUpdate"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsIndicatorPanel.this.addPressed();
            }
        });
        p2xs.add(this.addButton);
        this.add(p2xs);
    }

    void addPressed() {
        boolean ok = true;
        ok &= this.validateTurnout(this.outputName.getText());
        ok &= this.validateSensor(this.sensorName.getText());
        if (!this.lockName.getText().isEmpty()) {
            ok &= this.validateMemory(this.lockName.getText());
        }
        if (!ok) {
            return;
        }
        new OsIndicator(this.outputName.getText(), this.sensorName.getText(), this.lockName.getText()).instantiate();
    }

    void viewPressed() {
        try {
            OsIndicator o = new OsIndicator(this.outputName.getText());
            this.sensorName.setText(o.getOsSensorName());
            this.lockName.setText(o.getLockName());
        }
        catch (JmriException e) {
            log.error("Exception trying to find existing OS Indicator", (Throwable)e);
        }
    }
}

