/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.BeanSetting;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrit.ussctc.Lock;
import jmri.jmrit.ussctc.LockLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteLock
implements Lock {
    Iterable<NamedBeanHandle<SignalHead>> list;
    Iterable<BeanSetting> beans;
    private static final Logger log = LoggerFactory.getLogger(RouteLock.class);

    public RouteLock(@Nonnull List<NamedBeanHandle<SignalHead>> list) {
        this.list = list;
        this.beans = null;
    }

    public RouteLock(@Nonnull List<NamedBeanHandle<SignalHead>> list, @Nonnull List<BeanSetting> beans) {
        this.list = list;
        this.beans = beans;
    }

    public RouteLock(@Nonnull String[] array) {
        NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
        SignalHeadManager sm = InstanceManager.getDefault(SignalHeadManager.class);
        ArrayDeque<NamedBeanHandle<SignalHead>> q = new ArrayDeque<NamedBeanHandle<SignalHead>>();
        for (String s : array) {
            SignalHead sig = sm.getSignalHead(s);
            if (sig == null) continue;
            q.add(hm.getNamedBeanHandle(s, sig));
        }
        this.list = q;
        this.beans = null;
    }

    public RouteLock(@Nonnull String[] array, @Nonnull BeanSetting[] beans) {
        NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
        SignalHeadManager sm = InstanceManager.getDefault(SignalHeadManager.class);
        ArrayDeque<NamedBeanHandle<SignalHead>> q1 = new ArrayDeque<NamedBeanHandle<SignalHead>>();
        for (String s : array) {
            SignalHead sig = sm.getSignalHead(s);
            if (sig == null) continue;
            q1.add(hm.getNamedBeanHandle(s, sig));
        }
        this.list = q1;
        ArrayDeque<BeanSetting> q2 = new ArrayDeque<BeanSetting>();
        for (BeanSetting bean : beans) {
            q2.add(bean);
        }
        this.beans = q2;
    }

    public RouteLock(@Nonnull String head) {
        this(new String[]{head});
    }

    @Override
    public boolean isLockClear(LockLogger lockLogger) {
        if (this.beans != null) {
            for (BeanSetting beanSetting : this.beans) {
                if (beanSetting.check()) continue;
                lockLogger.setStatus(this, "");
                log.debug("RouteLock OK because {} doesn't match, route not engaged", (Object)beanSetting.getBeanName());
                return true;
            }
        }
        for (NamedBeanHandle namedBeanHandle : this.list) {
            if (!this.isSignalClear(namedBeanHandle)) continue;
            lockLogger.setStatus(this, "Locked due to route including signal " + ((SignalHead)namedBeanHandle.getBean()).getDisplayName());
            log.debug("RouteLock locked due to route including signal {} set clear", (Object)((SignalHead)namedBeanHandle.getBean()).getDisplayName());
            return false;
        }
        lockLogger.setStatus(this, "");
        log.debug("RouteLock OK, no signals set clear");
        return true;
    }

    boolean isSignalClear(@Nonnull NamedBeanHandle<SignalHead> handle) {
        return handle.getBean().getState() != 1;
    }

    public String toString() {
        Object retval = this.isLockClear(debugLockLogger) ? "clear " : "locked";
        retval = (String)retval + RouteLock.debugLockLogger.memory.getValue();
        return retval;
    }
}

