/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.ussctc.CentralSection;
import jmri.jmrit.ussctc.CodeGroupTwoBits;
import jmri.jmrit.ussctc.FieldSection;
import jmri.jmrit.ussctc.Lock;
import jmri.jmrit.ussctc.Section;
import jmri.jmrit.ussctc.Station;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutSection
implements Section<CodeGroupTwoBits, CodeGroupTwoBits> {
    TurnoutFieldSection field;
    TurnoutCentralSection central;
    Station<CodeGroupTwoBits, CodeGroupTwoBits> station;
    static final CodeGroupTwoBits CODE_CLOSED = CodeGroupTwoBits.Double10;
    static final CodeGroupTwoBits CODE_THROWN = CodeGroupTwoBits.Double01;
    static final CodeGroupTwoBits CODE_NEITHER = CodeGroupTwoBits.Double00;
    private static final Logger log = LoggerFactory.getLogger(TurnoutSection.class);

    TurnoutSection() {
    }

    public TurnoutSection(String layoutTO, String normalIndicator, String reversedIndicator, String normalInput, String reversedInput, Station<CodeGroupTwoBits, CodeGroupTwoBits> station) {
        TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
        this.station = station;
        this.central = new TurnoutCentralSection(normalIndicator, reversedIndicator, normalInput, reversedInput);
        this.field = new TurnoutFieldSection(layoutTO);
        this.central.initializeLamps(tm.provideTurnout(layoutTO));
        this.field.initializeState(tm.provideTurnout(layoutTO));
    }

    public void addLocks(List<Lock> locks) {
        this.field.addLocks(locks);
    }

    @Override
    public Station<CodeGroupTwoBits, CodeGroupTwoBits> getStation() {
        return this.station;
    }

    @Override
    public String getName() {
        return "TO for " + this.field.hLayoutTO.getBean().getDisplayName();
    }

    @Override
    public CodeGroupTwoBits codeSendStart() {
        return this.central.codeSendStart();
    }

    @Override
    public void codeValueDelivered(CodeGroupTwoBits value) {
        this.field.codeValueDelivered(value);
    }

    @Override
    public CodeGroupTwoBits indicationStart() {
        return this.field.indicationStart();
    }

    @Override
    public void indicationComplete(CodeGroupTwoBits value) {
        this.central.indicationComplete(value);
    }

    public String toString() {
        String retval = this.getName() + " central: " + this.central.state + " field lastCode: " + this.field.lastCodeValue + " lastInd " + this.field.lastIndicationValue;
        return retval;
    }

    class TurnoutFieldSection
    implements FieldSection<CodeGroupTwoBits, CodeGroupTwoBits> {
        CodeGroupTwoBits lastCodeValue = CODE_NEITHER;
        CodeGroupTwoBits lastIndicationValue = CODE_NEITHER;
        NamedBeanHandle<Turnout> hLayoutTO;
        List<Lock> locks;

        public TurnoutFieldSection(String layoutTO) {
            NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
            TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
            this.hLayoutTO = hm.getNamedBeanHandle(layoutTO, tm.provideTurnout(layoutTO));
            tm.provideTurnout(layoutTO).addPropertyChangeListener(e -> this.layoutTurnoutChanged(e));
        }

        public void addLocks(List<Lock> locks) {
            this.locks = locks;
        }

        void initializeState(Turnout to) {
            this.lastCodeValue = to.getCommandedState() == 2 ? CODE_CLOSED : (to.getCommandedState() == 4 ? CODE_THROWN : CODE_NEITHER);
            this.lastIndicationValue = this.lastCodeValue;
        }

        @Override
        public void codeValueDelivered(CodeGroupTwoBits value) {
            this.lastCodeValue = value;
            if (value == CODE_CLOSED && this.hLayoutTO.getBean().getCommandedState() != 2) {
                if (Lock.checkLocksClear(this.locks, Lock.turnoutLockLogger)) {
                    this.hLayoutTO.getBean().setCommandedState(2);
                    log.debug("Layout turnout set CLOSED");
                } else {
                    this.logLocked(value);
                }
            } else if (value == CODE_THROWN && this.hLayoutTO.getBean().getCommandedState() != 4) {
                if (Lock.checkLocksClear(this.locks, Lock.turnoutLockLogger)) {
                    this.hLayoutTO.getBean().setCommandedState(4);
                    log.debug("Layout turnout set THROWN");
                } else {
                    this.logLocked(value);
                }
            } else {
                log.debug("Layout turnout already set for {} as {}", (Object)value, (Object)this.hLayoutTO.getBean().getCommandedState());
                if (this.lastIndicationValue != this.getCurrentIndication()) {
                    log.debug("    Last indication {} doesn't match current {}, request indication", (Object)this.lastIndicationValue, (Object)this.getCurrentIndication());
                    ThreadingUtil.runOnLayoutEventually(() -> TurnoutSection.this.station.requestIndicationStart());
                }
            }
        }

        void logLocked(CodeGroupTwoBits value) {
            log.debug("No turnout operation due to not permitted by lock: {}", (Object)value);
            if (this.lastIndicationValue != this.getCurrentIndication()) {
                log.debug("    Locked, but last indication {} doesn't match current {}, request indication", (Object)this.lastIndicationValue, (Object)this.getCurrentIndication());
                ThreadingUtil.runOnLayoutEventually(() -> TurnoutSection.this.station.requestIndicationStart());
            }
        }

        @Override
        public CodeGroupTwoBits indicationStart() {
            this.lastIndicationValue = this.getCurrentIndication();
            return this.lastIndicationValue;
        }

        public CodeGroupTwoBits getCurrentIndication() {
            if (this.hLayoutTO.getBean().getKnownState() == 2 && this.lastCodeValue == CODE_CLOSED) {
                return CODE_CLOSED;
            }
            if (this.hLayoutTO.getBean().getKnownState() == 4 && this.lastCodeValue == CODE_THROWN) {
                return CODE_THROWN;
            }
            return CODE_NEITHER;
        }

        void layoutTurnoutChanged(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("KnownState") && !e.getNewValue().equals(e.getOldValue())) {
                log.debug("Turnout changed from {} to {}, so requestIndicationStart", e.getOldValue(), e.getNewValue());
                TurnoutSection.this.station.requestIndicationStart();
            }
        }
    }

    static class TurnoutCentralSection
    implements CentralSection<CodeGroupTwoBits, CodeGroupTwoBits> {
        State state = State.DARK_INCONSISTENT;
        NamedBeanHandle<Turnout> hNormalIndicator;
        NamedBeanHandle<Turnout> hReversedIndicator;
        NamedBeanHandle<Sensor> hNormalInput;
        NamedBeanHandle<Sensor> hReversedInput;

        public TurnoutCentralSection(String normalIndicator, String reversedIndicator, String normalInput, String reversedInput) {
            NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
            TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
            SensorManager sm = InstanceManager.getDefault(SensorManager.class);
            this.hNormalIndicator = hm.getNamedBeanHandle(normalIndicator, tm.provideTurnout(normalIndicator));
            this.hReversedIndicator = hm.getNamedBeanHandle(reversedIndicator, tm.provideTurnout(reversedIndicator));
            this.hNormalInput = hm.getNamedBeanHandle(normalInput, sm.provideSensor(normalInput));
            this.hReversedInput = hm.getNamedBeanHandle(reversedInput, sm.provideSensor(reversedInput));
        }

        void initializeLamps(Turnout to) {
            if (to.getKnownState() == 4) {
                this.hNormalIndicator.getBean().setCommandedState(2);
                this.hReversedIndicator.getBean().setCommandedState(4);
                this.state = State.SHOWING_REVERSED;
            } else if (to.getKnownState() == 2) {
                this.hNormalIndicator.getBean().setCommandedState(4);
                this.hReversedIndicator.getBean().setCommandedState(2);
                this.state = State.SHOWING_NORMAL;
            } else {
                this.hNormalIndicator.getBean().setCommandedState(2);
                this.hReversedIndicator.getBean().setCommandedState(2);
                this.state = State.DARK_INCONSISTENT;
            }
        }

        @Override
        public CodeGroupTwoBits codeSendStart() {
            if (this.state == State.SHOWING_NORMAL && this.hNormalInput.getBean().getKnownState() == 2 || this.state == State.SHOWING_REVERSED && this.hReversedInput.getBean().getKnownState() == 2) {
                log.debug("No turnout change requested, lamps left on");
            } else {
                log.debug("Turnout change requested, turn lamps off");
                this.hNormalIndicator.getBean().setCommandedState(2);
                this.hReversedIndicator.getBean().setCommandedState(2);
                this.state = State.DARK_WAITING_REPLY;
            }
            if (this.hNormalInput.getBean().getKnownState() == 2) {
                return CODE_CLOSED;
            }
            if (this.hReversedInput.getBean().getKnownState() == 2) {
                return CODE_THROWN;
            }
            return CODE_NEITHER;
        }

        @Override
        public void indicationComplete(CodeGroupTwoBits value) {
            log.debug("Indication sets from {}", (Object)value);
            if (value == CODE_CLOSED) {
                this.hNormalIndicator.getBean().setCommandedState(4);
                this.hReversedIndicator.getBean().setCommandedState(2);
                this.state = State.SHOWING_NORMAL;
            } else if (value == CODE_THROWN) {
                this.hNormalIndicator.getBean().setCommandedState(2);
                this.hReversedIndicator.getBean().setCommandedState(4);
                this.state = State.SHOWING_REVERSED;
            } else if (value == CODE_NEITHER) {
                this.hNormalIndicator.getBean().setCommandedState(2);
                this.hReversedIndicator.getBean().setCommandedState(2);
                this.state = State.DARK_INCONSISTENT;
            } else {
                log.error("Got code not recognized: {}", (Object)value);
            }
        }

        static enum State {
            SHOWING_NORMAL,
            SHOWING_REVERSED,
            DARK_WAITING_REPLY,
            DARK_INCONSISTENT;

        }
    }
}

