/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import com.jogamp.openal.ALException;
import com.jogamp.openal.util.ALut;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.audio.AudioThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioUtil {
    private static final Logger log = LoggerFactory.getLogger(AudioUtil.class);

    private static List<ByteBuffer> splitInputStream(InputStream stream, int max_time, int min_time) {
        ArrayList<ByteBuffer> rlist = new ArrayList<ByteBuffer>();
        int[] format = new int[1];
        ByteBuffer[] data = new ByteBuffer[1];
        int[] size = new int[1];
        int[] freq = new int[1];
        int[] loop = new int[1];
        try {
            ALut.alutLoadWAVFile((InputStream)stream, (int[])format, (ByteBuffer[])data, (int[])size, (int[])freq, (int[])loop);
        }
        catch (ALException e) {
            log.warn("Error loading JoalAudioBuffer", (Throwable)e);
            return null;
        }
        if (format[0] != 4352 && format[0] != 4353) {
            log.warn("Invalid Format for splitting! Failing out.{}", (Object)AudioUtil.parseFormat(format[0]));
            return null;
        }
        while (data[0].remaining() > 0) {
            log.debug("while loop. Source: {}", (Object)data[0]);
            ByteBuffer ab = AudioUtil.getSubBuffer(data[0], max_time, min_time, format[0], freq[0]);
            if (ab == null) continue;
            ab.rewind();
            rlist.add(ab);
        }
        return rlist;
    }

    public static ByteBuffer getWavData(InputStream stream) {
        int[] format = new int[1];
        int[] size = new int[1];
        ByteBuffer[] data = new ByteBuffer[1];
        int[] freq = new int[1];
        int[] loop = new int[1];
        try {
            ALut.alutLoadWAVFile((InputStream)stream, (int[])format, (ByteBuffer[])data, (int[])size, (int[])freq, (int[])loop);
        }
        catch (ALException e) {
            log.warn("Error loading JoalAudioBuffer from stream", (Throwable)e);
            return null;
        }
        log.debug("WAV data: {}, order: {}, size: {}", new Object[]{data[0], data[0].order(), size[0]});
        return data[0];
    }

    public static int[] getWavFormats(InputStream stream) {
        int[] format = new int[1];
        int[] size = new int[1];
        ByteBuffer[] data = new ByteBuffer[1];
        int[] freq = new int[1];
        int[] loop = new int[1];
        int[] formats = new int[3];
        try {
            ALut.alutLoadWAVFile((InputStream)stream, (int[])format, (ByteBuffer[])data, (int[])size, (int[])freq, (int[])loop);
        }
        catch (ALException e) {
            log.warn("Error loading JoalAudioBuffer from stream", (Throwable)e);
            return formats;
        }
        if (format[0] != 4352 && format[0] != 4353) {
            log.warn("Invalid Format! Failing out.{}", (Object)AudioUtil.parseFormat(format[0]));
            return formats;
        }
        formats[0] = format[0];
        formats[1] = freq[0];
        formats[2] = AudioUtil.frameSize(format[0]);
        return formats;
    }

    public static boolean isAudioRunning() {
        AudioFactory af = InstanceManager.getDefault(AudioManager.class).getActiveAudioFactory();
        if (af == null) {
            return false;
        }
        return ((AudioThread)((Object)af.getCommandThread())).isThreadAlive();
    }

    public static List<ByteBuffer> getByteBufferList(InputStream stream, int max_time, int min_time) {
        return AudioUtil.splitInputStream(stream, max_time, min_time);
    }

    private static int frameSize(int format) {
        int frameSize;
        switch (format) {
            case 130: {
                frameSize = 16;
                break;
            }
            case 129: {
                frameSize = 8;
                break;
            }
            case 114: {
                frameSize = 14;
                break;
            }
            case 113: {
                frameSize = 7;
                break;
            }
            case 98: {
                frameSize = 12;
                break;
            }
            case 97: {
                frameSize = 6;
                break;
            }
            case 66: {
                frameSize = 8;
                break;
            }
            case 34: 
            case 65: {
                frameSize = 4;
                break;
            }
            case 4353: 
            case 4354: {
                frameSize = 2;
                break;
            }
            default: {
                frameSize = 1;
            }
        }
        return frameSize;
    }

    private static String parseFormat(int fmt) {
        switch (fmt) {
            case 4352: {
                return "8-bit mono";
            }
            case 4353: {
                return "16-bit mono";
            }
            case 4354: {
                return "8-bit stereo";
            }
            case 4355: {
                return "16-bit stereo";
            }
        }
        return "Something Multichannel: val=" + fmt;
    }

    private static int calcTimeIndex(int fmt, int freq, int time_ms) {
        int rv = AudioUtil.frameSize(fmt) * (time_ms * freq / 1000);
        log.debug("calcTimeIndex: freq = {} time_us = {} rv = {}", new Object[]{freq, time_ms, rv});
        return rv;
    }

    private static Boolean isZeroCross(byte[] buf, int len, int format, ByteOrder order) {
        switch (format) {
            case 4352: {
                if (len < 3) {
                    return false;
                }
                return (0xFF & buf[len - 3]) < 128 && (0xFF & buf[len - 2]) < 128 && (0xFF & buf[len - 1]) >= 128;
            }
            case 4353: {
                if (len < 6) {
                    return false;
                }
                short[] sbuf = new short[len / 2];
                ByteBuffer bb = ByteBuffer.wrap(buf);
                bb.order(order);
                sbuf[0] = bb.getShort();
                sbuf[1] = bb.getShort();
                sbuf[2] = bb.getShort();
                return sbuf[0] < 0 && sbuf[1] < 0 && sbuf[2] >= 0;
            }
        }
        return false;
    }

    private static ByteBuffer getSubBuffer(ByteBuffer source, int max_time, int min_time, int format, int freq) {
        int bufcount;
        int time_size = AudioUtil.calcTimeIndex(format, freq, max_time);
        int frameSize = AudioUtil.frameSize(format);
        byte[] retbytes = new byte[source.remaining() + 1];
        log.debug("Creating sub buffer.  interval = {} freq = {} time_size = {} sample size= {}", new Object[]{max_time, freq, time_size, AudioUtil.frameSize(format)});
        log.debug("\tBefore: Source = {}", (Object)source);
        if (time_size < source.remaining()) {
            log.debug("Extracting slice.  Remaining = {}", (Object)source.remaining());
            source.get(retbytes, 0, time_size);
            bufcount = time_size;
            while (!AudioUtil.isZeroCross(Arrays.copyOfRange(retbytes, bufcount - 6, bufcount), 6, format, source.order()).booleanValue() && source.remaining() >= frameSize) {
                source.get(retbytes, bufcount, frameSize);
                bufcount += frameSize;
            }
        } else {
            log.debug("Not enough bytes.  Copying remaining bytes = {}", (Object)source.remaining());
            bufcount = source.remaining();
            source.get(retbytes, 0, bufcount);
        }
        if (bufcount <= AudioUtil.calcTimeIndex(format, freq, min_time)) {
            log.debug("Remaining bytes less than minimum time interval.  Discarding.");
            return null;
        }
        ByteBuffer retbuf = ByteBuffer.allocate(bufcount);
        retbuf.order(source.order());
        retbuf.put(retbytes, 0, bufcount);
        log.debug("\tAfter: source= {}bufcount={} retbuf= {}", new Object[]{source, bufcount, retbuf});
        return retbuf;
    }
}

