/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jmri.AudioException;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.vsdecoder.AudioUtil;
import jmri.jmrit.vsdecoder.EngineSound;
import jmri.jmrit.vsdecoder.SoundBite;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.util.PhysicalLocation;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Diesel3Sound
extends EngineSound {
    private HashMap<Integer, D3Notch> notch_sounds;
    private String _soundName;
    private AudioBuffer start_buffer;
    private AudioBuffer stop_buffer;
    private Integer idle_notch;
    private int first_notch;
    int top_speed;
    static final int number_helper_buffers = 5;
    private int current_notch = 1;
    private D3LoopThread _loopThread = null;
    private static final Logger log = LoggerFactory.getLogger(Diesel3Sound.class);

    public Diesel3Sound(String name) {
        super(name);
        log.debug("New Diesel3Sound name(param): {}, name(val): {}", (Object)name, (Object)this.getName());
    }

    private void startThread() {
        this._loopThread = new D3LoopThread(this, this.notch_sounds.get(this.current_notch), this._soundName, true);
        this._loopThread.setName("Diesel3Sound.D3LoopThread");
        log.debug("Loop Thread Started.  Sound name: {}", (Object)this._soundName);
    }

    @Override
    public void changeThrottle(float s) {
        if (this._loopThread != null) {
            this._loopThread.setThrottle(s);
        }
    }

    @Override
    public void changeLocoDirection(int dirfn) {
        log.debug("loco IsForward is {}", (Object)dirfn);
        if (this._loopThread != null) {
            this._loopThread.getLocoDirection(dirfn);
        }
    }

    private D3Notch getNotch(int n) {
        return this.notch_sounds.get(n);
    }

    @Override
    public void startEngine() {
        log.debug("startEngine.  ID: {}", (Object)this.getName());
        if (this._loopThread != null) {
            this._loopThread.startEngine(this.start_buffer);
        }
    }

    @Override
    public void stopEngine() {
        log.debug("stopEngine.  ID: {}", (Object)this.getName());
        if (this._loopThread != null) {
            this._loopThread.stopEngine(this.stop_buffer);
        }
    }

    @Override
    public void shutdown() {
        if (this._loopThread != null) {
            this._loopThread.setRunning(false);
        }
    }

    @Override
    public void mute(boolean m) {
        if (this._loopThread != null) {
            this._loopThread.mute(m);
        }
    }

    @Override
    public void setVolume(float v) {
        if (this._loopThread != null) {
            this._loopThread.setVolume(v);
        }
    }

    @Override
    public void setPosition(PhysicalLocation p) {
        if (this._loopThread != null) {
            this._loopThread.setPosition(p);
        }
    }

    @Override
    public Element getXml() {
        Element me = new Element("sound");
        me.setAttribute("name", this.getName());
        me.setAttribute("type", "engine");
        return me;
    }

    @Override
    public void setXml(Element e, VSDFile vf) {
        String fn;
        Element el;
        int frame_size = 0;
        int freq = 0;
        boolean buffer_ok = true;
        super.setXml(e, vf);
        this._soundName = this.getName() + ":LoopSound";
        log.debug("get name: {}, soundName: {}, name: {}", new Object[]{this.getName(), this._soundName, this.name});
        String in = e.getChildText("top-speed");
        this.top_speed = in != null ? Integer.parseInt(in) : 0;
        log.debug("top speed forward: {} MPH", (Object)this.top_speed);
        this.notch_sounds = new HashMap();
        in = e.getChildText("idle-notch");
        this.idle_notch = null;
        if (in != null) {
            this.idle_notch = Integer.parseInt(in);
            log.debug("Notch {} is Idle.", (Object)this.idle_notch);
        } else {
            log.warn("No Idle Notch Specified!");
        }
        this.is_auto_start = this.setXMLAutoStart(e);
        log.debug("config auto-start: {}", (Object)this.is_auto_start);
        this.engine_rd = this.setXMLEngineReferenceDistance(e);
        log.debug("engine-sound referenceDistance: {}", (Object)Float.valueOf(this.engine_rd));
        this.exponent = this.setXMLExponent(e);
        log.debug("exponent: {}", (Object)Float.valueOf(this.exponent));
        in = e.getChildText("engine-gain");
        this.engine_gain = in != null && !in.isEmpty() ? Float.parseFloat(in) : 0.8f;
        log.debug("engine gain: {}", (Object)Float.valueOf(this.engine_gain));
        this.sleep_interval = this.setXMLSleepInterval(e);
        log.debug("sleep interval: {}", (Object)this.sleep_interval);
        Iterator itr = e.getChildren("notch-sound").iterator();
        int i = 0;
        while (itr.hasNext()) {
            el = (Element)itr.next();
            int nn = Integer.parseInt(el.getChildText("notch"));
            D3Notch sb = new D3Notch(nn);
            sb.setIdleNotch(false);
            if (this.idle_notch != null && nn == this.idle_notch) {
                sb.setIdleNotch(true);
                log.debug("Notch {} set to Idle.", (Object)nn);
            }
            List elist = el.getChildren("file");
            for (Element fe : elist) {
                fn = fe.getText();
                if (i == 0) {
                    this.first_notch = nn;
                    int[] formats = AudioUtil.getWavFormats(D3Notch.getWavStream(vf, fn));
                    frame_size = formats[2];
                    freq = formats[1];
                    sb.setBufferFmt(formats[0]);
                    sb.setBufferFreq(formats[1]);
                    sb.setBufferFrameSize(formats[2]);
                    log.debug("formats: {}", (Object)formats);
                    for (int j = 0; j < 5; ++j) {
                        if (this.checkForFreeBuffer()) {
                            AudioBuffer bh = D3Notch.getBufferHelper(this.name + "_BUFFERHELPER_" + j, this.name + "_BUFFERHELPER_" + j);
                            if (bh != null) {
                                log.debug("helper buffer created: {}, name: {}", (Object)bh, (Object)bh.getSystemName());
                                sb.addHelper(bh);
                                continue;
                            }
                            buffer_ok = false;
                            continue;
                        }
                        buffer_ok = false;
                    }
                }
                List<ByteBuffer> l = D3Notch.getDataList(vf, fn, this.name + "_n" + i);
                log.debug("{} internal sub buffers created from file {}:", (Object)l.size(), (Object)fn);
                for (ByteBuffer b : l) {
                    log.debug(" length: {} ms", (Object)(1000 * b.limit() / frame_size / freq));
                }
                sb.addLoopData(l);
            }
            sb.setNextNotch(el.getChildText("next-notch"));
            sb.setPrevNotch(el.getChildText("prev-notch"));
            sb.setAccelLimit(el.getChildText("accel-limit"));
            sb.setDecelLimit(el.getChildText("decel-limit"));
            if (el.getChildText("accel-file") != null) {
                if (this.checkForFreeBuffer()) {
                    sb.setAccelBuffer(D3Notch.getBuffer(vf, el.getChildText("accel-file"), this.name + "_na" + i, this.name + "_na" + i));
                } else {
                    buffer_ok = false;
                }
            } else {
                sb.setAccelBuffer(null);
            }
            if (el.getChildText("decel-file") != null) {
                if (this.checkForFreeBuffer()) {
                    sb.setDecelBuffer(D3Notch.getBuffer(vf, el.getChildText("decel-file"), this.name + "_nd" + i, this.name + "_nd" + i));
                } else {
                    buffer_ok = false;
                }
            } else {
                sb.setDecelBuffer(null);
            }
            this.notch_sounds.put(nn, sb);
            ++i;
        }
        el = e.getChild("start-sound");
        if (el != null) {
            fn = el.getChild("file").getValue();
            if (this.checkForFreeBuffer()) {
                this.start_buffer = D3Notch.getBuffer(vf, fn, this.name + "_start", this.name + "_Start");
                log.debug("Start sound: {}, buffer {} created, length: {}", new Object[]{fn, this.start_buffer, SoundBite.calcLength(this.start_buffer)});
            } else {
                buffer_ok = false;
            }
        }
        if ((el = e.getChild("shutdown-sound")) != null) {
            fn = el.getChild("file").getValue();
            if (this.checkForFreeBuffer()) {
                this.stop_buffer = D3Notch.getBuffer(vf, fn, this.name + "_shutdown", this.name + "_Shutdown");
                log.debug("Shutdown sound: {}, buffer {} created, length: {}", new Object[]{fn, this.stop_buffer, SoundBite.calcLength(this.stop_buffer)});
            } else {
                buffer_ok = false;
            }
        }
        if (this.idle_notch == null) {
            D3Notch min_notch = null;
            for (D3Notch n : this.notch_sounds.values()) {
                if (min_notch != null && n.getNotch() >= min_notch.getNotch()) continue;
                min_notch = n;
            }
            log.info("No Idle Notch Specified.  Choosing Notch {} to be the Idle Notch.", min_notch != null ? Integer.valueOf(min_notch.getNotch()) : "min_notch not set");
            if (min_notch != null) {
                min_notch.setIdleNotch(true);
                this.idle_notch = min_notch.getNotch();
            } else {
                log.warn("Could not set idle notch because min_notch was still null");
            }
        }
        if (buffer_ok) {
            this.setBuffersFreeState(true);
            this.startThread();
            this.autoStartCheck();
        } else {
            this.setBuffersFreeState(false);
        }
    }

    private static class D3LoopThread
    extends Thread {
        private boolean is_running;
        private boolean is_looping;
        private boolean is_in_rampup_mode;
        private Diesel3Sound _parent;
        private D3Notch _notch;
        private D3Notch notch1;
        private SoundBite _sound;
        private float _throttle;
        private float rpm_dirfn;
        private int helper_index;
        private static final Logger log = LoggerFactory.getLogger(D3LoopThread.class);

        private D3LoopThread(Diesel3Sound d, D3Notch n, String s, boolean r) {
            this.is_running = r;
            this.is_looping = false;
            this.is_in_rampup_mode = false;
            this._parent = d;
            this._notch = n;
            this._sound = new SoundBite(s);
            this._sound.isInitialized();
            this._sound.setGain(this._parent.engine_gain);
            this._throttle = 0.0f;
            this.rpm_dirfn = 0.0f;
            if (r) {
                this.start();
            }
        }

        private void setRunning(boolean r) {
            this.is_running = r;
        }

        private void setThrottle(float t) {
            if (this._parent.isEngineStarted()) {
                if (t < 0.0f) {
                    t = 0.0f;
                    this.is_in_rampup_mode = false;
                }
                this._throttle = t;
                this._parent.setActualSpeed((float)this._parent.speedCurve(this._throttle));
                log.debug("Throttle set: {}", (Object)Float.valueOf(this._throttle));
            }
        }

        private void getLocoDirection(int d) {
            log.debug("loco direction: {}", (Object)d);
            if (this._throttle > 0.0f && this._parent.isEngineStarted() && !this.is_in_rampup_mode) {
                this.rpm_dirfn = this._throttle;
                log.debug("speed {} saved", (Object)Float.valueOf(this.rpm_dirfn));
                this.is_in_rampup_mode = true;
                this._throttle = 0.0f;
                this._parent.setActualSpeed(this._throttle);
            }
        }

        public void startEngine(AudioBuffer start_buf) {
            this._sound.unqueueBuffers();
            log.debug("thread: start engine ...");
            this.helper_index = -1;
            this.notch1 = this._parent.getNotch(this._parent.first_notch);
            this._sound.setReferenceDistance(this._parent.engine_rd);
            log.debug("set reference distance to {} for engine sound", (Object)Float.valueOf(this._sound.getReferenceDistance()));
            this._notch = this._parent.getNotch(this._parent.first_notch);
            log.debug("Notch: {}, prev: {}, next: {}", new Object[]{this._notch.getNotch(), this._notch.getPrevNotch(), this._notch.getNextNotch()});
            if (this._parent.engine_pane != null) {
                this._parent.engine_pane.setThrottle(this._notch.getNotch());
            }
            if (this._notch.isIdleNotch().booleanValue()) {
                this._sound.queueBuffer(start_buf);
                if (this._parent.engine_pane != null) {
                    this._parent.engine_pane.setButtonDelay(SoundBite.calcLength(start_buf));
                }
            } else {
                this.setSound(this._notch.nextLoopData());
            }
            this.setSound(this._notch.nextLoopData());
            this.is_looping = true;
            if (this._sound.getSource().getState() != 17) {
                this._sound.play();
            }
        }

        public void stopEngine(AudioBuffer stop_buf) {
            log.debug("thread: stop engine ...");
            this.is_looping = false;
            this._throttle = 0.0f;
            this._parent.setActualSpeed(0.0f);
            if (this._parent.engine_pane != null) {
                this._parent.engine_pane.setThrottle(this._parent.idle_notch);
                this._parent.engine_pane.setButtonDelay(SoundBite.calcLength(stop_buf));
                this._sound.queueBuffer(stop_buf);
                if (this._sound.getSource().getState() != 17) {
                    this._sound.play();
                }
            }
        }

        @Override
        public void run() {
            try {
                while (this.is_running) {
                    if (this.is_looping && AudioUtil.isAudioRunning()) {
                        if (this._sound.getSource().numProcessedBuffers() > 0) {
                            this._sound.unqueueBuffers();
                        }
                        if (!this._notch.isInLimits(this._throttle).booleanValue()) {
                            this.changeNotch();
                        }
                        if (this._sound.getSource().numQueuedBuffers() < 2) {
                            this.setSound(this._notch.nextLoopData());
                        }
                        this.checkAudioState();
                    } else if (this._sound.getSource().numProcessedBuffers() > 0) {
                        this._sound.unqueueBuffers();
                    }
                    D3LoopThread.sleep(this._parent.sleep_interval);
                    this.checkRampup();
                }
                this._sound.stop();
            }
            catch (InterruptedException ie) {
                log.debug("thread interrupted");
            }
        }

        private void checkAudioState() {
            if (this._sound.getSource().getState() != 17) {
                this._sound.play();
                log.info("loop sound re-started");
            }
        }

        private void changeNotch() {
            AudioBuffer transition_buf = null;
            int new_notch = this._notch.getNotch();
            log.debug("D3Thread Change Throttle: {}, Accel Limit: {}, Decel Limit: {}", new Object[]{Float.valueOf(this._throttle), Float.valueOf(this._notch.getAccelLimit()), Float.valueOf(this._notch.getDecelLimit())});
            if (this._throttle > this._notch.getAccelLimit()) {
                if (this._notch.getNotch() < this._notch.getNextNotch()) {
                    transition_buf = this._notch.getAccelBuffer();
                    new_notch = this._notch.getNextNotch();
                    log.debug("Change up. notch: {}", (Object)new_notch);
                }
            } else if (this._throttle < this._notch.getDecelLimit()) {
                transition_buf = this._notch.getDecelBuffer();
                new_notch = this._notch.getPrevNotch();
                log.debug("Change down. notch: {}", (Object)new_notch);
            }
            this._parent.engine_pane.setThrottle(new_notch);
            if (transition_buf == null) {
                this._notch = this._parent.getNotch(new_notch);
                log.debug("No transition sound defined.");
            } else {
                this._notch = this._parent.getNotch(new_notch);
                this._sound.queueBuffer(transition_buf);
                if (SoundBite.calcLength(transition_buf) > 50L) {
                    try {
                        D3LoopThread.sleep(SoundBite.calcLength(transition_buf) - 50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private void setSound(ByteBuffer data) {
            AudioBuffer buf = this.notch1.bufs_helper.get(this.incHelperIndex());
            int sbl = 0;
            if (this.notch1.getBufferFreq() > 0) {
                sbl = 1000 * data.limit() / this.notch1.getBufferFrameSize() / this.notch1.getBufferFreq();
                int bbufcount = this.notch1.getBufferFrameSize() * (sbl * this.notch1.getBufferFreq() / 1000);
                ByteBuffer bbuf = ByteBuffer.allocateDirect(bbufcount);
                byte[] bbytes = new byte[bbufcount];
                data.get(bbytes);
                data.rewind();
                bbuf.order(data.order());
                bbuf.put(bbytes);
                bbuf.rewind();
                buf.loadBuffer(bbuf, this.notch1.getBufferFmt(), this.notch1.getBufferFreq());
                this._sound.queueBuffer(buf);
            }
        }

        private void checkRampup() {
            if (this.is_in_rampup_mode && this._throttle == 0.0f && this._notch.getNotch() == this._parent.idle_notch.intValue()) {
                log.debug("now ramp-up to speed {}", (Object)Float.valueOf(this.rpm_dirfn));
                this.is_in_rampup_mode = false;
                this._throttle = this.rpm_dirfn;
            }
        }

        private int incHelperIndex() {
            ++this.helper_index;
            if (this.helper_index >= 5) {
                this.helper_index = 0;
            }
            return this.helper_index;
        }

        private void mute(boolean m) {
            this._sound.mute(m);
        }

        private void setVolume(float v) {
            this._sound.setVolume(v);
        }

        private void setPosition(PhysicalLocation p) {
            this._sound.setPosition(p);
            if (this._parent.getTunnel()) {
                this._sound.attachSourcesToEffects();
            } else {
                this._sound.detachSourcesToEffects();
            }
        }
    }

    private static class D3Notch {
        private int my_notch;
        private int next_notch;
        private int prev_notch;
        private int buffer_fmt;
        private int buffer_freq;
        private int buffer_frame_size;
        private int loop_index;
        private float accel_limit;
        private float decel_limit;
        private boolean is_idle;
        private AudioBuffer accel_buf;
        private AudioBuffer decel_buf;
        private List<AudioBuffer> bufs_helper = new ArrayList<AudioBuffer>();
        private List<ByteBuffer> loop_data = new ArrayList<ByteBuffer>();
        private static final Logger log = LoggerFactory.getLogger(D3Notch.class);

        private D3Notch(int notch) {
            this.my_notch = notch;
            this.loop_index = 0;
        }

        private int getNotch() {
            return this.my_notch;
        }

        private int getNextNotch() {
            return this.next_notch;
        }

        private int getPrevNotch() {
            return this.prev_notch;
        }

        private AudioBuffer getAccelBuffer() {
            return this.accel_buf;
        }

        private AudioBuffer getDecelBuffer() {
            return this.decel_buf;
        }

        private float getAccelLimit() {
            return this.accel_limit;
        }

        private float getDecelLimit() {
            return this.decel_limit;
        }

        private Boolean isInLimits(float val) {
            return val >= this.decel_limit && val <= this.accel_limit;
        }

        private void setBufferFmt(int fmt) {
            this.buffer_fmt = fmt;
        }

        private int getBufferFmt() {
            return this.buffer_fmt;
        }

        private void setBufferFreq(int freq) {
            this.buffer_freq = freq;
        }

        private int getBufferFreq() {
            return this.buffer_freq;
        }

        private void setBufferFrameSize(int framesize) {
            this.buffer_frame_size = framesize;
        }

        private int getBufferFrameSize() {
            return this.buffer_frame_size;
        }

        private Boolean isIdleNotch() {
            return this.is_idle;
        }

        private void setNextNotch(String s) {
            this.next_notch = this.setIntegerFromString(s);
        }

        private void setPrevNotch(String s) {
            this.prev_notch = this.setIntegerFromString(s);
        }

        private void setAccelLimit(String s) {
            this.accel_limit = this.setFloatFromString(s);
        }

        private void setDecelLimit(String s) {
            this.decel_limit = this.setFloatFromString(s);
        }

        private void setAccelBuffer(AudioBuffer b) {
            this.accel_buf = b;
        }

        private void setDecelBuffer(AudioBuffer b) {
            this.decel_buf = b;
        }

        private void addLoopData(List<ByteBuffer> l) {
            this.loop_data.addAll(l);
        }

        private ByteBuffer nextLoopData() {
            return this.loop_data.get(this.incLoopIndex());
        }

        private void setIdleNotch(Boolean i) {
            this.is_idle = i;
        }

        private void addHelper(AudioBuffer b) {
            this.bufs_helper.add(b);
        }

        private int incLoopIndex() {
            ++this.loop_index;
            if (this.loop_index >= this.loop_data.size()) {
                this.loop_index = 0;
            }
            return this.loop_index;
        }

        private int setIntegerFromString(String s) {
            if (s == null) {
                return 0;
            }
            try {
                int n = Integer.parseInt(s);
                return n;
            }
            catch (NumberFormatException e) {
                log.debug("Invalid integer: {}", (Object)s);
                return 0;
            }
        }

        private float setFloatFromString(String s) {
            if (s == null) {
                return 0.0f;
            }
            try {
                float f = Float.parseFloat(s) / 100.0f;
                return f;
            }
            catch (NumberFormatException e) {
                log.debug("Invalid float: {}", (Object)s);
                return 0.0f;
            }
        }

        private static List<ByteBuffer> getDataList(VSDFile vf, String filename, String sname) {
            List<ByteBuffer> datalist = null;
            InputStream ins = vf.getInputStream(filename);
            if (ins == null) {
                log.debug("Input Stream failed");
                return null;
            }
            datalist = AudioUtil.getByteBufferList(ins, 250, 150);
            return datalist;
        }

        private static AudioBuffer getBuffer(VSDFile vf, String filename, String sname, String uname) {
            AudioBuffer buf = null;
            AudioManager am = InstanceManager.getDefault(AudioManager.class);
            try {
                buf = (AudioBuffer)am.provideAudio("IAB$VSD:" + sname);
                buf.setUserName("IVSDB_" + uname);
                InputStream ins = vf.getInputStream(filename);
                if (ins == null) {
                    log.debug("Input Stream failed");
                    return null;
                }
                buf.setInputStream(ins);
            }
            catch (IllegalArgumentException | AudioException ex) {
                log.error("Problem creating SoundBite", (Throwable)ex);
                return null;
            }
            log.debug("Buffer created: {}, name: {}", (Object)buf, (Object)buf.getSystemName());
            return buf;
        }

        private static AudioBuffer getBufferHelper(String sname, String uname) {
            AudioBuffer bf = null;
            AudioManager am = InstanceManager.getDefault(AudioManager.class);
            try {
                bf = (AudioBuffer)am.provideAudio("IAB$VSD:" + sname);
                bf.setUserName("IVSDB_" + uname);
            }
            catch (IllegalArgumentException | AudioException ex) {
                log.warn("problem creating SoundBite", (Throwable)ex);
                return null;
            }
            log.debug("empty buffer created: {}, name: {}", (Object)bf, (Object)bf.getSystemName());
            return bf;
        }

        private static InputStream getWavStream(VSDFile vf, String filename) {
            InputStream ins = vf.getInputStream(filename);
            if (ins != null) {
                return ins;
            }
            log.warn("input Stream failed for {}", (Object)filename);
            return null;
        }
    }
}

