/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.beans.PropertyChangeEvent;
import jmri.jmrit.vsdecoder.Trigger;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FloatTrigger
extends Trigger {
    Float match_value;
    Trigger.CompareType compare_type;
    private static final Logger log = LoggerFactory.getLogger(FloatTrigger.class);

    public FloatTrigger(String name, Float next, Trigger.CompareType ct) {
        super(name);
        this.setTriggerType(Trigger.TriggerType.FLOAT);
        this.match_value = next;
        this.compare_type = ct;
    }

    public void setMatchValue(Float next) {
        this.match_value = next;
    }

    public Float getMatchValue() {
        return this.match_value;
    }

    public void setCompareType(Trigger.CompareType ct) {
        this.compare_type = ct;
    }

    public Trigger.CompareType getCompareType() {
        return this.compare_type;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        boolean compare = false;
        if (this.target == null) {
            return;
        }
        if (!event.getPropertyName().equals(this.getEventName())) {
            return;
        }
        if (this.getTriggerType() == Trigger.TriggerType.NONE) {
            return;
        }
        if (this.getTargetAction() == Trigger.TargetAction.NOTHING) {
            return;
        }
        Float next = (Float)event.getNewValue();
        int compare_val = next.compareTo(this.match_value);
        switch (this.compare_type) {
            case GT: {
                compare = compare_val > 0;
                break;
            }
            case LT: {
                compare = compare_val < 0;
                break;
            }
            case GTE: {
                compare = compare_val >= 0;
                break;
            }
            case LTE: {
                compare = compare_val <= 0;
                break;
            }
            default: {
                compare = compare_val == 0;
            }
        }
        log.debug("compareTrigger match_value: {}, next: {}, compare_val: {}, compare: {}", new Object[]{this.match_value, next, compare_val, compare});
        if (compare) {
            log.debug("compareTrigger taking action");
            this.callback.takeAction();
        }
    }

    @Override
    public Element getXml() {
        Element me = new Element("trigger");
        me.setAttribute("name", this.getName());
        me.setAttribute("type", "FLOAT");
        log.warn("CompareTrigger.getXml() not implemented");
        return me;
    }

    @Override
    public void setXml(Element e) {
        log.debug("FloatTrigger.setXml()");
        super.setXml(e);
        if (e.getAttributeValue("type").equals("FLOAT")) {
            this.match_value = Float.valueOf(Float.parseFloat(e.getChild("match").getValue() + "f"));
            this.compare_type = Trigger.CompareType.valueOf(e.getChild("compare-type").getValue().toUpperCase());
        }
    }
}

