/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.jmrit.vsdecoder.Bundle;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadVSDFileAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(LoadVSDFileAction.class);

    public LoadVSDFileAction(String s) {
        super(s);
    }

    public LoadVSDFileAction() {
        this(Bundle.getMessage("VSDecoderFileMenuLoadVSDFile"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String dir_external = FileUtil.getExternalFilename(VSDecoderManager.instance().getVSDecoderPreferences().getDefaultVSDFilePath());
        JmriJFileChooser fileChooser = new JmriJFileChooser(dir_external);
        fileChooser.setFileFilter(new FileNameExtensionFilter(Bundle.getMessage("LoadVSDFileChooserFilterLabel"), "vsd", "zip"));
        fileChooser.setCurrentDirectory(new File(dir_external));
        fileChooser.setDialogType(0);
        int retVal = fileChooser.showOpenDialog(null);
        if (retVal == 0) {
            LoadVSDFileAction.loadVSDFile(fileChooser.getSelectedFile().toString());
        }
    }

    public static boolean loadVSDFile(String fp) {
        String fp_external = FileUtil.getExternalFilename(fp);
        File file = new File(fp_external);
        if (!file.exists()) {
            log.error("Cannot locate VSD File {}", (Object)fp_external);
            if (!GraphicsEnvironment.isHeadless()) {
                JmriJOptionPane.showMessageDialog(null, "Cannot locate VSD File", Bundle.getMessage("VSDFileError"), 0);
            }
            return false;
        }
        try {
            VSDFile vsdfile = new VSDFile(fp_external);
            log.debug("VSD File name: {}", (Object)vsdfile.getName());
            if (!vsdfile.isInitialized()) {
                if (!GraphicsEnvironment.isHeadless()) {
                    JmriJOptionPane.showMessageDialog(null, vsdfile.getStatusMessage(), Bundle.getMessage("VSDFileError"), 0);
                }
                vsdfile.close();
                return false;
            }
            VSDecoderManager.instance().loadProfiles(vsdfile);
            vsdfile.close();
        }
        catch (ZipException ze) {
            log.error("ZipException opening file {}", (Object)fp, (Object)ze);
            return false;
        }
        catch (IOException ze) {
            log.error("IOException opening file {}", (Object)fp, (Object)ze);
            return false;
        }
        return true;
    }
}

