/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import jmri.jmrit.vsdecoder.BoolTrigger;
import jmri.jmrit.vsdecoder.ButtonTrigger;
import jmri.jmrit.vsdecoder.EnginePane;
import jmri.jmrit.vsdecoder.FloatTrigger;
import jmri.jmrit.vsdecoder.IntTrigger;
import jmri.jmrit.vsdecoder.NotchTrigger;
import jmri.jmrit.vsdecoder.ThrottleTrigger;
import jmri.jmrit.vsdecoder.Trigger;
import jmri.jmrit.vsdecoder.TriggerListener;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDSound;
import jmri.jmrit.vsdecoder.VSDecoder;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundEvent
implements PropertyChangeListener {
    String name;
    String event_name;
    ButtonType buttontype;
    AbstractButton button;
    EnginePane engine_pane;
    Trigger t;
    ButtonTrigger bt;
    VSDecoder parent;
    protected HashMap<String, ButtonTrigger> button_trigger_list;
    protected HashMap<String, Trigger> trigger_list;
    VSDSound my_sound;
    private static final Logger log = LoggerFactory.getLogger(SoundEvent.class);

    public SoundEvent(String n) {
        this.name = n;
        this.trigger_list = new HashMap();
        this.button_trigger_list = new HashMap();
        this.button = null;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setEventName(String n) {
        this.event_name = n;
    }

    public String getEventName() {
        return this.event_name;
    }

    public ButtonType getButtonType() {
        return this.buttontype;
    }

    public boolean hasButton() {
        return this.buttontype != ButtonType.NONE && this.buttontype != ButtonType.ENGINE && this.button != null;
    }

    public boolean hasEnginePane() {
        return this.buttontype == ButtonType.ENGINE && this.engine_pane != null;
    }

    public void setButton(AbstractButton b) {
        this.button = b;
    }

    public JComponent getButton() {
        if (this.buttontype == ButtonType.NONE || this.buttontype == ButtonType.ENGINE) {
            return null;
        }
        return this.button;
    }

    public EnginePane getEnginePane() {
        if (this.buttontype == ButtonType.ENGINE) {
            return this.engine_pane;
        }
        return null;
    }

    public void setEnginePane(EnginePane e) {
        this.engine_pane = e;
    }

    public void setButtonLabel(String bl) {
        this.button.setText(bl);
    }

    public String getButtonLabel() {
        return this.button.getText();
    }

    public void addTrigger(String s, Trigger t) {
        this.trigger_list.put(s, t);
    }

    public Trigger getTrigger(String s) {
        return this.trigger_list.get(s);
    }

    public void setSound(VSDSound v) {
        this.my_sound = v;
    }

    public VSDSound getSound() {
        return this.my_sound;
    }

    public void setParent(VSDecoder v) {
        this.parent = v;
    }

    public VSDecoder getParent() {
        return this.parent;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        for (Trigger t : this.trigger_list.values()) {
            t.propertyChange(event);
        }
    }

    protected ButtonTrigger setupButtonAction(Element te) {
        return null;
    }

    public Element getXml() {
        Element me = new Element("SoundEvent");
        me.setAttribute("name", this.name);
        me.setAttribute("label", me.getText());
        for (Trigger t : this.trigger_list.values()) {
            me.addContent((Content)t.getXml());
        }
        return me;
    }

    public void setXml(Element el) {
        this.setXml(el, null);
    }

    protected void addXmlTrigger(Element te, VSDFile vf) {
        String tts = te.getAttributeValue("type");
        Trigger.TriggerType tt = tts != null ? Trigger.TriggerType.valueOf(tts.toUpperCase()) : Trigger.TriggerType.NONE;
        switch (tt) {
            case BUTTON: {
                if (this.buttontype == ButtonType.NONE) break;
                this.t = this.setupButtonAction(te);
                break;
            }
            case BOOLEAN: {
                this.t = new BoolTrigger(te.getAttributeValue("name"));
                break;
            }
            case FLOAT: {
                this.t = new FloatTrigger(te.getAttributeValue("name"), Float.valueOf(0.0f), Trigger.CompareType.EQ);
                break;
            }
            case NOTCH: {
                this.t = new NotchTrigger(te.getAttributeValue("name"));
                break;
            }
            case INT: {
                this.t = new IntTrigger(te.getAttributeValue("name"));
                break;
            }
            case STRING: {
                log.warn("Don't have StringTriggers yet...");
                this.t = null;
                return;
            }
            case THROTTLE: {
                this.t = new ThrottleTrigger(te.getAttributeValue("name"));
                break;
            }
        }
        log.debug("Building trigger {}", (Object)this.t.getName());
        this.t.setXml(te);
        this.trigger_list.put(te.getAttributeValue("name"), this.t);
        this.t.setTarget(this.parent.getSound(this.t.getTargetName()));
        if (this.t.getTarget() == null) {
            this.t.setTargetAction(Trigger.TargetAction.NOTHING);
        }
        switch (this.t.getTargetAction()) {
            case PLAY: 
            case FADEIN: {
                this.t.setCallback(new TriggerListener(){

                    @Override
                    public void takeAction() {
                        SoundEvent.this.t.getTarget().play();
                    }

                    @Override
                    public void takeAction(int i) {
                    }

                    @Override
                    public void takeAction(float f) {
                    }
                });
                break;
            }
            case LOOP: {
                this.t.setCallback(new TriggerListener(){

                    @Override
                    public void takeAction() {
                        SoundEvent.this.t.getTarget().loop();
                    }

                    @Override
                    public void takeAction(int i) {
                    }

                    @Override
                    public void takeAction(float f) {
                    }
                });
                break;
            }
            case STOP: 
            case FADEOUT: {
                this.t.setCallback(new TriggerListener(){

                    @Override
                    public void takeAction() {
                        SoundEvent.this.t.getTarget().stop();
                    }

                    @Override
                    public void takeAction(int i) {
                    }

                    @Override
                    public void takeAction(float f) {
                    }
                });
                break;
            }
            case NOTCH: {
                log.debug("making callback t {} target {}", (Object)this.t, (Object)this.t.getTarget());
                this.t.setCallback(new TriggerListener(){

                    @Override
                    public void takeAction(int i) {
                        SoundEvent.this.t.getTarget().changeNotch(i);
                    }

                    @Override
                    public void takeAction() {
                    }

                    @Override
                    public void takeAction(float f) {
                    }
                });
                break;
            }
            case CHANGE: {
                log.debug("making callback t {} target {}", (Object)this.t, (Object)this.t.getTarget());
                this.t.setCallback(new TriggerListener(){

                    @Override
                    public void takeAction() {
                    }

                    @Override
                    public void takeAction(int i) {
                    }

                    @Override
                    public void takeAction(float f) {
                        SoundEvent.this.t.getTarget().changeThrottle(f);
                    }
                });
                break;
            }
            case NOTHING: 
            case STOP_AT_ZERO: {
                this.t.setCallback(new TriggerListener(){

                    @Override
                    public void takeAction() {
                    }

                    @Override
                    public void takeAction(int i) {
                    }

                    @Override
                    public void takeAction(float f) {
                    }
                });
                break;
            }
        }
    }

    public void setXml(Element el, VSDFile vf) {
        this.name = el.getAttributeValue("name");
        String btv = el.getAttributeValue("buttontype");
        this.buttontype = btv != null ? ButtonType.valueOf(btv.toUpperCase()) : ButtonType.NONE;
        for (Element te : el.getChildren("trigger")) {
            this.addXmlTrigger(te, vf);
        }
    }

    public static enum ButtonType {
        MOMENTARY,
        TOGGLE,
        ENGINE,
        NONE;

    }
}

