/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import jmri.jmrit.XmlFile;
import jmri.jmrit.vsdecoder.Bundle;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDFile
extends ZipFile {
    private static final String VSDXmlFileName = "config.xml";
    protected Element root;
    private boolean initialized = false;
    private String _statusMsg = Bundle.getMessage("ButtonOK");
    private String missedFileName;
    private int num_cylinders;
    private static final Logger log = LoggerFactory.getLogger(VSDFile.class);

    public VSDFile(String name) throws ZipException, IOException {
        super(name);
    }

    public String getStatusMessage() {
        return this._statusMsg;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="error text in _statusMsg kept for later use")
    final boolean isInitialized() {
        VSDXmlFile xmlfile = new VSDXmlFile();
        this.initialized = false;
        try {
            Enumeration<? extends ZipEntry> entries = this.entries();
            while (entries.hasMoreElements()) {
                ZipEntry z = entries.nextElement();
                log.debug("Entry: {}", (Object)z.getName());
            }
            ZipEntry config = this.getEntry(VSDXmlFileName);
            if (config == null) {
                this._statusMsg = "File does not contain config.xml";
                log.error(this._statusMsg);
                return false;
            }
            File f2 = new File(this.getURL(VSDXmlFileName));
            this.root = xmlfile.rootFromFile(f2);
            ValidateStatus rv = this.validate(this.root);
            if (!rv.getValid().booleanValue()) {
                this._statusMsg = rv.getMessage();
            }
            this.initialized = rv.getValid();
            return this.initialized;
        }
        catch (IOException ioe) {
            this._statusMsg = "IO Error auto-loading VSD File: config.xml " + ioe;
            log.error(this._statusMsg);
            return false;
        }
        catch (JDOMException ex) {
            this._statusMsg = "JDOM Exception loading VSDecoder from path config.xml " + ex;
            log.error(this._statusMsg);
            return false;
        }
    }

    public Element getRoot() {
        return this.root;
    }

    public InputStream getInputStream(String name) {
        InputStream rv;
        try {
            ZipEntry e = this.getEntry(name);
            if (e == null && (e = this.getEntry(name.toLowerCase())) == null && (e = this.getEntry(name.toUpperCase())) == null) {
                return null;
            }
            rv = this.getInputStream(this.getEntry(name));
        }
        catch (IOException e) {
            log.error("IOException caught", (Throwable)e);
            rv = null;
        }
        return rv;
    }

    public File getFile(String name) {
        ZipEntry e = this.getEntry(name);
        if (e == null) {
            return null;
        }
        File f = new File(e.getName());
        return f;
    }

    public String getURL(String name) {
        try {
            ZipEntry e = this.getEntry(name);
            File t = File.createTempFile(name, ".wav.tmp");
            t.deleteOnExit();
            VSDFile.copyInputStream(this.getInputStream(e), new BufferedOutputStream(new FileOutputStream(t)));
            return t.getPath();
        }
        catch (IOException e) {
            log.error("IO exception", (Throwable)e);
            return null;
        }
    }

    private static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public ValidateStatus validate(Element xmlroot) {
        Iterator i = xmlroot.getChildren("profile").iterator();
        if (!i.hasNext()) {
            log.error("No Profile(s)");
            return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusNoProfiles"));
        }
        while (i.hasNext()) {
            Element e = (Element)i.next();
            log.debug("Validate: Profile {}", (Object)e.getAttributeValue("name"));
            if (e.getAttributeValue("name") == null || e.getAttributeValue("name").isEmpty()) {
                log.error("Missing Profile name");
                return new ValidateStatus(false, "Missing Profile name");
            }
            Iterator i2 = e.getChildren("sound").iterator();
            if (!i2.hasNext()) {
                log.error("Profile {} has no Sounds", (Object)e.getAttributeValue("name"));
                return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusNoSounds") + ": " + e.getAttributeValue("name"));
            }
            while (i2.hasNext()) {
                String[] file_elements;
                Element el = (Element)i2.next();
                log.debug("Element: {}", (Object)el);
                if (el.getAttribute("name") == null) {
                    log.error("Sound element without a name in profile {}", (Object)e.getAttributeValue("name"));
                    return new ValidateStatus(false, "Sound-Element without a name");
                }
                String type = el.getAttributeValue("type");
                log.debug("  Name: {}", (Object)el.getAttributeValue("name"));
                log.debug("   type: {}", (Object)type);
                if (type.equals("configurable")) {
                    if (!this.validateOptionalFile(el, "start-file")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <start-file>: " + this.missedFileName);
                    }
                    if (!this.validateOptionalFile(el, "mid-file")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <mid-file>: " + this.missedFileName);
                    }
                    if (!this.validateOptionalFile(el, "end-file")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <end-file>: " + this.missedFileName);
                    }
                    if (this.validateOptionalFile(el, "short-file")) continue;
                    return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <short-file>: " + this.missedFileName);
                }
                if (type.equals("diesel")) {
                    file_elements = new String[]{"file"};
                    if (!this.validateOptionalFile(el, "start-file")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <start-file>: " + this.missedFileName);
                    }
                    if (!this.validateOptionalFile(el, "shutdown-file")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <shutdown-file>: " + this.missedFileName);
                    }
                    if (!this.validateFiles(el, "notch-sound", file_elements)) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <notch-sound>: " + this.missedFileName);
                    }
                    if (this.validateFiles(el, "notch-transition", file_elements, false)) continue;
                    return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <notch-transition>: " + this.missedFileName);
                }
                if (type.equals("diesel3")) {
                    file_elements = new String[]{"file", "accel-file", "decel-file"};
                    if (!this.validateOptionalFile(el, "start-file")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <start-file>: " + this.missedFileName);
                    }
                    if (!this.validateOptionalFile(el, "shutdown-file")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <shutdown-file>: " + this.missedFileName);
                    }
                    if (this.validateFiles(el, "notch-sound", file_elements)) continue;
                    return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <notch-sound>: " + this.missedFileName);
                }
                if (type.equals("steam")) {
                    file_elements = new String[]{"file"};
                    if (!this.validateRequiredElement(el, "top-speed")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingElement") + ": <top-speed>");
                    }
                    if (!this.validateRequiredElement(el, "driver-diameter")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingElement") + ": <driver-diameter>");
                    }
                    if (!this.validateRequiredElement(el, "cylinders")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingElement") + ": <cylinders>");
                    }
                    if (!this.validateRequiredElementRange(el, "cylinders", 1, 4)) {
                        return new ValidateStatus(false, "Number of cylinders must be 1, 2, 3 or 4");
                    }
                    if (this.validateFiles(el, "rpm-step", file_elements)) continue;
                    return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <rpm-step>: " + this.missedFileName);
                }
                if (type.equals("steam1")) {
                    if (!this.validateRequiredElement(el, "top-speed")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingElement") + ": <top-speed>");
                    }
                    if (!this.validateRequiredElement(el, "driver-diameter-float")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingElement") + ": <driver-diameter-float>");
                    }
                    if (!this.validateRequiredElement(el, "cylinders")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingElement") + ": <cylinders>");
                    }
                    if (!this.validateRequiredElementRange(el, "cylinders", 1, 4)) {
                        return new ValidateStatus(false, "Number of cylinders must be 1, 2, 3 or 4");
                    }
                    file_elements = new String[]{"notch-file", "coast-file"};
                    if (!this.validateFilesNumbers(el, "s1notch-sound", file_elements, true)) {
                        return new ValidateStatus(false, this.getStatusMessage());
                    }
                    if (!this.validateRequiredElement(el, "s1notch-sound")) {
                        return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingElement") + ": <s1notch-sound>");
                    }
                    if (!this.validateRequiredNotchElement(el, "s1notch-sound", "min-rpm")) {
                        return new ValidateStatus(false, "Element min-rpm for Element s1notch-sound missing");
                    }
                    if (!this.validateRequiredNotchElement(el, "s1notch-sound", "max-rpm")) {
                        return new ValidateStatus(false, "Element max-rpm for Element s1notch-sound missing");
                    }
                    file_elements = new String[]{"notch-file", "notchfiller-file", "coast-file", "coastfiller-file"};
                    if (this.validateFiles(el, "s1notch-sound", file_elements)) continue;
                    return new ValidateStatus(false, Bundle.getMessage("VSDFileStatusMissingSoundFile") + " <s1notch-sound>: " + this.missedFileName);
                }
                return new ValidateStatus(false, "Unsupported sound type: " + type);
            }
        }
        log.debug("File Validation Successful.");
        return new ValidateStatus(true, Bundle.getMessage("ButtonOK"));
    }

    protected boolean validateRequiredElement(Element el, String name) {
        if (el.getChild(name) == null || el.getChildText(name).isEmpty()) {
            log.error("Element {} for Element {} missing", (Object)name, (Object)el.getAttributeValue("name"));
            return false;
        }
        return true;
    }

    protected boolean validateRequiredElementRange(Element el, String name, int val_from, int val_to) {
        int val = Integer.parseInt(el.getChildText(name));
        log.debug(" <{}> found: {} ({} to {})", new Object[]{name, val, val_from, val_to});
        if (val >= val_from && val <= val_to) {
            if (name.equals("cylinders")) {
                this.num_cylinders = val;
            }
            return true;
        }
        log.error("Value of {} is invalid", (Object)name);
        return false;
    }

    protected boolean validateRequiredNotchElement(Element el, String name1, String name2) {
        List elist = el.getChildren(name1);
        for (Element ns_e : elist) {
            if (ns_e.getChild(name2) != null && !ns_e.getChildText(name2).isEmpty()) continue;
            log.error("Element {} for Element {} missing", (Object)name2, (Object)name1);
            return false;
        }
        return true;
    }

    protected boolean validateOptionalFile(Element el, String name) {
        return this.validateOptionalFile(el, name, true);
    }

    protected boolean validateOptionalFile(Element el, String name, Boolean required) {
        String s = el.getChildText(name);
        if (s != null && this.getFile(s) == null) {
            this.missedFileName = s;
            log.error("File {} for Element {} not found {}", new Object[]{s, name, el.getAttributeValue("name")});
            return false;
        }
        return true;
    }

    protected boolean validateFiles(Element el, String name, String[] fnames) {
        return this.validateFiles(el, name, fnames, true);
    }

    protected boolean validateFiles(Element el, String name, String[] fnames, Boolean required) {
        List elist = el.getChildren(name);
        if (elist.isEmpty() && required.booleanValue()) {
            log.error("No elements of name {}", (Object)name);
            return false;
        }
        log.debug("{}(s): {}", (Object)name, (Object)elist.size());
        for (Element ns_e : elist) {
            for (String fn : fnames) {
                List elistf = ns_e.getChildren(fn);
                log.debug(" {}(s): {}", (Object)fn, (Object)elistf.size());
                for (Element ns_ef : elistf) {
                    String s = ns_ef.getText();
                    log.debug("  getText: {}", (Object)s);
                    if (s != null && this.getFile(s) != null) continue;
                    log.error("File {} for Element {} in Element {} not found", new Object[]{s, fn, name});
                    this.missedFileName = s;
                    return false;
                }
            }
        }
        return true;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="error text in _statusMsg kept for later use")
    protected boolean validateFilesNumbers(Element el, String name, String[] fnames, Boolean required) {
        List elist = el.getChildren(name);
        if (elist.isEmpty() && required.booleanValue()) {
            log.error("No elements of name {}", (Object)name);
            return false;
        }
        log.debug("{}(s): {}", (Object)name, (Object)elist.size());
        int nn = 1;
        for (Element ns_e : elist) {
            log.debug(" nse: {}", (Object)ns_e);
            for (String fn : fnames) {
                List elistf = ns_e.getChildren(fn);
                if (fn.equals("notch-file") && elistf.size() != this.num_cylinders * 2) {
                    this._statusMsg = "Invalid number of notch files: " + elistf.size() + ", but should be " + this.num_cylinders * 2 + " (for " + this.num_cylinders + " cylinders) in notch " + nn;
                    log.error(this._statusMsg);
                    return false;
                }
                if (fn.equals("coast-file") && nn == 1 && elistf.size() != this.num_cylinders * 2 && elistf.size() != 0) {
                    this._statusMsg = "Invalid number of coast files: " + elistf.size() + ", but should be " + this.num_cylinders * 2 + " (for " + this.num_cylinders + " cylinders) in notch 1";
                    log.error(this._statusMsg);
                    return false;
                }
                if (!fn.equals("coast-file") || nn <= 1 || elistf.size() == 0) continue;
                this._statusMsg = "Invalid number of coast files: " + elistf.size() + ", but should be 0 in notch " + nn;
                log.error(this._statusMsg);
                return false;
            }
            ++nn;
        }
        return true;
    }

    static class ValidateStatus {
        String msg = "";
        Boolean valid = false;

        public ValidateStatus() {
            this(false, "");
        }

        public ValidateStatus(Boolean v, String m) {
            this.valid = v;
            this.msg = m;
        }

        public void setValid(Boolean v) {
            this.valid = v;
        }

        public void setMessage(String m) {
            this.msg = m;
        }

        public Boolean getValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.msg;
        }
    }

    private static class VSDXmlFile
    extends XmlFile {
        private VSDXmlFile() {
        }
    }
}

